/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateTable;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u0005\u000b\u0001mAQA\r\u0001\u0005\u0002MB\u0001B\u000e\u0001\t\u0006\u0004%Ia\u000e\u0005\ty\u0001A)\u0019!C\u0005{!)a\t\u0001C!\u000f\")Q\u000b\u0001C!-\")a\u000f\u0001C!o\"1q\u0010\u0001C\u0005\u0003\u0003Aq!a\b\u0001\t\u0003\n\tCA\bTi\u0006$X\rR1uCN{WO]2f\u0015\tYA\"A\u0003ti\u0006$XM\u0003\u0002\u000e\u001d\u0005\u0011aO\r\u0006\u0003\u001fA\t1\u0002Z1uCN|WO]2fg*\u0011\u0011CE\u0001\nKb,7-\u001e;j_:T!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u000f%YA\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB(cU\u0016\u001cG\u000f\u0005\u0002&U5\taE\u0003\u0002(Q\u000591-\u0019;bY><'BA\u0015\u0013\u0003%\u0019wN\u001c8fGR|'/\u0003\u0002,M\tiA+\u00192mKB\u0013xN^5eKJ\u0004\"!\f\u0019\u000e\u00039R!a\f\n\u0002\u000fM|WO]2fg&\u0011\u0011G\f\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002iA\u0011Q\u0007A\u0007\u0002\u0015\u000591/Z:tS>tW#\u0001\u001d\u0011\u0005eRT\"\u0001\n\n\u0005m\u0012\"\u0001D*qCJ\\7+Z:tS>t\u0017A\u00035bI>|\u0007oQ8oMV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!1m\u001c8g\u0015\t\u0019e#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u000b\u0002\u0013QbQ8oM&<WO]1uS>t\u0017!C:i_J$h*Y7f)\u0005A\u0005CA%S\u001d\tQ\u0005\u000b\u0005\u0002L\u001d6\tAJ\u0003\u0002N5\u00051AH]8pizR\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u000ba\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KT\u0001\tO\u0016$H+\u00192mKR!qK\u00172o!\t)\u0003,\u0003\u0002ZM\t)A+\u00192mK\")1,\u0002a\u00019\u000611o\u00195f[\u0006\u0004\"!\u00181\u000e\u0003yS!a\u0018\n\u0002\u000bQL\b/Z:\n\u0005\u0005t&AC*ueV\u001cG\u000fV=qK\")1-\u0002a\u0001I\u0006a\u0001/\u0019:uSRLwN\\5oOB\u0019QM\u001a5\u000e\u00039K!a\u001a(\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%dW\"\u00016\u000b\u0005-D\u0013aC3yaJ,7o]5p]NL!!\u001c6\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007\"B8\u0006\u0001\u0004\u0001\u0018A\u00039s_B,'\u000f^5fgB!\u0011\u000f\u001e%I\u001b\u0005\u0011(BA:!\u0003\u0011)H/\u001b7\n\u0005U\u0014(aA'ba\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)\ta\u0006\u0010C\u0003z\r\u0001\u0007!0A\u0004paRLwN\\:\u0011\u0005mlX\"\u0001?\u000b\u0005M\u0014\u0012B\u0001@}\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r]\u0001\u0014EVLG\u000eZ*uCR,7\u000b^8sK\u000e{gN\u001a\u000b\u0007\u0003\u0007\t\t\"!\u0006\u0011\t\u0005\u0015\u0011QB\u0007\u0003\u0003\u000fQ1aCA\u0005\u0015\r\tY\u0001E\u0001\ngR\u0014X-Y7j]\u001eLA!a\u0004\u0002\b\tq1\u000b^1uKN#xN]3D_:4\u0007BBA\n\u000f\u0001\u0007\u0001*\u0001\ndQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007bBA\f\u000f\u0001\u0007\u0011\u0011D\u0001\bE\u0006$8\r[%e!\r)\u00171D\u0005\u0004\u0003;q%\u0001\u0002'p]\u001e\f\u0001d];qa>\u0014Ho]#yi\u0016\u0014h.\u00197NKR\fG-\u0019;b)\t\t\u0019\u0003E\u0002f\u0003KI1!a\nO\u0005\u001d\u0011un\u001c7fC:\u0004")
public class StateDataSource
implements TableProvider,
DataSourceRegister {
    private SparkSession session;
    private Configuration hadoopConf;
    private volatile byte bitmap$0;

    public Transform[] inferPartitioning(CaseInsensitiveStringMap x$1) {
        return super.inferPartitioning(x$1);
    }

    private SparkSession session$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.session = SparkSession$.MODULE$.active();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.session;
    }

    private SparkSession session() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    private Configuration hadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopConf = this.session().sessionState().newHadoopConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hadoopConf;
    }

    private Configuration hadoopConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hadoopConf$lzycompute();
        }
        return this.hadoopConf;
    }

    @Override
    public String shortName() {
        return "statestore";
    }

    public Table getTable(StructType schema, Transform[] partitioning2, Map<String, String> properties) {
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), properties);
        StateStoreConf stateConf = this.buildStateStoreConf(sourceOptions.resolvedCpLocation(), sourceOptions.batchId());
        return new StateTable(this.session(), schema, sourceOptions, stateConf);
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        StructType structType;
        int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), options);
        Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
        try {
            Tuple2<StructType, StructType> tuple2;
            Enumeration.Value value = sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$5());
            } else {
                Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$5());
                } else {
                    Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        StateStoreId storeId = new StateStoreId(stateCheckpointLocation.toString(), sourceOptions.operatorId(), partitionId, sourceOptions.storeName());
                        StateStoreProviderId providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
                        StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerId, this.hadoopConf());
                        tuple2 = manager.readSchemaFile();
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            Tuple2<StructType, StructType> tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            StructType keySchema = (StructType)tuple22._1();
            StructType valueSchema = (StructType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)keySchema, (Object)valueSchema);
            StructType keySchema2 = (StructType)tuple23._1();
            StructType valueSchema2 = (StructType)tuple23._2();
            structType = new StructType().add("key", (DataType)keySchema2).add("value", (DataType)valueSchema2).add("partition_id", (DataType)IntegerType$.MODULE$);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
            }
            throw throwable;
        }
        return structType;
    }

    private StateStoreConf buildStateStoreConf(String checkpointLocation, long batchId) {
        OffsetSeqLog offsetLog = new OffsetSeqLog(this.session(), new Path(checkpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_OFFSETS()).toString());
        Option option = offsetLog.get(batchId);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetSeq value = (OffsetSeq)some.value();
            OffsetSeqMetadata metadata = (OffsetSeqMetadata)value.metadata().getOrElse((Function0 & Serializable)() -> {
                throw StateDataSourceErrors$.MODULE$.offsetMetadataLogUnavailable(batchId, checkpointLocation);
            });
            RuntimeConfig clonedRuntimeConf = new RuntimeConfig(this.session().sessionState().conf().clone());
            OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, clonedRuntimeConf);
            return StateStoreConf$.MODULE$.apply(clonedRuntimeConf.sqlConf());
        }
        throw StateDataSourceErrors$.MODULE$.offsetLogUnavailable(batchId, checkpointLocation);
    }

    public boolean supportsExternalMetadata() {
        return false;
    }
}

