/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StatePartitionReaderFactory;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreInputPartition;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStatePartitionReaderFactory;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\b\u0010\u0001\u0001B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d!\u0006A1A\u0005\nUCaA\u0019\u0001!\u0002\u00131\u0006\"B2\u0001\t\u0003\"\u0007\"B3\u0001\t\u00032\u0007\"\u00029\u0001\t\u0003\n\b\"B;\u0001\t\u00032\b\"B<\u0001\t\u0003B\bbBA\u0005\u0001\u0011%\u00111\u0002\u0002\n'R\fG/Z*dC:T!\u0001E\t\u0002\u000bM$\u0018\r^3\u000b\u0005I\u0019\u0012A\u0001<3\u0015\t!R#A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\f\u0018\u0003%)\u00070Z2vi&|gN\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001C%\n\u0004C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u0002:fC\u0012T!AL\f\u0002\u0013\r|gN\\3di>\u0014\u0018B\u0001\u0019,\u0005\u0011\u00196-\u00198\u0011\u0005)\u0012\u0014BA\u001a,\u0005\u0015\u0011\u0015\r^2i\u0003\u001d\u0019Xm]:j_:\u0004\"AN\u001c\u000e\u0003]I!\u0001O\f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rM\u001c\u0007.Z7b!\tYd(D\u0001=\u0015\tit#A\u0003usB,7/\u0003\u0002@y\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001bM|WO]2f\u001fB$\u0018n\u001c8t!\t\u00115)D\u0001\u0010\u0013\t!uB\u0001\nTi\u0006$XmU8ve\u000e,w\n\u001d;j_:\u001c\u0018AD:uCR,7\u000b^8sK\u000e{gN\u001a\t\u0003\u000f.k\u0011\u0001\u0013\u0006\u0003!%S!AS\u000b\u0002\u0013M$(/Z1nS:<\u0017B\u0001'I\u00059\u0019F/\u0019;f'R|'/Z\"p]\u001a\fa\u0001P5oSRtD#B(Q#J\u001b\u0006C\u0001\"\u0001\u0011\u0015!T\u00011\u00016\u0011\u0015IT\u00011\u0001;\u0011\u0015\u0001U\u00011\u0001B\u0011\u0015)U\u00011\u0001G\u0003MA\u0017\rZ8pa\u000e{gN\u001a\"s_\u0006$7-Y:u+\u00051\u0006cA,[96\t\u0001L\u0003\u0002Z3\u0005I!M]8bI\u000e\f7\u000f^\u0005\u00037b\u0013\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0005u\u0003W\"\u00010\u000b\u0005}K\u0012\u0001B;uS2L!!\u00190\u00033M+'/[1mSj\f'\r\\3D_:4\u0017nZ;sCRLwN\\\u0001\u0015Q\u0006$wn\u001c9D_:4'I]8bI\u000e\f7\u000f\u001e\u0011\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\rF\u0001;\u0003M\u0001H.\u00198J]B,H\u000fU1si&$\u0018n\u001c8t)\u00059\u0007c\u00015l[6\t\u0011NC\u0001k\u0003\u0015\u00198-\u00197b\u0013\ta\u0017NA\u0003BeJ\f\u0017\u0010\u0005\u0002+]&\u0011qn\u000b\u0002\u000f\u0013:\u0004X\u000f\u001e)beRLG/[8o\u0003M\u0019'/Z1uKJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:z)\u0005\u0011\bC\u0001\u0016t\u0013\t!8F\u0001\fQCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0003\u001d!xNQ1uG\"$\u0012!M\u0001\fI\u0016\u001c8M]5qi&|g\u000eF\u0001z!\rQ\u00181\u0001\b\u0003w~\u0004\"\u0001`5\u000e\u0003uT!A`\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\t\t![\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u0011.A\u0011ti\u0006$Xm\u00115fG.\u0004x.\u001b8u!\u0006\u0014H/\u001b;j_:\u001cHj\\2bi&|g.\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011A\u00014t\u0015\r\t9bG\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005m\u0011\u0011\u0003\u0002\u0005!\u0006$\b\u000e")
public class StateScan
implements Scan,
Batch {
    private final SparkSession session;
    private final StructType schema;
    private final StateSourceOptions sourceOptions;
    private final StateStoreConf stateStoreConf;
    private final Broadcast<SerializableConfiguration> hadoopConfBroadcast;

    public MicroBatchStream toMicroBatchStream(String x$1) {
        return super.toMicroBatchStream(x$1);
    }

    public ContinuousStream toContinuousStream(String x$1) {
        return super.toContinuousStream(x$1);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return super.supportedCustomMetrics();
    }

    public CustomTaskMetric[] reportDriverMetrics() {
        return super.reportDriverMetrics();
    }

    public Scan.ColumnarSupportMode columnarSupportMode() {
        return super.columnarSupportMode();
    }

    private Broadcast<SerializableConfiguration> hadoopConfBroadcast() {
        return this.hadoopConfBroadcast;
    }

    public StructType readSchema() {
        return this.schema;
    }

    public InputPartition[] planInputPartitions() {
        FileSystem fs2 = this.stateCheckpointPartitionsLocation().getFileSystem(((SerializableConfiguration)this.hadoopConfBroadcast().value()).value());
        FileStatus[] partitions = fs2.listStatus(this.stateCheckpointPartitionsLocation(), new PathFilter(null, fs2){
            private final FileSystem fs$1;

            public boolean accept(Path path) {
                return this.fs$1.isDirectory(path) && Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(path.getName()))).isSuccess() && StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(path.getName())) >= 0;
            }
            {
                this.fs$1 = fs$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1(org.apache.hadoop.fs.Path )}, serializedLambda);
            }
        });
        if (ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])partitions)).isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.noPartitionDiscoveredInStateStore(this.sourceOptions);
        }
        UUID queryId = UUID.randomUUID();
        FileStatus[] partitionsSorted = (FileStatus[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])partitions), (Function1 & Serializable)fs -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fs.getPath().getName()))), (Ordering)Ordering.Int$.MODULE$);
        int[] partitionNums = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionsSorted), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1.getPath().getName()))), (ClassTag)ClassTag$.MODULE$.Int());
        int head = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(partitionNums)));
        int tail = partitionNums[partitionNums.length - 1];
        Predef$.MODULE$.assert(head == 0, (Function0 & Serializable)() -> "Partition should start with 0");
        Predef$.MODULE$.assert(tail - head + 1 == partitionNums.length, (Function0 & Serializable)() -> "No continuous partitions in state: " + Predef$.MODULE$.wrapIntArray(partitionNums).mkString("Array(", ", ", ")"));
        return (InputPartition[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partitionNums), (Function1 & Serializable)pn -> StateScan.$anonfun$planInputPartitions$5(this, queryId, BoxesRunTime.unboxToInt((Object)pn)), ClassTag$.MODULE$.apply(StateStoreInputPartition.class))), ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        Enumeration.Value value = this.sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType userFacingSchema = this.schema;
            StructType stateSchema = StreamStreamJoinStateHelper$.MODULE$.readSchema(this.session, this.sourceOptions.stateCheckpointLocation().toString(), this.sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, false);
            return new StreamStreamJoinStatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), userFacingSchema, stateSchema);
        }
        Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            StructType userFacingSchema = this.schema;
            StructType stateSchema = StreamStreamJoinStateHelper$.MODULE$.readSchema(this.session, this.sourceOptions.stateCheckpointLocation().toString(), this.sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, false);
            return new StreamStreamJoinStatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), userFacingSchema, stateSchema);
        }
        Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new StatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), this.schema);
        }
        throw new MatchError((Object)value);
    }

    public Batch toBatch() {
        return this;
    }

    public String description() {
        String desc = "StateScan [stateCkptLocation=" + this.sourceOptions.stateCheckpointLocation() + "][batchId=" + this.sourceOptions.batchId() + "][operatorId=" + this.sourceOptions.operatorId() + "][storeName=" + this.sourceOptions.storeName() + "]";
        Enumeration.Value value = this.sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (value == null ? value2 != null : !value.equals(value2)) {
            return desc + "[joinSide=" + this.sourceOptions.joinSide() + "]";
        }
        return desc;
    }

    private Path stateCheckpointPartitionsLocation() {
        return new Path(this.sourceOptions.stateCheckpointLocation(), Integer.toString(this.sourceOptions.operatorId()));
    }

    public static final /* synthetic */ StateStoreInputPartition $anonfun$planInputPartitions$5(StateScan $this, UUID queryId$1, int pn) {
        return new StateStoreInputPartition(pn, queryId$1, $this.sourceOptions);
    }

    public StateScan(SparkSession session, StructType schema, StateSourceOptions sourceOptions, StateStoreConf stateStoreConf) {
        this.session = session;
        this.schema = schema;
        this.sourceOptions = sourceOptions;
        this.stateStoreConf = stateStoreConf;
        this.hadoopConfBroadcast = session.sparkContext().broadcast((Object)new SerializableConfiguration(session.sessionState().newHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
    }
}

