/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.AsyncCommitLog;
import org.apache.spark.sql.execution.streaming.AsyncOffsetSeqLog;
import org.apache.spark.sql.execution.streaming.AsyncProgressTrackingMicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.AvailableNowTrigger$;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\u0016-\u0001eB\u0011B\u0010\u0001\u0003\u0002\u0003\u0006IaP\"\t\u0013\u0019\u0003!\u0011!Q\u0001\n\u001dc\u0005\"C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(U\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u000b9\u0004A\u0011A8\t\u000fY\u0004!\u0019!C\to\"1A\u0010\u0001Q\u0001\naDq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0018\u0001\u0001\u000b\u0011B@\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0001\u0002CA\u0015\u0001\u0001\u0006I!!\b\t\u0013\u0005-\u0002\u00011A\u0005\n\u00055\u0002\"CA\u001b\u0001\u0001\u0007I\u0011BA\u001c\u0011!\t\u0019\u0005\u0001Q!\n\u0005=\u0002\"CA#\u0001\t\u0007I\u0011CA$\u0011!\ty\u0005\u0001Q\u0001\n\u0005%\u0003\"CA)\u0001\t\u0007I\u0011IA*\u0011!\tY\u0006\u0001Q\u0001\n\u0005U\u0003\"CA/\u0001\t\u0007I\u0011IA0\u0011!\t9\u0007\u0001Q\u0001\n\u0005\u0005\u0004bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003o\u0002A\u0011IA=\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!a#\u0001\t\u0003\ni\tC\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003O\u0003A\u0011KAU\u0011\u001d\t\t\f\u0001C\u0005\u0003SCq!a-\u0001\t\u0013\t)lB\u0004\u000282B\t!!/\u0007\r-b\u0003\u0012AA^\u0011\u0019q'\u0005\"\u0001\u0002D\"I\u0011Q\u0019\u0012C\u0002\u0013\u0005\u0011q\u0019\u0005\t\u0003'\u0014\u0003\u0015!\u0003\u0002J\"I\u0011Q\u001b\u0012C\u0002\u0013\u0005\u0011q\u0019\u0005\t\u0003/\u0014\u0003\u0015!\u0003\u0002J\"I\u0011\u0011\u001c\u0012C\u0002\u0013\u0005\u0011q\u0019\u0005\t\u00037\u0014\u0003\u0015!\u0003\u0002J\"9\u0011Q\u001c\u0012\u0005\n\u0005}'\u0001K!ts:\u001c\u0007K]8he\u0016\u001c8\u000f\u0016:bG.LgnZ'jGJ|')\u0019;dQ\u0016CXmY;uS>t'BA\u0017/\u0003%\u0019HO]3b[&twM\u0003\u00020a\u0005IQ\r_3dkRLwN\u001c\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<7\u0001A\n\u0003\u0001i\u0002\"a\u000f\u001f\u000e\u00031J!!\u0010\u0017\u0003'5K7M]8CCR\u001c\u0007.\u0012=fGV$\u0018n\u001c8\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u0001\u000bU\"\u0001\u0019\n\u0005\t\u0003$\u0001D*qCJ\\7+Z:tS>t\u0017B\u0001 E\u0013\t)EFA\bTiJ,\u0017-\\#yK\u000e,H/[8o\u0003\u001d!(/[4hKJ\u0004\"\u0001\u0013&\u000e\u0003%S!!\f\u0019\n\u0005-K%a\u0002+sS\u001e<WM]\u0005\u0003\r\u0012\u000bA\u0002\u001e:jO\u001e,'o\u00117pG.\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u001a\u0002\tU$\u0018\u000e\\\u0005\u0003'B\u0013Qa\u00117pG.L!!\u0014#\u0002\u0019\u0015DHO]1PaRLwN\\:\u0011\t]\u00037m\u0019\b\u00031z\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u001d\u0002\rq\u0012xn\u001c;?\u0015\u0005i\u0016!B:dC2\f\u0017BA0]\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0004\u001b\u0006\u0004(BA0]!\t9F-\u0003\u0002fE\n11\u000b\u001e:j]\u001e\fA\u0001\u001d7b]B\u0011\u0001\u000e\\\u0007\u0002S*\u0011QF\u001b\u0006\u0003WB\n\u0001bY1uC2L8\u000f^\u0005\u0003[&\u0014Qb\u0016:ji\u0016$vn\u0015;sK\u0006l\u0017A\u0002\u001fj]&$h\b\u0006\u0004qcJ\u001cH/\u001e\t\u0003w\u0001AQA\u0010\u0004A\u0002}BQA\u0012\u0004A\u0002\u001dCQ!\u0014\u0004A\u00029CQ!\u0016\u0004A\u0002YCQA\u001a\u0004A\u0002\u001d\fA&Y:z]\u000e\u0004&o\\4sKN\u001cHK]1dW&twm\u00115fG.\u0004x.\u001b8uS:<\u0017J\u001c;feZ\fG.T:\u0016\u0003a\u0004\"!\u001f>\u000e\u0003qK!a\u001f/\u0003\t1{gnZ\u0001.CNLhn\u0019)s_\u001e\u0014Xm]:Ue\u0006\u001c7.\u001b8h\u0007\",7m\u001b9pS:$\u0018N\\4J]R,'O^1m\u001bN\u0004\u0013!E:pkJ\u001cWmQ8n[&$\u0018+^3vKV\tq\u0010\u0005\u0004\u0002\u0002\u00055\u0011\u0011C\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007E\u000bIA\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!a\u0001\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB\u00191(a\u0005\n\u0007\u0005UAFA\u0005PM\u001a\u001cX\r^*fc\u0006\u00112o\\;sG\u0016\u001cu.\\7jiF+X-^3!\u0003\tb\u0017m\u001d;CCR\u001c\u0007\u000eU3sg&\u001cH/\u001a3U_\u0012+(/\u00192mKN#xN]1hKV\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")!\u00111EA\u0002\u0003\u0019\tGo\\7jG&!\u0011qEA\u0011\u0005)\tEo\\7jG2{gnZ\u0001$Y\u0006\u001cHOQ1uG\"\u0004VM]:jgR,G\rV8EkJ\f'\r\\3Ti>\u0014\u0018mZ3!\u00031I7OR5sgR\u0014\u0015\r^2i+\t\ty\u0003E\u0002z\u0003cI1!a\r]\u0005\u001d\u0011un\u001c7fC:\f\u0001#[:GSJ\u001cHOQ1uG\"|F%Z9\u0015\t\u0005e\u0012q\b\t\u0004s\u0006m\u0012bAA\u001f9\n!QK\\5u\u0011%\t\tEDA\u0001\u0002\u0004\ty#A\u0002yIE\nQ\"[:GSJ\u001cHOQ1uG\"\u0004\u0013AG1ts:\u001cwK]5uKN,\u00050Z2vi>\u00148+\u001a:wS\u000e,WCAA%!\u0011\t\t!a\u0013\n\t\u00055\u00131\u0001\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'/A\u000ebgft7m\u0016:ji\u0016\u001cX\t_3dkR|'oU3sm&\u001cW\rI\u0001\n_\u001a47/\u001a;M_\u001e,\"!!\u0016\u0011\u0007m\n9&C\u0002\u0002Z1\u0012\u0011#Q:z]\u000e|eMZ:fiN+\u0017\u000fT8h\u0003)ygMZ:fi2{w\rI\u0001\nG>lW.\u001b;M_\u001e,\"!!\u0019\u0011\u0007m\n\u0019'C\u0002\u0002f1\u0012a\"Q:z]\u000e\u001cu.\\7ji2{w-\u0001\u0006d_6l\u0017\u000e\u001e'pO\u0002\n\u0011E^1mS\u0012\fG/Z(gMN,G\u000fT8h\u0003:$w)\u001a;Qe\u00164xJ\u001a4tKR$B!!\u001c\u0002tA)\u00110a\u001c\u0002\u0012%\u0019\u0011\u0011\u000f/\u0003\r=\u0003H/[8o\u0011\u0019\t)H\u0006a\u0001q\u0006iA.\u0019;fgR\u0014\u0015\r^2i\u0013\u0012\fA$\\1sW6K7M]8CCR\u001c\u0007.\u0012=fGV$\u0018n\u001c8Ti\u0006\u0014H\u000f\u0006\u0003\u0002:\u0005m\u0004bBA?/\u0001\u0007\u0011qP\u0001\bKb,7m\u0011;y!\rY\u0014\u0011Q\u0005\u0004\u0003\u0007c#AG'jGJ|')\u0019;dQ\u0016CXmY;uS>t7i\u001c8uKb$\u0018!H2mK\u0006tW\u000b\u001d'bgR,\u00050Z2vi\u0016$W*[2s_\n\u000bGo\u00195\u0015\t\u0005e\u0012\u0011\u0012\u0005\b\u0003{B\u0002\u0019AA@\u0003Mi\u0017M]6NS\u000e\u0014xNQ1uG\"\u001cF/\u0019:u)\u0011\tI$a$\t\u000f\u0005u\u0014\u00041\u0001\u0002\u0000\u0005\tR.\u0019:l\u001b&\u001c'o\u001c\"bi\u000eDWI\u001c3\u0015\t\u0005e\u0012Q\u0013\u0005\b\u0003{R\u0002\u0019AA@\u0003\u0015\u0001XO]4f)\u0011\tI$a'\t\r\u0005u5\u00041\u0001y\u0003%!\bN]3tQ>dG-A\u0004dY\u0016\fg.\u001e9\u0015\u0005\u0005e\u0012\u0001H1sK^\u0013\u0018\u000e^3t!\u0016tG-\u001b8h\u001fJLe\u000e\u0015:pOJ,7o\u001d\u000b\u0003\u0003_\t!bZ3u)JLwmZ3s)\t\tY\u000bE\u0002<\u0003[K1!a,-\u0005=!&/[4hKJ,\u00050Z2vi>\u0014\u0018!\u0006<bY&$\u0017\r^3B]\u0012<U\r\u001e+sS\u001e<WM]\u0001\u001fG\",7m\u001b(piN#\u0018\r^3gk2\u001cFO]3b[&tw-U;fef,\"!!\u000f\u0002Q\u0005\u001b\u0018P\\2Qe><'/Z:t)J\f7m[5oO6K7M]8CCR\u001c\u0007.\u0012=fGV$\u0018n\u001c8\u0011\u0005m\u00123c\u0001\u0012\u0002>B\u0019\u00110a0\n\u0007\u0005\u0005GL\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003s\u000bq$Q*Z\u001d\u000e{\u0006KU(H%\u0016\u001b6k\u0018+S\u0003\u000e[\u0015JT$`\u000b:\u000b%\tT#E+\t\tI\r\u0005\u0003\u0002L\u0006EWBAAg\u0015\u0011\ty-!\u0003\u0002\t1\fgnZ\u0005\u0004K\u00065\u0017\u0001I!T3:\u001bu\f\u0015*P\u000fJ+5kU0U%\u0006\u001b5*\u0013(H?\u0016s\u0015I\u0011'F\t\u0002\n\u0011'Q*Z\u001d\u000e{\u0006KU(H%\u0016\u001b6k\u0018+S\u0003\u000e[\u0015JT$`\u0007\"+5i\u0013)P\u0013:#\u0016JT$`\u0013:#VI\u0015,B\u0019~k5+\u0001\u001aB'fs5i\u0018)S\u001f\u001e\u0013ViU*`)J\u000b5iS%O\u000f~\u001b\u0005*R\"L!>Ke\nV%O\u000f~Ke\nV#S-\u0006cu,T*!\u0003M\n5+\u0017(D?B\u0013vj\u0012*F'N{FKU!D\u0017&suiX(W\u000bJ\u0013\u0016\nR#`'&s5jX*V!B{%\u000bV0D\u0011\u0016\u001b5*\u0001\u001bB'fs5i\u0018)S\u001f\u001e\u0013ViU*`)J\u000b5iS%O\u000f~{e+\u0012*S\u0013\u0012+ulU%O\u0017~\u001bV\u000b\u0015)P%R{6\tS#D\u0017\u0002\nqfZ3u\u0003NLhn\u0019)s_\u001e\u0014Xm]:Ue\u0006\u001c7.\u001b8h\u0007\",7m\u001b9pS:$\u0018N\\4J]R,'O^1m\u001bN$2\u0001_Aq\u0011\u0015)&\u00061\u0001W\u0001")
public class AsyncProgressTrackingMicroBatchExecution
extends MicroBatchExecution {
    private final Map<String, String> extraOptions;
    private final WriteToStream plan;
    private final long asyncProgressTrackingCheckpointingIntervalMs;
    private final ConcurrentLinkedQueue<OffsetSeq> sourceCommitQueue;
    private final AtomicLong lastBatchPersistedToDurableStorage;
    private boolean isFirstBatch;
    private final ThreadPoolExecutor asyncWritesExecutorService;
    private final AsyncOffsetSeqLog offsetLog;
    private final AsyncCommitLog commitLog;

    public static String ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK();
    }

    public static String ASYNC_PROGRESS_TRACKING_CHECKPOINTING_INTERVAL_MS() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_CHECKPOINTING_INTERVAL_MS();
    }

    public static String ASYNC_PROGRESS_TRACKING_ENABLED() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_ENABLED();
    }

    public long asyncProgressTrackingCheckpointingIntervalMs() {
        return this.asyncProgressTrackingCheckpointingIntervalMs;
    }

    private ConcurrentLinkedQueue<OffsetSeq> sourceCommitQueue() {
        return this.sourceCommitQueue;
    }

    private AtomicLong lastBatchPersistedToDurableStorage() {
        return this.lastBatchPersistedToDurableStorage;
    }

    private boolean isFirstBatch() {
        return this.isFirstBatch;
    }

    private void isFirstBatch_$eq(boolean x$1) {
        this.isFirstBatch = x$1;
    }

    public ThreadPoolExecutor asyncWritesExecutorService() {
        return this.asyncWritesExecutorService;
    }

    @Override
    public AsyncOffsetSeqLog offsetLog() {
        return this.offsetLog;
    }

    @Override
    public AsyncCommitLog commitLog() {
        return this.commitLog;
    }

    @Override
    public Option<OffsetSeq> validateOffsetLogAndGetPrevOffset(long latestBatchId) {
        Option<Object> prevBatchId = this.offsetLog().getPrevBatchFromStorage(latestBatchId);
        if (latestBatchId != 0L && prevBatchId.isDefined()) {
            return new Some(this.offsetLog().get(BoxesRunTime.unboxToLong((Object)prevBatchId.get())).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Offset metadata for batch " + prevBatchId + " cannot be found.  This should not happen.");
            }));
        }
        return None$.MODULE$;
    }

    @Override
    public void markMicroBatchExecutionStart(MicroBatchExecutionContext execCtx) {
        this.checkNotStatefulStreamingQuery();
    }

    @Override
    public void cleanUpLastExecutedMicroBatch(MicroBatchExecutionContext execCtx) {
    }

    @Override
    public void markMicroBatchStart(MicroBatchExecutionContext execCtx) {
        Object object = new Object();
        try {
            ((CompletableFuture)this.offsetLog().addAsync(execCtx.batchId(), execCtx.endOffsets().toOffsetSeq(this.sources(), execCtx.offsetSeqMetadata())).thenAccept(tuple -> {
                Tuple2 tuple2 = tuple;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long batchId = tuple2._1$mcJ$sp();
                boolean persistedToDurableStorage = tuple2._2$mcZ$sp();
                Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(batchId, persistedToDurableStorage);
                long batchId2 = sp2._1$mcJ$sp();
                boolean persistedToDurableStorage2 = sp2._2$mcZ$sp();
                if (persistedToDurableStorage2) {
                    if (this.lastBatchPersistedToDurableStorage().get() == -1L) {
                        this.lastBatchPersistedToDurableStorage().set(BoxesRunTime.unboxToLong((Object)this.offsetLog().getPrevBatchFromStorage(batchId2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
                    }
                    if (batchId2 != 0L && this.lastBatchPersistedToDurableStorage().get() != -1L) {
                        Predef$.MODULE$.assert(this.lastBatchPersistedToDurableStorage().get() < batchId2);
                        Option prevBatchOff = this.offsetLog().get(this.lastBatchPersistedToDurableStorage().get());
                        if (!prevBatchOff.isDefined()) {
                            throw new IllegalStateException("Failed to commit processed data in the source because batch " + this.lastBatchPersistedToDurableStorage().get() + " doesn't exist in the offset log.  This should not happen.");
                        }
                        v0 = BoxesRunTime.boxToBoolean((boolean)this.sourceCommitQueue().add((OffsetSeq)prevBatchOff.get()));
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    this.lastBatchPersistedToDurableStorage().set(batchId2);
                    return;
                }
            })).exceptionally(th -> {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Encountered error while performing async offset write for batch " + execCtx.batchId(), (Throwable)th);
                this.errorNotifier().markError((Throwable)th);
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            OffsetSeq offset = this.sourceCommitQueue().poll();
            while (offset != null) {
                this.commitSources(offset);
                offset = this.sourceCommitQueue().poll();
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void markMicroBatchEnd(MicroBatchExecutionContext execCtx) {
        Object object = new Object();
        try {
            this.watermarkTracker().updateWatermark(execCtx.executionPlan().executedPlan());
            execCtx.reportTimeTaken("commitOffsets", (JFunction0.mcV.sp & Serializable)() -> {
                if (this.offsetLog().getAsyncOffsetWrite(execCtx.batchId()).nonEmpty() || this.isFirstBatch()) {
                    this.isFirstBatch_$eq(false);
                    v0 = this.commitLog().addAsync(execCtx.batchId(), new CommitMetadata(this.watermarkTracker().currentWatermark())).exceptionally(th -> BoxesRunTime.boxToLong((long)AsyncProgressTrackingMicroBatchExecution.$anonfun$markMicroBatchEnd$2(this, execCtx, object, th)));
                } else {
                    if (!this.commitLog().addInMemory(execCtx.batchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()))) {
                        throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(execCtx.batchId());
                    }
                    v0 = BoxedUnit.UNIT;
                }
                this.offsetLog().removeAsyncOffsetWrite(execCtx.batchId());
            });
            this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)execCtx.endOffsets()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void purge(long threshold) {
        while (this.offsetLog().writtenToDurableStorage().size() > this.minLogEntriesToMaintain()) {
            this.offsetLog().writtenToDurableStorage().poll();
        }
        this.offsetLog().purge(BoxesRunTime.unboxToLong((Object)this.offsetLog().writtenToDurableStorage().peek()));
        while (this.commitLog().writtenToDurableStorage().size() > this.minLogEntriesToMaintain()) {
            this.commitLog().writtenToDurableStorage().poll();
        }
        this.commitLog().purge(BoxesRunTime.unboxToLong((Object)this.commitLog().writtenToDurableStorage().peek()));
    }

    @Override
    public void cleanup() {
        super.cleanup();
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.asyncWritesExecutorService(), ThreadUtils$.MODULE$.shutdown$default$2());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Async progress tracking executor pool for query "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " has been shutdown"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PRETTY_ID_STRING$.MODULE$, (Object)this.prettyIdString())})))));
    }

    public boolean areWritesPendingOrInProgress() {
        return this.asyncWritesExecutorService().getQueue().size() > 0 || this.asyncWritesExecutorService().getActiveCount() > 0;
    }

    @Override
    public TriggerExecutor getTrigger() {
        return this.validateAndGetTrigger();
    }

    private TriggerExecutor validateAndGetTrigger() {
        Trigger trigger;
        block13: {
            if (!StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)this.extraOptions.getOrElse((Object)AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK(), (Function0 & Serializable)() -> "false")))) {
                try {
                    String string = this.plan.sink().name();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1007587933: {
                            if (!"noop-table".equals(string)) break;
                            break block13;
                        }
                        case -373802904: {
                            if (!"KafkaTable".equals(string)) break;
                            break block13;
                        }
                        case -316439724: {
                            if (!"MemorySink".equals(string)) break;
                            break block13;
                        }
                        case 951510359: {
                            if (!"console".equals(string)) break;
                            break block13;
                        }
                    }
                    throw new IllegalArgumentException("Sink " + this.plan.sink().name() + " does not support async progress tracking");
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("should not be called.")) {
                        throw new IllegalArgumentException("Sink " + this.plan.sink() + " does not support async progress tracking");
                    }
                    throw e;
                }
            }
        }
        if ((trigger = super.trigger()) instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger;
            return new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        }
        if (OneTimeTrigger$.MODULE$.equals(trigger)) {
            throw new IllegalArgumentException("Async progress tracking cannot be used with Once trigger");
        }
        if (AvailableNowTrigger$.MODULE$.equals(trigger)) {
            throw new IllegalArgumentException("Async progress tracking cannot be used with AvailableNow trigger");
        }
        throw new IllegalStateException("Unknown type of trigger: " + super.trigger());
    }

    private void checkNotStatefulStreamingQuery() {
        if (this.isFirstBatch()) {
            this.lastExecution().executedPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof StateStoreWriter) {
                        throw new IllegalArgumentException("Stateful streaming queries does not support async progress tracking at this moment.");
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    return sparkPlan instanceof StateStoreWriter;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$markMicroBatchEnd$2(AsyncProgressTrackingMicroBatchExecution $this, MicroBatchExecutionContext execCtx$2, Object nonLocalReturnKey2$1, Throwable th) {
        $this.logError((Function0<String>)(Function0 & Serializable)() -> "Got exception during async write to commit log for batch " + execCtx$2.batchId(), th);
        $this.errorNotifier().markError(th);
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
    }

    public AsyncProgressTrackingMicroBatchExecution(SparkSession sparkSession, Trigger trigger, Clock triggerClock, Map<String, String> extraOptions, WriteToStream plan) {
        this.extraOptions = extraOptions;
        this.plan = plan;
        super(sparkSession, trigger, triggerClock, extraOptions, plan);
        this.asyncProgressTrackingCheckpointingIntervalMs = AsyncProgressTrackingMicroBatchExecution$.MODULE$.org$apache$spark$sql$execution$streaming$AsyncProgressTrackingMicroBatchExecution$$getAsyncProgressTrackingCheckpointingIntervalMs(extraOptions);
        this.sourceCommitQueue = new ConcurrentLinkedQueue();
        this.lastBatchPersistedToDurableStorage = new AtomicLong(-1L);
        this.isFirstBatch = true;
        this.asyncWritesExecutorService = ThreadUtils$.MODULE$.newDaemonSingleThreadExecutorWithRejectedExecutionHandler("async-log-write", 2, new RejectedExecutionHandler(this){
            private final /* synthetic */ AsyncProgressTrackingMicroBatchExecution $outer;

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                block3: {
                    try {
                        if (executor.isShutdown()) break block3;
                        long start = System.currentTimeMillis();
                        executor.getQueue().put(r);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Async write paused execution for " + (System.currentTimeMillis() - start) + " due to task queue being full.");
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RejectedExecutionException("Producer interrupted", e);
                    }
                    catch (Throwable e) {
                        this.$outer.logError((Function0<String>)(Function0 & Serializable)() -> "Encountered error in async write executor service", e);
                        this.$outer.errorNotifier().markError(e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$rejectedExecution$1(long ), $anonfun$rejectedExecution$2()}, serializedLambda);
            }
        });
        this.offsetLog = new AsyncOffsetSeqLog(super.sparkSession(), this.checkpointFile("offsets"), this.asyncWritesExecutorService(), this.asyncProgressTrackingCheckpointingIntervalMs(), super.triggerClock());
        this.commitLog = new AsyncCommitLog(super.sparkSession(), this.checkpointFile("commits"), this.asyncWritesExecutorService());
        this.validateAndGetTrigger();
    }
}

