/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.ListStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.SingleKeyTTLStateImpl;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchema$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.util.NextIterator;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\r\u001a\u0001\u0019B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u000b!\u0004A\u0011A5\t\u0011E\u0004\u0001R1A\u0005\nID!\"!\u0004\u0001\u0011\u000b\u0007I\u0011BA\b\u0011)\t9\u0002\u0001EC\u0002\u0013%\u0011\u0011\u0004\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA0\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\t9\u0007\u0001C!\u0003SBq!a\u001e\u0001\t\u0013\tI\b\u0003\u0005\u0002\u0000\u0001!\t!HA\u0019\u0011!\t\t\t\u0001C\u0001;\u0005\r\u0005\u0002CAG\u0001\u0011\u0005Q$a$\u0003)1K7\u000f^*uCR,\u0017*\u001c9m/&$\b\u000e\u0016+M\u0015\tQ2$A\u0005tiJ,\u0017-\\5oO*\u0011A$H\u0001\nKb,7-\u001e;j_:T!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001)\"aJ\u001a\u0014\u0007\u0001AC\u0006\u0005\u0002*U5\t\u0011$\u0003\u0002,3\t)2+\u001b8hY\u0016\\U-\u001f+U\u0019N#\u0018\r^3J[Bd\u0007cA\u00170c5\taF\u0003\u0002\u001b;%\u0011\u0001G\f\u0002\n\u0019&\u001cHo\u0015;bi\u0016\u0004\"AM\u001a\r\u0001\u0011)A\u0007\u0001b\u0001k\t\t1+\u0005\u00027yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9aj\u001c;iS:<\u0007CA\u001c>\u0013\tq\u0004HA\u0002B]f\fQa\u001d;pe\u0016\u0004\"!\u0011#\u000e\u0003\tS!aQ\r\u0002\u000bM$\u0018\r^3\n\u0005\u0015\u0013%AC*uCR,7\u000b^8sK\u0006I1\u000f^1uK:\u000bW.\u001a\t\u0003\u0011>s!!S'\u0011\u0005)CT\"A&\u000b\u00051+\u0013A\u0002\u001fs_>$h(\u0003\u0002Oq\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0005(\u0001\u0006lKf,\u0005\u0010\u001d:F]\u000e\u00042\u0001V-=\u001b\u0005)&B\u0001,X\u0003!)gnY8eKJ\u001c(B\u0001-\u001e\u0003!\u0019\u0017\r^1msN$\u0018B\u0001.V\u0005E)\u0005\u0010\u001d:fgNLwN\\#oG>$WM]\u0001\u000bm\u0006dWI\\2pI\u0016\u0014\bcA/_c5\tQ$\u0003\u0002`;\t9QI\\2pI\u0016\u0014\u0018!\u0003;uY\u000e{gNZ5h!\ti#-\u0003\u0002d]\tIA\u000b\u0016'D_:4\u0017nZ\u0001\u0011E\u0006$8\r\u001b+j[\u0016\u001cH/Y7q\u001bN\u0004\"a\u000e4\n\u0005\u001dD$\u0001\u0002'p]\u001e\fa\u0001P5oSRtDc\u00026lY6tw\u000e\u001d\t\u0004S\u0001\t\u0004\"B \b\u0001\u0004\u0001\u0005\"\u0002$\b\u0001\u00049\u0005\"\u0002*\b\u0001\u0004\u0019\u0006\"B.\b\u0001\u0004a\u0006\"\u00021\b\u0001\u0004\t\u0007\"\u00023\b\u0001\u0004)\u0017!D6fsN+'/[1mSj,'/F\u0001t!\u0011!\u0018q\u0001\u001f\u000f\u0007U\f\u0019AD\u0002w\u0003\u0003q!a^@\u000f\u0005athBA=~\u001d\tQHP\u0004\u0002Kw&\tA%\u0003\u0002#G%\u0011\u0001%I\u0005\u0003=}I!\u0001W\u000f\n\u0005Y;\u0016bAA\u0003+\u0006\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\n\t\u0005%\u00111\u0002\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014(bAA\u0003+\u0006\t2\u000f^1uKRK\b/Z:F]\u000e|G-\u001a:\u0016\u0005\u0005E\u0001#B\u0015\u0002\u0014q\n\u0014bAA\u000b3\t\t2\u000b^1uKRK\b/Z:F]\u000e|G-\u001a:\u0002\u001fQ$H.\u0012=qSJ\fG/[8o\u001bN,\u0012!Z\u0001\u000bS:LG/[1mSj,GCAA\u0010!\r9\u0014\u0011E\u0005\u0004\u0003GA$\u0001B+oSR\fa!\u001a=jgR\u001cHCAA\u0015!\r9\u00141F\u0005\u0004\u0003[A$a\u0002\"p_2,\u0017M\\\u0001\u0004O\u0016$HCAA\u001a!\u0015\t)$a\u00102\u001d\u0011\t9$a\u000f\u000f\u0007)\u000bI$C\u0001:\u0013\r\ti\u0004O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t%a\u0011\u0003\u0011%#XM]1u_JT1!!\u00109\u0003\r\u0001X\u000f\u001e\u000b\u0005\u0003?\tI\u0005C\u0004\u0002L9\u0001\r!!\u0014\u0002\u00119,wo\u0015;bi\u0016\u0004BaNA(c%\u0019\u0011\u0011\u000b\u001d\u0003\u000b\u0005\u0013(/Y=\u0002\u0017\u0005\u0004\b/\u001a8e-\u0006dW/\u001a\u000b\u0005\u0003?\t9\u0006\u0003\u0004\u0002L=\u0001\r!M\u0001\u000bCB\u0004XM\u001c3MSN$H\u0003BA\u0010\u0003;Bq!a\u0013\u0011\u0001\u0004\ti%A\u0003dY\u0016\f'/\u0001\twC2LG-\u0019;f\u001d\u0016<8\u000b^1uKR!\u0011qDA3\u0011\u001d\tYE\u0005a\u0001\u0003\u001b\nab\u00197fCJLe-\u0012=qSJ,G\rF\u0002f\u0003WBq!!\u001c\u0014\u0001\u0004\ty'A\u0006he>,\b/\u001b8h\u0017\u0016L\b#B\u001c\u0002P\u0005E\u0004cA\u001c\u0002t%\u0019\u0011Q\u000f\u001d\u0003\t\tKH/Z\u0001\u0015kB\u001cXM\u001d;U)23uN]*uCR,7*Z=\u0015\t\u0005}\u00111\u0010\u0005\b\u0003{\"\u0002\u0019AA8\u0003U\u0019XM]5bY&TX\rZ$s_V\u0004\u0018N\\4LKf\facZ3u/&$\bn\\;u\u000b:4wN]2j]\u001e$F\u000bT\u0001\rO\u0016$H\u000b\u0016'WC2,Xm\u001d\u000b\u0003\u0003\u000b\u0003b!!\u000e\u0002@\u0005\u001d\u0005#B\u001c\u0002\nF*\u0017bAAFq\t1A+\u001e9mKJ\n1cZ3u-\u0006dW/Z:J]R#Fj\u0015;bi\u0016$\"!!%\u0011\u000b\u0005U\u0012qH3")
public class ListStateImplWithTTL<S>
extends SingleKeyTTLStateImpl
implements ListState<S> {
    private ExpressionEncoder.Serializer<Object> keySerializer;
    private StateTypesEncoder<Object, S> org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    private long ttlExpirationMs;
    private final StateStore store;
    private final String stateName;
    private ExpressionEncoder<Object> keyExprEnc;
    private Encoder<S> valEncoder;
    private TTLConfig ttlConfig;
    public final long org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs;
    private volatile byte bitmap$0;

    private ExpressionEncoder.Serializer<Object> keySerializer$lzycompute() {
        ListStateImplWithTTL listStateImplWithTTL = this;
        synchronized (listStateImplWithTTL) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keySerializer = this.keyExprEnc.createSerializer();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.keyExprEnc = null;
        return this.keySerializer;
    }

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.keySerializer$lzycompute();
        }
        return this.keySerializer;
    }

    private StateTypesEncoder<Object, S> stateTypesEncoder$lzycompute() {
        ListStateImplWithTTL listStateImplWithTTL = this;
        synchronized (listStateImplWithTTL) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(this.keySerializer(), this.valEncoder, this.stateName, true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.valEncoder = null;
        return this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    }

    public StateTypesEncoder<Object, S> org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.stateTypesEncoder$lzycompute();
        }
        return this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    }

    private long ttlExpirationMs$lzycompute() {
        ListStateImplWithTTL listStateImplWithTTL = this;
        synchronized (listStateImplWithTTL) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(this.ttlConfig.ttlDuration(), this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        this.ttlConfig = null;
        return this.ttlExpirationMs;
    }

    private long ttlExpirationMs() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.ttlExpirationMs$lzycompute();
        }
        return this.ttlExpirationMs;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, TransformWithStateKeyValueRowSchema$.MODULE$.KEY_ROW_SCHEMA(), TransformWithStateKeyValueRowSchema$.MODULE$.VALUE_ROW_SCHEMA_WITH_TTL(), new NoPrefixKeyStateEncoderSpec(TransformWithStateKeyValueRowSchema$.MODULE$.KEY_ROW_SCHEMA()), true, this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get().nonEmpty();
    }

    public Iterator<S> get() {
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedKey, this.stateName);
        return new NextIterator<S>(this, unsafeRowValuesIterator){
            private final /* synthetic */ ListStateImplWithTTL $outer;
            private final Iterator unsafeRowValuesIterator$1;

            public S getNext() {
                Iterator iter = this.unsafeRowValuesIterator$1.dropWhile((Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getNext$1(this, row)));
                if (iter.hasNext()) {
                    UnsafeRow currentRow = (UnsafeRow)iter.next();
                    return this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue(currentRow);
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }

            public static final /* synthetic */ boolean $anonfun$getNext$1($anon$1 $this, UnsafeRow row) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().isExpired(row, $this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unsafeRowValuesIterator$1 = unsafeRowValuesIterator$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getNext$1$adapted(org.apache.spark.sql.execution.streaming.ListStateImplWithTTL$$anon$1 org.apache.spark.sql.catalyst.expressions.UnsafeRow )}, serializedLambda);
            }
        };
    }

    public void put(Object newState) {
        this.validateNewState(newState);
        byte[] serializedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().serializeGroupingKey();
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeSerializedGroupingKey(serializedGroupingKey);
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(newState), (Function1 & Serializable)v -> {
            ListStateImplWithTTL.$anonfun$put$1(this, isFirst, encodedKey, v);
            return BoxedUnit.UNIT;
        });
        this.upsertTTLForStateKey(serializedGroupingKey);
    }

    public void appendValue(S newState) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(newState, this.stateName);
        byte[] serializedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().serializeGroupingKey();
        this.store.merge(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeSerializedGroupingKey(serializedGroupingKey), this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(newState, this.ttlExpirationMs()), this.stateName);
        this.upsertTTLForStateKey(serializedGroupingKey);
    }

    public void appendList(Object newState) {
        this.validateNewState(newState);
        byte[] serializedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().serializeGroupingKey();
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeSerializedGroupingKey(serializedGroupingKey);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(newState), (Function1 & Serializable)v -> {
            ListStateImplWithTTL.$anonfun$appendList$1(this, encodedKey, v);
            return BoxedUnit.UNIT;
        });
        this.upsertTTLForStateKey(serializedGroupingKey);
    }

    public void clear() {
        this.store.remove(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey(), this.stateName);
        this.clearTTLState();
    }

    private void validateNewState(Object newState) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(newState, this.stateName);
        StateStoreErrors$.MODULE$.requireNonEmptyListStateValue(newState, this.stateName);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(newState), (Function1 & Serializable)v -> {
            StateStoreErrors$.MODULE$.requireNonNullStateValue(v, this.stateName);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public long clearIfExpired(byte[] groupingKey) {
        LongRef numValuesExpired = LongRef.create((long)0L);
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeSerializedGroupingKey(groupingKey);
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedGroupingKey, this.stateName);
        this.store.remove(encodedGroupingKey, this.stateName);
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        unsafeRowValuesIterator.foreach((Function1 & Serializable)encodedValue -> {
            ListStateImplWithTTL.$anonfun$clearIfExpired$1(this, isFirst, encodedGroupingKey, numValuesExpired, encodedValue);
            return BoxedUnit.UNIT;
        });
        return numValuesExpired.elem;
    }

    private void upsertTTLForStateKey(byte[] serializedGroupingKey) {
        this.upsertTTLForStateKey(this.ttlExpirationMs(), serializedGroupingKey);
    }

    public Iterator<S> getWithoutEnforcingTTL() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedGroupingKey, this.stateName);
        return unsafeRowValuesIterator.map((Function1 & Serializable)valueUnsafeRow -> this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue((UnsafeRow)valueUnsafeRow));
    }

    public Iterator<Tuple2<S, Object>> getTTLValues() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedGroupingKey, this.stateName);
        return unsafeRowValuesIterator.map((Function1 & Serializable)valueUnsafeRow -> new Tuple2(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue((UnsafeRow)valueUnsafeRow), this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeTtlExpirationMs((UnsafeRow)valueUnsafeRow).get()));
    }

    public Iterator<Object> getValuesInTTLState() {
        return this.getValuesInTTLState(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().serializeGroupingKey());
    }

    public static final /* synthetic */ void $anonfun$put$1(ListStateImplWithTTL $this, BooleanRef isFirst$1, UnsafeRow encodedKey$1, Object v) {
        UnsafeRow encodedValue = $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(v, $this.ttlExpirationMs());
        if (isFirst$1.elem) {
            $this.store.put(encodedKey$1, encodedValue, $this.stateName);
            isFirst$1.elem = false;
            return;
        }
        $this.store.merge(encodedKey$1, encodedValue, $this.stateName);
    }

    public static final /* synthetic */ void $anonfun$appendList$1(ListStateImplWithTTL $this, UnsafeRow encodedKey$2, Object v) {
        UnsafeRow encodedValue = $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(v, $this.ttlExpirationMs());
        $this.store.merge(encodedKey$2, encodedValue, $this.stateName);
    }

    public static final /* synthetic */ void $anonfun$clearIfExpired$1(ListStateImplWithTTL $this, BooleanRef isFirst$2, UnsafeRow encodedGroupingKey$1, LongRef numValuesExpired$1, UnsafeRow encodedValue) {
        if (!$this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().isExpired(encodedValue, $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs)) {
            if (isFirst$2.elem) {
                $this.store.put(encodedGroupingKey$1, encodedValue, $this.stateName);
                isFirst$2.elem = false;
                return;
            }
            $this.store.merge(encodedGroupingKey$1, encodedValue, $this.stateName);
            return;
        }
        ++numValuesExpired$1.elem;
    }

    public ListStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<S> valEncoder, TTLConfig ttlConfig, long batchTimestampMs) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        this.ttlConfig = ttlConfig;
        this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs = batchTimestampMs;
        super(stateName, store, batchTimestampMs);
        this.initialize();
    }
}

