/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\r\u001a\u0001\u0019B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!A\u0007A!A!\u0002\u0013I\u0007\"\u00026\u0001\t\u0003Y\u0007bB:\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007w\u0002\u0001\u000b\u0011B;\t\u000fq\u0004!\u0019!C\u0005i\"1Q\u0010\u0001Q\u0001\nUDqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0001\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0017\u0011\u001d\t)\u0004\u0001C!\u0003oAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011Q\f\u0001\u0005B\u0005}\u0003bBA=\u0001\u0011\u0005\u00131\u0010\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!a#\u0001\t\u0003\niI\u0001\u0007NCB\u001cF/\u0019;f\u00136\u0004HN\u0003\u0002\u001b7\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00039u\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005yy\u0012aA:rY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007\u001d*th\u0005\u0003\u0001Q9\n\u0005CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00030cMrT\"\u0001\u0019\u000b\u0005ii\u0012B\u0001\u001a1\u0005!i\u0015\r]*uCR,\u0007C\u0001\u001b6\u0019\u0001!QA\u000e\u0001C\u0002]\u0012\u0011aS\t\u0003qm\u0002\"!K\u001d\n\u0005iR#a\u0002(pi\"Lgn\u001a\t\u0003SqJ!!\u0010\u0016\u0003\u0007\u0005s\u0017\u0010\u0005\u00025\u007f\u0011)\u0001\t\u0001b\u0001o\t\ta\u000b\u0005\u0002C\u000b6\t1I\u0003\u0002E?\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002G\u0007\n9Aj\\4hS:<\u0017!B:u_J,\u0007CA%M\u001b\u0005Q%BA&\u001a\u0003\u0015\u0019H/\u0019;f\u0013\ti%J\u0001\u0006Ti\u0006$Xm\u0015;pe\u0016\f\u0011b\u001d;bi\u0016t\u0015-\\3\u0011\u0005A;fBA)V!\t\u0011&&D\u0001T\u0015\t!V%\u0001\u0004=e>|GOP\u0005\u0003-*\na\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011aKK\u0001\u000bW\u0016LX\t\u001f9s\u000b:\u001c\u0007c\u0001/bw5\tQL\u0003\u0002_?\u0006AQM\\2pI\u0016\u00148O\u0003\u0002a;\u0005A1-\u0019;bYf\u001cH/\u0003\u0002c;\n\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0002\u0015U\u001cXM]&fs\u0016s7\rE\u0002fMNj\u0011!H\u0005\u0003Ov\u0011q!\u00128d_\u0012,'/\u0001\u0006wC2,enY8eKJ\u00042!\u001a4?\u0003\u0019a\u0014N\\5u}Q1AN\\8qcJ\u0004B!\u001c\u00014}5\t\u0011\u0004C\u0003H\r\u0001\u0007\u0001\nC\u0003O\r\u0001\u0007q\nC\u0003[\r\u0001\u00071\fC\u0003d\r\u0001\u0007A\rC\u0003i\r\u0001\u0007\u0011.\u0001\rtG\",W.\u0019$pe\u000e{W\u000e]8tSR,7*Z=S_^,\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003qv\tQ\u0001^=qKNL!A_<\u0003\u0015M#(/^2u)f\u0004X-A\rtG\",W.\u0019$pe\u000e{W\u000e]8tSR,7*Z=S_^\u0004\u0013!E:dQ\u0016l\u0017MR8s-\u0006dW/\u001a*po\u0006\u00112o\u00195f[\u00064uN\u001d,bYV,'k\\<!\u00035YW-_*fe&\fG.\u001b>feV\u0011\u0011\u0011\u0001\t\u0006\u0003\u0007\t\tc\u000f\b\u0005\u0003\u000b\tiB\u0004\u0003\u0002\b\u0005ma\u0002BA\u0005\u00033qA!a\u0003\u0002\u00189!\u0011QBA\u000b\u001d\u0011\ty!a\u0005\u000f\u0007I\u000b\t\"C\u0001%\u0013\t\u00113%\u0003\u0002!C%\u0011adH\u0005\u0003AvI!AX0\n\u0007\u0005}Q,A\tFqB\u0014Xm]:j_:,enY8eKJLA!a\t\u0002&\tQ1+\u001a:jC2L'0\u001a:\u000b\u0007\u0005}Q,\u0001\blKf\u001cVM]5bY&TXM\u001d\u0011\u0002#M$\u0018\r^3UsB,7/\u00128d_\u0012,'/\u0006\u0002\u0002.A1Q.a\f<gyJ1!!\r\u001a\u0005a\u0019u.\u001c9pg&$XmS3z'R\fG/Z#oG>$WM]\u0001\u0013gR\fG/\u001a+za\u0016\u001cXI\\2pI\u0016\u0014\b%\u0001\u0004fq&\u001cHo\u001d\u000b\u0003\u0003s\u00012!KA\u001e\u0013\r\tiD\u000b\u0002\b\u0005>|G.Z1o\u0003!9W\r\u001e,bYV,Gc\u0001 \u0002D!1\u0011Q\t\tA\u0002M\n1a[3z\u0003-\u0019wN\u001c;bS:\u001c8*Z=\u0015\t\u0005e\u00121\n\u0005\u0007\u0003\u000b\n\u0002\u0019A\u001a\u0002\u0017U\u0004H-\u0019;f-\u0006dW/\u001a\u000b\u0007\u0003#\n9&!\u0017\u0011\u0007%\n\u0019&C\u0002\u0002V)\u0012A!\u00168ji\"1\u0011Q\t\nA\u0002MBa!a\u0017\u0013\u0001\u0004q\u0014!\u0002<bYV,\u0017\u0001C5uKJ\fGo\u001c:\u0015\u0005\u0005\u0005\u0004CBA2\u0003[\n\u0019H\u0004\u0003\u0002f\u0005%db\u0001*\u0002h%\t1&C\u0002\u0002l)\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002p\u0005E$\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005-$\u0006E\u0003*\u0003k\u001ad(C\u0002\u0002x)\u0012a\u0001V;qY\u0016\u0014\u0014\u0001B6fsN$\"!! \u0011\u000b\u0005\r\u0014QN\u001a\u0002\rY\fG.^3t)\t\t\u0019\tE\u0003\u0002d\u00055d(A\u0005sK6|g/Z&fsR!\u0011\u0011KAE\u0011\u0019\t)E\u0006a\u0001g\u0005)1\r\\3beR\u0011\u0011\u0011\u000b")
public class MapStateImpl<K, V>
implements MapState<K, V>,
Logging {
    private final StateStore store;
    private final String stateName;
    private final StructType schemaForCompositeKeyRow;
    private final StructType schemaForValueRow;
    private final ExpressionEncoder.Serializer<Object> keySerializer;
    private final CompositeKeyStateEncoder<Object, K, V> stateTypesEncoder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schemaForCompositeKeyRow() {
        return this.schemaForCompositeKeyRow;
    }

    private StructType schemaForValueRow() {
        return this.schemaForValueRow;
    }

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        return this.keySerializer;
    }

    private CompositeKeyStateEncoder<Object, K, V> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    public boolean exists() {
        return this.store.prefixScan(this.stateTypesEncoder().encodeGroupingKey(), this.stateName).nonEmpty();
    }

    public V getValue(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow encodedCompositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        UnsafeRow unsafeRowValue = this.store.get(encodedCompositeKey, this.stateName);
        if (unsafeRowValue == null) {
            return null;
        }
        return this.stateTypesEncoder().decodeValue(unsafeRowValue);
    }

    public boolean containsKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        return this.getValue(key) != null;
    }

    public void updateValue(K key, V value) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        StateStoreErrors$.MODULE$.requireNonNullStateValue(value, this.stateName);
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(value);
        UnsafeRow encodedCompositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        this.store.put(encodedCompositeKey, encodedValue, this.stateName);
    }

    public Iterator<Tuple2<K, V>> iterator() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        return this.store.prefixScan(encodedGroupingKey, this.stateName).map((Function1 & Serializable)x0$1 -> {
            UnsafeRowPair unsafeRowPair = x0$1;
            if (unsafeRowPair != null) {
                UnsafeRowPair unsafeRowPair2 = unsafeRowPair;
                return new Tuple2(this.stateTypesEncoder().decodeCompositeKey(unsafeRowPair2.key()), this.stateTypesEncoder().decodeValue(unsafeRowPair2.value()));
            }
            throw new MatchError((Object)unsafeRowPair);
        });
    }

    public Iterator<K> keys() {
        return this.iterator().map((Function1 & Serializable)x$1 -> x$1._1());
    }

    public Iterator<V> values() {
        return this.iterator().map((Function1 & Serializable)x$2 -> x$2._2());
    }

    public void removeKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow compositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        this.store.remove(compositeKey, this.stateName);
    }

    public void clear() {
        this.keys().foreach((Function1 & Serializable)itr -> {
            this.removeKey(itr);
            return BoxedUnit.UNIT;
        });
    }

    public MapStateImpl(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<K> userKeyEnc, Encoder<V> valEncoder) {
        this.store = store;
        this.stateName = stateName;
        Logging.$init$((Logging)this);
        this.schemaForCompositeKeyRow = new StructType().add("key", (DataType)BinaryType$.MODULE$).add("userKey", (DataType)BinaryType$.MODULE$);
        this.schemaForValueRow = new StructType().add("value", (DataType)BinaryType$.MODULE$);
        this.keySerializer = keyExprEnc.createSerializer();
        this.stateTypesEncoder = new CompositeKeyStateEncoder<Object, K, V>(this.keySerializer(), userKeyEnc, valEncoder, this.schemaForCompositeKeyRow(), stateName, CompositeKeyStateEncoder$.MODULE$.$lessinit$greater$default$6());
        store.createColFamilyIfAbsent(stateName, this.schemaForCompositeKeyRow(), this.schemaForValueRow(), new PrefixKeyScanStateEncoderSpec(this.schemaForCompositeKeyRow(), 1), store.createColFamilyIfAbsent$default$5(), store.createColFamilyIfAbsent$default$6());
    }
}

