/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.CompositeKeyTTLRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyTTLStateImpl;
import org.apache.spark.sql.execution.streaming.MapStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchema$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001B\u000f\u001f\u0001-B\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!A!\u0002\u0013y\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0011Q\u0004!\u0011!Q\u0001\nUDQ\u0001\u001f\u0001\u0005\u0002eD\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005=\u0002\u0001)A\u0005\u0003\u0013A\u0011\"!\r\u0001\u0005\u0004%I!a\r\t\u0011\u0005m\u0002\u0001)A\u0005\u0003kA\u0011\"!\u0010\u0001\u0005\u0004%I!a\u0010\t\u000f\u0005\u0005\u0003\u0001)A\u0005k\"9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!\u001a\u0001\t\u0003\n9\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005bBAL\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003;\u0003A\u0011IA#\u0011\u001d\ty\n\u0001C!\u0003CC\u0001\"a.\u0001\t\u0003\u0011\u0013\u0011\u0018\u0005\t\u0003\u0007\u0004A\u0011\u0001\u0012\u0002F\"A\u0011Q\u001a\u0001\u0005\u0002\t\nyMA\nNCB\u001cF/\u0019;f\u00136\u0004HnV5uQR#FJ\u0003\u0002 A\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003C\t\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0016\u00071BTi\u0005\u0003\u0001[E:\u0005C\u0001\u00180\u001b\u0005q\u0012B\u0001\u0019\u001f\u0005a\u0019u.\u001c9pg&$XmS3z)Rc5\u000b^1uK&k\u0007\u000f\u001c\t\u0005eQ2D)D\u00014\u0015\ty\"%\u0003\u00026g\tAQ*\u00199Ti\u0006$X\r\u0005\u00028q1\u0001A!B\u001d\u0001\u0005\u0004Q$!A&\u0012\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002(pi\"Lgn\u001a\t\u0003y\tK!aQ\u001f\u0003\u0007\u0005s\u0017\u0010\u0005\u00028\u000b\u0012)a\t\u0001b\u0001u\t\ta\u000b\u0005\u0002I\u00176\t\u0011J\u0003\u0002KI\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002M\u0013\n9Aj\\4hS:<\u0017!B:u_J,\u0007CA(S\u001b\u0005\u0001&BA)\u001f\u0003\u0015\u0019H/\u0019;f\u0013\t\u0019\u0006K\u0001\u0006Ti\u0006$Xm\u0015;pe\u0016\f\u0011b\u001d;bi\u0016t\u0015-\\3\u0011\u0005YkfBA,\\!\tAV(D\u0001Z\u0015\tQ&&\u0001\u0004=e>|GOP\u0005\u00039v\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A,P\u0001\u000bW\u0016LX\t\u001f9s\u000b:\u001c\u0007c\u00012h\u00036\t1M\u0003\u0002eK\u0006AQM\\2pI\u0016\u00148O\u0003\u0002gE\u0005A1-\u0019;bYf\u001cH/\u0003\u0002iG\n\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0002\u0015U\u001cXM]&fs\u0016s7\rE\u0002lYZj\u0011AI\u0005\u0003[\n\u0012q!\u00128d_\u0012,'/\u0001\u0006wC2,enY8eKJ\u00042a\u001b7E\u0003%!H\u000f\\\"p]\u001aLw\r\u0005\u00023e&\u00111o\r\u0002\n)Rc5i\u001c8gS\u001e\f\u0001CY1uG\"$\u0016.\\3ti\u0006l\u0007/T:\u0011\u0005q2\u0018BA<>\u0005\u0011auN\\4\u0002\rqJg.\u001b;?))Q8\u0010`?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0005]\u00011D\tC\u0003N\u0011\u0001\u0007a\nC\u0003U\u0011\u0001\u0007Q\u000bC\u0003a\u0011\u0001\u0007\u0011\rC\u0003j\u0011\u0001\u0007!\u000eC\u0003o\u0011\u0001\u0007q\u000eC\u0003q\u0011\u0001\u0007\u0011\u000fC\u0003u\u0011\u0001\u0007Q/A\u0007lKf\u001cVM]5bY&TXM]\u000b\u0003\u0003\u0013\u0001R!a\u0003\u0002*\u0005sA!!\u0004\u0002&9!\u0011qBA\u0012\u001d\u0011\t\t\"!\t\u000f\t\u0005M\u0011q\u0004\b\u0005\u0003+\tiB\u0004\u0003\u0002\u0018\u0005mab\u0001-\u0002\u001a%\t\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003G\u0011J!A\u001a\u0012\n\u0005\u0011,\u0017bAA\u0014G\u0006\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\n\t\u0005-\u0012Q\u0006\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014(bAA\u0014G\u0006q1.Z=TKJL\u0017\r\\5{KJ\u0004\u0013!E:uCR,G+\u001f9fg\u0016s7m\u001c3feV\u0011\u0011Q\u0007\t\u0007]\u0005]\u0012I\u000e#\n\u0007\u0005ebD\u0001\rD_6\u0004xn]5uK.+\u0017p\u0015;bi\u0016,enY8eKJ\f!c\u001d;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3sA\u0005yA\u000f\u001e7FqBL'/\u0019;j_:l5/F\u0001v\u0003A!H\u000f\\#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!a\u0012\u0011\u0007q\nI%C\u0002\u0002Lu\u0012A!\u00168ji\u00061Q\r_5tiN$\"!!\u0015\u0011\u0007q\n\u0019&C\u0002\u0002Vu\u0012qAQ8pY\u0016\fg.\u0001\u0005hKR4\u0016\r\\;f)\r!\u00151\f\u0005\u0007\u0003;\n\u0002\u0019\u0001\u001c\u0002\u0007-,\u00170A\u0006d_:$\u0018-\u001b8t\u0017\u0016LH\u0003BA)\u0003GBa!!\u0018\u0013\u0001\u00041\u0014aC;qI\u0006$XMV1mk\u0016$b!a\u0012\u0002j\u0005-\u0004BBA/'\u0001\u0007a\u0007\u0003\u0004\u0002nM\u0001\r\u0001R\u0001\u0006m\u0006dW/Z\u0001\tSR,'/\u0019;peR\u0011\u00111\u000f\t\u0007\u0003k\ny(!\"\u000f\t\u0005]\u00141\u0010\b\u00041\u0006e\u0014\"\u0001 \n\u0007\u0005uT(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00151\u0011\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011QP\u001f\u0011\u000bq\n9I\u000e#\n\u0007\u0005%UH\u0001\u0004UkBdWMM\u0001\u0005W\u0016L8\u000f\u0006\u0002\u0002\u0010B)\u0011QOA@m\u00051a/\u00197vKN$\"!!&\u0011\u000b\u0005U\u0014q\u0010#\u0002\u0013I,Wn\u001c<f\u0017\u0016LH\u0003BA$\u00037Ca!!\u0018\u0018\u0001\u00041\u0014!B2mK\u0006\u0014\u0018AD2mK\u0006\u0014\u0018JZ#ya&\u0014X\r\u001a\u000b\u0006k\u0006\r\u00161\u0017\u0005\b\u0003KK\u0002\u0019AAT\u0003-9'o\\;qS:<7*Z=\u0011\u000bq\nI+!,\n\u0007\u0005-VHA\u0003BeJ\f\u0017\u0010E\u0002=\u0003_K1!!->\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005U\u0016\u00041\u0001\u0002(\u00069Qo]3s\u0017\u0016L\u0018AF4fi^KG\u000f[8vi\u0016sgm\u001c:dS:<G\u000b\u0016'\u0015\t\u0005m\u0016\u0011\u0019\t\u0005y\u0005uF)C\u0002\u0002@v\u0012aa\u00149uS>t\u0007BBA[5\u0001\u0007a'A\u0006hKR$F\u000b\u0014,bYV,G\u0003BAd\u0003\u0017\u0004R\u0001PA_\u0003\u0013\u0004R\u0001PAD\tVDa!!.\u001c\u0001\u00041\u0014AF4fi.+\u0017PV1mk\u0016\u001c\u0018J\u001c+U\u0019N#\u0018\r^3\u0015\u0005\u0005E\u0007CBA;\u0003\u007f\n\u0019\u000eE\u0003=\u0003\u000f3T\u000f")
public class MapStateImplWithTTL<K, V>
extends CompositeKeyTTLStateImpl
implements MapState<K, V>,
Logging {
    private final StateStore store;
    private final String stateName;
    public final long org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs;
    private final ExpressionEncoder.Serializer<Object> keySerializer;
    private final CompositeKeyStateEncoder<Object, K, V> org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder;
    private final long ttlExpirationMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        return this.keySerializer;
    }

    public CompositeKeyStateEncoder<Object, K, V> org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder() {
        return this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder;
    }

    private long ttlExpirationMs() {
        return this.ttlExpirationMs;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, TransformWithStateKeyValueRowSchema$.MODULE$.COMPOSITE_KEY_ROW_SCHEMA(), TransformWithStateKeyValueRowSchema$.MODULE$.VALUE_ROW_SCHEMA_WITH_TTL(), new PrefixKeyScanStateEncoderSpec(TransformWithStateKeyValueRowSchema$.MODULE$.COMPOSITE_KEY_ROW_SCHEMA(), 1), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.iterator().nonEmpty();
    }

    public V getValue(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        if (retRow != null) {
            if (!this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(retRow, this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs)) {
                return this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(retRow);
            }
            return null;
        }
        return null;
    }

    public boolean containsKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        return this.getValue(key) != null;
    }

    public void updateValue(K key, V value) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        StateStoreErrors$.MODULE$.requireNonNullStateValue(value, this.stateName);
        byte[] serializedGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().serializeGroupingKey();
        byte[] serializedUserKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().serializeUserKey(key);
        UnsafeRow encodedValue = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeValue(value, this.ttlExpirationMs());
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(serializedGroupingKey, serializedUserKey);
        this.store.put(encodedCompositeKey, encodedValue, this.stateName);
        this.upsertTTLForStateKey(this.ttlExpirationMs(), serializedGroupingKey, serializedUserKey);
    }

    public Iterator<Tuple2<K, V>> iterator() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRowPair> unsafeRowPairIterator = this.store.prefixScan(encodedGroupingKey, this.stateName);
        return new NextIterator<Tuple2<K, V>>(this, unsafeRowPairIterator){
            private final /* synthetic */ MapStateImplWithTTL $outer;
            private final Iterator unsafeRowPairIterator$1;

            public Tuple2<K, V> getNext() {
                Iterator iter = this.unsafeRowPairIterator$1.dropWhile((Function1 & Serializable)rowPair -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getNext$1(this, rowPair)));
                if (iter.hasNext()) {
                    UnsafeRowPair currentRowPair = (UnsafeRowPair)iter.next();
                    K key = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeCompositeKey(currentRowPair.key());
                    V value = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(currentRowPair.value());
                    return new Tuple2(key, value);
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }

            public static final /* synthetic */ boolean $anonfun$getNext$1($anon$1 $this, UnsafeRowPair rowPair) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(rowPair.value(), $this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unsafeRowPairIterator$1 = unsafeRowPairIterator$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getNext$1$adapted(org.apache.spark.sql.execution.streaming.MapStateImplWithTTL$$anon$1 org.apache.spark.sql.execution.streaming.state.UnsafeRowPair )}, serializedLambda);
            }
        };
    }

    public Iterator<K> keys() {
        return this.iterator().map((Function1 & Serializable)x$1 -> x$1._1());
    }

    public Iterator<V> values() {
        return this.iterator().map((Function1 & Serializable)x$2 -> x$2._2());
    }

    public void removeKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow compositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        this.store.remove(compositeKey, this.stateName);
    }

    public void clear() {
        this.keys().foreach((Function1 & Serializable)itr -> {
            this.removeKey(itr);
            return BoxedUnit.UNIT;
        });
        this.clearTTLState();
    }

    @Override
    public long clearIfExpired(byte[] groupingKey, byte[] userKey) {
        long numRemovedElements;
        block0: {
            UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(groupingKey, userKey);
            UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
            numRemovedElements = 0L;
            if (retRow == null || !this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(retRow, this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs)) break block0;
            this.store.remove(encodedCompositeKey, this.stateName);
            ++numRemovedElements;
        }
        return numRemovedElements;
    }

    public Option<V> getWithoutEnforcingTTL(K userKey) {
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(userKey);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        if (retRow != null) {
            Object resState = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(retRow);
            return new Some(resState);
        }
        return None$.MODULE$;
    }

    public Option<Tuple2<V, Object>> getTTLValue(K userKey) {
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(userKey);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        return Option$.MODULE$.apply((Object)retRow).flatMap((Function1 & Serializable)row -> {
            Option<Object> ttlExpiration = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeTtlExpirationMs((UnsafeRow)row);
            return ttlExpiration.map((Function1 & Serializable)expiration -> MapStateImplWithTTL.$anonfun$getTTLValue$2(this, row, BoxesRunTime.unboxToLong((Object)expiration)));
        });
    }

    public Iterator<Tuple2<K, Object>> getKeyValuesInTTLState() {
        Iterator<CompositeKeyTTLRow> ttlIterator = this.ttlIndexIterator();
        byte[] implicitGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().serializeGroupingKey();
        ObjectRef nextValue = ObjectRef.create((Object)None$.MODULE$);
        return new Iterator<Tuple2<K, Object>>(this, nextValue, ttlIterator, implicitGroupingKey){
            private final /* synthetic */ MapStateImplWithTTL $outer;
            private final ObjectRef nextValue$1;
            private final Iterator ttlIterator$1;
            private final byte[] implicitGroupingKey$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Tuple2<K, Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Tuple2<K, Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Tuple2<K, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> partition(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<K, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<K, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Tuple2<K, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Tuple2<K, Object>> filter(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> filterNot(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> filterImpl(Function1<Tuple2<K, Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Tuple2<K, Object>> withFilter(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<K, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Tuple2<K, Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Tuple2<K, Object>> distinctBy(Function1<Tuple2<K, Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Tuple2<K, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<K, Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Tuple2<K, Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Tuple2<K, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<K, Object>> takeWhile(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<K, Object>> dropWhile(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> span(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<K, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Tuple2<K, Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Tuple2<K, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U$> Iterator<Tuple2<K, Object>> tapEach(Function1<Tuple2<K, Object>, U$> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Tuple2<K, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U$> void foreach(Function1<Tuple2<K, Object>, U$> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Tuple2<K, Object>> find(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<K, Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<K, Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Tuple2<K, Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Tuple2<K, Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<K, Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<K, Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<K, Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<K, Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> maxByOption(Function1<Tuple2<K, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> minByOption(Function1<Tuple2<K, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<K, Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<K, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<K, Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Tuple2<K, Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Tuple2<K, Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Tuple2<K, Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Tuple2<K, Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V> Map<K$, V> toMap(.less.colon.less<Tuple2<K, Object>, Tuple2<K$, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Tuple2<K, Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Tuple2<K, Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Tuple2<K, Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Tuple2<K, Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S$ extends Stepper<?>> S$ stepper(StepperShape<Tuple2<K, Object>, S$> shape) {
                return (S$)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public boolean hasNext() {
                while (((Option)this.nextValue$1.elem).isEmpty() && this.ttlIterator$1.hasNext()) {
                    CompositeKeyTTLRow nextTtlValue = (CompositeKeyTTLRow)this.ttlIterator$1.next();
                    byte[] groupingKey = nextTtlValue.groupingKey();
                    if (!Predef$.MODULE$.wrapByteArray(groupingKey).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(this.implicitGroupingKey$1))) continue;
                    K userKey = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeUserKeyFromTTLRow(nextTtlValue);
                    this.nextValue$1.elem = new Some((Object)new Tuple2(userKey, (Object)BoxesRunTime.boxToLong((long)nextTtlValue.expirationMs())));
                }
                return ((Option)this.nextValue$1.elem).isDefined();
            }

            public Tuple2<K, Object> next() {
                Tuple2 result = (Tuple2)((Option)this.nextValue$1.elem).get();
                this.nextValue$1.elem = None$.MODULE$;
                return result;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nextValue$1 = nextValue$1;
                this.ttlIterator$1 = ttlIterator$1;
                this.implicitGroupingKey$1 = implicitGroupingKey$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }
        };
    }

    public static final /* synthetic */ Tuple2 $anonfun$getTTLValue$2(MapStateImplWithTTL $this, UnsafeRow row$1, long expiration) {
        return new Tuple2($this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(row$1), (Object)BoxesRunTime.boxToLong((long)expiration));
    }

    public MapStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<K> userKeyEnc, Encoder<V> valEncoder, TTLConfig ttlConfig, long batchTimestampMs) {
        this.store = store;
        this.stateName = stateName;
        this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs = batchTimestampMs;
        super(stateName, store, batchTimestampMs);
        Logging.$init$((Logging)this);
        this.keySerializer = keyExprEnc.createSerializer();
        this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder = new CompositeKeyStateEncoder<Object, K, V>(this.keySerializer(), userKeyEnc, valEncoder, TransformWithStateKeyValueRowSchema$.MODULE$.COMPOSITE_KEY_ROW_SCHEMA(), stateName, true);
        this.ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(ttlConfig.ttlDuration(), batchTimestampMs);
        this.initialize();
    }
}

