/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchema$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001B\u0010!\u00015B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t7\u0002\u0011\t\u0011)A\u00059\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001dA\bA1A\u0005\neDq!!\u0001\u0001A\u0003%!\u0010\u0003\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003z\u0011\u001d\t)\u0001\u0001Q\u0001\niD\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u0017A\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005m\u0001\u0001)A\u0005\u00033A\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003CA\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005M\u0002\u0001)A\u0005\u0003[Aq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003bBA)\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a\u001f\u0001\t\u0003\tihB\u0004\u0002\u0006\u0002B\t!a\"\u0007\r}\u0001\u0003\u0012AAE\u0011\u0019\u00018\u0004\"\u0001\u0002\f\"9\u0011QR\u000e\u0005\u0002\u0005=\u0005\"CAU7E\u0005I\u0011AAV\u0005E\u0019F/\u0019;f)f\u0004Xm]#oG>$WM\u001d\u0006\u0003C\t\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\r\"\u0013!C3yK\u000e,H/[8o\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001+\rq#+Y\n\u0003\u0001=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0017!D6fsN+'/[1mSj,'\u000fE\u00028\u001bBs!\u0001\u000f&\u000f\u0005e:eB\u0001\u001eF\u001d\tYDI\u0004\u0002=\u0007:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u00012\na\u0001\u0010:p_Rt\u0014\"A\u0016\n\u0005%R\u0013BA\u0014)\u0013\t)c%\u0003\u0002GI\u0005A1-\u0019;bYf\u001cH/\u0003\u0002I\u0013\u0006AQM\\2pI\u0016\u00148O\u0003\u0002GI%\u00111\nT\u0001\u0012\u000bb\u0004(/Z:tS>tWI\\2pI\u0016\u0014(B\u0001%J\u0013\tquJ\u0001\u0006TKJL\u0017\r\\5{KJT!a\u0013'\u0011\u0005E\u0013F\u0002\u0001\u0003\u0006'\u0002\u0011\r\u0001\u0016\u0002\u0003\u000f.\u000b\"!\u0016-\u0011\u0005A2\u0016BA,2\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001M-\n\u0005i\u000b$aA!os\u0006Qa/\u00197F]\u000e|G-\u001a:\u0011\u0007us\u0006-D\u0001%\u0013\tyFEA\u0004F]\u000e|G-\u001a:\u0011\u0005E\u000bG!\u00022\u0001\u0005\u0004!&!\u0001,\u0002\u0013M$\u0018\r^3OC6,\u0007CA3j\u001d\t1w\r\u0005\u0002?c%\u0011\u0001.M\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002ic\u00051\u0001.Y:Ui2\u0004\"\u0001\r8\n\u0005=\f$a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI$XO^<\u0011\tM\u0004\u0001\u000bY\u0007\u0002A!)Q'\u0002a\u0001m!)1,\u0002a\u00019\")1-\u0002a\u0001I\")A.\u0002a\u0001[\u0006i1.Z=Qe>TWm\u0019;j_:,\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{&\u000b1\"\u001a=qe\u0016\u001c8/[8og&\u0011q\u0010 \u0002\u0011+:\u001c\u0018MZ3Qe>TWm\u0019;j_:\fab[3z!J|'.Z2uS>t\u0007%A\bwC2,X\r\u0015:pU\u0016\u001cG/[8o\u0003A1\u0018\r\\;f!J|'.Z2uS>t\u0007%\u0001\twC2,\u0005\u0010\u001d:fgNLwN\\#oGV\u0011\u00111\u0002\t\u0006\u0003\u001b\ty\u0001Y\u0007\u0002\u0019&\u0019\u0011\u0011\u0003'\u0003#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/A\twC2,\u0005\u0010\u001d:fgNLwN\\#oG\u0002\n!c\u001c2k)>\u0014vn^*fe&\fG.\u001b>feV\u0011\u0011\u0011\u0004\t\u0004o5\u0003\u0017aE8cUR{'k\\<TKJL\u0017\r\\5{KJ\u0004\u0013\u0001\u0006:poR{wJ\u00196EKN,'/[1mSj,'/\u0006\u0002\u0002\"A!q'a\ta\u0013\r\t)c\u0014\u0002\r\t\u0016\u001cXM]5bY&TXM]\u0001\u0016e><Hk\\(cU\u0012+7/\u001a:jC2L'0\u001a:!\u00031\u0011X-^:fIZ\u000bGNU8x+\t\ti\u0003E\u0002|\u0003_I1!!\r}\u0005%)fn]1gKJ{w/A\u0007sKV\u001cX\r\u001a,bYJ{w\u000fI\u0001\u0012K:\u001cw\u000eZ3He>,\b/\u001b8h\u0017\u0016LHCAA\u0017\u0003m)gnY8eKN+'/[1mSj,Gm\u0012:pkBLgnZ&fsR!\u0011QFA\u001f\u0011\u001d\tyd\u0005a\u0001\u0003\u0003\n\u0001c\u001a:pkBLgnZ&fs\nKH/Z:\u0011\u000bA\n\u0019%a\u0012\n\u0007\u0005\u0015\u0013GA\u0003BeJ\f\u0017\u0010E\u00021\u0003\u0013J1!a\u00132\u0005\u0011\u0011\u0015\u0010^3\u0002)M,'/[1mSj,wI]8va&twmS3z)\t\t\t%A\u0006f]\u000e|G-\u001a,bYV,G\u0003BA\u0017\u0003+Ba!a\u0016\u0016\u0001\u0004\u0001\u0017!\u0002<bYV,GCBA\u0017\u00037\ni\u0006\u0003\u0004\u0002XY\u0001\r\u0001\u0019\u0005\b\u0003?2\u0002\u0019AA1\u00031)\u0007\u0010]5sCRLwN\\'t!\r\u0001\u00141M\u0005\u0004\u0003K\n$\u0001\u0002'p]\u001e\f1\u0002Z3d_\u0012,g+\u00197vKR\u0019\u0001-a\u001b\t\u000f\u00055t\u00031\u0001\u0002.\u0005\u0019!o\\<\u0002+\u0011,7m\u001c3f)RdW\t\u001f9je\u0006$\u0018n\u001c8NgR!\u00111OA=!\u0015\u0001\u0014QOA1\u0013\r\t9(\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u00055\u0004\u00041\u0001\u0002.\u0005I\u0011n]#ya&\u0014X\r\u001a\u000b\u0006[\u0006}\u0014\u0011\u0011\u0005\b\u0003[J\u0002\u0019AA\u0017\u0011\u001d\t\u0019)\u0007a\u0001\u0003C\n\u0001CY1uG\"$\u0016.\\3ti\u0006l\u0007/T:\u0002#M#\u0018\r^3UsB,7/\u00128d_\u0012,'\u000f\u0005\u0002t7M\u00111d\f\u000b\u0003\u0003\u000f\u000bQ!\u00199qYf,b!!%\u0002\u0018\u0006mECCAJ\u0003;\u000b\t+!*\u0002(B11\u000fAAK\u00033\u00032!UAL\t\u0015\u0019VD1\u0001U!\r\t\u00161\u0014\u0003\u0006Ev\u0011\r\u0001\u0016\u0005\u0007ku\u0001\r!a(\u0011\t]j\u0015Q\u0013\u0005\u00077v\u0001\r!a)\u0011\tus\u0016\u0011\u0014\u0005\u0006Gv\u0001\r\u0001\u001a\u0005\bYv\u0001\n\u00111\u0001n\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TCBAW\u0003\u0007\f)-\u0006\u0002\u00020*\u001aQ.!-,\u0005\u0005M\u0006\u0003BA[\u0003\u007fk!!a.\u000b\t\u0005e\u00161X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!02\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\f9LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$Qa\u0015\u0010C\u0002Q#QA\u0019\u0010C\u0002Q\u0003")
public class StateTypesEncoder<GK, V> {
    private final ExpressionEncoder.Serializer<GK> keySerializer;
    private final String stateName;
    private final boolean hasTtl;
    private final UnsafeProjection keyProjection;
    private final UnsafeProjection valueProjection;
    private final ExpressionEncoder<V> valExpressionEnc;
    private final ExpressionEncoder.Serializer<V> objToRowSerializer;
    private final ExpressionEncoder.Deserializer<V> rowToObjDeserializer;
    private final UnsafeRow reusedValRow;

    public static <GK, V> boolean apply$default$4() {
        return StateTypesEncoder$.MODULE$.apply$default$4();
    }

    public static <GK, V> StateTypesEncoder<GK, V> apply(ExpressionEncoder.Serializer<GK> keySerializer, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        return StateTypesEncoder$.MODULE$.apply(keySerializer, valEncoder, stateName, hasTtl);
    }

    private UnsafeProjection keyProjection() {
        return this.keyProjection;
    }

    private UnsafeProjection valueProjection() {
        return this.valueProjection;
    }

    private ExpressionEncoder<V> valExpressionEnc() {
        return this.valExpressionEnc;
    }

    private ExpressionEncoder.Serializer<V> objToRowSerializer() {
        return this.objToRowSerializer;
    }

    private ExpressionEncoder.Deserializer<V> rowToObjDeserializer() {
        return this.rowToObjDeserializer;
    }

    private UnsafeRow reusedValRow() {
        return this.reusedValRow;
    }

    public UnsafeRow encodeGroupingKey() {
        UnsafeRow keyRow = this.keyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.serializeGroupingKey()})));
        return keyRow;
    }

    public UnsafeRow encodeSerializedGroupingKey(byte[] groupingKeyBytes) {
        UnsafeRow keyRow = this.keyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupingKeyBytes})));
        return keyRow;
    }

    public byte[] serializeGroupingKey() {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(this.stateName);
        }
        Object groupingKey = keyOption.get();
        return ((UnsafeRow)this.keySerializer.apply(groupingKey)).getBytes();
    }

    public UnsafeRow encodeValue(V value) {
        InternalRow objRow = this.objToRowSerializer().apply(value);
        byte[] bytes = ((UnsafeRow)objRow).getBytes();
        return this.valueProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bytes})));
    }

    public UnsafeRow encodeValue(V value, long expirationMs) {
        InternalRow objRow = this.objToRowSerializer().apply(value);
        byte[] bytes = ((UnsafeRow)objRow).getBytes();
        return this.valueProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bytes, BoxesRunTime.boxToLong((long)expirationMs)})));
    }

    public V decodeValue(UnsafeRow row) {
        byte[] bytes = row.getBinary(0);
        this.reusedValRow().pointTo(bytes, bytes.length);
        Object value = this.rowToObjDeserializer().apply((InternalRow)this.reusedValRow());
        return (V)value;
    }

    public Option<Object> decodeTtlExpirationMs(UnsafeRow row) {
        Predef$.MODULE$.assert(this.hasTtl);
        long expirationMs = row.getLong(1);
        if (expirationMs == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)expirationMs));
    }

    public boolean isExpired(UnsafeRow row, long batchTimestampMs) {
        Option<Object> expirationMs = this.decodeTtlExpirationMs(row);
        return expirationMs.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> StateTTL$.MODULE$.isExpired(x$1, batchTimestampMs));
    }

    public StateTypesEncoder(ExpressionEncoder.Serializer<GK> keySerializer, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        this.keySerializer = keySerializer;
        this.stateName = stateName;
        this.hasTtl = hasTtl;
        this.keyProjection = UnsafeProjection$.MODULE$.create(TransformWithStateKeyValueRowSchema$.MODULE$.KEY_ROW_SCHEMA());
        this.valueProjection = hasTtl ? UnsafeProjection$.MODULE$.create(TransformWithStateKeyValueRowSchema$.MODULE$.VALUE_ROW_SCHEMA_WITH_TTL()) : UnsafeProjection$.MODULE$.create(TransformWithStateKeyValueRowSchema$.MODULE$.VALUE_ROW_SCHEMA());
        this.valExpressionEnc = package$.MODULE$.encoderFor(valEncoder);
        this.objToRowSerializer = this.valExpressionEnc().createSerializer();
        this.rowToObjDeserializer = this.valExpressionEnc().resolveAndBind(this.valExpressionEnc().resolveAndBind$default$1(), this.valExpressionEnc().resolveAndBind$default$2()).createDeserializer();
        this.reusedValRow = new UnsafeRow(valEncoder.schema().fields().length);
    }
}

