/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.plans.logical.NoTime$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.ListStateImpl;
import org.apache.spark.sql.execution.streaming.ListStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.MapStateImpl;
import org.apache.spark.sql.execution.streaming.MapStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.QueryInfoImpl;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl$;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleState$;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.TTLState;
import org.apache.spark.sql.execution.streaming.TimerStateImpl;
import org.apache.spark.sql.execution.streaming.ValueStateImpl;
import org.apache.spark.sql.execution.streaming.ValueStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.streaming.QueryInfo;
import org.apache.spark.sql.streaming.StatefulProcessorHandle;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.streaming.ValueState;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u0005h\u0001B\u0017/\u0001mB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u0011a\u0004!\u0011!Q\u0001\neDq!a\u0007\u0001\t\u0003\ti\u0002\u0003\u0006\u00022\u0001\u0011\r\u0011\"\u00013\u0003gA\u0001\"!\u0011\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0015\u0001A\u0003%\u0011q\t\u0005\b\u0003'\u0002A\u0011BA+\u0011)\ti\u0006\u0001EC\u0002\u0013%\u0011q\f\u0005\n\u0003C\u0002\u0001\u0019!C\u0005\u0003GB\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u0011\u0005\u0005\u0005\u0001)Q\u0005\u0003KBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005M\u0005\u0001\"\u0001\u0002d!9\u0011Q\u0013\u0001\u0005B\u0005]\u0005bBAK\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u00037\u0004A\u0011IA+\u0011)\ti\u000e\u0001EC\u0002\u0013%\u0011q\u001c\u0005\b\u0003O\u0004A\u0011BAu\u0011\u001d\ty\u000f\u0001C\u0005\u0003cDq!!>\u0001\t\u0003\n9\u0010C\u0004\u0002~\u0002!\t%a@\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0014\u0001\u0011\u0005!\u0011\u0006\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u0011\t\u0004\u0001C!\u0005gAqA!\r\u0001\t\u0003\u00129\u0005C\u0004\u0003Z\u0001!\tEa\u0017\t\u000f\te\u0003\u0001\"\u0011\u0003~!9!q\u0013\u0001\u0005\n\teu!\u0003BP]\u0005\u0005\t\u0012\u0001BQ\r!ic&!A\t\u0002\t\r\u0006bBA\u000eO\u0011\u0005!\u0011\u0017\u0005\n\u0005g;\u0013\u0013!C\u0001\u0005kC\u0011Ba3(#\u0003%\tA!4\t\u0013\tEw%%A\u0005\u0002\tM\u0007\"\u0003BlO\u0005\u0005I\u0011\u0002Bm\u0005m\u0019F/\u0019;fMVd\u0007K]8dKN\u001cxN\u001d%b]\u0012dW-S7qY*\u0011q\u0006M\u0001\ngR\u0014X-Y7j]\u001eT!!\r\u001a\u0002\u0013\u0015DXmY;uS>t'BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\nQa\u001d9be.T!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO\u000e\u00011\u0003\u0002\u0001=\u0005\u001e\u0003\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0007CA\"F\u001b\u0005!%BA\u00183\u0013\t1EIA\fTi\u0006$XMZ;m!J|7-Z:t_JD\u0015M\u001c3mKB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nN\u0001\tS:$XM\u001d8bY&\u0011A*\u0013\u0002\b\u0019><w-\u001b8h\u0003\u0015\u0019Ho\u001c:f!\ty%+D\u0001Q\u0015\t\tf&A\u0003ti\u0006$X-\u0003\u0002T!\nQ1\u000b^1uKN#xN]3\u0002\u000bI,h.\u00133\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001B;uS2T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n!Q+V%E\u0003)YW-_#oG>$WM\u001d\t\u0004?\u00124W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001C3oG>$WM]:\u000b\u0005\r\u0014\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u0015\u0004'!E#yaJ,7o]5p]\u0016s7m\u001c3feB\u0011QhZ\u0005\u0003Qz\u00121!\u00118z\u0003!!\u0018.\\3N_\u0012,\u0007CA\"l\u0013\taGI\u0001\u0005US6,Wj\u001c3f\u0003-I7o\u0015;sK\u0006l\u0017N\\4\u0011\u0005uz\u0017B\u00019?\u0005\u001d\u0011un\u001c7fC:\f\u0001CY1uG\"$\u0016.\\3ti\u0006l\u0007/T:\u0011\u0007u\u001aX/\u0003\u0002u}\t1q\n\u001d;j_:\u0004\"!\u0010<\n\u0005]t$\u0001\u0002'p]\u001e\fq!\\3ue&\u001c7\u000fE\u0004{\u0003\u0007\tI!a\u0004\u000f\u0005m|\bC\u0001??\u001b\u0005i(B\u0001@;\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0001 \u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\u00075\u000b\u0007OC\u0002\u0002\u0002y\u00022A_A\u0006\u0013\u0011\ti!a\u0002\u0003\rM#(/\u001b8h!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000ba\u00051Q.\u001a;sS\u000eLA!!\u0007\u0002\u0014\tI1+\u0015'NKR\u0014\u0018nY\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005}\u00111EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0002cAA\u0011\u00015\ta\u0006C\u0003N\u0011\u0001\u0007a\nC\u0003U\u0011\u0001\u0007Q\u000bC\u0003^\u0011\u0001\u0007a\fC\u0003j\u0011\u0001\u0007!\u000eC\u0004n\u0011A\u0005\t\u0019\u00018\t\u000fED\u0001\u0013!a\u0001e\"9\u0001\u0010\u0003I\u0001\u0002\u0004I\u0018!\u0003;uYN#\u0018\r^3t+\t\t)\u0004E\u0003W\u0003o\tY$C\u0002\u0002:]\u0013A\u0001T5tiB!\u0011\u0011EA\u001f\u0013\r\tyD\f\u0002\t)Rc5\u000b^1uK\u0006QA\u000f\u001e7Ti\u0006$Xm\u001d\u0011\u0002\u001d\t\u000bEk\u0011%`#V+%+W0J\tV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011QJ-\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\tY%A\bC\u0003R\u001b\u0005jX)V\u000bJKv,\u0013#!\u00039\u0011W/\u001b7e#V,'/_%oM>$\"!a\u0016\u0011\u0007\r\u000bI&C\u0002\u0002\\\u0011\u0013\u0011\"U;fefLeNZ8\u0002\u001b\r,(O])vKJL\u0018J\u001c4p+\t\t9&A\u0005dkJ\u00148\u000b^1uKV\u0011\u0011Q\r\t\u0005\u0003O\niG\u0004\u0003\u0002\"\u0005%\u0014bAA6]\u0005a2\u000b^1uK\u001a,H\u000e\u0015:pG\u0016\u001c8o\u001c:IC:$G.Z*uCR,\u0017\u0002BA8\u0003c\u0012Ad\u0015;bi\u00164W\u000f\u001c)s_\u000e,7o]8s\u0011\u0006tG\r\\3Ti\u0006$XMC\u0002\u0002l9\nQbY;seN#\u0018\r^3`I\u0015\fH\u0003BA<\u0003{\u00022!PA=\u0013\r\tYH\u0010\u0002\u0005+:LG\u000fC\u0005\u0002\u0000A\t\t\u00111\u0001\u0002f\u0005\u0019\u0001\u0010J\u0019\u0002\u0015\r,(O]*uCR,\u0007%A\bj]\u000e\u0014X-\\3oi6+GO]5d)\u0011\t9(a\"\t\u000f\u0005%%\u00031\u0001\u0002\n\u0005QQ.\u001a;sS\u000et\u0015-\\3\u0002\u001dM,G\u000fS1oI2,7\u000b^1uKR!\u0011qOAH\u0011\u001d\t\tj\u0005a\u0001\u0003K\n\u0001B\\3x'R\fG/Z\u0001\u000fO\u0016$\b*\u00198eY\u0016\u001cF/\u0019;f\u000359W\r\u001e,bYV,7\u000b^1uKV!\u0011\u0011TAS)\u0019\tY*!-\u00026B)1)!(\u0002\"&\u0019\u0011q\u0014#\u0003\u0015Y\u000bG.^3Ti\u0006$X\r\u0005\u0003\u0002$\u0006\u0015F\u0002\u0001\u0003\b\u0003O+\"\u0019AAU\u0005\u0005!\u0016cAAVMB\u0019Q(!,\n\u0007\u0005=fHA\u0004O_RD\u0017N\\4\t\u000f\u0005MV\u00031\u0001\u0002\n\u0005I1\u000f^1uK:\u000bW.\u001a\u0005\b\u0003o+\u0002\u0019AA]\u0003)1\u0018\r\\#oG>$WM\u001d\t\u0007\u0003w\u000bi,!)\u000e\u0003IJ1!a03\u0005\u001d)enY8eKJ,B!a1\u0002JRA\u0011QYAf\u0003\u001b\f\t\u000eE\u0003D\u0003;\u000b9\r\u0005\u0003\u0002$\u0006%GaBAT-\t\u0007\u0011\u0011\u0016\u0005\b\u0003g3\u0002\u0019AA\u0005\u0011\u001d\t9L\u0006a\u0001\u0003\u001f\u0004b!a/\u0002>\u0006\u001d\u0007bBAj-\u0001\u0007\u0011Q[\u0001\niRd7i\u001c8gS\u001e\u00042aQAl\u0013\r\tI\u000e\u0012\u0002\n)Rc5i\u001c8gS\u001e\fAbZ3u#V,'/_%oM>\f!\u0002^5nKJ\u001cF/\u0019;f+\t\t\t\u000f\u0005\u0003\u0002\"\u0005\r\u0018bAAs]\tqA+[7feN#\u0018\r^3J[Bd\u0017\u0001\u0007<fe&4\u0017p\u0015;bi\u00164\u0016M](qKJ\fG/[8ogR!\u0011qOAv\u0011\u001d\ti/\u0007a\u0001\u0003\u0013\tQb\u001c9fe\u0006$\u0018n\u001c8UsB,\u0017!\u0006<fe&4\u0017\u0010V5nKJ|\u0005/\u001a:bi&|gn\u001d\u000b\u0005\u0003o\n\u0019\u0010C\u0004\u0002nj\u0001\r!!\u0003\u0002\u001bI,w-[:uKJ$\u0016.\\3s)\u0011\t9(!?\t\r\u0005m8\u00041\u0001v\u0003E)\u0007\u0010]5ssRKW.Z:uC6\u0004Xj]\u0001\fI\u0016dW\r^3US6,'\u000f\u0006\u0003\u0002x\t\u0005\u0001BBA~9\u0001\u0007Q/\u0001\thKR,\u0005\u0010]5sK\u0012$\u0016.\\3sgR!!q\u0001B\u0010!\u0019\u0011IAa\u0005\u0003\u001a9!!1\u0002B\b\u001d\ra(QB\u0005\u0002\u007f%\u0019!\u0011\u0003 \u0002\u000fA\f7m[1hK&!!Q\u0003B\f\u0005!IE/\u001a:bi>\u0014(b\u0001B\t}A)QHa\u0007gk&\u0019!Q\u0004 \u0003\rQ+\b\u000f\\33\u0011\u0019\tY0\ba\u0001k\u0006QA.[:u)&lWM]:\u0015\u0005\t\u0015\u0002#\u0002B\u0005\u0005')\u0018\u0001\u00043p)Rd7\t\\3b]V\u0004HCAA<\u00039!W\r\\3uK&3W\t_5tiN$B!a\u001e\u00030!9\u00111\u0017\u0011A\u0002\u0005%\u0011\u0001D4fi2K7\u000f^*uCR,W\u0003\u0002B\u001b\u0005\u007f!bAa\u000e\u0003B\t\r\u0003#B\"\u0003:\tu\u0012b\u0001B\u001e\t\nIA*[:u'R\fG/\u001a\t\u0005\u0003G\u0013y\u0004B\u0004\u0002(\u0006\u0012\r!!+\t\u000f\u0005M\u0016\u00051\u0001\u0002\n!9\u0011qW\u0011A\u0002\t\u0015\u0003CBA^\u0003{\u0013i$\u0006\u0003\u0003J\t=C\u0003\u0003B&\u0005#\u0012\u0019Fa\u0016\u0011\u000b\r\u0013ID!\u0014\u0011\t\u0005\r&q\n\u0003\b\u0003O\u0013#\u0019AAU\u0011\u001d\t\u0019L\ta\u0001\u0003\u0013Aq!a.#\u0001\u0004\u0011)\u0006\u0005\u0004\u0002<\u0006u&Q\n\u0005\b\u0003'\u0014\u0003\u0019AAk\u0003-9W\r^'baN#\u0018\r^3\u0016\r\tu#q\rB7)!\u0011yF!\u001d\u0003t\te\u0004cB\"\u0003b\t\u0015$1N\u0005\u0004\u0005G\"%\u0001C'baN#\u0018\r^3\u0011\t\u0005\r&q\r\u0003\b\u0005S\u001a#\u0019AAU\u0005\u0005Y\u0005\u0003BAR\u0005[\"qAa\u001c$\u0005\u0004\tIKA\u0001W\u0011\u001d\t\u0019l\ta\u0001\u0003\u0013AqA!\u001e$\u0001\u0004\u00119(\u0001\u0006vg\u0016\u00148*Z=F]\u000e\u0004b!a/\u0002>\n\u0015\u0004bBA\\G\u0001\u0007!1\u0010\t\u0007\u0003w\u000biLa\u001b\u0016\r\t}$Q\u0011BE))\u0011\tIa#\u0003\u000e\nE%Q\u0013\t\b\u0007\n\u0005$1\u0011BD!\u0011\t\u0019K!\"\u0005\u000f\t%DE1\u0001\u0002*B!\u00111\u0015BE\t\u001d\u0011y\u0007\nb\u0001\u0003SCq!a-%\u0001\u0004\tI\u0001C\u0004\u0003v\u0011\u0002\rAa$\u0011\r\u0005m\u0016Q\u0018BB\u0011\u001d\t9\f\na\u0001\u0005'\u0003b!a/\u0002>\n\u001d\u0005bBAjI\u0001\u0007\u0011Q[\u0001\u0012m\u0006d\u0017\u000eZ1uKR#FjQ8oM&<GCBA<\u00057\u0013i\nC\u0004\u0002T\u0016\u0002\r!!6\t\u000f\u0005MV\u00051\u0001\u0002\n\u0005Y2\u000b^1uK\u001a,H\u000e\u0015:pG\u0016\u001c8o\u001c:IC:$G.Z%na2\u00042!!\t('\u00119CH!*\u0011\t\t\u001d&QV\u0007\u0003\u0005SS1Aa+Z\u0003\tIw.\u0003\u0003\u00030\n%&\u0001D*fe&\fG.\u001b>bE2,GC\u0001BQ\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!q\u0017\u0016\u0004]\ne6F\u0001B^!\u0011\u0011iLa2\u000e\u0005\t}&\u0002\u0002Ba\u0005\u0007\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015g(\u0001\u0006b]:|G/\u0019;j_:LAA!3\u0003@\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011yMK\u0002s\u0005s\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001BkU\rI(\u0011X\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00057\u0004B!!\u0013\u0003^&!!q\\A&\u0005\u0019y%M[3di\u0002")
public class StatefulProcessorHandleImpl
implements StatefulProcessorHandle,
Logging {
    private QueryInfo currQueryInfo;
    private TimerStateImpl timerState;
    private final StateStore store;
    private final UUID runId;
    private final ExpressionEncoder<Object> keyEncoder;
    private final TimeMode timeMode;
    private final boolean isStreaming;
    private final Option<Object> batchTimestampMs;
    private final Map<String, SQLMetric> metrics;
    private final List<TTLState> ttlStates;
    private final String BATCH_QUERY_ID;
    private Enumeration.Value currState;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Map<String, SQLMetric> $lessinit$greater$default$7() {
        return StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Object> $lessinit$greater$default$6() {
        return StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<TTLState> ttlStates() {
        return this.ttlStates;
    }

    private String BATCH_QUERY_ID() {
        return this.BATCH_QUERY_ID;
    }

    private QueryInfo buildQueryInfo() {
        Tuple2 tuple2;
        Option taskCtxOpt = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (!this.isStreaming) {
            v0 = new Tuple2((Object)this.BATCH_QUERY_ID(), (Object)BoxesRunTime.boxToLong((long)0L));
        } else if (taskCtxOpt.isDefined()) {
            v0 = new Tuple2((Object)((TaskContext)taskCtxOpt.get()).getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY()), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((TaskContext)taskCtxOpt.get()).getLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY())))));
        } else {
            Predef$.MODULE$.assert(Utils$.MODULE$.isTesting(), (Function0 & Serializable)() -> "Failed to find query id/batch Id in task context");
            v0 = tuple2 = new Tuple2((Object)UUID.randomUUID().toString(), (Object)BoxesRunTime.boxToLong((long)0L));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String queryId = (String)tuple2._1();
        long batchId = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)queryId, (Object)BoxesRunTime.boxToLong((long)batchId));
        String queryId2 = (String)tuple22._1();
        long batchId2 = tuple22._2$mcJ$sp();
        return new QueryInfoImpl(UUID.fromString(queryId2), this.runId, batchId2);
    }

    private QueryInfo currQueryInfo$lzycompute() {
        StatefulProcessorHandleImpl statefulProcessorHandleImpl = this;
        synchronized (statefulProcessorHandleImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.currQueryInfo = this.buildQueryInfo();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.currQueryInfo;
    }

    private QueryInfo currQueryInfo() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.currQueryInfo$lzycompute();
        }
        return this.currQueryInfo;
    }

    private Enumeration.Value currState() {
        return this.currState;
    }

    private void currState_$eq(Enumeration.Value x$1) {
        this.currState = x$1;
    }

    private void incrementMetric(String metricName) {
        this.metrics.get((Object)metricName).foreach((Function1 & Serializable)x$2 -> {
            x$2.add(1L);
            return BoxedUnit.UNIT;
        });
    }

    public void setHandleState(Enumeration.Value newState) {
        this.currState_$eq(newState);
    }

    public Enumeration.Value getHandleState() {
        return this.currState();
    }

    public <T> ValueState<T> getValueState(String stateName, Encoder<T> valEncoder) {
        this.verifyStateVarOperations("get_value_state");
        this.incrementMetric("numValueStateVars");
        ValueStateImpl<T> resultState = new ValueStateImpl<T>(this.store, stateName, this.keyEncoder, valEncoder);
        return resultState;
    }

    public <T> ValueState<T> getValueState(String stateName, Encoder<T> valEncoder, TTLConfig ttlConfig) {
        this.verifyStateVarOperations("get_value_state");
        this.validateTTLConfig(ttlConfig, stateName);
        Predef$.MODULE$.assert(this.batchTimestampMs.isDefined());
        ValueStateImplWithTTL<T> valueStateWithTTL = new ValueStateImplWithTTL<T>(this.store, stateName, this.keyEncoder, valEncoder, ttlConfig, BoxesRunTime.unboxToLong((Object)this.batchTimestampMs.get()));
        this.incrementMetric("numValueStateWithTTLVars");
        this.ttlStates().add(valueStateWithTTL);
        return valueStateWithTTL;
    }

    public QueryInfo getQueryInfo() {
        return this.currQueryInfo();
    }

    private TimerStateImpl timerState$lzycompute() {
        StatefulProcessorHandleImpl statefulProcessorHandleImpl = this;
        synchronized (statefulProcessorHandleImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.timerState = new TimerStateImpl(this.store, this.timeMode, this.keyEncoder);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.timerState;
    }

    private TimerStateImpl timerState() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.timerState$lzycompute();
        }
        return this.timerState;
    }

    private void verifyStateVarOperations(String operationType) {
        Enumeration.Value value = this.currState();
        Enumeration.Value value2 = StatefulProcessorHandleState$.MODULE$.CREATED();
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw StateStoreErrors$.MODULE$.cannotPerformOperationWithInvalidHandleState(operationType, this.currState().toString());
        }
    }

    private void verifyTimerOperations(String operationType) {
        TimeMode timeMode = this.timeMode;
        NoTime$ noTime$ = NoTime$.MODULE$;
        if (!(timeMode != null ? !timeMode.equals(noTime$) : noTime$ != null)) {
            throw StateStoreErrors$.MODULE$.cannotPerformOperationWithInvalidTimeMode(operationType, this.timeMode.toString());
        }
        if (this.currState().$less((Object)StatefulProcessorHandleState$.MODULE$.INITIALIZED()) || this.currState().$greater$eq((Object)StatefulProcessorHandleState$.MODULE$.TIMER_PROCESSED())) {
            throw StateStoreErrors$.MODULE$.cannotPerformOperationWithInvalidHandleState(operationType, this.currState().toString());
        }
    }

    public void registerTimer(long expiryTimestampMs) {
        this.verifyTimerOperations("register_timer");
        this.incrementMetric("numRegisteredTimers");
        this.timerState().registerTimer(expiryTimestampMs);
    }

    public void deleteTimer(long expiryTimestampMs) {
        this.verifyTimerOperations("delete_timer");
        this.incrementMetric("numDeletedTimers");
        this.timerState().deleteTimer(expiryTimestampMs);
    }

    public Iterator<Tuple2<Object, Object>> getExpiredTimers(long expiryTimestampMs) {
        this.verifyTimerOperations("get_expired_timers");
        return this.timerState().getExpiredTimers(expiryTimestampMs);
    }

    public Iterator<Object> listTimers() {
        this.verifyTimerOperations("list_timers");
        return this.timerState().listTimers();
    }

    public void doTtlCleanup() {
        SQLMetric numValuesRemovedDueToTTLExpiry = (SQLMetric)((Object)this.metrics.get((Object)"numValuesRemovedDueToTTLExpiry").get());
        this.ttlStates().forEach(s -> numValuesRemovedDueToTTLExpiry.$plus$eq(s.clearExpiredState()));
    }

    public void deleteIfExists(String stateName) {
        this.verifyStateVarOperations("delete_if_exists");
        if (this.store.removeColFamilyIfExists(stateName)) {
            this.incrementMetric("numDeletedStateVars");
            return;
        }
    }

    public <T> ListState<T> getListState(String stateName, Encoder<T> valEncoder) {
        this.verifyStateVarOperations("get_list_state");
        this.incrementMetric("numListStateVars");
        ListStateImpl<T> resultState = new ListStateImpl<T>(this.store, stateName, this.keyEncoder, valEncoder);
        return resultState;
    }

    public <T> ListState<T> getListState(String stateName, Encoder<T> valEncoder, TTLConfig ttlConfig) {
        this.verifyStateVarOperations("get_list_state");
        this.validateTTLConfig(ttlConfig, stateName);
        Predef$.MODULE$.assert(this.batchTimestampMs.isDefined());
        ListStateImplWithTTL<T> listStateWithTTL = new ListStateImplWithTTL<T>(this.store, stateName, this.keyEncoder, valEncoder, ttlConfig, BoxesRunTime.unboxToLong((Object)this.batchTimestampMs.get()));
        this.incrementMetric("numListStateWithTTLVars");
        this.ttlStates().add(listStateWithTTL);
        return listStateWithTTL;
    }

    public <K, V> MapState<K, V> getMapState(String stateName, Encoder<K> userKeyEnc, Encoder<V> valEncoder) {
        this.verifyStateVarOperations("get_map_state");
        this.incrementMetric("numMapStateVars");
        MapStateImpl<K, V> resultState = new MapStateImpl<K, V>(this.store, stateName, this.keyEncoder, userKeyEnc, valEncoder);
        return resultState;
    }

    public <K, V> MapState<K, V> getMapState(String stateName, Encoder<K> userKeyEnc, Encoder<V> valEncoder, TTLConfig ttlConfig) {
        this.verifyStateVarOperations("get_map_state");
        this.validateTTLConfig(ttlConfig, stateName);
        Predef$.MODULE$.assert(this.batchTimestampMs.isDefined());
        MapStateImplWithTTL<K, V> mapStateWithTTL = new MapStateImplWithTTL<K, V>(this.store, stateName, this.keyEncoder, userKeyEnc, valEncoder, ttlConfig, BoxesRunTime.unboxToLong((Object)this.batchTimestampMs.get()));
        this.incrementMetric("numMapStateWithTTLVars");
        this.ttlStates().add(mapStateWithTTL);
        return mapStateWithTTL;
    }

    private void validateTTLConfig(TTLConfig ttlConfig, String stateName) {
        Duration ttlDuration = ttlConfig.ttlDuration();
        TimeMode timeMode = this.timeMode;
        TimeMode timeMode2 = TimeMode.ProcessingTime();
        if (timeMode == null ? timeMode2 != null : !timeMode.equals(timeMode2)) {
            throw StateStoreErrors$.MODULE$.cannotProvideTTLConfigForTimeMode(stateName, this.timeMode.toString());
        }
        if (ttlDuration == null || ttlDuration.isNegative() || ttlDuration.isZero()) {
            throw StateStoreErrors$.MODULE$.ttlMustBePositive("update", stateName);
        }
    }

    public StatefulProcessorHandleImpl(StateStore store, UUID runId, ExpressionEncoder<Object> keyEncoder, TimeMode timeMode, boolean isStreaming, Option<Object> batchTimestampMs, Map<String, SQLMetric> metrics) {
        this.store = store;
        this.runId = runId;
        this.keyEncoder = keyEncoder;
        this.timeMode = timeMode;
        this.isStreaming = isStreaming;
        this.batchTimestampMs = batchTimestampMs;
        this.metrics = metrics;
        Logging.$init$((Logging)this);
        this.ttlStates = new ArrayList<TTLState>();
        this.BATCH_QUERY_ID = "00000000-0000-0000-0000-000000000000";
        this.currState = StatefulProcessorHandleState$.MODULE$.CREATED();
    }
}

