/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchUserFuncException;
import org.sparkproject.guava.util.concurrent.UncheckedExecutionException;
import py4j.Py4JException;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.util.matching.Regex;

public final class StreamExecution$ {
    public static final StreamExecution$ MODULE$ = new StreamExecution$();
    private static final String QUERY_ID_KEY = "sql.streaming.queryId";
    private static final String IS_CONTINUOUS_PROCESSING = "__is_continuous_processing";
    private static final Seq<String> IO_EXCEPTION_NAMES = new .colon.colon((Object)InterruptedException.class.getName(), (List)new .colon.colon((Object)InterruptedIOException.class.getName(), (List)new .colon.colon((Object)ClosedByInterruptException.class.getName(), (List)Nil$.MODULE$)));
    private static final Regex PROXY_ERROR = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("py4j.protocol.Py4JJavaError: An error occurred while calling.+(\\r\\n|\\r|\\n): (" + MODULE$.IO_EXCEPTION_NAMES().mkString("|") + ")"));

    public String QUERY_ID_KEY() {
        return QUERY_ID_KEY;
    }

    public String IS_CONTINUOUS_PROCESSING() {
        return IS_CONTINUOUS_PROCESSING;
    }

    public Seq<String> IO_EXCEPTION_NAMES() {
        return IO_EXCEPTION_NAMES;
    }

    public Regex PROXY_ERROR() {
        return PROXY_ERROR;
    }

    public boolean isInterruptionException(Throwable e, SparkContext sc) {
        Throwable throwable;
        block7: {
            while (true) {
                if ((throwable = e) instanceof InterruptedException ? true : (throwable instanceof InterruptedIOException ? true : throwable instanceof ClosedByInterruptException)) {
                    return true;
                }
                if ((throwable instanceof UncheckedIOException ? true : (throwable instanceof ExecutionException ? true : throwable instanceof UncheckedExecutionException)) && throwable.getCause() != null) {
                    e = throwable.getCause();
                    continue;
                }
                if (throwable instanceof ForeachBatchUserFuncException) {
                    ForeachBatchUserFuncException foreachBatchUserFuncException = (ForeachBatchUserFuncException)((Object)throwable);
                    e = foreachBatchUserFuncException.getCause();
                    continue;
                }
                if (!(throwable instanceof SparkException)) break block7;
                SparkException sparkException = (SparkException)throwable;
                String jobGroup = sc.getLocalProperty("spark.jobGroup.id");
                if (jobGroup == null) {
                    return false;
                }
                String errorMsg = sparkException.getMessage();
                if (errorMsg.contains("cancelled") && errorMsg.contains(jobGroup) && sparkException.getCause() == null) {
                    return true;
                }
                if (sparkException.getCause() == null) break;
                e = sparkException.getCause();
            }
            return false;
        }
        if (throwable instanceof Py4JException) {
            Py4JException py4JException = (Py4JException)throwable;
            return this.PROXY_ERROR().findFirstIn((CharSequence)py4JException.getMessage()).isDefined();
        }
        return false;
    }

    public boolean containsSpecialCharsInPath(Path path) {
        String string = path.toUri().getPath();
        String string2 = new Path(path.toUri().toString()).toUri().getPath();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private StreamExecution$() {
    }
}

