/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u0014)\u0001UB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"Aq\n\u0001B\u0001B\u0003%\u0001\u000bC\u0003\\\u0001\u0011\u0005A\fC\u0004c\u0001\t\u0007I\u0011B2\t\r)\u0004\u0001\u0015!\u0003e\u0011\u001dY\u0007A1A\u0005\n1Daa\u001d\u0001!\u0002\u0013i\u0007b\u0002;\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007k\u0002\u0001\u000b\u0011B7\t\u000fY\u0004!\u0019!C\u0005Y\"1q\u000f\u0001Q\u0001\n5Dq\u0001\u001f\u0001C\u0002\u0013%A\u000e\u0003\u0004z\u0001\u0001\u0006I!\u001c\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\t)\u0003\u0001Q\u0001\nqD\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003WA\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005e\u0002\u0001)A\u0005\u0003WA\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u007fA\u0011\"!\u0015\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u007fA\u0011\"!\u0016\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u007fAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!!-\u0001\t\u0003\t\u0019\fC\u0004\u0002H\u0002!I!!3\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\nqA+[7feN#\u0018\r^3J[Bd'BA\u0015+\u0003%\u0019HO]3b[&twM\u0003\u0002,Y\u0005IQ\r_3dkRLwN\u001c\u0006\u0003[9\n1a]9m\u0015\ty\u0003'A\u0003ta\u0006\u00148N\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<7\u0001A\n\u0004\u0001Yb\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g\r\u0005\u0002>\u00016\taH\u0003\u0002@]\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002B}\t9Aj\\4hS:<\u0017!B:u_J,\u0007C\u0001#H\u001b\u0005)%B\u0001$)\u0003\u0015\u0019H/\u0019;f\u0013\tAUI\u0001\u0006Ti\u0006$Xm\u0015;pe\u0016\f\u0001\u0002^5nK6{G-\u001a\t\u0003\u00176k\u0011\u0001\u0014\u0006\u0003S1J!A\u0014'\u0003\u0011QKW.Z'pI\u0016\f!b[3z\u000bb\u0004(/\u00128d!\r\tf\u000bW\u0007\u0002%*\u00111\u000bV\u0001\tK:\u001cw\u000eZ3sg*\u0011Q\u000bL\u0001\tG\u0006$\u0018\r\\=ti&\u0011qK\u0015\u0002\u0012\u000bb\u0004(/Z:tS>tWI\\2pI\u0016\u0014\bCA\u001cZ\u0013\tQ\u0006HA\u0002B]f\fa\u0001P5oSRtD\u0003B/`A\u0006\u0004\"A\u0018\u0001\u000e\u0003!BQA\u0011\u0003A\u0002\rCQ!\u0013\u0003A\u0002)CQa\u0014\u0003A\u0002A\u000b\u0011\"R'Q)f{&kT,\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a+\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003S\u001a\u0014\u0011\"\u00168tC\u001a,'k\\<\u0002\u0015\u0015k\u0005\u000bV-`%>;\u0006%\u0001\ntG\",W.\u0019$peB\u0013XMZ5y\u0017\u0016LX#A7\u0011\u00059\fX\"A8\u000b\u0005Ad\u0013!\u0002;za\u0016\u001c\u0018B\u0001:p\u0005)\u0019FO];diRK\b/Z\u0001\u0014g\u000eDW-\\1G_J\u0004&/\u001a4jq.+\u0017\u0010I\u0001\u0010g\u000eDW-\\1G_J\\U-\u001f*po\u0006\u00012o\u00195f[\u00064uN]&fsJ{w\u000fI\u0001\u0015W\u0016L8k\u00195f[\u00064uN]*fG&sG-\u001a=\u0002+-,\u0017pU2iK6\fgi\u001c:TK\u000eLe\u000eZ3yA\u0005\t2o\u00195f[\u00064uN\u001d,bYV,'k\\<\u0002%M\u001c\u0007.Z7b\r>\u0014h+\u00197vKJ{w\u000fI\u0001\u000eW\u0016L8+\u001a:jC2L'0\u001a:\u0016\u0003q\u0004B!`A\u00101:\u0019a0a\u0007\u000f\u0007}\fIB\u0004\u0003\u0002\u0002\u0005]a\u0002BA\u0002\u0003+qA!!\u0002\u0002\u00149!\u0011qAA\t\u001d\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007i\u00051AH]8pizJ\u0011aM\u0005\u0003cIJ!a\f\u0019\n\u00055r\u0013BA+-\u0013\t\u0019F+C\u0002\u0002\u001eI\u000b\u0011#\u0012=qe\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s\u0013\u0011\t\t#a\t\u0003\u0015M+'/[1mSj,'OC\u0002\u0002\u001eI\u000bab[3z'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\tqe\u00164\u0017\u000e_&fs\u0016s7m\u001c3feV\u0011\u00111\u0006\t\u0004K\u00065\u0012bAA\u0018M\n\u0001RK\\:bM\u0016\u0004&o\u001c6fGRLwN\\\u0001\u0012aJ,g-\u001b=LKf,enY8eKJ\u0004\u0013AC6fs\u0016s7m\u001c3fe\u0006Y1.Z=F]\u000e|G-\u001a:!\u0003I\u0019XmY%oI\u0016D8*Z=F]\u000e|G-\u001a:\u0002'M,7-\u00138eKb\\U-_#oG>$WM\u001d\u0011\u0002\u0017QLW.\u001a:D\r:\u000bW.Z\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003mC:<'BAA%\u0003\u0011Q\u0017M^1\n\t\u00055\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019QLW.\u001a:D\r:\u000bW.\u001a\u0011\u0002\u001b-,\u0017\u0010V8Ug\u000e3e*Y7f\u00039YW-\u001f+p)N\u001ceIT1nK\u0002\nQ\u0002^:U_.+\u0017p\u0011$OC6,\u0017A\u0004;t)>\\U-_\"G\u001d\u0006lW\rI\u0001\u000fO\u0016$xI]8va&twmS3z)\rA\u0016Q\f\u0005\b\u0003?j\u0002\u0019AA1\u0003\u0019\u0019gMT1nKB!\u00111MA6\u001d\u0011\t)'a\u001a\u0011\u0007\u0005%\u0001(C\u0002\u0002ja\na\u0001\u0015:fI\u00164\u0017\u0002BA'\u0003[R1!!\u001b9\u0003%)gnY8eK.+\u0017\u0010F\u0003e\u0003g\n9\b\u0003\u0004\u0002vy\u0001\r\u0001W\u0001\fOJ|W\u000f]5oO.+\u0017\u0010C\u0004\u0002zy\u0001\r!a\u001f\u0002#\u0015D\b/\u001b:z)&lWm\u001d;b[Bl5\u000fE\u00028\u0003{J1!a 9\u0005\u0011auN\\4\u0002#\u0015t7m\u001c3f'\u0016\u001c\u0017J\u001c3fq.+\u0017\u0010F\u0003e\u0003\u000b\u000b9\t\u0003\u0004\u0002v}\u0001\r\u0001\u0017\u0005\b\u0003sz\u0002\u0019AA>\u0003\u0019)\u00070[:ugR1\u0011QRAJ\u0003+\u00032aNAH\u0013\r\t\t\n\u000f\u0002\b\u0005>|G.Z1o\u0011\u0019\t)\b\ta\u00011\"9\u0011\u0011\u0010\u0011A\u0002\u0005m\u0014aB4fi&k\u0007\u000f\u001c\u000b\u0006I\u0006m\u0015Q\u0014\u0005\u0007\u0003k\n\u0003\u0019\u0001-\t\u000f\u0005e\u0014\u00051\u0001\u0002|\u0005i!/Z4jgR,'\u000fV5nKJ$B!a)\u0002*B\u0019q'!*\n\u0007\u0005\u001d\u0006H\u0001\u0003V]&$\bbBA=E\u0001\u0007\u00111P\u0001\fI\u0016dW\r^3US6,'\u000f\u0006\u0003\u0002$\u0006=\u0006bBA=G\u0001\u0007\u00111P\u0001\u000bY&\u001cH\u000fV5nKJ\u001cHCAA[!\u0019\t9,!1\u0002|9!\u0011\u0011XA_\u001d\u0011\tI!a/\n\u0003eJ1!a09\u0003\u001d\u0001\u0018mY6bO\u0016LA!a1\u0002F\nA\u0011\n^3sCR|'OC\u0002\u0002@b\nqcZ3u)&lWM\u001d*po\u001a\u0013x.\\*fG&sG-\u001a=\u0015\t\u0005-\u0017\u0011\u001b\t\u0007o\u00055\u0007,a\u001f\n\u0007\u0005=\u0007H\u0001\u0004UkBdWM\r\u0005\u0007\u0003',\u0003\u0019\u00013\u0002\r-,\u0017PU8x\u0003A9W\r^#ya&\u0014X\r\u001a+j[\u0016\u00148\u000f\u0006\u0003\u0002Z\u0006m\u0007CBA\\\u0003\u0003\fY\rC\u0004\u0002z\u0019\u0002\r!a\u001f")
public class TimerStateImpl
implements Logging {
    private final StateStore store;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final UnsafeRow EMPTY_ROW;
    private final StructType schemaForPrefixKey;
    private final StructType schemaForKeyRow;
    private final StructType keySchemaForSecIndex;
    private final StructType schemaForValueRow;
    private final ExpressionEncoder.Serializer<Object> keySerializer;
    private final UnsafeProjection prefixKeyEncoder;
    private final UnsafeProjection keyEncoder;
    private final UnsafeProjection secIndexKeyEncoder;
    private final String timerCFName;
    private final String keyToTsCFName;
    private final String tsToKeyCFName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private UnsafeRow EMPTY_ROW() {
        return this.EMPTY_ROW;
    }

    private StructType schemaForPrefixKey() {
        return this.schemaForPrefixKey;
    }

    private StructType schemaForKeyRow() {
        return this.schemaForKeyRow;
    }

    private StructType keySchemaForSecIndex() {
        return this.keySchemaForSecIndex;
    }

    private StructType schemaForValueRow() {
        return this.schemaForValueRow;
    }

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        return this.keySerializer;
    }

    private UnsafeProjection prefixKeyEncoder() {
        return this.prefixKeyEncoder;
    }

    private UnsafeProjection keyEncoder() {
        return this.keyEncoder;
    }

    private UnsafeProjection secIndexKeyEncoder() {
        return this.secIndexKeyEncoder;
    }

    private String timerCFName() {
        return this.timerCFName;
    }

    private String keyToTsCFName() {
        return this.keyToTsCFName;
    }

    private String tsToKeyCFName() {
        return this.tsToKeyCFName;
    }

    private Object getGroupingKey(String cfName) {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(cfName);
        }
        return keyOption.get();
    }

    private UnsafeRow encodeKey(Object groupingKey, long expiryTimestampMs) {
        byte[] keyByteArr = ((UnsafeRow)this.keySerializer().apply(groupingKey)).getBytes();
        UnsafeRow keyRow = this.keyEncoder().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{keyByteArr, BoxesRunTime.boxToLong((long)expiryTimestampMs)})));
        return keyRow;
    }

    private UnsafeRow encodeSecIndexKey(Object groupingKey, long expiryTimestampMs) {
        byte[] keyByteArr = ((UnsafeRow)this.keySerializer().apply(groupingKey)).getBytes();
        UnsafeRow keyRow = this.secIndexKeyEncoder().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)expiryTimestampMs), keyByteArr})));
        return keyRow;
    }

    private boolean exists(Object groupingKey, long expiryTimestampMs) {
        return this.getImpl(groupingKey, expiryTimestampMs) != null;
    }

    private UnsafeRow getImpl(Object groupingKey, long expiryTimestampMs) {
        return this.store.get(this.encodeKey(groupingKey, expiryTimestampMs), this.keyToTsCFName());
    }

    public void registerTimer(long expiryTimestampMs) {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        if (this.exists(groupingKey, expiryTimestampMs)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to register timer for key=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.KEY$.MODULE$, groupingKey)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp=", " ms since it already exists"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXPIRY_TIMESTAMP$.MODULE$, (Object)BoxesRunTime.boxToLong((long)expiryTimestampMs))})))));
            return;
        }
        this.store.put(this.encodeKey(groupingKey, expiryTimestampMs), this.EMPTY_ROW(), this.keyToTsCFName());
        this.store.put(this.encodeSecIndexKey(groupingKey, expiryTimestampMs), this.EMPTY_ROW(), this.tsToKeyCFName());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Registered timer for key=" + groupingKey + " and timestamp=" + expiryTimestampMs);
    }

    public void deleteTimer(long expiryTimestampMs) {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        if (!this.exists(groupingKey, expiryTimestampMs)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete timer for key=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.KEY$.MODULE$, groupingKey)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp=", " ms since it does not exist"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXPIRY_TIMESTAMP$.MODULE$, (Object)BoxesRunTime.boxToLong((long)expiryTimestampMs))})))));
            return;
        }
        this.store.remove(this.encodeKey(groupingKey, expiryTimestampMs), this.keyToTsCFName());
        this.store.remove(this.encodeSecIndexKey(groupingKey, expiryTimestampMs), this.tsToKeyCFName());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted timer for key=" + groupingKey + " and timestamp=" + expiryTimestampMs);
    }

    public Iterator<Object> listTimers() {
        byte[] keyByteArr = ((UnsafeRow)this.keySerializer().apply(this.getGroupingKey(this.keyToTsCFName()))).getBytes();
        UnsafeRow keyRow = this.prefixKeyEncoder().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{keyByteArr})));
        Iterator<UnsafeRowPair> iter = this.store.prefixScan(keyRow, this.keyToTsCFName());
        return iter.map((Function1 & Serializable)kv -> BoxesRunTime.boxToLong((long)TimerStateImpl.$anonfun$listTimers$1(kv)));
    }

    public Tuple2<Object, Object> org$apache$spark$sql$execution$streaming$TimerStateImpl$$getTimerRowFromSecIndex(UnsafeRow keyRow) {
        byte[] keyBytes = keyRow.getBinary(1);
        UnsafeRow retUnsafeRow = new UnsafeRow(1);
        retUnsafeRow.pointTo(keyBytes, keyBytes.length);
        Object keyObj = this.keyExprEnc.resolveAndBind(this.keyExprEnc.resolveAndBind$default$1(), this.keyExprEnc.resolveAndBind$default$2()).createDeserializer().apply((InternalRow)retUnsafeRow);
        long expiryTimestampMs = keyRow.getLong(0);
        return new Tuple2(keyObj, (Object)BoxesRunTime.boxToLong((long)expiryTimestampMs));
    }

    public Iterator<Tuple2<Object, Object>> getExpiredTimers(long expiryTimestampMs) {
        Iterator<UnsafeRowPair> iter = this.store.iterator(this.tsToKeyCFName());
        return new NextIterator<Tuple2<Object, Object>>(this, iter, expiryTimestampMs){
            private final /* synthetic */ TimerStateImpl $outer;
            private final Iterator iter$1;
            private final long expiryTimestampMs$3;

            public Tuple2<Object, Object> getNext() {
                if (this.iter$1.hasNext()) {
                    UnsafeRowPair rowPair = (UnsafeRowPair)this.iter$1.next();
                    UnsafeRow keyRow = rowPair.key();
                    Tuple2<Object, Object> result = this.$outer.org$apache$spark$sql$execution$streaming$TimerStateImpl$$getTimerRowFromSecIndex(keyRow);
                    if (result._2$mcJ$sp() < this.expiryTimestampMs$3) {
                        return result;
                    }
                    this.finished_$eq(true);
                    return null;
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$1 = iter$1;
                this.expiryTimestampMs$3 = expiryTimestampMs$3;
            }
        };
    }

    public static final /* synthetic */ long $anonfun$listTimers$1(UnsafeRowPair kv) {
        UnsafeRow keyRow = kv.key();
        return keyRow.getLong(1);
    }

    public TimerStateImpl(StateStore store, TimeMode timeMode, ExpressionEncoder<Object> keyExprEnc) {
        this.store = store;
        this.keyExprEnc = keyExprEnc;
        Logging.$init$((Logging)this);
        this.EMPTY_ROW = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{NullType$.MODULE$})).apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
        this.schemaForPrefixKey = new StructType().add("key", (DataType)BinaryType$.MODULE$);
        this.schemaForKeyRow = new StructType().add("key", (DataType)BinaryType$.MODULE$).add("expiryTimestampMs", (DataType)LongType$.MODULE$, false);
        this.keySchemaForSecIndex = new StructType().add("expiryTimestampMs", (DataType)LongType$.MODULE$, false).add("key", (DataType)BinaryType$.MODULE$);
        this.schemaForValueRow = new StructType((StructField[])((Object[])new StructField[]{new StructField("__dummy__", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        this.keySerializer = keyExprEnc.createSerializer();
        this.prefixKeyEncoder = UnsafeProjection$.MODULE$.create(this.schemaForPrefixKey());
        this.keyEncoder = UnsafeProjection$.MODULE$.create(this.schemaForKeyRow());
        this.secIndexKeyEncoder = UnsafeProjection$.MODULE$.create(this.keySchemaForSecIndex());
        TimeMode timeMode2 = timeMode;
        TimeMode timeMode3 = TimeMode.ProcessingTime();
        this.timerCFName = !(timeMode2 != null ? !timeMode2.equals(timeMode3) : timeMode3 != null) ? TimerStateUtils$.MODULE$.PROC_TIMERS_STATE_NAME() : TimerStateUtils$.MODULE$.EVENT_TIMERS_STATE_NAME();
        this.keyToTsCFName = this.timerCFName() + TimerStateUtils$.MODULE$.KEY_TO_TIMESTAMP_CF();
        store.createColFamilyIfAbsent(this.keyToTsCFName(), this.schemaForKeyRow(), this.schemaForValueRow(), new PrefixKeyScanStateEncoderSpec(this.schemaForKeyRow(), 1), false, true);
        this.tsToKeyCFName = this.timerCFName() + TimerStateUtils$.MODULE$.TIMESTAMP_TO_KEY_CF();
        store.createColFamilyIfAbsent(this.tsToKeyCFName(), this.keySchemaForSecIndex(), this.schemaForValueRow(), new RangeKeyScanStateEncoderSpec(this.keySchemaForSecIndex(), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))), false, true);
    }
}

