/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchema$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.streaming.ValueState;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\t\u0012\u0001yA\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001d)\u0007A1A\u0005\n\u0019DaA\u001f\u0001!\u0002\u00139\u0007bB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0002bBA\u0017\u0001\u0011\u0005\u0013Q\u0001\u0002\u000f-\u0006dW/Z*uCR,\u0017*\u001c9m\u0015\t\u00112#A\u0005tiJ,\u0017-\\5oO*\u0011A#F\u0001\nKb,7-\u001e;j_:T!AF\f\u0002\u0007M\fHN\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001)\"aH\u0017\u0014\t\u0001\u0001cE\u000e\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u001dJ3&D\u0001)\u0015\t\u0011R#\u0003\u0002+Q\tQa+\u00197vKN#\u0018\r^3\u0011\u00051jC\u0002\u0001\u0003\u0006]\u0001\u0011\ra\f\u0002\u0002'F\u0011\u0001g\r\t\u0003CEJ!A\r\u0012\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0005N\u0005\u0003k\t\u00121!\u00118z!\t9$(D\u00019\u0015\tIt#\u0001\u0005j]R,'O\\1m\u0013\tY\u0004HA\u0004M_\u001e<\u0017N\\4\u0002\u000bM$xN]3\u0011\u0005y\nU\"A \u000b\u0005\u0001\u000b\u0012!B:uCR,\u0017B\u0001\"@\u0005)\u0019F/\u0019;f'R|'/Z\u0001\ngR\fG/\u001a(b[\u0016\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$#\u001b\u0005A%BA%\u001e\u0003\u0019a$o\\8u}%\u00111JI\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002LE\u0005Q1.Z=FqB\u0014XI\\2\u0011\u0007E36'D\u0001S\u0015\t\u0019F+\u0001\u0005f]\u000e|G-\u001a:t\u0015\t)V#\u0001\u0005dCR\fG._:u\u0013\t9&KA\tFqB\u0014Xm]:j_:,enY8eKJ\f!B^1m\u000b:\u001cw\u000eZ3s!\rQ6lK\u0007\u0002+%\u0011A,\u0006\u0002\b\u000b:\u001cw\u000eZ3s\u0003\u0019a\u0014N\\5u}Q)q,\u00192dIB\u0019\u0001\rA\u0016\u000e\u0003EAQ\u0001P\u0003A\u0002uBQaQ\u0003A\u0002\u0011CQaT\u0003A\u0002ACQ\u0001W\u0003A\u0002e\u000bQb[3z'\u0016\u0014\u0018.\u00197ju\u0016\u0014X#A4\u0011\u0007!<8G\u0004\u0002jk:\u0011!\u000e\u001e\b\u0003WNt!\u0001\u001c:\u000f\u00055\fhB\u00018q\u001d\t9u.C\u0001\u001d\u0013\tQ2$\u0003\u0002\u00193%\u0011acF\u0005\u0003+VI!a\u0015+\n\u0005Y\u0014\u0016!E#yaJ,7o]5p]\u0016s7m\u001c3fe&\u0011\u00010\u001f\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001<S\u00039YW-_*fe&\fG.\u001b>fe\u0002\n\u0011c\u001d;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3s+\u0005i\b\u0003\u00021\u007fg-J!a`\t\u0003#M#\u0018\r^3UsB,7/\u00128d_\u0012,'/\u0001\nti\u0006$X\rV=qKN,enY8eKJ\u0004\u0013AC5oSRL\u0017\r\\5{KR\u0011\u0011q\u0001\t\u0004C\u0005%\u0011bAA\u0006E\t!QK\\5u\u0003\u0019)\u00070[:ugR\u0011\u0011\u0011\u0003\t\u0004C\u0005M\u0011bAA\u000bE\t9!i\\8mK\u0006t\u0017!C4fi>\u0003H/[8o)\t\tY\u0002\u0005\u0003\"\u0003;Y\u0013bAA\u0010E\t1q\n\u001d;j_:\f1aZ3u)\u0005Y\u0013AB;qI\u0006$X\r\u0006\u0003\u0002\b\u0005%\u0002BBA\u0016\u001d\u0001\u00071&\u0001\u0005oK^\u001cF/\u0019;f\u0003\u0015\u0019G.Z1s\u0001")
public class ValueStateImpl<S>
implements ValueState<S>,
Logging {
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder.Serializer<Object> keySerializer;
    private final StateTypesEncoder<Object, S> stateTypesEncoder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        return this.keySerializer;
    }

    private StateTypesEncoder<Object, S> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, TransformWithStateKeyValueRowSchema$.MODULE$.KEY_ROW_SCHEMA(), TransformWithStateKeyValueRowSchema$.MODULE$.VALUE_ROW_SCHEMA(), new NoPrefixKeyStateEncoderSpec(TransformWithStateKeyValueRowSchema$.MODULE$.KEY_ROW_SCHEMA()), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get() != null;
    }

    public Option<S> getOption() {
        return Option$.MODULE$.apply(this.get());
    }

    public S get() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            return this.stateTypesEncoder().decodeValue(retRow);
        }
        return null;
    }

    public void update(S newState) {
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(newState);
        byte[] serializedGroupingKey = this.stateTypesEncoder().serializeGroupingKey();
        this.store.put(this.stateTypesEncoder().encodeSerializedGroupingKey(serializedGroupingKey), encodedValue, this.stateName);
    }

    public void clear() {
        this.store.remove(this.stateTypesEncoder().encodeGroupingKey(), this.stateName);
    }

    public ValueStateImpl(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<S> valEncoder) {
        this.store = store;
        this.stateName = stateName;
        Logging.$init$((Logging)this);
        this.keySerializer = keyExprEnc.createSerializer();
        this.stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(this.keySerializer(), valEncoder, stateName, StateTypesEncoder$.MODULE$.apply$default$4());
        this.initialize();
    }
}

