/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.SingleKeyTTLStateImpl;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchema$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.ValueState;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001\u0002\r\u001a\u0001\u0019B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u000b!\u0004A\u0011A5\t\u000fE\u0004!\u0019!C\u0005e\"9\u0011Q\u0002\u0001!\u0002\u0013\u0019\b\"CA\b\u0001\t\u0007I\u0011BA\t\u0011!\tI\u0002\u0001Q\u0001\n\u0005M\u0001\"CA\u000e\u0001\t\u0007I\u0011BA\u000f\u0011\u001d\ty\u0002\u0001Q\u0001\n\u0015Dq!!\t\u0001\t\u0013\t\u0019\u0003C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u0017\u0002A\u0011IA\u0012\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fB\u0001\"!\u0019\u0001\t\u0003i\u0012q\u0007\u0005\t\u0003G\u0002A\u0011A\u000f\u0002f!A\u0011q\u000e\u0001\u0005\u0002u\t\tHA\u000bWC2,Xm\u0015;bi\u0016LU\u000e\u001d7XSRDG\u000b\u0016'\u000b\u0005iY\u0012!C:ue\u0016\fW.\u001b8h\u0015\taR$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001U\u0011qeM\n\u0004\u0001!b\u0003CA\u0015+\u001b\u0005I\u0012BA\u0016\u001a\u0005U\u0019\u0016N\\4mK.+\u0017\u0010\u0016+M'R\fG/Z%na2\u00042!L\u00182\u001b\u0005q#B\u0001\u000e\u001e\u0013\t\u0001dF\u0001\u0006WC2,Xm\u0015;bi\u0016\u0004\"AM\u001a\r\u0001\u0011)A\u0007\u0001b\u0001k\t\t1+\u0005\u00027yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9aj\u001c;iS:<\u0007CA\u001c>\u0013\tq\u0004HA\u0002B]f\fQa\u001d;pe\u0016\u0004\"!\u0011#\u000e\u0003\tS!aQ\r\u0002\u000bM$\u0018\r^3\n\u0005\u0015\u0013%AC*uCR,7\u000b^8sK\u0006I1\u000f^1uK:\u000bW.\u001a\t\u0003\u0011>s!!S'\u0011\u0005)CT\"A&\u000b\u00051+\u0013A\u0002\u001fs_>$h(\u0003\u0002Oq\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0005(\u0001\u0006lKf,\u0005\u0010\u001d:F]\u000e\u00042\u0001V-=\u001b\u0005)&B\u0001,X\u0003!)gnY8eKJ\u001c(B\u0001-\u001e\u0003!\u0019\u0017\r^1msN$\u0018B\u0001.V\u0005E)\u0005\u0010\u001d:fgNLwN\\#oG>$WM]\u0001\u000bm\u0006dWI\\2pI\u0016\u0014\bcA/_c5\tQ$\u0003\u0002`;\t9QI\\2pI\u0016\u0014\u0018!\u0003;uY\u000e{gNZ5h!\ti#-\u0003\u0002d]\tIA\u000b\u0016'D_:4\u0017nZ\u0001\u0011E\u0006$8\r\u001b+j[\u0016\u001cH/Y7q\u001bN\u0004\"a\u000e4\n\u0005\u001dD$\u0001\u0002'p]\u001e\fa\u0001P5oSRtDc\u00026lY6tw\u000e\u001d\t\u0004S\u0001\t\u0004\"B \b\u0001\u0004\u0001\u0005\"\u0002$\b\u0001\u00049\u0005\"\u0002*\b\u0001\u0004\u0019\u0006\"B.\b\u0001\u0004a\u0006\"\u00021\b\u0001\u0004\t\u0007\"\u00023\b\u0001\u0004)\u0017!D6fsN+'/[1mSj,'/F\u0001t!\u0011!\u0018q\u0001\u001f\u000f\u0007U\f\u0019AD\u0002w\u0003\u0003q!a^@\u000f\u0005athBA=~\u001d\tQHP\u0004\u0002Kw&\tA%\u0003\u0002#G%\u0011\u0001%I\u0005\u0003=}I!\u0001W\u000f\n\u0005Y;\u0016bAA\u0003+\u0006\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\n\t\u0005%\u00111\u0002\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014(bAA\u0003+\u0006q1.Z=TKJL\u0017\r\\5{KJ\u0004\u0013!E:uCR,G+\u001f9fg\u0016s7m\u001c3feV\u0011\u00111\u0003\t\u0006S\u0005UA(M\u0005\u0004\u0003/I\"!E*uCR,G+\u001f9fg\u0016s7m\u001c3fe\u0006\u00112\u000f^1uKRK\b/Z:F]\u000e|G-\u001a:!\u0003=!H\u000f\\#ya&\u0014\u0018\r^5p]6\u001bX#A3\u0002!Q$H.\u0012=qSJ\fG/[8o\u001bN\u0004\u0013AC5oSRL\u0017\r\\5{KR\u0011\u0011Q\u0005\t\u0004o\u0005\u001d\u0012bAA\u0015q\t!QK\\5u\u0003\u0019)\u00070[:ugR\u0011\u0011q\u0006\t\u0004o\u0005E\u0012bAA\u001aq\t9!i\\8mK\u0006t\u0017!C4fi>\u0003H/[8o)\t\tI\u0004\u0005\u00038\u0003w\t\u0014bAA\u001fq\t1q\n\u001d;j_:\f1aZ3u)\u0005\t\u0014AB;qI\u0006$X\r\u0006\u0003\u0002&\u0005\u001d\u0003BBA%%\u0001\u0007\u0011'\u0001\u0005oK^\u001cF/\u0019;f\u0003\u0015\u0019G.Z1s\u00039\u0019G.Z1s\u0013\u001a,\u0005\u0010]5sK\u0012$2!ZA)\u0011\u001d\t\u0019\u0006\u0006a\u0001\u0003+\n1b\u001a:pkBLgnZ&fsB)q'a\u0016\u0002\\%\u0019\u0011\u0011\f\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0007]\ni&C\u0002\u0002`a\u0012AAQ=uK\u00061r-\u001a;XSRDw.\u001e;F]\u001a|'oY5oOR#F*A\u0006hKR$F\u000b\u0014,bYV,GCAA4!\u00159\u00141HA5!\u00159\u00141N\u0019f\u0013\r\ti\u0007\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0002'\u001d,GOV1mk\u0016\u001c\u0018J\u001c+U\u0019N#\u0018\r^3\u0015\u0005\u0005M\u0004#BA;\u0003\u007f*g\u0002BA<\u0003wr1ASA=\u0013\u0005I\u0014bAA?q\u00059\u0001/Y2lC\u001e,\u0017\u0002BAA\u0003\u0007\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003{B\u0004")
public class ValueStateImplWithTTL<S>
extends SingleKeyTTLStateImpl
implements ValueState<S> {
    private final StateStore store;
    private final String stateName;
    private final long batchTimestampMs;
    private final ExpressionEncoder.Serializer<Object> keySerializer;
    private final StateTypesEncoder<Object, S> stateTypesEncoder;
    private final long ttlExpirationMs;

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        return this.keySerializer;
    }

    private StateTypesEncoder<Object, S> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    private long ttlExpirationMs() {
        return this.ttlExpirationMs;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, TransformWithStateKeyValueRowSchema$.MODULE$.KEY_ROW_SCHEMA(), TransformWithStateKeyValueRowSchema$.MODULE$.VALUE_ROW_SCHEMA_WITH_TTL(), new NoPrefixKeyStateEncoderSpec(TransformWithStateKeyValueRowSchema$.MODULE$.KEY_ROW_SCHEMA()), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get() != null;
    }

    public Option<S> getOption() {
        return Option$.MODULE$.apply(this.get());
    }

    public S get() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            S resState = this.stateTypesEncoder().decodeValue(retRow);
            if (!this.stateTypesEncoder().isExpired(retRow, this.batchTimestampMs)) {
                return resState;
            }
            return null;
        }
        return null;
    }

    public void update(S newState) {
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(newState, this.ttlExpirationMs());
        byte[] serializedGroupingKey = this.stateTypesEncoder().serializeGroupingKey();
        this.store.put(this.stateTypesEncoder().encodeSerializedGroupingKey(serializedGroupingKey), encodedValue, this.stateName);
        this.upsertTTLForStateKey(this.ttlExpirationMs(), serializedGroupingKey);
    }

    public void clear() {
        this.store.remove(this.stateTypesEncoder().encodeGroupingKey(), this.stateName);
        this.clearTTLState();
    }

    @Override
    public long clearIfExpired(byte[] groupingKey) {
        long result;
        block0: {
            UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeSerializedGroupingKey(groupingKey);
            UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
            result = 0L;
            if (retRow == null || !this.stateTypesEncoder().isExpired(retRow, this.batchTimestampMs)) break block0;
            this.store.remove(encodedGroupingKey, this.stateName);
            result = 1L;
        }
        return result;
    }

    public Option<S> getWithoutEnforcingTTL() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            S resState = this.stateTypesEncoder().decodeValue(retRow);
            return new Some(resState);
        }
        return None$.MODULE$;
    }

    public Option<Tuple2<S, Object>> getTTLValue() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Option<Object> ttlExpiration = this.stateTypesEncoder().decodeTtlExpirationMs(retRow);
            return ttlExpiration.map((Function1 & Serializable)expiration -> ValueStateImplWithTTL.$anonfun$getTTLValue$1(this, retRow, BoxesRunTime.unboxToLong((Object)expiration)));
        }
        return None$.MODULE$;
    }

    public Iterator<Object> getValuesInTTLState() {
        return this.getValuesInTTLState(this.stateTypesEncoder().serializeGroupingKey());
    }

    public static final /* synthetic */ Tuple2 $anonfun$getTTLValue$1(ValueStateImplWithTTL $this, UnsafeRow retRow$1, long expiration) {
        return new Tuple2($this.stateTypesEncoder().decodeValue(retRow$1), (Object)BoxesRunTime.boxToLong((long)expiration));
    }

    public ValueStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<S> valEncoder, TTLConfig ttlConfig, long batchTimestampMs) {
        this.store = store;
        this.stateName = stateName;
        this.batchTimestampMs = batchTimestampMs;
        super(stateName, store, batchTimestampMs);
        this.keySerializer = keyExprEnc.createSerializer();
        this.stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(this.keySerializer(), valEncoder, stateName, true);
        this.ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(ttlConfig.ttlDuration(), batchTimestampMs);
        this.initialize();
    }
}

