/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadata;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV1$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r3A\u0001C\u0005\u00011!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015y\u0003\u0001\"\u00011\u0011\u001d)\u0004A1A\u0005\nYBaa\u000e\u0001!\u0002\u0013\u0001\u0003\u0002\u0003\u001d\u0001\u0011\u000b\u0007I\u0011B\u001d\t\u000by\u0002A\u0011A \u00037=\u0003XM]1u_J\u001cF/\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017\rZ3s\u0015\tQ1\"A\u0003ti\u0006$XM\u0003\u0002\r\u001b\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u001d=\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-A\nti\u0006$Xm\u00115fG.\u0004x.\u001b8u!\u0006$\b\u000e\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005\u0011am\u001d\u0006\u0003KM\ta\u0001[1e_>\u0004\u0018BA\u0014#\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002+[5\t1F\u0003\u0002-I\u0005!1m\u001c8g\u0013\tq3FA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u001aD\u0007\u0005\u00023\u00015\t\u0011\u0002C\u0003 \u0007\u0001\u0007\u0001\u0005C\u0003)\u0007\u0001\u0007\u0011&\u0001\tnKR\fG-\u0019;b\r&dW\rU1uQV\t\u0001%A\tnKR\fG-\u0019;b\r&dW\rU1uQ\u0002\n!AZ7\u0016\u0003i\u0002\"a\u000f\u001f\u000e\u0003-I!!P\u0006\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\u0006!!/Z1e)\u0005\u0001\u0005C\u0001\u001aB\u0013\t\u0011\u0015BA\u000bPa\u0016\u0014\u0018\r^8s'R\fG/Z'fi\u0006$\u0017\r^1")
public class OperatorStateMetadataReader {
    private CheckpointFileManager fm;
    private Path stateCheckpointPath;
    private Configuration hadoopConf;
    private final Path metadataFilePath;
    private volatile boolean bitmap$0;

    private Path metadataFilePath() {
        return this.metadataFilePath;
    }

    private CheckpointFileManager fm$lzycompute() {
        OperatorStateMetadataReader operatorStateMetadataReader = this;
        synchronized (operatorStateMetadataReader) {
            if (!this.bitmap$0) {
                this.fm = CheckpointFileManager$.MODULE$.create(this.stateCheckpointPath, this.hadoopConf);
                this.bitmap$0 = true;
            }
        }
        this.stateCheckpointPath = null;
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if (!this.bitmap$0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    public OperatorStateMetadata read() {
        OperatorStateMetadata operatorStateMetadata;
        FSDataInputStream inputStream = this.fm().open(this.metadataFilePath());
        BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        try {
            String versionStr = inputReader.readLine();
            int version = MetadataVersionUtil$.MODULE$.validateVersion(versionStr, 1);
            Predef$.MODULE$.assert(version == 1);
            operatorStateMetadata = OperatorStateMetadataV1$.MODULE$.deserialize(inputReader);
        }
        finally {
            inputStream.close();
        }
        return operatorStateMetadata;
    }

    public OperatorStateMetadataReader(Path stateCheckpointPath, Configuration hadoopConf) {
        this.stateCheckpointPath = stateCheckpointPath;
        this.hadoopConf = hadoopConf;
        this.metadataFilePath = OperatorStateMetadataV1$.MODULE$.metadataFilePath(stateCheckpointPath);
    }
}

