/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.RocksDBKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateEncoder$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\u000b\u0017\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!)1\b\u0001C\u0001y!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002+\u0001A\u0003%!\tC\u0004V\u0001\t\u0007I\u0011B!\t\rY\u0003\u0001\u0015!\u0003C\u0011\u001d9\u0006A1A\u0005\naCa!\u0019\u0001!\u0002\u0013I\u0006b\u00022\u0001\u0005\u0004%I\u0001\u0017\u0005\u0007G\u0002\u0001\u000b\u0011B-\t\u000f\u0011\u0004!\u0019!C\u00051\"1Q\r\u0001Q\u0001\neCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001b\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006s\u0002!\tE\u001f\u0005\u0006{\u0002!IA \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\tY\u0001\u0001C!\u0003\u001b\u0011\u0011\u0004\u0015:fM&D8*Z=TG\u0006t7\u000b^1uK\u0016s7m\u001c3fe*\u0011q\u0003G\u0001\u0006gR\fG/\u001a\u0006\u00033i\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005ma\u0012!C3yK\u000e,H/[8o\u0015\tib$A\u0002tc2T!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055rS\"\u0001\f\n\u0005=2\"A\u0006*pG.\u001cHIQ&fsN#\u0018\r^3F]\u000e|G-\u001a:\u0002\u0013-,\u0017pU2iK6\f\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001d\u0003\u0015!\u0018\u0010]3t\u0013\t14G\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0001C\\;n\u0007>d7\u000f\u0015:fM&D8*Z=\u0011\u0005\u001dJ\u0014B\u0001\u001e)\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007urt\b\u0005\u0002.\u0001!)\u0001g\u0001a\u0001c!)qg\u0001a\u0001q\u00051\u0002O]3gSb\\U-\u001f$jK2$7oV5uQ&#\u00070F\u0001C!\r\u00195J\u0014\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013B\u0001&)\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0007M+\u0017O\u0003\u0002KQA!qeT)9\u0013\t\u0001\u0006F\u0001\u0004UkBdWM\r\t\u0003eIK!aU\u001a\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u0018aJ,g-\u001b=LKf4\u0015.\u001a7eg^KG\u000f[%eq\u0002\n\u0011D]3nC&t\u0017N\\4LKf4\u0015.\u001a7eg^KG\u000f[%eq\u0006Q\"/Z7bS:LgnZ&fs\u001aKW\r\u001c3t/&$\b.\u00133yA\u0005\u0019\u0002O]3gSb\\U-\u001f)s_*,7\r^5p]V\t\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqF$\u0001\u0005dCR\fG._:u\u0013\t\u00017L\u0001\tV]N\fg-\u001a)s_*,7\r^5p]\u0006!\u0002O]3gSb\\U-\u001f)s_*,7\r^5p]\u0002\naC]3nC&t\u0017N\\4LKf\u0004&o\u001c6fGRLwN\\\u0001\u0018e\u0016l\u0017-\u001b8j]\u001e\\U-\u001f)s_*,7\r^5p]\u0002\nAC]3ti>\u0014XmS3z!J|'.Z2uS>t\u0017!\u0006:fgR|'/Z&fsB\u0013xN[3di&|g\u000eI\u0001\u000fU>Lg.\u001a3S_^|enS3z+\u0005A\u0007C\u0001.j\u0013\tQ7LA\u0005K_&tW\r\u001a*po\u0006y!n\\5oK\u0012\u0014vn^(o\u0017\u0016L\b%A\u0005f]\u000e|G-Z&fsR\u0011a\u000e\u001e\t\u0004O=\f\u0018B\u00019)\u0005\u0015\t%O]1z!\t9#/\u0003\u0002tQ\t!!)\u001f;f\u0011\u0015)\b\u00031\u0001w\u0003\r\u0011xn\u001e\t\u00035^L!\u0001_.\u0003\u0013Us7/\u00194f%><\u0018!\u00033fG>$WmS3z)\t18\u0010C\u0003}#\u0001\u0007a.\u0001\u0005lKf\u0014\u0015\u0010^3t\u0003A)\u0007\u0010\u001e:bGR\u0004&/\u001a4jq.+\u0017\u0010\u0006\u0002w\u007f\"1\u0011\u0011\u0001\nA\u0002Y\f1a[3z\u0003=)gnY8eKB\u0013XMZ5y\u0017\u0016LHc\u00018\u0002\b!1\u0011\u0011B\nA\u0002Y\f\u0011\u0002\u001d:fM&D8*Z=\u0002)M,\b\u000f]8siB\u0013XMZ5y\u0017\u0016L8kY1o+\t\ty\u0001E\u0002(\u0003#I1!a\u0005)\u0005\u001d\u0011un\u001c7fC:\u0004")
public class PrefixKeyScanStateEncoder
implements RocksDBKeyStateEncoder {
    private final StructType keySchema;
    private final int numColsPrefixKey;
    private final Seq<Tuple2<StructField, Object>> prefixKeyFieldsWithIdx;
    private final Seq<Tuple2<StructField, Object>> remainingKeyFieldsWithIdx;
    private final UnsafeProjection prefixKeyProjection;
    private final UnsafeProjection remainingKeyProjection;
    private final UnsafeProjection restoreKeyProjection;
    private final JoinedRow joinedRowOnKey;

    private Seq<Tuple2<StructField, Object>> prefixKeyFieldsWithIdx() {
        return this.prefixKeyFieldsWithIdx;
    }

    private Seq<Tuple2<StructField, Object>> remainingKeyFieldsWithIdx() {
        return this.remainingKeyFieldsWithIdx;
    }

    private UnsafeProjection prefixKeyProjection() {
        return this.prefixKeyProjection;
    }

    private UnsafeProjection remainingKeyProjection() {
        return this.remainingKeyProjection;
    }

    private UnsafeProjection restoreKeyProjection() {
        return this.restoreKeyProjection;
    }

    private JoinedRow joinedRowOnKey() {
        return this.joinedRowOnKey;
    }

    @Override
    public byte[] encodeKey(UnsafeRow row) {
        byte[] prefixKeyEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(this.extractPrefixKey(row));
        byte[] remainingEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(this.remainingKeyProjection().apply((InternalRow)row));
        byte[] encodedBytes = new byte[prefixKeyEncoded.length + remainingEncoded.length + 4];
        Platform.putInt((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)prefixKeyEncoded.length);
        Platform.copyMemory((Object)prefixKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)prefixKeyEncoded.length);
        Platform.copyMemory((Object)remainingEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4 + prefixKeyEncoded.length), (long)remainingEncoded.length);
        return encodedBytes;
    }

    @Override
    public UnsafeRow decodeKey(byte[] keyBytes) {
        int prefixKeyEncodedLen = Platform.getInt((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET);
        byte[] prefixKeyEncoded = new byte[prefixKeyEncodedLen];
        Platform.copyMemory((Object)keyBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (Object)prefixKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (long)prefixKeyEncodedLen);
        int remainingKeyEncodedLen = keyBytes.length - 4 - prefixKeyEncodedLen;
        byte[] remainingKeyEncoded = new byte[remainingKeyEncodedLen];
        Platform.copyMemory((Object)keyBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4 + prefixKeyEncodedLen), (Object)remainingKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (long)remainingKeyEncodedLen);
        UnsafeRow prefixKeyDecoded = RocksDBStateEncoder$.MODULE$.decodeToUnsafeRow(prefixKeyEncoded, this.numColsPrefixKey);
        UnsafeRow remainingKeyDecoded = RocksDBStateEncoder$.MODULE$.decodeToUnsafeRow(remainingKeyEncoded, this.keySchema.length() - this.numColsPrefixKey);
        return this.restoreKeyProjection().apply((InternalRow)this.joinedRowOnKey().withLeft((InternalRow)prefixKeyDecoded).withRight((InternalRow)remainingKeyDecoded));
    }

    private UnsafeRow extractPrefixKey(UnsafeRow key) {
        return this.prefixKeyProjection().apply((InternalRow)key);
    }

    @Override
    public byte[] encodePrefixKey(UnsafeRow prefixKey) {
        byte[] prefixKeyEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(prefixKey);
        byte[] prefix = new byte[prefixKeyEncoded.length + 4];
        Platform.putInt((Object)prefix, (long)Platform.BYTE_ARRAY_OFFSET, (int)prefixKeyEncoded.length);
        Platform.copyMemory((Object)prefixKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)prefix, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)prefixKeyEncoded.length);
        return prefix;
    }

    @Override
    public boolean supportPrefixKeyScan() {
        return true;
    }

    public PrefixKeyScanStateEncoder(StructType keySchema, int numColsPrefixKey) {
        this.keySchema = keySchema;
        this.numColsPrefixKey = numColsPrefixKey;
        this.prefixKeyFieldsWithIdx = (Seq)((IterableOps)keySchema.zipWithIndex()).take(numColsPrefixKey);
        this.remainingKeyFieldsWithIdx = (Seq)((IterableOps)keySchema.zipWithIndex()).drop(numColsPrefixKey);
        Seq refs = (Seq)this.prefixKeyFieldsWithIdx().map((Function1 & Serializable)x -> new BoundReference(x._2$mcI$sp(), ((StructField)x._1()).dataType(), ((StructField)x._1()).nullable()));
        this.prefixKeyProjection = UnsafeProjection$.MODULE$.create(refs);
        Seq refs2 = (Seq)this.remainingKeyFieldsWithIdx().map((Function1 & Serializable)x -> new BoundReference(x._2$mcI$sp(), ((StructField)x._1()).dataType(), ((StructField)x._1()).nullable()));
        this.remainingKeyProjection = UnsafeProjection$.MODULE$.create(refs2);
        this.restoreKeyProjection = UnsafeProjection$.MODULE$.create(keySchema);
        this.joinedRowOnKey = new JoinedRow();
    }
}

