/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.execution.streaming.state.RocksDBKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateEncoder$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\u0014(\u0001YB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\")\u0001\f\u0001C\u00013\"9Q\f\u0001b\u0001\n\u0013q\u0006B\u00024\u0001A\u0003%q\fC\u0003h\u0001\u0011%\u0001\u000eC\u0004r\u0001\t\u0007I\u0011\u00020\t\rI\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\bA1A\u0005\nQDa! \u0001!\u0002\u0013)\bb\u0002@\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007\u007f\u0002\u0001\u000b\u0011B;\t\u0011\u0005\u0005\u0001A1A\u0005\nQDq!a\u0001\u0001A\u0003%Q\u000fC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011q\u0002\u0001!\u0002\u0013\tI\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u0013\u0005}\u0001A1A\u0005\n\u0005\u0005\u0002bBA\u0012\u0001\u0001\u0006I!\u0016\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003CAq!a\n\u0001A\u0003%Q\u000bC\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u00111\u0007\u0001!\u0002\u0013\ti\u0003C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011q\u0007\u0001!\u0002\u0013\ti\u0003C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<!A\u00111\t\u0001!\u0002\u0013\ti\u0004C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002<!A\u0011q\t\u0001!\u0002\u0013\ti\u0004C\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002<!A\u00111\n\u0001!\u0002\u0013\ti\u0004C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u00111\f\u0001\u0005B\u0005u\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\t9\b\u0001C!\u0003s\u0012\u0001DU1oO\u0016\\U-_*dC:\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s\u0015\tA\u0013&A\u0003ti\u0006$XM\u0003\u0002+W\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003Y5\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019T\b\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VM\u001a\t\u0003}}j\u0011aJ\u0005\u0003\u0001\u001e\u0012aCU8dWN$%iS3z'R\fG/Z#oG>$WM]\u0001\nW\u0016L8k\u00195f[\u0006\u0004\"a\u0011$\u000e\u0003\u0011S!!R\u0017\u0002\u000bQL\b/Z:\n\u0005\u001d#%AC*ueV\u001cG\u000fV=qK\u0006\u0001rN\u001d3fe&twm\u0014:eS:\fGn\u001d\t\u0004\u0015J+fBA&Q\u001d\tau*D\u0001N\u0015\tqU'\u0001\u0004=e>|GOP\u0005\u0002u%\u0011\u0011+O\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FKA\u0002TKFT!!U\u001d\u0011\u0005a2\u0016BA,:\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007i[F\f\u0005\u0002?\u0001!)\u0011i\u0001a\u0001\u0005\")\u0001j\u0001a\u0001\u0013\u0006i\"/\u00198hKN\u001b\u0017M\\&fs\u001aKW\r\u001c3t/&$\bn\u0014:eS:\fG.F\u0001`!\rQ%\u000b\u0019\t\u0005q\u0005\u001cW+\u0003\u0002cs\t1A+\u001e9mKJ\u0002\"a\u00113\n\u0005\u0015$%aC*ueV\u001cGOR5fY\u0012\faD]1oO\u0016\u001c6-\u00198LKf4\u0015.\u001a7eg^KG\u000f[(sI&t\u0017\r\u001c\u0011\u0002\u0017%\u001ch)\u001b=fINK'0\u001a\u000b\u0003S2\u0004\"\u0001\u000f6\n\u0005-L$a\u0002\"p_2,\u0017M\u001c\u0005\u0006[\u001a\u0001\rA\\\u0001\tI\u0006$\u0018\rV=qKB\u00111i\\\u0005\u0003a\u0012\u0013\u0001\u0002R1uCRK\b/Z\u0001\u001ee\u0016l\u0017-\u001b8j]\u001e\\U-\u001f$jK2$7oV5uQ>\u0013H-\u001b8bY\u0006q\"/Z7bS:LgnZ&fs\u001aKW\r\u001c3t/&$\bn\u0014:eS:\fG\u000eI\u0001\u0017e\u0006tw-Z*dC:\\U-\u001f)s_*,7\r^5p]V\tQ\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tQX&\u0001\u0005dCR\fG._:u\u0013\taxO\u0001\tV]N\fg-\u001a)s_*,7\r^5p]\u00069\"/\u00198hKN\u001b\u0017M\\&fsB\u0013xN[3di&|g\u000eI\u0001\u0017e\u0016l\u0017-\u001b8j]\u001e\\U-\u001f)s_*,7\r^5p]\u00069\"/Z7bS:LgnZ&fsB\u0013xN[3di&|g\u000eI\u0001\u0015e\u0016\u001cHo\u001c:f\u0017\u0016L\bK]8kK\u000e$\u0018n\u001c8\u0002+I,7\u000f^8sK.+\u0017\u0010\u0015:pU\u0016\u001cG/[8oA\u0005q!n\\5oK\u0012\u0014vn^(o\u0017\u0016LXCAA\u0005!\r1\u00181B\u0005\u0004\u0003\u001b9(!\u0003&pS:,GMU8x\u0003=Qw.\u001b8fIJ{wo\u00148LKf\u0004\u0013\u0001E3yiJ\f7\r\u001e)sK\u001aL\u0007pS3z)\u0011\t)\"a\u0007\u0011\u0007Y\f9\"C\u0002\u0002\u001a]\u0014\u0011\"\u00168tC\u001a,'k\\<\t\u000f\u0005u\u0011\u00031\u0001\u0002\u0016\u0005\u00191.Z=\u0002!\u0019dw.\u0019;GY&\u0004()\u001b;NCN\\W#A+\u0002#\u0019dw.\u0019;GY&\u0004()\u001b;NCN\\\u0007%\u0001\tgY>\fGoU5h]\nKG/T1tW\u0006\tb\r\\8biNKwM\u001c\"ji6\u000b7o\u001b\u0011\u0002#\u0011|WO\u00197f\r2L\u0007OQ5u\u001b\u0006\u001c8.\u0006\u0002\u0002.A\u0019\u0001(a\f\n\u0007\u0005E\u0012H\u0001\u0003M_:<\u0017A\u00053pk\ndWM\u00127ja\nKG/T1tW\u0002\n\u0011\u0003Z8vE2,7+[4o\u0005&$X*Y:l\u0003I!w.\u001e2mKNKwM\u001c\"ji6\u000b7o\u001b\u0011\u0002#9,w-\u0019;jm\u00164\u0016\r\\'be.,'/\u0006\u0002\u0002>A\u0019\u0001(a\u0010\n\u0007\u0005\u0005\u0013H\u0001\u0003CsR,\u0017A\u00058fO\u0006$\u0018N^3WC2l\u0015M]6fe\u0002\n\u0011\u0003]8tSRLg/\u001a,bY6\u000b'o[3s\u0003I\u0001xn]5uSZ,g+\u00197NCJ\\WM\u001d\u0011\u0002\u001b9,H\u000e\u001c,bY6\u000b'o[3s\u00039qW\u000f\u001c7WC2l\u0015M]6fe\u0002\n1$\u001a8d_\u0012,\u0007K]3gSb\\U-\u001f$peJ\u000bgnZ3TG\u0006tG\u0003BA\u000b\u0003#Bq!a\u0015!\u0001\u0004\t)\"A\u0002s_^\f1\u0004Z3d_\u0012,\u0007K]3gSb\\U-\u001f$peJ\u000bgnZ3TG\u0006tG\u0003BA\u000b\u00033Bq!a\u0015\"\u0001\u0004\t)\"A\u0005f]\u000e|G-Z&fsR!\u0011qLA3!\u0015A\u0014\u0011MA\u001f\u0013\r\t\u0019'\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003'\u0012\u0003\u0019AA\u000b\u0003%!WmY8eK.+\u0017\u0010\u0006\u0003\u0002\u0016\u0005-\u0004bBA7G\u0001\u0007\u0011qL\u0001\tW\u0016L()\u001f;fg\u0006yQM\\2pI\u0016\u0004&/\u001a4jq.+\u0017\u0010\u0006\u0003\u0002`\u0005M\u0004bBA;I\u0001\u0007\u0011QC\u0001\naJ,g-\u001b=LKf\fAc];qa>\u0014H\u000f\u0015:fM&D8*Z=TG\u0006tW#A5")
public class RangeKeyScanStateEncoder
implements RocksDBKeyStateEncoder {
    private final StructType keySchema;
    private final Seq<Object> orderingOrdinals;
    private final Seq<Tuple2<StructField, Object>> rangeScanKeyFieldsWithOrdinal;
    private final Seq<Tuple2<StructField, Object>> remainingKeyFieldsWithOrdinal;
    private final UnsafeProjection rangeScanKeyProjection;
    private final UnsafeProjection remainingKeyProjection;
    private final UnsafeProjection restoreKeyProjection;
    private final JoinedRow joinedRowOnKey;
    private final int floatFlipBitMask;
    private final int floatSignBitMask;
    private final long doubleFlipBitMask;
    private final long doubleSignBitMask;
    private final byte negativeValMarker;
    private final byte positiveValMarker;
    private final byte nullValMarker;

    private Seq<Tuple2<StructField, Object>> rangeScanKeyFieldsWithOrdinal() {
        return this.rangeScanKeyFieldsWithOrdinal;
    }

    private boolean isFixedSize(DataType dataType) {
        DataType dataType2 = dataType;
        return dataType2 instanceof ByteType ? true : (dataType2 instanceof BooleanType ? true : (dataType2 instanceof ShortType ? true : (dataType2 instanceof IntegerType ? true : (dataType2 instanceof LongType ? true : (dataType2 instanceof FloatType ? true : dataType2 instanceof DoubleType)))));
    }

    private Seq<Tuple2<StructField, Object>> remainingKeyFieldsWithOrdinal() {
        return this.remainingKeyFieldsWithOrdinal;
    }

    private UnsafeProjection rangeScanKeyProjection() {
        return this.rangeScanKeyProjection;
    }

    private UnsafeProjection remainingKeyProjection() {
        return this.remainingKeyProjection;
    }

    private UnsafeProjection restoreKeyProjection() {
        return this.restoreKeyProjection;
    }

    private JoinedRow joinedRowOnKey() {
        return this.joinedRowOnKey;
    }

    private UnsafeRow extractPrefixKey(UnsafeRow key) {
        return this.rangeScanKeyProjection().apply((InternalRow)key);
    }

    private int floatFlipBitMask() {
        return this.floatFlipBitMask;
    }

    private int floatSignBitMask() {
        return this.floatSignBitMask;
    }

    private long doubleFlipBitMask() {
        return this.doubleFlipBitMask;
    }

    private long doubleSignBitMask() {
        return this.doubleSignBitMask;
    }

    private byte negativeValMarker() {
        return this.negativeValMarker;
    }

    private byte positiveValMarker() {
        return this.positiveValMarker;
    }

    private byte nullValMarker() {
        return this.nullValMarker;
    }

    private UnsafeRow encodePrefixKeyForRangeScan(UnsafeRow row) {
        UnsafeRowWriter writer = new UnsafeRowWriter(this.orderingOrdinals.length());
        writer.resetRowWriter();
        ((IterableOnceOps)this.rangeScanKeyFieldsWithOrdinal().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            RangeKeyScanStateEncoder.$anonfun$encodePrefixKeyForRangeScan$1(this, row, writer, x0$1);
            return BoxedUnit.UNIT;
        });
        return writer.getRow();
    }

    private UnsafeRow decodePrefixKeyForRangeScan(UnsafeRow row) {
        UnsafeRowWriter writer = new UnsafeRowWriter(this.orderingOrdinals.length());
        writer.resetRowWriter();
        ((IterableOnceOps)this.rangeScanKeyFieldsWithOrdinal().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            RangeKeyScanStateEncoder.$anonfun$decodePrefixKeyForRangeScan$1(this, row, writer, x0$1);
            return BoxedUnit.UNIT;
        });
        return writer.getRow();
    }

    @Override
    public byte[] encodeKey(UnsafeRow row) {
        byte[] byArray;
        UnsafeRow prefixKey = this.extractPrefixKey(row);
        byte[] rangeScanKeyEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(this.encodePrefixKeyForRangeScan(prefixKey));
        if (this.orderingOrdinals.length() < this.keySchema.length()) {
            byte[] remainingEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(this.remainingKeyProjection().apply((InternalRow)row));
            byte[] encodedBytes = new byte[rangeScanKeyEncoded.length + remainingEncoded.length + 4];
            Platform.putInt((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)rangeScanKeyEncoded.length);
            Platform.copyMemory((Object)rangeScanKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)rangeScanKeyEncoded.length);
            Platform.copyMemory((Object)remainingEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4 + rangeScanKeyEncoded.length), (long)remainingEncoded.length);
            byArray = encodedBytes;
        } else {
            byte[] encodedBytes = new byte[rangeScanKeyEncoded.length + 4];
            Platform.putInt((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)rangeScanKeyEncoded.length);
            Platform.copyMemory((Object)rangeScanKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)rangeScanKeyEncoded.length);
            byArray = encodedBytes;
        }
        byte[] result = byArray;
        return result;
    }

    @Override
    public UnsafeRow decodeKey(byte[] keyBytes) {
        int prefixKeyEncodedLen = Platform.getInt((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET);
        byte[] prefixKeyEncoded = new byte[prefixKeyEncodedLen];
        Platform.copyMemory((Object)keyBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (Object)prefixKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (long)prefixKeyEncodedLen);
        UnsafeRow prefixKeyDecodedForRangeScan = RocksDBStateEncoder$.MODULE$.decodeToUnsafeRow(prefixKeyEncoded, this.orderingOrdinals.length());
        UnsafeRow prefixKeyDecoded = this.decodePrefixKeyForRangeScan(prefixKeyDecodedForRangeScan);
        if (this.orderingOrdinals.length() < this.keySchema.length()) {
            int remainingKeyEncodedLen = keyBytes.length - 4 - prefixKeyEncodedLen;
            byte[] remainingKeyEncoded = new byte[remainingKeyEncodedLen];
            Platform.copyMemory((Object)keyBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4 + prefixKeyEncodedLen), (Object)remainingKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (long)remainingKeyEncodedLen);
            UnsafeRow remainingKeyDecoded = RocksDBStateEncoder$.MODULE$.decodeToUnsafeRow(remainingKeyEncoded, this.keySchema.length() - this.orderingOrdinals.length());
            JoinedRow joined = this.joinedRowOnKey().withLeft((InternalRow)prefixKeyDecoded).withRight((InternalRow)remainingKeyDecoded);
            UnsafeRow restored = this.restoreKeyProjection().apply((InternalRow)joined);
            return restored;
        }
        return prefixKeyDecoded;
    }

    @Override
    public byte[] encodePrefixKey(UnsafeRow prefixKey) {
        byte[] rangeScanKeyEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(this.encodePrefixKeyForRangeScan(prefixKey));
        byte[] prefix = new byte[rangeScanKeyEncoded.length + 4];
        Platform.putInt((Object)prefix, (long)Platform.BYTE_ARRAY_OFFSET, (int)rangeScanKeyEncoded.length);
        Platform.copyMemory((Object)rangeScanKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)prefix, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)rangeScanKeyEncoded.length);
        return prefix;
    }

    @Override
    public boolean supportPrefixKeyScan() {
        return true;
    }

    public static final /* synthetic */ Tuple2 $anonfun$rangeScanKeyFieldsWithOrdinal$1(RangeKeyScanStateEncoder $this, int ordinal) {
        StructField field = $this.keySchema.apply(ordinal);
        return new Tuple2((Object)field, (Object)BoxesRunTime.boxToInteger((int)ordinal));
    }

    public static final /* synthetic */ void $anonfun$new$1(RangeKeyScanStateEncoder $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int ordinal = tuple2._2$mcI$sp();
            if (!$this.isFixedSize(field.dataType())) {
                DataType dataType = field.dataType();
                NullType$ nullType$ = NullType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(nullType$) : nullType$ != null)) {
                    throw StateStoreErrors$.MODULE$.nullTypeOrderingColsNotSupported(field.name(), Integer.toString(ordinal));
                }
                throw StateStoreErrors$.MODULE$.variableSizeOrderingColsNotSupported(field.name(), Integer.toString(ordinal));
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$remainingKeyFieldsWithOrdinal$1(RangeKeyScanStateEncoder $this, int ordinal) {
        StructField field = $this.keySchema.apply(ordinal);
        return new Tuple2((Object)field, (Object)BoxesRunTime.boxToInteger((int)ordinal));
    }

    public static final /* synthetic */ boolean $anonfun$restoreKeyProjection$2(int originalOrdinal$1, Tuple2 x$1) {
        return x$1._2$mcI$sp() == originalOrdinal$1;
    }

    public static final /* synthetic */ void $anonfun$encodePrefixKeyForRangeScan$1(RangeKeyScanStateEncoder $this, UnsafeRow row$1, UnsafeRowWriter writer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 fieldWithOrdinal = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            StructField field = (StructField)fieldWithOrdinal._1();
            Object value = row$1.get(idx, field.dataType());
            ByteBuffer bbuf = ByteBuffer.allocate(field.dataType().defaultSize() + 1);
            bbuf.order(ByteOrder.BIG_ENDIAN);
            if (value == null) {
                bbuf.put($this.nullValMarker());
                writer$1.write(idx, bbuf.array());
                return;
            }
            DataType dataType = field.dataType();
            if (BooleanType$.MODULE$.equals(dataType)) {
            } else if (ByteType$.MODULE$.equals(dataType)) {
                byte byteVal = BoxesRunTime.unboxToByte((Object)value);
                byte signCol = byteVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.put(byteVal);
                writer$1.write(idx, bbuf.array());
            } else if (ShortType$.MODULE$.equals(dataType)) {
                short shortVal = BoxesRunTime.unboxToShort((Object)value);
                byte signCol = shortVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.putShort(shortVal);
                writer$1.write(idx, bbuf.array());
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                int intVal = BoxesRunTime.unboxToInt((Object)value);
                byte signCol = intVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.putInt(intVal);
                writer$1.write(idx, bbuf.array());
            } else if (LongType$.MODULE$.equals(dataType)) {
                long longVal = BoxesRunTime.unboxToLong((Object)value);
                byte signCol = longVal < 0L ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.putLong(longVal);
                writer$1.write(idx, bbuf.array());
            } else if (FloatType$.MODULE$.equals(dataType)) {
                float floatVal = BoxesRunTime.unboxToFloat((Object)value);
                int rawBits = Float.floatToRawIntBits(floatVal);
                if ((rawBits & $this.floatSignBitMask()) != 0) {
                    int updatedVal = rawBits ^ $this.floatFlipBitMask();
                    bbuf.put($this.negativeValMarker());
                    v0 = bbuf.putFloat(Float.intBitsToFloat(updatedVal));
                } else {
                    bbuf.put($this.positiveValMarker());
                    v0 = bbuf.putFloat(floatVal);
                }
                writer$1.write(idx, bbuf.array());
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                double doubleVal = BoxesRunTime.unboxToDouble((Object)value);
                long rawBits = Double.doubleToRawLongBits(doubleVal);
                if ((rawBits & $this.doubleSignBitMask()) != 0L) {
                    long updatedVal = rawBits ^ $this.doubleFlipBitMask();
                    bbuf.put($this.negativeValMarker());
                    v1 = bbuf.putDouble(Double.longBitsToDouble(updatedVal));
                } else {
                    bbuf.put($this.positiveValMarker());
                    v1 = bbuf.putDouble(doubleVal);
                }
                writer$1.write(idx, bbuf.array());
            } else {
                throw new MatchError((Object)dataType);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$decodePrefixKeyForRangeScan$1(RangeKeyScanStateEncoder $this, UnsafeRow row$2, UnsafeRowWriter writer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 fieldWithOrdinal = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            StructField field = (StructField)fieldWithOrdinal._1();
            byte[] value = row$2.getBinary(idx);
            ByteBuffer bbuf = ByteBuffer.wrap(value);
            bbuf.order(ByteOrder.BIG_ENDIAN);
            byte isNullOrSignCol = bbuf.get();
            if (isNullOrSignCol == $this.nullValMarker()) {
                writer$2.setNullAt(idx);
                return;
            }
            DataType dataType = field.dataType();
            if (BooleanType$.MODULE$.equals(dataType)) {
            } else if (ByteType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.get());
            } else if (ShortType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.getShort());
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.getInt());
            } else if (LongType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.getLong());
            } else if (FloatType$.MODULE$.equals(dataType)) {
                if (isNullOrSignCol == $this.negativeValMarker()) {
                    int updatedVal = Float.floatToRawIntBits(bbuf.getFloat()) ^ $this.floatFlipBitMask();
                    writer$2.write(idx, Float.intBitsToFloat(updatedVal));
                } else {
                    writer$2.write(idx, bbuf.getFloat());
                }
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                if (isNullOrSignCol == $this.negativeValMarker()) {
                    long updatedVal = Double.doubleToRawLongBits(bbuf.getDouble()) ^ $this.doubleFlipBitMask();
                    writer$2.write(idx, Double.longBitsToDouble(updatedVal));
                } else {
                    writer$2.write(idx, bbuf.getDouble());
                }
            } else {
                throw new MatchError((Object)dataType);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public RangeKeyScanStateEncoder(StructType keySchema, Seq<Object> orderingOrdinals) {
        this.keySchema = keySchema;
        this.orderingOrdinals = orderingOrdinals;
        this.rangeScanKeyFieldsWithOrdinal = (Seq)orderingOrdinals.map((Function1 & Serializable)ordinal -> RangeKeyScanStateEncoder.$anonfun$rangeScanKeyFieldsWithOrdinal$1(this, BoxesRunTime.unboxToInt((Object)ordinal)));
        this.rangeScanKeyFieldsWithOrdinal().foreach((Function1 & Serializable)x0$1 -> {
            RangeKeyScanStateEncoder.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.remainingKeyFieldsWithOrdinal = (Seq)((IndexedSeqOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), keySchema.length() - 1).diff(orderingOrdinals)).map((Function1 & Serializable)ordinal -> RangeKeyScanStateEncoder.$anonfun$remainingKeyFieldsWithOrdinal$1(this, BoxesRunTime.unboxToInt((Object)ordinal)));
        Seq refs = (Seq)this.rangeScanKeyFieldsWithOrdinal().map((Function1 & Serializable)x -> new BoundReference(x._2$mcI$sp(), ((StructField)x._1()).dataType(), ((StructField)x._1()).nullable()));
        this.rangeScanKeyProjection = UnsafeProjection$.MODULE$.create(refs);
        Seq refs2 = (Seq)this.remainingKeyFieldsWithOrdinal().map((Function1 & Serializable)x -> new BoundReference(x._2$mcI$sp(), ((StructField)x._1()).dataType(), ((StructField)x._1()).nullable()));
        this.remainingKeyProjection = UnsafeProjection$.MODULE$.create(refs2);
        Seq refs3 = (Seq)((IterableOps)keySchema.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int originalOrdinal = tuple2._2$mcI$sp();
                int ordinalInJoinedRow = $this.orderingOrdinals.contains((Object)BoxesRunTime.boxToInteger((int)originalOrdinal)) ? $this.orderingOrdinals.indexOf((Object)BoxesRunTime.boxToInteger((int)originalOrdinal)) : $this.orderingOrdinals.length() + this.remainingKeyFieldsWithOrdinal().indexWhere((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RangeKeyScanStateEncoder.$anonfun$restoreKeyProjection$2(originalOrdinal, x$1)));
                return new BoundReference(ordinalInJoinedRow, field.dataType(), field.nullable());
            }
            throw new MatchError((Object)tuple2);
        });
        this.restoreKeyProjection = UnsafeProjection$.MODULE$.create(refs3);
        this.joinedRowOnKey = new JoinedRow();
        this.floatFlipBitMask = -1;
        this.floatSignBitMask = Integer.MIN_VALUE;
        this.doubleFlipBitMask = -1L;
        this.doubleSignBitMask = Long.MIN_VALUE;
        this.negativeValMarker = (byte)0;
        this.positiveValMarker = (byte)1;
        this.nullValMarker = (byte)2;
    }
}

