/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV1;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV2;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriter;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriterV1;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriterV2;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r5a\u0001B\u001f?\u00015C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"Aq\u000e\u0001B\u0001B\u0003%\u0001\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003\\\u0011!I\bA!A!\u0002\u0013Y\u0006\"\u0002>\u0001\t\u0003Y\b\"CA\u0004\u0001\t\u0007I\u0011BA\u0005\u0011!\tI\u0004\u0001Q\u0001\n\u0005-\u0001BCA\u001e\u0001\t\u0007I\u0011\u0001#\u0002>!A\u0011\u0011\t\u0001!\u0002\u0013\ty\u0004\u0003\u0006\u0002D\u0001A)\u0019!C\u0005\u0003\u000bB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005u\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0018\u0001\u0005\u0004%I!!\u0019\t\u0011\u0005%\u0004\u0001)A\u0005\u0003GB\u0011\"! \u0001\u0005\u0004%I!a \t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003\u0003C!\"a\"\u0001\u0011\u000b\u0007I\u0011BAE\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+C\u0011\"!)\u0001\u0001\u0004%I!a)\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0006\u0002CA]\u0001\u0001\u0006K!!*\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"I\u0011Q\u001b\u0001\u0012\u0002\u0013\u0005\u0011q\u001b\u0005\b\u0003[\u0004A\u0011AAx\u0011%\tY\u0010AI\u0001\n\u0003\t9\u000eC\u0005\u0002~\u0002\u0001\r\u0011\"\u0003\u0002\u0000\"I!q\u0001\u0001A\u0002\u0013%!\u0011\u0002\u0005\t\u0005\u001b\u0001\u0001\u0015)\u0003\u0003\u0002!I!\u0011\u0003\u0001A\u0002\u0013%\u0011q \u0005\n\u0005'\u0001\u0001\u0019!C\u0005\u0005+A\u0001B!\u0007\u0001A\u0003&!\u0011\u0001\u0005\b\u0005;\u0001A\u0011AA\u0000\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003\u007fDqA!\t\u0001\t\u0003\u0011\u0019\u0003C\u0004\u00030\u0001!\tA!\r\t\u000f\t}\u0002\u0001\"\u0001\u0003B!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B%\u0001\u0011\u0005!1\n\u0005\b\u0005?\u0002A\u0011\u0002B1\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005_BqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\b\u0002!IA!#\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BO\u0001\u0011%!q\u0014\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011\t\r\u0001C\u0005\u0005\u0007DqA!3\u0001\t\u0013\u0011Y\rC\u0004\u0003P\u0002!IA!5\t\u000f\tU\u0007\u0001\"\u0003\u0003X\"9!Q\u001c\u0001\u0005R\t}\u0007b\u0002Bq\u0001\u0011%!1\u001d\u0005\b\u0005S\u0004A\u0011\u0002Bv\u0011\u001d\u0011\t\u0010\u0001C\u0005\u0005g<\u0011B!@?\u0003\u0003E\tAa@\u0007\u0011ur\u0014\u0011!E\u0001\u0007\u0003AaA_\u001d\u0005\u0002\r\r\u0001\"CB\u0003sE\u0005I\u0011AB\u0004\u0011%\u0019Y!OI\u0001\n\u0003\u00199A\u0001\nS_\u000e\\7\u000f\u0012\"GS2,W*\u00198bO\u0016\u0014(BA A\u0003\u0015\u0019H/\u0019;f\u0015\t\t%)A\u0005tiJ,\u0017-\\5oO*\u00111\tR\u0001\nKb,7-\u001e;j_:T!!\u0012$\u0002\u0007M\fHN\u0003\u0002H\u0011\u0006)1\u000f]1sW*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001(U!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0019\te.\u001f*fMB\u0011Q\u000bW\u0007\u0002-*\u0011qKR\u0001\tS:$XM\u001d8bY&\u0011\u0011L\u0016\u0002\b\u0019><w-\u001b8h\u0003)!gm\u001d*p_R$\u0015N\u001d\t\u00039\u000et!!X1\u0011\u0005y\u0003V\"A0\u000b\u0005\u0001d\u0015A\u0002\u001fs_>$h(\u0003\u0002c!\u00061\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011\u0007+\u0001\u0007m_\u000e\fG\u000eV3na\u0012K'\u000f\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006\u0011\u0011n\u001c\u0006\u0002Y\u0006!!.\u0019<b\u0013\tq\u0017N\u0001\u0003GS2,\u0017A\u00035bI>|\u0007oQ8oMB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005G>tgM\u0003\u0002v\u0011\u00061\u0001.\u00193p_BL!a\u001e:\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003%\u0019w\u000eZ3d\u001d\u0006lW-A\u0005m_\u001e<\u0017N\\4JI\u00061A(\u001b8jiz\"\u0012\u0002 @\u0000\u0003\u0003\t\u0019!!\u0002\u0011\u0005u\u0004Q\"\u0001 \t\u000bi3\u0001\u0019A.\t\u000b\u00194\u0001\u0019A4\t\u000b=4\u0001\u0019\u00019\t\u000fa4\u0001\u0013!a\u00017\"9\u0011P\u0002I\u0001\u0002\u0004Y\u0016!\u0006<feNLwN\u001c+p%>\u001c7n\u001d#C\r&dWm]\u000b\u0003\u0003\u0017\u0001\u0002\"!\u0004\u0002\u0018\u0005m\u0011\u0011E\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005U1.\u0001\u0003vi&d\u0017\u0002BA\r\u0003\u001f\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\ry\u0015QD\u0005\u0004\u0003?\u0001&\u0001\u0002'p]\u001e\u0004b!a\t\u0002.\u0005Mb\u0002BA\u0013\u0003Sq1AXA\u0014\u0013\u0005\t\u0016bAA\u0016!\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u00111aU3r\u0015\r\tY\u0003\u0015\t\u0004{\u0006U\u0012bAA\u001c}\t!\"k\\2lg\u0012\u0013\u0015*\\7vi\u0006\u0014G.\u001a$jY\u0016\faC^3sg&|g\u000eV8S_\u000e\\7\u000f\u0012\"GS2,7\u000fI\u0001\u0015Y>\u001c\u0017\r\u001c$jY\u0016\u001cHk\u001c#gg\u001aKG.Z:\u0016\u0005\u0005}\u0002cBA\u0007\u0003/Y\u00161G\u0001\u0016Y>\u001c\u0017\r\u001c$jY\u0016\u001cHk\u001c#gg\u001aKG.Z:!\u0003\t1W.\u0006\u0002\u0002HA!\u0011\u0011JA&\u001b\u0005\u0001\u0015bAA'\u0001\n)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\u0018A\u00014t+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005eSBAA,\u0015\r\ty\u0005^\u0005\u0005\u00037\n9F\u0001\u0006GS2,7+_:uK6\f1AZ:!\u00031yg\u000e\\=[SB4\u0015\u000e\\3t+\t\t\u0019G\u0005\u0004\u0002f\u0005-\u0014q\u000f\u0004\u0007\u0003Oz\u0001!a\u0019\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002\u001b=tG.\u001f.ja\u001aKG.Z:!!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9W\u0006!A.\u00198h\u0013\u0011\t)(a\u001c\u0003\r=\u0013'.Z2u!\u0011\t)&!\u001f\n\t\u0005m\u0014q\u000b\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\u0018AE8oYf\u001c\u0005.\u00198hK2|wMR5mKN,\"!!!\u0013\r\u0005\r\u00151NA<\r\u0019\t9'\u0005\u0001\u0002\u0002\u0006\u0019rN\u001c7z\u0007\"\fgnZ3m_\u001e4\u0015\u000e\\3tA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00106\ta)C\u0002\u0002\u0012\u001a\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|G-Z2\u0016\u0005\u0005]\u0005\u0003BAM\u0003;k!!a'\u000b\u0005)4\u0015\u0002BAP\u00037\u0013\u0001cQ8naJ,7o]5p]\u000e{G-Z2\u0002\u001dI|w\u000e\u001e#je\u000eCWmY6fIV\u0011\u0011Q\u0015\t\u0004\u001f\u0006\u001d\u0016bAAU!\n9!i\\8mK\u0006t\u0017A\u0005:p_R$\u0015N]\"iK\u000e\\W\rZ0%KF$B!a,\u00026B\u0019q*!-\n\u0007\u0005M\u0006K\u0001\u0003V]&$\b\"CA\\+\u0005\u0005\t\u0019AAS\u0003\rAH%M\u0001\u0010e>|G\u000fR5s\u0007\",7m[3eA!\u001aa#!0\u0011\u0007=\u000by,C\u0002\u0002BB\u0013\u0001B^8mCRLG.Z\u0001\u0013O\u0016$8\t[1oO\u0016dunZ,sSR,'\u000f\u0006\u0004\u0002H\u00065\u0017\u0011\u001b\t\u0004{\u0006%\u0017bAAf}\tI2\u000b^1uKN#xN]3DQ\u0006tw-\u001a7pO^\u0013\u0018\u000e^3s\u0011\u001d\tym\u0006a\u0001\u00037\tqA^3sg&|g\u000eC\u0005\u0002T^\u0001\n\u00111\u0001\u0002&\u0006\tRo]3D_2,XN\u001c$b[&d\u0017.Z:\u00029\u001d,Go\u00115b]\u001e,Gj\\4Xe&$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001c\u0016\u0005\u0003K\u000bYn\u000b\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018!C;oG\",7m[3e\u0015\r\t9\u000fU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAv\u0003C\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I9W\r^\"iC:<W\r\\8h%\u0016\fG-\u001a:\u0015\r\u0005E\u0018q_A}!\ri\u00181_\u0005\u0004\u0003kt$!G*uCR,7\u000b^8sK\u000eC\u0017M\\4fY><'+Z1eKJDq!a4\u001a\u0001\u0004\tY\u0002C\u0005\u0002Tf\u0001\n\u00111\u0001\u0002&\u0006ar-\u001a;DQ\u0006tw-\u001a7pOJ+\u0017\rZ3sI\u0011,g-Y;mi\u0012\u0012\u0014!\u00067pC\u0012\u001c\u0005.Z2la>Lg\u000e^'fiJL7m]\u000b\u0003\u0005\u0003\u00012! B\u0002\u0013\r\u0011)A\u0010\u0002\u001a%>\u001c7n\u001d#C\r&dW-T1oC\u001e,'/T3ue&\u001c7/A\rm_\u0006$7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:`I\u0015\fH\u0003BAX\u0005\u0017A\u0011\"a.\u001d\u0003\u0003\u0005\rA!\u0001\u0002-1|\u0017\rZ\"iK\u000e\\\u0007o\\5oi6+GO]5dg\u0002B3!HA_\u0003U\u0019\u0018M^3DQ\u0016\u001c7\u000e]8j]RlU\r\u001e:jGN\f\u0011d]1wK\u000eCWmY6q_&tG/T3ue&\u001c7o\u0018\u0013fcR!\u0011q\u0016B\f\u0011%\t9lHA\u0001\u0002\u0004\u0011\t!\u0001\ftCZ,7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:!Q\r\u0001\u0013QX\u0001\u001cY\u0006$Xm\u001d;M_\u0006$7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:\u000271\fG/Z:u'\u00064Xm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2t\u0003M\u0019\u0018M^3DQ\u0016\u001c7\u000e]8j]R$v\u000e\u00124t)!\tyK!\n\u0003*\t-\u0002B\u0002B\u0014G\u0001\u0007q-A\u0007dQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u0005\b\u0003\u001f\u001c\u0003\u0019AA\u000e\u0011\u001d\u0011ic\ta\u0001\u00037\tqA\\;n\u0017\u0016L8/A\u000bm_\u0006$7\t[3dWB|\u0017N\u001c;Ge>lGIZ:\u0015\r\tM\"\u0011\bB\u001e!\ri(QG\u0005\u0004\u0005oq$!\u0007*pG.\u001cHIQ\"iK\u000e\\\u0007o\\5oi6+G/\u00193bi\u0006Dq!a4%\u0001\u0004\tY\u0002\u0003\u0004\u0003>\u0011\u0002\raZ\u0001\tY>\u001c\u0017\r\u001c#je\u0006Ar-\u001a;MCR,7\u000f^*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0015\t\u0005m!1\t\u0005\b\u0003\u001f,\u0003\u0019AA\u000e\u0003A9W\r\u001e'bi\u0016\u001cHOV3sg&|g\u000e\u0006\u0002\u0002\u001c\u0005ya-\u001b8e\u001fJ\u0004\b.\u00198GS2,7\u000f\u0006\u0004\u0003N\t=#1\u000b\t\u0006\u0003G\tic\u0017\u0005\b\u0005#:\u0003\u0019\u0001B'\u00031!(/Y2lK\u00124\u0015\u000e\\3t\u0011\u001d\u0011)f\na\u0001\u0005/\n\u0001\"\u00197m\r&dWm\u001d\t\u0007\u0003G\tiC!\u0017\u0011\t\u0005U#1L\u0005\u0005\u0005;\n9F\u0001\u0006GS2,7\u000b^1ukN\fA\u0003Z3mKR,7\t[1oO\u0016dwn\u001a$jY\u0016\u001cH\u0003BAX\u0005GBqA!\u001a)\u0001\u0004\u00119'\u0001\twKJ\u001c\u0018n\u001c8t)>$U\r\\3uKB)qJ!\u001b\u0002\u001c%\u0019!1\u000e)\u0003\u000b\u0005\u0013(/Y=\u0002#\u0011,G.\u001a;f\u001f2$g+\u001a:tS>t7\u000f\u0006\u0003\u00020\nE\u0004b\u0002B:S\u0001\u0007!QO\u0001\u0014]Vlg+\u001a:tS>t7\u000fV8SKR\f\u0017N\u001c\t\u0004\u001f\n]\u0014b\u0001B=!\n\u0019\u0011J\u001c;\u0002/M\fg/Z%n[V$\u0018M\u00197f\r&dWm\u001d+p\t\u001a\u001cHCBA\u0011\u0005\u007f\u0012\t\tC\u0004\u0002P*\u0002\r!a\u0007\t\u000f\t\r%\u00061\u0001\u0003\u0006\u0006QAn\\2bY\u001aKG.Z:\u0011\u000b\u0005\r\u0012QF4\u000231|\u0017\rZ%n[V$\u0018M\u00197f\r&dWm\u001d$s_6$em\u001d\u000b\u0007\u0003_\u0013YIa$\t\u000f\t55\u00061\u0001\u0002\"\u0005q\u0011.\\7vi\u0006\u0014G.\u001a$jY\u0016\u001c\bB\u0002B\u001fW\u0001\u0007q-\u0001\u0016sK6|g/\u001a'pG\u0006dG.\u001f#fY\u0016$X\rZ*T)\u001aKG.Z:Ge>lGIZ:NCB\u0004\u0018N\\4\u0015\t\u0005=&Q\u0013\u0005\b\u0005\u0007c\u0003\u0019\u0001BC\u0003}9W\r^%n[V$\u0018M\u00197f\r&dWm\u001d$s_64VM]:j_:T\u0016\u000e\u001d\u000b\u0005\u0003C\u0011Y\nC\u0004\u0002P6\u0002\r!a\u0007\u0002\u0019iL\u0007\u000fV8EMN4\u0015\u000e\\3\u0015\r\u0005=&\u0011\u0015BS\u0011\u001d\u0011\u0019K\fa\u0001\u0005\u000b\u000bQAZ5mKNDqAa*/\u0001\u0004\u0011I+\u0001\u0006eMNT\u0016\u000e\u001d$jY\u0016\u0004B!!\u0016\u0003,&!!QVA,\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001b1|wMR5mKNLe\u000eR5s)\u0019\tyKa-\u00038\"1!QW\u0018A\u0002\u001d\f1\u0001Z5s\u0011\u001d\u0011Il\fa\u0001\u0005w\u000b1!\\:h!\r)&QX\u0005\u0004\u0005\u007f3&AE'fgN\fw-Z,ji\"\u001cuN\u001c;fqR\faB\\3x\t\u001a\u001bf)\u001b7f\u001d\u0006lW\rF\u0002\\\u0005\u000bDaAa21\u0001\u0004Y\u0016!\u00047pG\u0006dg)\u001b7f\u001d\u0006lW-A\beMN\u0014\u0015\r^2i5&\u0004h)\u001b7f)\u0011\u0011IK!4\t\u000f\u0005=\u0017\u00071\u0001\u0002\u001c\u0005\u0001BMZ:DQ\u0006tw-\u001a7pO\u001aKG.\u001a\u000b\u0005\u0005S\u0013\u0019\u000eC\u0004\u0002PJ\u0002\r!a\u0007\u0002#1|7-\u00197NKR\fG-\u0019;b\r&dW\rF\u0002h\u00053DaAa74\u0001\u00049\u0017!\u00039be\u0016tG\u000fR5s\u0003\u001dawn\u001a(b[\u0016,\u0012aW\u0001\fI\u001a\u001ch)\u001b7f!\u0006$\b\u000e\u0006\u0003\u0003*\n\u0015\bB\u0002Btk\u0001\u00071,\u0001\u0005gS2,g*Y7f\u00035awnY1m\r&dW\rU1uQR)qM!<\u0003p\"1!Q\b\u001cA\u0002\u001dDaAa:7\u0001\u0004Y\u0016\u0001\u00057jgR\u0014vnY6t\t\n3\u0015\u000e\\3t)\u0011\u0011)Pa?\u0011\u000f=\u00139P!\"\u0003\u0006&\u0019!\u0011 )\u0003\rQ+\b\u000f\\33\u0011\u0019\u0011id\u000ea\u0001O\u0006\u0011\"k\\2lg\u0012\u0013e)\u001b7f\u001b\u0006t\u0017mZ3s!\ti\u0018h\u0005\u0002:\u001dR\u0011!q`\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r%!fA.\u0002\\\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\u0002")
public class RocksDBFileManager
implements Logging {
    private CheckpointFileManager fm;
    private SparkConf sparkConf;
    private final String dfsRootDir;
    private final File localTempDir;
    private Configuration hadoopConf;
    private final String codecName;
    private final String loggingId;
    private final ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles;
    private final ConcurrentHashMap<String, RocksDBImmutableFile> localFilesToDfsFiles;
    private final FileSystem fs;
    private final PathFilter onlyZipFiles;
    private final PathFilter onlyChangelogFiles;
    private volatile boolean rootDirChecked;
    private volatile RocksDBFileManagerMetrics loadCheckpointMetrics;
    private volatile RocksDBFileManagerMetrics saveCheckpointMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$5() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> versionToRocksDBFiles() {
        return this.versionToRocksDBFiles;
    }

    public ConcurrentHashMap<String, RocksDBImmutableFile> localFilesToDfsFiles() {
        return this.localFilesToDfsFiles;
    }

    private CheckpointFileManager fm$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fm = CheckpointFileManager$.MODULE$.create(new Path(this.dfsRootDir), this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private PathFilter onlyZipFiles() {
        return this.onlyZipFiles;
    }

    private PathFilter onlyChangelogFiles() {
        return this.onlyChangelogFiles;
    }

    private SparkConf sparkConf$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkConf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable)() -> new SparkConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkConf;
    }

    private SparkConf sparkConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkConf$lzycompute();
        }
        return this.sparkConf;
    }

    private CompressionCodec codec() {
        return CompressionCodec$.MODULE$.createCodec(this.sparkConf(), this.codecName);
    }

    private boolean rootDirChecked() {
        return this.rootDirChecked;
    }

    private void rootDirChecked_$eq(boolean x$1) {
        this.rootDirChecked = x$1;
    }

    public StateStoreChangelogWriter getChangeLogWriter(long version, boolean useColumnFamilies) {
        Path changelogFile = this.dfsChangelogFile(version);
        if (!this.rootDirChecked()) {
            Path rootDir = new Path(this.dfsRootDir);
            if (!this.fm().exists(rootDir)) {
                this.fm().mkdirs(rootDir);
            }
            this.rootDirChecked_$eq(true);
        }
        StateStoreChangelogWriter changelogWriter = useColumnFamilies ? new StateStoreChangelogWriterV2(this.fm(), changelogFile, this.codec()) : new StateStoreChangelogWriterV1(this.fm(), changelogFile, this.codec());
        return changelogWriter;
    }

    public boolean getChangeLogWriter$default$2() {
        return false;
    }

    public StateStoreChangelogReader getChangelogReader(long version, boolean useColumnFamilies) {
        Path changelogFile = this.dfsChangelogFile(version);
        if (useColumnFamilies) {
            return new StateStoreChangelogReaderV2(this.fm(), changelogFile, this.codec());
        }
        return new StateStoreChangelogReaderV1(this.fm(), changelogFile, this.codec());
    }

    public boolean getChangelogReader$default$2() {
        return false;
    }

    private RocksDBFileManagerMetrics loadCheckpointMetrics() {
        return this.loadCheckpointMetrics;
    }

    private void loadCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.loadCheckpointMetrics = x$1;
    }

    private RocksDBFileManagerMetrics saveCheckpointMetrics() {
        return this.saveCheckpointMetrics;
    }

    private void saveCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.saveCheckpointMetrics = x$1;
    }

    public RocksDBFileManagerMetrics latestLoadCheckpointMetrics() {
        return this.loadCheckpointMetrics();
    }

    public RocksDBFileManagerMetrics latestSaveCheckpointMetrics() {
        return this.saveCheckpointMetrics();
    }

    public void saveCheckpointToDfs(File checkpointDir, long version, long numKeys) {
        this.logFilesInDir(checkpointDir, this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Saving checkpoint files "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        Tuple2<Seq<File>, Seq<File>> tuple2 = this.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localOtherFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)localImmutableFiles, (Object)localOtherFiles);
        Seq localImmutableFiles2 = (Seq)tuple22._1();
        Seq localOtherFiles2 = (Seq)tuple22._2();
        Seq<RocksDBImmutableFile> rocksDBFiles = this.saveImmutableFilesToDfs(version, (Seq<File>)localImmutableFiles2);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.apply(rocksDBFiles, numKeys);
        File metadataFile = this.localMetadataFile(checkpointDir);
        metadata.writeToFile(metadataFile);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Written metadata for version ", ":\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.METADATA_JSON$.MODULE$, (Object)metadata.prettyJson())})))));
        if (version <= 1L && numKeys <= 0L && !this.rootDirChecked()) {
            Path path = new Path(this.dfsRootDir);
            if (!this.fm().exists(path)) {
                this.fm().mkdirs(path);
            }
            this.rootDirChecked_$eq(true);
        }
        this.zipToDfsFile((Seq<File>)((Seq)localOtherFiles2.$colon$plus((Object)metadataFile)), this.dfsBatchZipFile(version));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Saved checkpoint file for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
    }

    public RocksDBCheckpointMetadata loadCheckpointFromDfs(long version, File localDir) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Loading checkpoint files for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        this.versionToRocksDBFiles().keySet().removeIf(x$3 -> RocksDBFileManager.$anonfun$loadCheckpointFromDfs$2(version, BoxesRunTime.unboxToLong((Object)x$3)));
        if (version == 0L) {
            if (localDir.exists()) {
                Utils$.MODULE$.deleteRecursively(localDir);
            }
            this.localFilesToDfsFiles().clear();
            localDir.mkdirs();
            rocksDBCheckpointMetadata = RocksDBCheckpointMetadata$.MODULE$.apply((Seq<RocksDBImmutableFile>)((Seq)scala.package$.MODULE$.Seq().empty()), 0L);
        } else {
            ((IterableOnceOps)this.listRocksDBFiles(localDir)._2()).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.delete()));
            Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), localDir);
            File metadataFile = this.localMetadataFile(localDir);
            RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Read metadata for version ", ":\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.METADATA_JSON$.MODULE$, (Object)metadata.prettyJson())})))));
            this.loadImmutableFilesFromDfs(metadata.immutableFiles(), localDir);
            this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), metadata.immutableFiles());
            metadataFile.delete();
            rocksDBCheckpointMetadata = metadata;
        }
        RocksDBCheckpointMetadata metadata = rocksDBCheckpointMetadata;
        this.logFilesInDir(localDir, this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded checkpoint files "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        return metadata;
    }

    public long getLatestSnapshotVersion(long version) {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            if (this.fm().exists(this.dfsBatchZipFile(version))) {
                return version;
            }
            return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles())), (Function1 & Serializable)x$5 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$5.getPath().getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6))), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 <= version)), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public long getLatestVersion() {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            Path[] files = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path)), (Function1 & Serializable)x$8 -> x$8.getPath(), ClassTag$.MODULE$.apply(Path.class));
            long[] changelogFileVersions = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$2(this, x$9)))), (Function1 & Serializable)x$10 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$10.getName()), ".changelog"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$11))), (ClassTag)ClassTag$.MODULE$.Long());
            long[] snapshotFileVersions = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$5(this, x$12)))), (Function1 & Serializable)x$13 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$13.getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14))), (ClassTag)ClassTag$.MODULE$.Long());
            long[] versions = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps(changelogFileVersions), (Object)snapshotFileVersions, (ClassTag)ClassTag$.MODULE$.Long());
            return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps(versions), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public Seq<String> findOrphanFiles(Seq<String> trackedFiles, Seq<FileStatus> allFiles) {
        Map fileModificationTimes = ((IterableOnceOps)allFiles.map((Function1 & Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getPath().getName()), (Object)BoxesRunTime.boxToLong((long)file.getModificationTime())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (trackedFiles.nonEmpty() && allFiles.size() > trackedFiles.size()) {
            long oldestTrackedFileModificationTime = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)trackedFiles.flatMap((Function1 & Serializable)x$15 -> fileModificationTimes.get(x$15))).min((Ordering)Ordering.Long$.MODULE$));
            Seq orphanFiles = ((MapOps)fileModificationTimes.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$findOrphanFiles$3(oldestTrackedFileModificationTime, x$16)))).keys().toSeq();
            if (orphanFiles.nonEmpty()) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " orphan files: "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)orphanFiles.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_MODIFICATION_TIME$.MODULE$, (Object)((IterableOnceOps)orphanFiles.take(20)).mkString(", "))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"... (display at most 20 filenames) that should be deleted."}))).log((Seq)Nil$.MODULE$))));
            }
            return orphanFiles;
        }
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private void deleteChangelogFiles(long[] versionsToDelete) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(versionsToDelete), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            try {
                this.fm().delete(this.dfsChangelogFile(version));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted changelog file ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
            }
            catch (Exception e) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting changelog file for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_VERSION$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))), (Throwable)e);
            }
        });
    }

    public void deleteOldVersions(int numVersionsToRetain) {
        Path path = new Path(this.dfsRootDir);
        Path[] allFiles = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path)), (Function1 & Serializable)x$17 -> x$17.getPath(), ClassTag$.MODULE$.apply(Path.class));
        Path[] snapshotFiles = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$2(this, file)));
        Path[] changelogFiles = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$3(this, file)));
        long[] sortedSnapshotVersions = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])snapshotFiles), (Function1 & Serializable)x$18 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$18.getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$19))), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions))) {
            return;
        }
        long maxSnapshotVersionPresent = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)));
        long minVersionToRetain = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcZJ.sp & Serializable)x$20 -> x$20 <= maxSnapshotVersionPresent - (long)numVersionsToRetain + 1L)), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        long[] snapshotVersionsToDelete = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcZJ.sp & Serializable)x$21 -> x$21 < minVersionToRetain);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete))) {
            return;
        }
        scala.collection.mutable.HashMap fileToMaxUsedVersion = new scala.collection.mutable.HashMap();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            Seq files = (Seq)Option$.MODULE$.apply(this.versionToRocksDBFiles().get(BoxesRunTime.boxToLong((long)version))).getOrElse((Function0 & Serializable)() -> {
                Seq<RocksDBImmutableFile> newResolvedFiles = this.getImmutableFilesFromVersionZip(version);
                this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), newResolvedFiles);
                return newResolvedFiles;
            });
            files.foreach((Function1 & Serializable)f -> {
                fileToMaxUsedVersion.update((Object)f.dfsFileName(), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(version, BoxesRunTime.unboxToLong((Object)fileToMaxUsedVersion.getOrElse((Object)f.dfsFileName(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> version$5)))));
                return BoxedUnit.UNIT;
            });
        });
        scala.collection.mutable.HashMap filesToDelete = (scala.collection.mutable.HashMap)fileToMaxUsedVersion.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$13(snapshotVersionsToDelete, x0$1)));
        Path sstDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR());
        Path logDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR());
        Seq allSstFiles = this.fm().exists(sstDir) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.fm().list(sstDir)).toImmutableArraySeq() : (Seq)scala.package$.MODULE$.Seq().empty();
        Seq allLogFiles = this.fm().exists(logDir) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.fm().list(logDir)).toImmutableArraySeq() : (Seq)scala.package$.MODULE$.Seq().empty();
        filesToDelete.$plus$plus$eq((IterableOnce)this.findOrphanFiles((Seq<String>)fileToMaxUsedVersion.keys().toSeq(), (Seq<FileStatus>)((Seq)allSstFiles.$plus$plus((IterableOnce)allLogFiles))).map((Function1 & Serializable)x$22 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$22), (Object)BoxesRunTime.boxToLong((long)-1L))));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)filesToDelete.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"files not used in versions >= ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)minVersionToRetain))})))));
        IntRef failedToDelete = IntRef.create((int)0);
        filesToDelete.foreach((Function1 & Serializable)x0$2 -> {
            RocksDBFileManager.$anonfun$deleteOldVersions$16(this, failedToDelete, x0$2);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            Path versionFile = this.dfsBatchZipFile(version);
            try {
                this.fm().delete(versionFile);
                this.versionToRocksDBFiles().remove(BoxesRunTime.boxToLong((long)version));
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted version " + version);
            }
            catch (Exception e) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting version file ", " for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)versionFile)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_VERSION$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))})))), (Throwable)e);
            }
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " files "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(filesToDelete.size() - failedToDelete$1.elem)))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(failed to delete"}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " files) "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_FAILED_TO_DELETE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)failedToDelete$1.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"not used in versions >= ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MIN_VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)minVersionToRetain))})))));
        long[] changelogVersionsToDelete = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])changelogFiles), (Function1 & Serializable)x$23 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$23.getName()), ".changelog"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$24))), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$25 -> x$25 < minVersionToRetain);
        this.deleteChangelogFiles(changelogVersionsToDelete);
    }

    private Seq<RocksDBImmutableFile> saveImmutableFilesToDfs(long version, Seq<File> localFiles) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Saving RocksDB files to DFS for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        Seq immutableFiles = (Seq)localFiles.map((Function1 & Serializable)localFile -> {
            Option existingDfsFile = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.localFilesToDfsFiles()).asScala().get((Object)localFile.getName());
            if (existingDfsFile.isDefined() && ((RocksDBImmutableFile)existingDfsFile.get()).sizeBytes() == localFile.length()) {
                RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)existingDfsFile.get();
                ++filesReused$1.elem;
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reusing file ", " for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)dfsFile)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, localFile)})))));
                return RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFile.dfsFileName(), dfsFile.sizeBytes());
            }
            String localFileName = localFile.getName();
            String dfsFileName = this.newDFSFileName(localFileName);
            Path dfsFile = this.dfsFilePath(dfsFileName);
            this.fs().copyFromLocalFile(new Path(localFile.getAbsoluteFile().toURI()), dfsFile);
            long localFileSize = localFile.length();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, localFile)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", " bytes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)dfsFile), new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)localFileSize))})))));
            ++filesCopied$1.elem;
            bytesCopied$1.elem += localFileSize;
            RocksDBImmutableFile immutableDfsFile = RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFileName, localFileSize);
            this.localFilesToDfsFiles().put(localFileName, immutableDfsFile);
            return immutableDfsFile;
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " files "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_COPIED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesCopied$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes) from local to"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)bytesCopied$1.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" DFS for version ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " files reused without copying."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_REUSED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesReused$1.elem))})))));
        this.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), (Seq<RocksDBImmutableFile>)immutableFiles);
        this.removeLocallyDeletedSSTFilesFromDfsMapping(localFiles);
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.saveCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
        return immutableFiles;
    }

    private void loadImmutableFilesFromDfs(Seq<RocksDBImmutableFile> immutableFiles, File localDir) {
        Map requiredFileNameToFileDetails = ((IterableOnceOps)immutableFiles.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Seq localImmutableFiles = (Seq)this.listRocksDBFiles(localDir)._1();
        this.removeLocallyDeletedSSTFilesFromDfsMapping((Seq<File>)localImmutableFiles);
        localImmutableFiles.foreach((Function1 & Serializable)existingFile -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$2(this, requiredFileNameToFileDetails, existingFile);
            return BoxedUnit.UNIT;
        });
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        immutableFiles.foreach((Function1 & Serializable)file -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$6(this, localDir, filesCopied, bytesCopied, filesReused, file);
            return BoxedUnit.UNIT;
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " files "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_COPIED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesCopied$2.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes) from DFS to local with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)bytesCopied$2.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " files reused."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_REUSED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesReused$2.elem))})))));
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.loadCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
    }

    private void removeLocallyDeletedSSTFilesFromDfsMapping(Seq<File> localFiles) {
        Set currentLocalFiles = ((IterableOnceOps)localFiles.map((Function1 & Serializable)x$26 -> x$26.getName())).toSet();
        Iterable mappingsToClean = (Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.localFilesToDfsFiles()).asScala().keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)currentLocalFiles.contains((Object)elem)));
        mappingsToClean.foreach((Function1 & Serializable)f -> {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cleaning ", " from the localFilesToDfsFiles map"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, f)}))));
            return this.localFilesToDfsFiles().remove(f);
        });
    }

    private Seq<RocksDBImmutableFile> getImmutableFilesFromVersionZip(long version) {
        Utils$.MODULE$.deleteRecursively(this.localTempDir);
        this.localTempDir.mkdirs();
        Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), this.localTempDir);
        File metadataFile = this.localMetadataFile(this.localTempDir);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
        return metadata.immutableFiles();
    }

    private void zipToDfsFile(Seq<File> files, Path dfsZipFile) {
        LazyRef filesStr$lzy = new LazyRef();
        ObjectRef in = ObjectRef.create(null);
        CheckpointFileManager.CancellableFSDataOutputStream out = this.fm().createAtomic(dfsZipFile, true);
        LongRef totalBytes = LongRef.create((long)0L);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)((Object)out));
        try {
            try {
                files.foreach((Function1 & Serializable)file -> {
                    RocksDBFileManager.$anonfun$zipToDfsFile$1(zout, in, totalBytes, file);
                    return BoxedUnit.UNIT;
                });
                zout.close();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Zipped ", " bytes (before compression) to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)totalBytes$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files))})))));
                RocksDBFileManagerMetrics qual$1 = this.saveCheckpointMetrics();
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)totalBytes.elem));
                long x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                long x$4 = qual$1.copy$default$3();
                this.saveCheckpointMetrics_$eq(qual$1.copy(x$2, x$3, x$4, (Option<Object>)x$1));
            }
            catch (Exception e) {
                out.cancel();
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Error zipping to " + RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files), (Throwable)e);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)in.elem));
            IOUtils.closeQuietly((OutputStream)zout);
        }
    }

    private void logFilesInDir(File dir, MessageWithContext msg) {
        LazyRef files$lzy = new LazyRef();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msg.$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" - ", " files\\n\\t"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)RocksDBFileManager.files$2(files$lzy, dir).length))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)Predef$.MODULE$.wrapRefArray((Object[])RocksDBFileManager.files$2(files$lzy, dir)).mkString("\n\t"))})))));
    }

    private String newDFSFileName(String localFileName) {
        String baseName = FilenameUtils.getBaseName((String)localFileName);
        String extension = FilenameUtils.getExtension((String)localFileName);
        return baseName + "-" + UUID.randomUUID() + "." + extension;
    }

    private Path dfsBatchZipFile(long version) {
        return new Path(this.dfsRootDir + "/" + version + ".zip");
    }

    private Path dfsChangelogFile(long version) {
        return new Path(this.dfsRootDir + "/" + version + ".changelog");
    }

    private File localMetadataFile(File parentDir) {
        return new File(parentDir, "metadata");
    }

    public String logName() {
        return Logging.logName$((Logging)this) + " " + this.loggingId;
    }

    private Path dfsFilePath(String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isSstFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR()), fileName);
        }
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR()), fileName);
        }
        return new Path(this.dfsRootDir, fileName);
    }

    private File localFilePath(File localDir, String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new File(new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()), fileName);
        }
        return new File(localDir, fileName);
    }

    private Tuple2<Seq<File>, Seq<File>> listRocksDBFiles(File localDir) {
        File[] topLevelFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])localDir.listFiles()), (Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$listRocksDBFiles$1(x$27)));
        File[] archivedLogFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()).listFiles()).getOrElse((Function0 & Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)))), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isLogFile(file.getName())));
        Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isSstFile(f.getName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] topLevelSstFiles = (File[])tuple2._1();
        File[] topLevelOtherFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelSstFiles, (Object)topLevelOtherFiles);
        File[] topLevelSstFiles2 = (File[])tuple22._1();
        File[] topLevelOtherFiles2 = (File[])tuple22._2();
        return new Tuple2((Object)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])topLevelSstFiles2), (Object)archivedLogFiles, ClassTag$.MODULE$.apply(File.class))).toImmutableArraySeq(), (Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)topLevelOtherFiles2).toImmutableArraySeq());
    }

    public static final /* synthetic */ boolean $anonfun$loadCheckpointFromDfs$2(long version$2, long x$3) {
        return x$3 >= version$2;
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$2(RocksDBFileManager $this, Path x$9) {
        return $this.onlyChangelogFiles().accept(x$9);
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$5(RocksDBFileManager $this, Path x$12) {
        return $this.onlyZipFiles().accept(x$12);
    }

    public static final /* synthetic */ boolean $anonfun$findOrphanFiles$3(long oldestTrackedFileModificationTime$1, Tuple2 x$16) {
        return x$16._2$mcJ$sp() < oldestTrackedFileModificationTime$1;
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$2(RocksDBFileManager $this, Path file) {
        return $this.onlyZipFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$3(RocksDBFileManager $this, Path file) {
        return $this.onlyChangelogFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$13(long[] snapshotVersionsToDelete$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long v = tuple2._2$mcJ$sp();
            return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete$1), (Object)BoxesRunTime.boxToLong((long)v));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteOldVersions$16(RocksDBFileManager $this, IntRef failedToDelete$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String dfsFileName = (String)tuple2._1();
            long maxUsedVersion = tuple2._2$mcJ$sp();
            try {
                Path dfsFile = $this.dfsFilePath(dfsFileName);
                $this.fm().delete(dfsFile);
                if (maxUsedVersion == -1L) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted orphan file " + dfsFileName);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted file " + dfsFileName + " that was last used in version " + maxUsedVersion);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                ++failedToDelete$1.elem;
                if (maxUsedVersion == -1L) {
                    $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting orphan file ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)dfsFileName)}))), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting file ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)dfsFileName)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"last used in version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_FILE_VERSION$.MODULE$, (Object)BoxesRunTime.boxToLong((long)maxUsedVersion))})))), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$2(RocksDBFileManager $this, Map requiredFileNameToFileDetails$1, File existingFile) {
        boolean isSameFile;
        long existingFileSize = existingFile.length();
        Option requiredFile = requiredFileNameToFileDetails$1.get((Object)existingFile.getName());
        Option prevDfsFile = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.localFilesToDfsFiles()).asScala().get((Object)existingFile.getName());
        if (requiredFile.isDefined() && prevDfsFile.isDefined()) {
            String string = ((RocksDBImmutableFile)requiredFile.get()).dfsFileName();
            String string2 = ((RocksDBImmutableFile)prevDfsFile.get()).dfsFileName();
            v1 = !(string != null ? !string.equals(string2) : string2 != null) && existingFile.length() == ((RocksDBImmutableFile)requiredFile.get()).sizeBytes();
        } else {
            v1 = isSameFile = false;
        }
        if (!isSameFile) {
            existingFile.delete();
            $this.localFilesToDfsFiles().remove(existingFile.getName());
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted local file ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)existingFile)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with size ", " mapped"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)existingFileSize))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" to previous dfsFile ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, prevDfsFile.getOrElse((Function0 & Serializable)() -> "null"))})))));
            return;
        }
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reusing ", " present at "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)prevDfsFile)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXISTING_FILE$.MODULE$, (Object)existingFile)}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)requiredFile)})))));
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$6(RocksDBFileManager $this, File localDir$1, LongRef filesCopied$2, LongRef bytesCopied$2, LongRef filesReused$2, RocksDBImmutableFile file) {
        String localFileName = file.localFileName();
        File localFile = $this.localFilePath(localDir$1, localFileName);
        if (!localFile.exists()) {
            Path dfsFile = $this.dfsFilePath(file.dfsFileName());
            $this.fs().copyToLocalFile(dfsFile, new Path(localFile.getAbsoluteFile().toURI()));
            long localFileSize = localFile.length();
            long expectedSize = file.sizeBytes();
            if (localFileSize != expectedSize) {
                throw QueryExecutionErrors$.MODULE$.unexpectedFileSize(dfsFile, localFile, expectedSize, localFileSize);
            }
            ++filesCopied$2.elem;
            bytesCopied$2.elem += localFileSize;
            $this.localFilesToDfsFiles().put(localFileName, file);
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)dfsFile)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)localFile)}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)localFileSize))})))));
            return;
        }
        ++filesReused$2.elem;
    }

    private static final /* synthetic */ String filesStr$lzycompute$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        String string;
        LazyRef lazyRef = filesStr$lzy$1;
        synchronized (lazyRef) {
            string = filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : (String)filesStr$lzy$1.initialize((Object)(dfsZipFile$1 + "\n\t" + files$1.mkString("\n\t")));
        }
        return string;
    }

    private static final String filesStr$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        if (filesStr$lzy$1.initialized()) {
            return (String)filesStr$lzy$1.value();
        }
        return RocksDBFileManager.filesStr$lzycompute$1(filesStr$lzy$1, dfsZipFile$1, files$1);
    }

    public static final /* synthetic */ void $anonfun$zipToDfsFile$1(ZipOutputStream zout$1, ObjectRef in$1, LongRef totalBytes$1, File file) {
        zout$1.putNextEntry(new ZipEntry(file.getName()));
        in$1.elem = new FileInputStream(file);
        int bytes = IOUtils.copy((InputStream)((InputStream)in$1.elem), (OutputStream)zout$1);
        ((InputStream)in$1.elem).close();
        zout$1.closeEntry();
        totalBytes$1.elem += (long)bytes;
    }

    private static final /* synthetic */ String[] files$lzycompute$1(LazyRef files$lzy$1, File dir$1) {
        String[] stringArray;
        LazyRef lazyRef = files$lzy$1;
        synchronized (lazyRef) {
            stringArray = files$lzy$1.initialized() ? (String[])files$lzy$1.value() : (String[])files$lzy$1.initialize(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)Utils$.MODULE$.recursiveList(dir$1)).getOrElse((Function0 & Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))), (Function1 & Serializable)f -> f.getAbsolutePath() + " - " + f.length() + " bytes", ClassTag$.MODULE$.apply(String.class)));
        }
        return stringArray;
    }

    private static final String[] files$2(LazyRef files$lzy$1, File dir$1) {
        if (files$lzy$1.initialized()) {
            return (String[])files$lzy$1.value();
        }
        return RocksDBFileManager.files$lzycompute$1(files$lzy$1, dir$1);
    }

    public static final /* synthetic */ boolean $anonfun$listRocksDBFiles$1(File x$27) {
        return !x$27.isDirectory();
    }

    public RocksDBFileManager(String dfsRootDir, File localTempDir, Configuration hadoopConf, String codecName, String loggingId) {
        this.dfsRootDir = dfsRootDir;
        this.localTempDir = localTempDir;
        this.hadoopConf = hadoopConf;
        this.codecName = codecName;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        this.versionToRocksDBFiles = new ConcurrentHashMap();
        this.localFilesToDfsFiles = new ConcurrentHashMap();
        this.fs = new Path(dfsRootDir).getFileSystem(hadoopConf);
        this.onlyZipFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".zip");
            }
        };
        this.onlyChangelogFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".changelog");
            }
        };
        this.rootDirChecked = false;
        this.loadCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.saveCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
    }
}

