/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriter;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import scala.Function0;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)4Aa\u0003\u0007\u00017!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!q\u0003A!A!\u0002\u0013y\u0003\"B\u001b\u0001\t\u00031\u0004\"B\u001e\u0001\t\u0003b\u0004\"B\u001e\u0001\t\u0003j\u0005\"B/\u0001\t\u0003r\u0006\"B/\u0001\t\u0003\u0002\u0007\"B2\u0001\t\u0003\"\u0007\"\u00025\u0001\t\u0003J'aG*uCR,7\u000b^8sK\u000eC\u0017M\\4fY><wK]5uKJ4\u0016G\u0003\u0002\u000e\u001d\u0005)1\u000f^1uK*\u0011q\u0002E\u0001\ngR\u0014X-Y7j]\u001eT!!\u0005\n\u0002\u0013\u0015DXmY;uS>t'BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011C\u0001\u0001\u001d!\tib$D\u0001\r\u0013\tyBBA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wm\u0016:ji\u0016\u0014\u0018A\u00014n!\t\u00113%D\u0001\u000f\u0013\t!cBA\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0002\t\u0019LG.\u001a\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\n!AZ:\u000b\u0005-2\u0012A\u00025bI>|\u0007/\u0003\u0002.Q\t!\u0001+\u0019;i\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\r\u0005\u00021g5\t\u0011G\u0003\u00023)\u0005\u0011\u0011n\\\u0005\u0003iE\u0012\u0001cQ8naJ,7o]5p]\u000e{G-Z2\u0002\rqJg.\u001b;?)\u00119\u0004(\u000f\u001e\u0011\u0005u\u0001\u0001\"\u0002\u0011\u0005\u0001\u0004\t\u0003\"B\u0013\u0005\u0001\u00041\u0003\"\u0002\u0018\u0005\u0001\u0004y\u0013a\u00019viR\u0019QhQ&\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\tUs\u0017\u000e\u001e\u0005\u0006\t\u0016\u0001\r!R\u0001\u0004W\u0016L\bc\u0001 G\u0011&\u0011qi\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003}%K!AS \u0003\t\tKH/\u001a\u0005\u0006\u0019\u0016\u0001\r!R\u0001\u0006m\u0006dW/\u001a\u000b\u0005{9{\u0005\u000bC\u0003E\r\u0001\u0007Q\tC\u0003M\r\u0001\u0007Q\tC\u0003R\r\u0001\u0007!+A\u0007d_24\u0015-\\5ms:\u000bW.\u001a\t\u0003'js!\u0001\u0016-\u0011\u0005U{T\"\u0001,\u000b\u0005]S\u0012A\u0002\u001fs_>$h(\u0003\u0002Z\u007f\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tIv(\u0001\u0004eK2,G/\u001a\u000b\u0003{}CQ\u0001R\u0004A\u0002\u0015#2!P1c\u0011\u0015!\u0005\u00021\u0001F\u0011\u0015\t\u0006\u00021\u0001S\u0003\u0015iWM]4f)\u0011iTMZ4\t\u000b\u0011K\u0001\u0019A#\t\u000b1K\u0001\u0019A#\t\u000bEK\u0001\u0019\u0001*\u0002\r\r|W.\\5u)\u0005i\u0004")
public class StateStoreChangelogWriterV1
extends StateStoreChangelogWriter {
    private final Path file;

    @Override
    public void put(byte[] key, byte[] value) {
        Predef$.MODULE$.assert(this.compressedStream() != null);
        this.compressedStream().writeInt(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(key)));
        this.compressedStream().write(key);
        this.compressedStream().writeInt(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(value)));
        this.compressedStream().write(value);
        this.size_$eq(this.size() + 1);
    }

    @Override
    public void put(byte[] key, byte[] value, String colFamilyName) {
        throw StateStoreErrors$.MODULE$.unsupportedOperationException("Put", "changelog writer v1");
    }

    @Override
    public void delete(byte[] key) {
        Predef$.MODULE$.assert(this.compressedStream() != null);
        this.compressedStream().writeInt(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(key)));
        this.compressedStream().write(key);
        this.compressedStream().writeInt(-1);
        this.size_$eq(this.size() + 1);
    }

    @Override
    public void delete(byte[] key, String colFamilyName) {
        throw StateStoreErrors$.MODULE$.unsupportedOperationException("Delete", "changelog writer v1");
    }

    @Override
    public void merge(byte[] key, byte[] value, String colFamilyName) {
        throw new UnsupportedOperationException("Operation not supported with state changelog writer v1");
    }

    @Override
    public void commit() {
        try {
            try {
                this.compressedStream().writeInt(-1);
                this.compressedStream().close();
            }
            catch (Throwable e) {
                this.abort();
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Fail to commit changelog file " + $this.file + " because of exception " + e);
                throw e;
            }
        }
        finally {
            this.backingFileStream_$eq(null);
            this.compressedStream_$eq(null);
        }
    }

    public StateStoreChangelogWriterV1(CheckpointFileManager fm, Path file, CompressionCodec compressionCodec) {
        this.file = file;
        super(fm, file, compressionCodec);
    }
}

