/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCannotCreateColumnFamilyWithReservedChars;
import org.apache.spark.sql.execution.streaming.state.StateStoreCannotUseColumnFamilyWithInvalidName;
import org.apache.spark.sql.execution.streaming.state.StateStoreIncorrectNumOrderingColsForPrefixScan;
import org.apache.spark.sql.execution.streaming.state.StateStoreIncorrectNumOrderingColsForRangeScan;
import org.apache.spark.sql.execution.streaming.state.StateStoreMultipleColumnFamiliesNotSupportedException;
import org.apache.spark.sql.execution.streaming.state.StateStoreNullTypeOrderingColsNotSupported;
import org.apache.spark.sql.execution.streaming.state.StateStoreRemovingColumnFamiliesNotSupportedException;
import org.apache.spark.sql.execution.streaming.state.StateStoreUnsupportedOperationException;
import org.apache.spark.sql.execution.streaming.state.StateStoreUnsupportedOperationOnMissingColumnFamily;
import org.apache.spark.sql.execution.streaming.state.StateStoreVariableSizeOrderingColsNotSupported;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorCannotAssignTTLInTimeMode;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorCannotPerformOperationWithInvalidHandleState;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorCannotPerformOperationWithInvalidTimeMode;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorCannotReInitializeState;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorTTLMustBePositive;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class StateStoreErrors$ {
    public static final StateStoreErrors$ MODULE$ = new StateStoreErrors$();

    public SparkException implicitKeyNotFound(String stateName) {
        return SparkException$.MODULE$.internalError("Implicit key not found in state store for stateName=" + stateName, "TWS");
    }

    public SparkException missingTimeValues(String timeMode) {
        return SparkException$.MODULE$.internalError("Failed to find time values for timeMode=" + timeMode, "TWS");
    }

    public StateStoreUnsupportedOperationOnMissingColumnFamily unsupportedOperationOnMissingColumnFamily(String operationName, String colFamilyName) {
        return new StateStoreUnsupportedOperationOnMissingColumnFamily(operationName, colFamilyName);
    }

    public StateStoreMultipleColumnFamiliesNotSupportedException multipleColumnFamiliesNotSupported(String stateStoreProvider) {
        return new StateStoreMultipleColumnFamiliesNotSupportedException(stateStoreProvider);
    }

    public StateStoreRemovingColumnFamiliesNotSupportedException removingColumnFamiliesNotSupported(String stateStoreProvider) {
        return new StateStoreRemovingColumnFamiliesNotSupportedException(stateStoreProvider);
    }

    public StateStoreCannotUseColumnFamilyWithInvalidName cannotUseColumnFamilyWithInvalidName(String operationName, String colFamilyName) {
        return new StateStoreCannotUseColumnFamilyWithInvalidName(operationName, colFamilyName);
    }

    public StateStoreUnsupportedOperationException unsupportedOperationException(String operationName, String entity) {
        return new StateStoreUnsupportedOperationException(operationName, entity);
    }

    public void requireNonNullStateValue(Object value, String stateName) {
        SparkException$.MODULE$.require(value != null, "ILLEGAL_STATE_STORE_VALUE.NULL_VALUE", (Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateName"), (Object)stateName)})));
    }

    public <S> void requireNonEmptyListStateValue(Object value, String stateName) {
        SparkException$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.genericArrayOps(value)), "ILLEGAL_STATE_STORE_VALUE.EMPTY_LIST_VALUE", (Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateName"), (Object)stateName)})));
    }

    public StateStoreIncorrectNumOrderingColsForPrefixScan incorrectNumOrderingColsForPrefixScan(String numPrefixCols) {
        return new StateStoreIncorrectNumOrderingColsForPrefixScan(numPrefixCols);
    }

    public StateStoreIncorrectNumOrderingColsForRangeScan incorrectNumOrderingColsForRangeScan(String numOrderingCols) {
        return new StateStoreIncorrectNumOrderingColsForRangeScan(numOrderingCols);
    }

    public StateStoreNullTypeOrderingColsNotSupported nullTypeOrderingColsNotSupported(String fieldName, String index) {
        return new StateStoreNullTypeOrderingColsNotSupported(fieldName, index);
    }

    public StateStoreVariableSizeOrderingColsNotSupported variableSizeOrderingColsNotSupported(String fieldName, String index) {
        return new StateStoreVariableSizeOrderingColsNotSupported(fieldName, index);
    }

    public StateStoreCannotCreateColumnFamilyWithReservedChars cannotCreateColumnFamilyWithReservedChars(String colFamilyName) {
        return new StateStoreCannotCreateColumnFamilyWithReservedChars(colFamilyName);
    }

    public StatefulProcessorCannotPerformOperationWithInvalidTimeMode cannotPerformOperationWithInvalidTimeMode(String operationType, String timeMode) {
        return new StatefulProcessorCannotPerformOperationWithInvalidTimeMode(operationType, timeMode);
    }

    public StatefulProcessorCannotPerformOperationWithInvalidHandleState cannotPerformOperationWithInvalidHandleState(String operationType, String handleState) {
        return new StatefulProcessorCannotPerformOperationWithInvalidHandleState(operationType, handleState);
    }

    public StatefulProcessorCannotReInitializeState cannotReInitializeStateOnKey(String groupingKey) {
        return new StatefulProcessorCannotReInitializeState(groupingKey);
    }

    public StatefulProcessorCannotAssignTTLInTimeMode cannotProvideTTLConfigForTimeMode(String stateName, String timeMode) {
        return new StatefulProcessorCannotAssignTTLInTimeMode(stateName, timeMode);
    }

    public StatefulProcessorTTLMustBePositive ttlMustBePositive(String operationType, String stateName) {
        return new StatefulProcessorTTLMustBePositive(operationType, stateName);
    }

    private StateStoreErrors$() {
    }
}

