/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.jdbc.DatabricksDialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\u000f\u001f\t&BQ\u0001\u0011\u0001\u0005\u0002\u0005CQa\u0011\u0001\u0005B\u0011CQA\u0015\u0001\u0005BMCQa\u001b\u0001\u0005B1DQa\u001d\u0001\u0005BQDQa\u001e\u0001\u0005BaDQ!\u001f\u0001\u0005BaDQA\u001f\u0001\u0005BaDQa\u001f\u0001\u0005BqDq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002<\u0001!\t%!\u0010\t\u0011\u0005-\u0003!!A\u0005\u0002\u0005C\u0011\"!\u0014\u0001\u0003\u0003%\t%a\u0014\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0003\"CA0\u0001\u0005\u0005I\u0011AA1\u0011%\ti\u0007AA\u0001\n\u0003\ny\u0007C\u0005\u0002~\u0001\t\t\u0011\"\u0001\u0002\u0000!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"!$\u0001\u0003\u0003%\t%a$\t\u0013\u0005E\u0005!!A\u0005B\u0005Mu!CAL=\u0005\u0005\t\u0012BAM\r!ib$!A\t\n\u0005m\u0005B\u0002!\u0018\t\u0003\t\u0019\fC\u0005\u0002\u000e^\t\t\u0011\"\u0012\u0002\u0010\"A\u0011QW\f\u0002\u0002\u0013\u0005\u0015\tC\u0005\u00028^\t\t\u0011\"!\u0002:\"I\u0011qX\f\u0002\u0002\u0013%\u0011\u0011\u0019\u0002\u0012\t\u0006$\u0018M\u0019:jG.\u001cH)[1mK\u000e$(BA\u0010!\u0003\u0011QGMY2\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Qc\u0006\u000e\t\u0003W1j\u0011AH\u0005\u0003[y\u00111B\u00133cG\u0012K\u0017\r\\3diB\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t9\u0001K]8ek\u000e$\bCA\u001b>\u001d\t14H\u0004\u00028u5\t\u0001H\u0003\u0002:Q\u00051AH]8pizJ\u0011!M\u0005\u0003yA\nq\u0001]1dW\u0006<W-\u0003\u0002?\u007f\ta1+\u001a:jC2L'0\u00192mK*\u0011A\bM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0003\"a\u000b\u0001\u0002\u0013\r\fg\u000eS1oI2,GCA#I!\tyc)\u0003\u0002Ha\t9!i\\8mK\u0006t\u0007\"B%\u0003\u0001\u0004Q\u0015aA;sYB\u00111j\u0014\b\u0003\u00196\u0003\"a\u000e\u0019\n\u00059\u0003\u0014A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!A\u0014\u0019\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$R\u0001V/cI\u001a\u00042aL+X\u0013\t1\u0006G\u0001\u0004PaRLwN\u001c\t\u00031nk\u0011!\u0017\u0006\u00035\u0002\nQ\u0001^=qKNL!\u0001X-\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQAX\u0002A\u0002}\u000bqa]9m)f\u0004X\r\u0005\u00020A&\u0011\u0011\r\r\u0002\u0004\u0013:$\b\"B2\u0004\u0001\u0004Q\u0015\u0001\u0003;za\u0016t\u0015-\\3\t\u000b\u0015\u001c\u0001\u0019A0\u0002\tML'0\u001a\u0005\u0006O\u000e\u0001\r\u0001[\u0001\u0003[\u0012\u0004\"\u0001W5\n\u0005)L&aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u0017\u001d,GO\u0013#C\u0007RK\b/\u001a\u000b\u0003[F\u00042aL+o!\tYs.\u0003\u0002q=\tA!\n\u001a2d)f\u0004X\rC\u0003s\t\u0001\u0007q+\u0001\u0002ei\u0006y\u0011/^8uK&#WM\u001c;jM&,'\u000f\u0006\u0002Kk\")a/\u0002a\u0001\u0015\u000691m\u001c7OC6,\u0017!D:vaB|'\u000f^:MS6LG/F\u0001F\u00039\u0019X\u000f\u001d9peR\u001cxJ\u001a4tKR\f1c];qa>\u0014Ho\u001d+bE2,7+Y7qY\u0016\fabZ3u)\u0006\u0014G.Z*b[BdW\r\u0006\u0002K{\")a0\u0003a\u0001\u007f\u000611/Y7qY\u0016\u0004B!!\u0001\u0002\u00105\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0002we)!\u0011\u0011BA\u0006\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0007\u00055\u0001%A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011\u0011CA\u0002\u0005=!\u0016M\u00197f'\u0006l\u0007\u000f\\3J]\u001a|\u0017!D:dQ\u0016l\u0017m]#ySN$8\u000fF\u0004F\u0003/\tI#a\u000e\t\u000f\u0005e!\u00021\u0001\u0002\u001c\u0005!1m\u001c8o!\u0011\ti\"!\n\u000e\u0005\u0005}!bA\u0011\u0002\")\u0011\u00111E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0005}!AC\"p]:,7\r^5p]\"9\u00111\u0006\u0006A\u0002\u00055\u0012aB8qi&|gn\u001d\t\u0005\u0003_\t\u0019$\u0004\u0002\u00022)\u0019q$a\u0002\n\t\u0005U\u0012\u0011\u0007\u0002\f\u0015\u0012\u00135i\u00149uS>t7\u000f\u0003\u0004\u0002:)\u0001\rAS\u0001\u0007g\u000eDW-\\1\u0002\u00171L7\u000f^*dQ\u0016l\u0017m\u001d\u000b\u0007\u0003\u007f\t9%!\u0013\u0011\u000b=\n\t%!\u0012\n\u0007\u0005\r\u0003GA\u0003BeJ\f\u0017\u0010\u0005\u00030\u0003\u0003R\u0005bBA\r\u0017\u0001\u0007\u00111\u0004\u0005\b\u0003WY\u0001\u0019AA\u0017\u0003\u0011\u0019w\u000e]=\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&!\t\u0002\t1\fgnZ\u0005\u0004!\u0006U\u0013\u0001\u00049s_\u0012,8\r^!sSRLX#A0\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111MA5!\ry\u0013QM\u0005\u0004\u0003O\u0002$aA!os\"A\u00111N\b\u0002\u0002\u0003\u0007q,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0002b!a\u001d\u0002z\u0005\rTBAA;\u0015\r\t9\bM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA>\u0003k\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q)!!\t\u0013\u0005-\u0014#!AA\u0002\u0005\r\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0015\u0002\b\"A\u00111\u000e\n\u0002\u0002\u0003\u0007q,\u0001\u0005iCND7i\u001c3f)\u0005y\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0013AB3rk\u0006d7\u000fF\u0002F\u0003+C\u0011\"a\u001b\u0016\u0003\u0003\u0005\r!a\u0019\u0002#\u0011\u000bG/\u00192sS\u000e\\7\u000fR5bY\u0016\u001cG\u000f\u0005\u0002,/M)q#!(\u0002*B)\u0011qTAS\u00056\u0011\u0011\u0011\u0015\u0006\u0004\u0003G\u0003\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003O\u000b\tKA\tBEN$(/Y2u\rVt7\r^5p]B\u0002B!a+\u000226\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t#\u0001\u0002j_&\u0019a(!,\u0015\u0005\u0005e\u0015!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u0004\u000b\u0006m\u0006\u0002CA_7\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002DB!\u00111KAc\u0013\u0011\t9-!\u0016\u0003\r=\u0013'.Z2u\u0001")
public class DatabricksDialect
extends JdbcDialect
implements Product {
    public static boolean unapply(DatabricksDialect x$0) {
        return DatabricksDialect$.MODULE$.unapply(x$0);
    }

    public static DatabricksDialect apply() {
        return DatabricksDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:databricks");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case -6: {
                return new Some((Object)ByteType$.MODULE$);
            }
            case 5: {
                return new Some((Object)ShortType$.MODULE$);
            }
            case 7: {
                return new Some((Object)FloatType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DOUBLE", 8));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("STRING", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BINARY", -2));
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return "`" + colName + "`";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public DatabricksDialect copy() {
        return new DatabricksDialect();
    }

    public String productPrefix() {
        return "DatabricksDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatabricksDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof DatabricksDialect && ((DatabricksDialect)x$1).canEqual(this);
    }

    public DatabricksDialect() {
        Product.$init$((Product)this);
    }
}

