/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.H2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\t}h!B\u00193\u0001Rb\u0004\"\u0002+\u0001\t\u0003)\u0006\"B,\u0001\t\u0003B\u0006b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007o\u0002\u0001\u000b\u0011\u00025\t\u000fa\u0004!\u0019!C\u0005O\"1\u0011\u0010\u0001Q\u0001\n!DqA\u001f\u0001C\u0002\u0013%q\r\u0003\u0004|\u0001\u0001\u0006I\u0001\u001b\u0005\u0006y\u0002!\t% \u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t\u0019\u0004\u0001C!\u0003kA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003\u000fBq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002Z\u0001!\t%!\u001e\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011Q\u0012\u0001\u0005B\u0005=\u0005bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\t9\u0010\u0001C!\u0003sDqAa\u0004\u0001\t\u0013\u0011\t\u0002C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\t}\u0001\u0001\"\u0011\u0003\"!9!Q\t\u0001\u0005B\t\u001dcA\u0002B+\u0001\u0001\u00119\u0006\u0003\u0004U3\u0011\u0005!\u0011\r\u0005\b\u0005KJB\u0011\tB4\u0011\u001d\u0011)(\u0007C!\u0005oBqA!!\u001a\t\u0003\u0012\u0019\tC\u0004\u0003\n\u0002!\tEa#\t\u000f\t5\u0005\u0001\"\u0011\u0003\f\"A!q\u0012\u0001\u0002\u0002\u0013\u0005Q\u000bC\u0005\u0003\u0012\u0002\t\t\u0011\"\u0011\u0003\u0014\"I!Q\u0013\u0001\u0002\u0002\u0013\u0005!q\u0013\u0005\n\u00053\u0003\u0011\u0011!C\u0001\u00057C\u0011Ba*\u0001\u0003\u0003%\tE!+\t\u0013\tM\u0006!!A\u0005\u0002\tU\u0006\"\u0003B]\u0001\u0005\u0005I\u0011\tB^\u0011%\u0011y\fAA\u0001\n\u0003\u0012\t\rC\u0005\u0003D\u0002\t\t\u0011\"\u0011\u0003F\"I!q\u0019\u0001\u0002\u0002\u0013\u0005#\u0011Z\u0004\u000b\u0005\u001b\u0014\u0014\u0011!E\u0001i\t=g!C\u00193\u0003\u0003E\t\u0001\u000eBi\u0011\u0019!6\u0006\"\u0001\u0003j\"I!1Y\u0016\u0002\u0002\u0013\u0015#Q\u0019\u0005\t\u0005W\\\u0013\u0011!CA+\"I!Q^\u0016\u0002\u0002\u0013\u0005%q\u001e\u0005\n\u0005k\\\u0013\u0011!C\u0005\u0005o\u0014\u0011\u0002\u0013\u001aES\u0006dWm\u0019;\u000b\u0005M\"\u0014\u0001\u00026eE\u000eT!!\u000e\u001c\u0002\u0007M\fHN\u0003\u00028q\u0005)1\u000f]1sW*\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h'\u0011\u0001Q(Q$\u0011\u0005yzT\"\u0001\u001a\n\u0005\u0001\u0013$a\u0003&eE\u000e$\u0015.\u00197fGR\u0004\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002I#:\u0011\u0011j\u0014\b\u0003\u0015:k\u0011a\u0013\u0006\u0003\u00196\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0002\t&\u0011\u0001kQ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Q\u0007\u00061A(\u001b8jiz\"\u0012A\u0016\t\u0003}\u0001\t\u0011bY1o\u0011\u0006tG\r\\3\u0015\u0005ec\u0006C\u0001\"[\u0013\tY6IA\u0004C_>dW-\u00198\t\u000bu\u0013\u0001\u0019\u00010\u0002\u0007U\u0014H\u000e\u0005\u0002`G:\u0011\u0001-\u0019\t\u0003\u0015\u000eK!AY\"\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003E\u000e\u000bQ\u0005Z5ti&t7\r^+ogV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u0016\u0003!\u00042!\u001b8q\u001b\u0005Q'BA6m\u0003%IW.\\;uC\ndWM\u0003\u0002n\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=T'aA*fiB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005Y\u0006twMC\u0001v\u0003\u0011Q\u0017M^1\n\u0005\u0011\u0014\u0018A\n3jgRLgn\u0019;V]N,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005Y2/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N\fAd];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\b%\u0001\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\u0018aE:vaB|'\u000f^3e\rVt7\r^5p]N\u0004\u0013aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGCA-\u007f\u0011\u0015y\u0018\u00021\u0001_\u0003!1WO\\2OC6,\u0017aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0015\u0005\u0015\u0011qCA\u0011\u0003K\tI\u0003E\u0003C\u0003\u000f\tY!C\u0002\u0002\n\r\u0013aa\u00149uS>t\u0007\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EA'A\u0003usB,7/\u0003\u0003\u0002\u0016\u0005=!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005e!\u00021\u0001\u0002\u001c\u000591/\u001d7UsB,\u0007c\u0001\"\u0002\u001e%\u0019\u0011qD\"\u0003\u0007%sG\u000f\u0003\u0004\u0002$)\u0001\rAX\u0001\tif\u0004XMT1nK\"9\u0011q\u0005\u0006A\u0002\u0005m\u0011\u0001B:ju\u0016Dq!a\u000b\u000b\u0001\u0004\ti#\u0001\u0002nIB!\u0011QBA\u0018\u0013\u0011\t\t$a\u0004\u0003\u001f5+G/\u00193bi\u0006\u0014U/\u001b7eKJ\f1bZ3u\u0015\u0012\u00135\tV=qKR!\u0011qGA !\u0015\u0011\u0015qAA\u001d!\rq\u00141H\u0005\u0004\u0003{\u0011$\u0001\u0003&eE\u000e$\u0016\u0010]3\t\u000f\u0005\u00053\u00021\u0001\u0002\f\u0005\u0011A\r^\u0001\fMVt7\r^5p]6\u000b\u0007/\u0006\u0002\u0002HA9\u0011\u0011JA(=\u0006MSBAA&\u0015\r\ti\u0005^\u0001\u0005kRLG.\u0003\u0003\u0002R\u0005-#aA'baB!\u0011QKA2\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!\u00034v]\u000e$\u0018n\u001c8t\u0015\u0011\ti&a\u0018\u0002\u000f\r\fG/\u00197pO*\u0019\u0011\u0011\r\u001b\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BA3\u0003/\u0012q\"\u00168c_VtGMR;oGRLwN\\\u0001\rMVt7\r^5p]6\u000b\u0007\u000fI\u0001\u0011e\u0016<\u0017n\u001d;fe\u001a+hn\u0019;j_:$b!a\u0015\u0002n\u0005E\u0004BBA8\u001d\u0001\u0007a,\u0001\u0003oC6,\u0007bBA:\u001d\u0001\u0007\u00111K\u0001\u0003M:,\"!a\u001e\u0011\u000b!\u000bI(! \n\u0007\u0005m4KA\u0002TKF\u0004bAQA@=\u0006M\u0013bAAA\u0007\n1A+\u001e9mKJ\nab\u00197fCJ4UO\\2uS>t7\u000f\u0006\u0002\u0002\bB\u0019!)!#\n\u0007\u0005-5I\u0001\u0003V]&$\u0018aC2sK\u0006$X-\u00138eKb$2BXAI\u0003+\u000b\t+a.\u0002@\"1\u00111S\tA\u0002y\u000b\u0011\"\u001b8eKbt\u0015-\\3\t\u000f\u0005]\u0015\u00031\u0001\u0002\u001a\u0006QA/\u00192mK&#WM\u001c;\u0011\t\u0005m\u0015QT\u0007\u0003\u00037JA!a(\u0002\\\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000f\u0005\r\u0016\u00031\u0001\u0002&\u000691m\u001c7v[:\u001c\b#\u0002\"\u0002(\u0006-\u0016bAAU\u0007\n)\u0011I\u001d:bsB!\u0011QVAZ\u001b\t\tyK\u0003\u0003\u00022\u0006}\u0013aC3yaJ,7o]5p]NLA!!.\u00020\nqa*Y7fIJ+g-\u001a:f]\u000e,\u0007bBA]#\u0001\u0007\u00111X\u0001\u0012G>dW/\u001c8t!J|\u0007/\u001a:uS\u0016\u001c\b\u0003CA%\u0003\u001f\nY+!0\u0011\r\u0005%\u0013q\n0_\u0011\u001d\t\t-\u0005a\u0001\u0003{\u000b!\u0002\u001d:pa\u0016\u0014H/[3t\u0003%!'o\u001c9J]\u0012,\u0007\u0010F\u0003_\u0003\u000f\fI\r\u0003\u0004\u0002\u0014J\u0001\rA\u0018\u0005\b\u0003/\u0013\u0002\u0019AAM\u0003-Ig\u000eZ3y\u000bbL7\u000f^:\u0015\u0013e\u000by-!8\u0002`\u0006\u0005\bbBAi'\u0001\u0007\u00111[\u0001\u0005G>tg\u000e\u0005\u0003\u0002V\u0006eWBAAl\u0015\t)D/\u0003\u0003\u0002\\\u0006]'AC\"p]:,7\r^5p]\"1\u00111S\nA\u0002yCq!a&\u0014\u0001\u0004\tI\nC\u0004\u0002dN\u0001\r!!:\u0002\u000f=\u0004H/[8ogB!\u0011q]Az\u001b\t\tIOC\u00024\u0003WTA!!<\u0002p\u0006YA-\u0019;bg>,(oY3t\u0015\r\t\t\u0010N\u0001\nKb,7-\u001e;j_:LA!!>\u0002j\nY!\n\u0012\"D\u001fB$\u0018n\u001c8t\u0003-a\u0017n\u001d;J]\u0012,\u00070Z:\u0015\u0011\u0005m(\u0011\u0002B\u0006\u0005\u001b\u0001RAQAT\u0003{\u0004B!a@\u0003\u00065\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\tY&A\u0003j]\u0012,\u00070\u0003\u0003\u0003\b\t\u0005!A\u0003+bE2,\u0017J\u001c3fq\"9\u0011\u0011\u001b\u000bA\u0002\u0005M\u0007bBAL)\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003G$\u0002\u0019AAs\u0003M!\u0018M\u00197f\u001d\u0006lWmV5uQN\u001b\u0007.Z7b)\rq&1\u0003\u0005\b\u0005+)\u0002\u0019AAM\u0003\u0015IG-\u001a8u\u0003MIg\u000eZ3y\u001d\u0006lWmV5uQN\u001b\u0007.Z7b)\u0015q&1\u0004B\u000f\u0011\u001d\u0011)B\u0006a\u0001\u00033Ca!a%\u0017\u0001\u0004q\u0016!E2mCN\u001c\u0018NZ=Fq\u000e,\u0007\u000f^5p]RQ!1\u0005B\u0016\u0005k\u0011ID!\u0011\u0011\t\t\u0015\"qE\u0007\u0002i%\u0019!\u0011\u0006\u001b\u0003#\u0005s\u0017\r\\=tSN,\u0005pY3qi&|g\u000eC\u0004\u0003.]\u0001\rAa\f\u0002\u0003\u0015\u00042\u0001\u0013B\u0019\u0013\r\u0011\u0019d\u0015\u0002\n)\"\u0014xn^1cY\u0016DaAa\u000e\u0018\u0001\u0004q\u0016AC3se>\u00148\t\\1tg\"9!1H\fA\u0002\tu\u0012!E7fgN\fw-\u001a)be\u0006lW\r^3sgB)qLa\u0010_=&\u0019\u0011\u0011K3\t\r\t\rs\u00031\u0001_\u0003-!Wm]2sSB$\u0018n\u001c8\u0002#\r|W\u000e]5mK\u0016C\bO]3tg&|g\u000e\u0006\u0003\u0003J\t-\u0003\u0003\u0002\"\u0002\byCqA!\u0014\u0019\u0001\u0004\u0011y%\u0001\u0003fqB\u0014\b\u0003BAW\u0005#JAAa\u0015\u00020\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0003\u0019!\u00134+\u0015'Ck&dG-\u001a:\u0014\u0007e\u0011I\u0006\u0005\u0003\u0003\\\tuS\"\u0001\u0001\n\u0007\t}sH\u0001\bK\t\n\u001b5+\u0015'Ck&dG-\u001a:\u0015\u0005\t\r\u0004c\u0001B.3\u00051b/[:ji\u0006;wM]3hCR,g)\u001e8di&|g\u000eF\u0004_\u0005S\u0012YGa\u001c\t\u000b}\\\u0002\u0019\u00010\t\r\t54\u00041\u0001Z\u0003)I7\u000fR5ti&t7\r\u001e\u0005\b\u0005cZ\u0002\u0019\u0001B:\u0003\u0019Ig\u000e];ugB!!)a*_\u000311\u0018n]5u\u000bb$(/Y2u)\u0015q&\u0011\u0010B?\u0011\u0019\u0011Y\b\ba\u0001=\u0006)a-[3mI\"1!q\u0010\u000fA\u0002y\u000baa]8ve\u000e,\u0017\u0001\u0005<jg&$8+\u0015'Gk:\u001cG/[8o)\u0015q&Q\u0011BD\u0011\u0015yX\u00041\u0001_\u0011\u001d\u0011\t(\ba\u0001\u0005g\nQb];qa>\u0014Ho\u001d'j[&$X#A-\u0002\u001dM,\b\u000f]8siN|eMZ:fi\u0006!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u0001/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001c\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BO\u0005G\u00032A\u0011BP\u0013\r\u0011\tk\u0011\u0002\u0004\u0003:L\b\"\u0003BSG\u0005\u0005\t\u0019AA\u000e\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0016\t\u0007\u0005[\u0013yK!(\u000e\u00031L1A!-m\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007e\u00139\fC\u0005\u0003&\u0016\n\t\u00111\u0001\u0003\u001e\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\r\u0001(Q\u0018\u0005\n\u0005K3\u0013\u0011!a\u0001\u00037\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00037\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002a\u00061Q-];bYN$2!\u0017Bf\u0011%\u0011)+KA\u0001\u0002\u0004\u0011i*A\u0005Ie\u0011K\u0017\r\\3diB\u0011ahK\n\u0006W\tM'q\u001c\t\u0006\u0005+\u0014YNV\u0007\u0003\u0005/T1A!7D\u0003\u001d\u0011XO\u001c;j[\u0016LAA!8\u0003X\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u0019\u0011\t\t\u0005(q]\u0007\u0003\u0005GT1A!:u\u0003\tIw.C\u0002S\u0005G$\"Aa4\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR\u0019\u0011L!=\t\u0011\tMx&!AA\u0002Y\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011I\u0010E\u0002r\u0005wL1A!@s\u0005\u0019y%M[3di\u0002")
public class H2Dialect
extends JdbcDialect
implements Product {
    private final Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Map<String, UnboundFunction> functionMap;

    public static boolean unapply(H2Dialect x$0) {
        return H2Dialect$.MODULE$.unapply(x$0);
    }

    public static H2Dialect apply() {
        return H2Dialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    public Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                if (size <= 38) break;
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int selectedScale = (int)((double)DecimalType$.MODULE$.MAX_PRECISION() * ((double)scale / (double)size));
                return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), selectedScale));
            }
            case 2013: 
            case 2014: {
                return new Some((Object)TimestampType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    private Map<String, UnboundFunction> functionMap() {
        return this.functionMap;
    }

    public UnboundFunction registerFunction(String name, UnboundFunction fn) {
        return this.functionMap().put(name, fn);
    }

    @Override
    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.functionMap()).asScala().toSeq();
    }

    public void clearFunctions() {
        this.functionMap().clear();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "h2");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String indexType2 = indexType;
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.tableNameWithSchema(tableIdent) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ")";
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.indexNameWithSchema(tableIdent, indexName);
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "' AND TABLE_NAME = '" + tableIdent.name() + "' AND INDEX_NAME = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         | SELECT\n         |   i.INDEX_CATALOG AS INDEX_CATALOG,\n         |   i.INDEX_SCHEMA AS INDEX_SCHEMA,\n         |   i.INDEX_NAME AS INDEX_NAME,\n         |   i.INDEX_TYPE_NAME AS INDEX_TYPE_NAME,\n         |   i.REMARKS as REMARKS,\n         |   ic.COLUMN_NAME AS COLUMN_NAME\n         | FROM INFORMATION_SCHEMA.INDEXES i, INFORMATION_SCHEMA.INDEX_COLUMNS ic\n         | WHERE i.TABLE_CATALOG = ic.TABLE_CATALOG\n         | AND i.TABLE_SCHEMA = ic.TABLE_SCHEMA\n         | AND i.TABLE_NAME = ic.TABLE_NAME\n         | AND i.INDEX_CATALOG = ic.INDEX_CATALOG\n         | AND i.INDEX_SCHEMA = ic.INDEX_SCHEMA\n         | AND i.INDEX_NAME = ic.INDEX_NAME\n         | AND i.TABLE_NAME = '" + tableIdent.name() + "'\n         | AND i.INDEX_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "'\n         |"));
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                H2Dialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    private String tableNameWithSchema(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    private String indexNameWithSchema(Identifier ident, String indexName) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)indexName, ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, scala.collection.immutable.Map<String, String> messageParameters, String description) {
        block7: {
            Throwable throwable = e;
            if (!(throwable instanceof SQLException)) break block7;
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 42101: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new TableAlreadyExistsException("TABLE_OR_VIEW_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})), (Option)new Some((Object)e));
                }
                case 42102: {
                    String relationName = (String)messageParameters.getOrElse((Object)"tableName", (Function0 & Serializable)() -> "");
                    throw new NoSuchTableException("TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)relationName)})), (Option)new Some((Object)e));
                }
                case 90079: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new NoSuchNamespaceException("SCHEMA_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)quotedName)})));
                }
                case 42111: {
                    String string = errorClass;
                    String string2 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 42112: {
                    String string = errorClass;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
        }
        return super.classifyException(e, errorClass, messageParameters, description);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        H2SQLBuilder h2SQLBuilder = new H2SQLBuilder(this);
        try {
            some = new Some((Object)h2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public H2Dialect copy() {
        return new H2Dialect();
    }

    public String productPrefix() {
        return "H2Dialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof H2Dialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof H2Dialect && ((H2Dialect)x$1).canEqual(this);
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String colName = rs.getString("COLUMN_NAME");
            String indexType = rs.getString("INDEX_TYPE_NAME");
            String indexComment = rs.getString("REMARKS");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).apply((Object)indexName);
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringUtils.isNotEmpty((CharSequence)indexComment) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public H2Dialect() {
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY", "MODE", "PERCENTILE_CONT", "PERCENTILE_DISC"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "GREATEST", "LEAST", "RAND", "LOG", "LOG10", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL", "ROUND", "SIN", "SINH", "COS", "COSH", "TAN", "TANH", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "DEGREES", "RADIANS", "SIGN", "PI", "SUBSTRING", "UPPER", "LOWER", "TRANSLATE", "TRIM", "MD5", "SHA1", "SHA2", "BIT_LENGTH", "CHAR_LENGTH", "CONCAT"})));
        this.functionMap = new ConcurrentHashMap<String, UnboundFunction>();
    }

    public class H2SQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer().org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public String visitExtract(String field, String source) {
            String string;
            block5: {
                String string2 = field;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1351979174: {
                        if (!"YEAR_OF_WEEK".equals(string2)) break;
                        string = "ISO_WEEK_YEAR";
                        break block5;
                    }
                    case 2660340: {
                        if (!"WEEK".equals(string2)) break;
                        string = "ISO_WEEK";
                        break block5;
                    }
                    case 2074232729: {
                        if (!"DAY_OF_WEEK".equals(string2)) break;
                        string = "ISO_DAY_OF_WEEK";
                        break block5;
                    }
                }
                string = field;
            }
            String newField = string;
            return "EXTRACT(" + newField + " FROM " + source + ")";
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer().isSupportedFunction(funcName)) {
                String string = funcName;
                switch (string == null ? 0 : string.hashCode()) {
                    case 76158: {
                        if (!"MD5".equals(string)) break;
                        return "RAWTOHEX(HASH('MD5', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                    }
                    case 2543909: {
                        if (!"SHA1".equals(string)) break;
                        return "RAWTOHEX(HASH('SHA-1', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                    }
                    case 2543910: {
                        if (!"SHA2".equals(string)) break;
                        return "RAWTOHEX(HASH('SHA-" + inputs[1] + "'," + inputs[0] + "))";
                    }
                }
                return super.visitSQLFunction(funcName, inputs);
            }
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3177", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
        }

        public /* synthetic */ H2Dialect org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer() {
            return (H2Dialect)this.$outer;
        }

        public H2SQLBuilder(H2Dialect $outer) {
            super($outer);
        }
    }
}

