/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rEe\u0001B\u001f?\t&CQA\u001a\u0001\u0005\u0002\u001dDQ!\u001b\u0001\u0005B)Dq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002\u0014\u0001\u0001\u000b\u0011\u0002>\t\u0011\u0005U\u0001A1A\u0005\neDq!a\u0006\u0001A\u0003%!\u0010\u0003\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003z\u0011\u001d\tY\u0002\u0001Q\u0001\niDq!!\b\u0001\t\u0003\nyB\u0002\u0004\u0002&\u0001\u0001\u0011q\u0005\u0005\u0007M*!\t!!\r\t\u000f\u0005U\"\u0002\"\u0011\u00028!9\u00111\f\u0006\u0005B\u0005u\u0003bBA4\u0015\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003_RA\u0011IA9\u0011\u001d\t9H\u0003C!\u0003sBq!a#\u0001\t\u0003\ni\tC\u0004\u0002 \u0002!\t%!)\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0007b\u0002B\u0001\u0001\u0011\u0005#1\u0001\u0005\b\u0005\u0017\u0001A\u0011\tB\u0007\u0011\u001d\u0011\t\u0002\u0001C!\u0005'AqA!\t\u0001\t\u0003\u0012\u0019\u0003C\u0004\u00032\u0001!\tEa\r\t\u000f\tu\u0002\u0001\"\u0011\u0003@!9!\u0011\n\u0001\u0005B\t-\u0003b\u0002B-\u0001\u0011\u0005#1\f\u0005\b\u0005C\u0002A\u0011\tB2\u0011\u001d\u00119\u0007\u0001C!\u0005SBqA!)\u0001\t\u0003\u0012\u0019\u000bC\u0004\u0003.\u0002!\tEa,\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!Q\u001a\u0001\u0005B\t=\u0007b\u0002Bz\u0001\u0011\u0005#Q\u001f\u0004\u0007\u0005{\u0004\u0001Aa@\t\u0013\r\u001dAE!A!\u0002\u0013Q\u0005BCAuI\t\u0005\t\u0015!\u0003\u0002l\"1a\r\nC\u0001\u0007\u0013Aqa!\u0005%\t\u0003\u001a\u0019\u0002C\u0004\u0004\u0016\u0001!\tea\u0006\t\u000f\rm\u0001\u0001\"\u0011\u0004\u001e!91q\u0004\u0001\u0005B\ru\u0001\u0002CB\u0011\u0001\u0005\u0005I\u0011A4\t\u0013\r\r\u0002!!A\u0005B\r\u0015\u0002\"CB\u0014\u0001\u0005\u0005I\u0011AB\u0015\u0011%\u0019Y\u0003AA\u0001\n\u0003\u0019i\u0003C\u0005\u0004:\u0001\t\t\u0011\"\u0011\u0004<!I1Q\t\u0001\u0002\u0002\u0013\u00051q\t\u0005\n\u0007\u0017\u0002\u0011\u0011!C!\u0007\u001bB\u0011b!\u0015\u0001\u0003\u0003%\tea\u0015\t\u0013\rU\u0003!!A\u0005B\r]\u0003\"CB-\u0001\u0005\u0005I\u0011IB.\u000f%\u0019yFPA\u0001\u0012\u0013\u0019\tG\u0002\u0005>}\u0005\u0005\t\u0012BB2\u0011\u00191w\u0007\"\u0001\u0004|!I1QK\u001c\u0002\u0002\u0013\u00153q\u000b\u0005\t\u0007{:\u0014\u0011!CAO\"I1qP\u001c\u0002\u0002\u0013\u00055\u0011\u0011\u0005\n\u0007\u000f;\u0014\u0011!C\u0005\u0007\u0013\u0013A\"T=T#2#\u0015.\u00197fGRT!a\u0010!\u0002\t)$'m\u0019\u0006\u0003\u0003\n\u000b1a]9m\u0015\t\u0019E)A\u0003ta\u0006\u00148N\u0003\u0002F\r\u00061\u0011\r]1dQ\u0016T\u0011aR\u0001\u0004_J<7\u0001A\n\u0006\u0001)sEK\u0017\t\u0003\u00172k\u0011AP\u0005\u0003\u001bz\u00121B\u00133cG\u0012K\u0017\r\\3diB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bQ\u0001\tG\u0006$\u0018\r\\=ti&\u00111\u000b\u0015\u0002\u000e'Fc5i\u001c8g\u0011\u0016d\u0007/\u001a:\u0011\u0005UCV\"\u0001,\u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0003\u000fA\u0013x\u000eZ;diB\u00111l\u0019\b\u00039\u0006t!!\u00181\u000e\u0003yS!a\u0018%\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0016B\u00012W\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Z3\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\t4\u0016A\u0002\u001fj]&$h\bF\u0001i!\tY\u0005!A\u0005dC:D\u0015M\u001c3mKR\u00111N\u001c\t\u0003+2L!!\u001c,\u0003\u000f\t{w\u000e\\3b]\")qN\u0001a\u0001a\u0006\u0019QO\u001d7\u0011\u0005E,hB\u0001:t!\tif+\u0003\u0002u-\u00061\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!h+A\u0013eSN$\u0018N\\2u+:\u001cX\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8ogV\t!\u0010E\u0003|\u0003\u0003\t)!D\u0001}\u0015\tih0A\u0005j[6,H/\u00192mK*\u0011qPV\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0002y\n\u00191+\u001a;\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005!A.\u00198h\u0015\t\ty!\u0001\u0003kCZ\f\u0017b\u0001<\u0002\n\u00051C-[:uS:\u001cG/\u00168tkB\u0004xN\u001d;fI\u0006;wM]3hCR,g)\u001e8di&|gn\u001d\u0011\u00027M,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8t\u0003q\u0019X\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8og\u0002\n!c];qa>\u0014H/\u001a3Gk:\u001cG/[8og\u0006\u00192/\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8tA\u0005\u0019\u0012n]*vaB|'\u000f^3e\rVt7\r^5p]R\u00191.!\t\t\r\u0005\r\u0012\u00021\u0001q\u0003!1WO\\2OC6,'aD'z'Fc5+\u0015'Ck&dG-\u001a:\u0014\u0007)\tI\u0003\u0005\u0003\u0002,\u00055R\"\u0001\u0001\n\u0007\u0005=BJ\u0001\bK\t\n\u001b5+\u0015'Ck&dG-\u001a:\u0015\u0005\u0005M\u0002cAA\u0016\u0015\u0005qa/[:jiN{'\u000f^(sI\u0016\u0014Hc\u00029\u0002:\u0005u\u0012\u0011\u000b\u0005\u0007\u0003wa\u0001\u0019\u00019\u0002\u000fM|'\u000f^&fs\"9\u0011q\b\u0007A\u0002\u0005\u0005\u0013!D:peR$\u0015N]3di&|g\u000e\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u0003\u0017\u0002\u0015!C2p]:,7\r^8s\u0013\u0011\ty%!\u0012\u0003\u001bM{'\u000f\u001e#je\u0016\u001cG/[8o\u0011\u001d\t\u0019\u0006\u0004a\u0001\u0003+\nAB\\;mY>\u0013H-\u001a:j]\u001e\u0004B!a\u0011\u0002X%!\u0011\u0011LA#\u00051qU\u000f\u001c7Pe\u0012,'/\u001b8h\u0003=1\u0018n]5u'R\f'\u000f^:XSRDG#\u00029\u0002`\u0005\r\u0004BBA1\u001b\u0001\u0007\u0001/A\u0001m\u0011\u0019\t)'\u0004a\u0001a\u0006\t!/A\u0007wSNLG/\u00128eg^KG\u000f\u001b\u000b\u0006a\u0006-\u0014Q\u000e\u0005\u0007\u0003Cr\u0001\u0019\u00019\t\r\u0005\u0015d\u00021\u0001q\u000351\u0018n]5u\u0007>tG/Y5ogR)\u0001/a\u001d\u0002v!1\u0011\u0011M\bA\u0002ADa!!\u001a\u0010\u0001\u0004\u0001\u0018A\u0006<jg&$\u0018iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8\u0015\u000fA\fY(! \u0002\u0002\"1\u00111\u0005\tA\u0002ADa!a \u0011\u0001\u0004Y\u0017AC5t\t&\u001cH/\u001b8di\"9\u00111\u0011\tA\u0002\u0005\u0015\u0015AB5oaV$8\u000f\u0005\u0003V\u0003\u000f\u0003\u0018bAAE-\n)\u0011I\u001d:bs\u0006\t2m\\7qS2,W\t\u001f9sKN\u001c\u0018n\u001c8\u0015\t\u0005=\u0015Q\u0013\t\u0005+\u0006E\u0005/C\u0002\u0002\u0014Z\u0013aa\u00149uS>t\u0007bBAL#\u0001\u0007\u0011\u0011T\u0001\u0005Kb\u0004(\u000f\u0005\u0003\u0002D\u0005m\u0015\u0002BAO\u0003\u000b\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,GCCAR\u0003c\u000bY,a0\u0002DB)Q+!%\u0002&B!\u0011qUAW\u001b\t\tIKC\u0002\u0002,\u0002\u000bQ\u0001^=qKNLA!a,\u0002*\nAA)\u0019;b)f\u0004X\rC\u0004\u00024J\u0001\r!!.\u0002\u000fM\fH\u000eV=qKB\u0019Q+a.\n\u0007\u0005efKA\u0002J]RDa!!0\u0013\u0001\u0004\u0001\u0018\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\u0005\u0005'\u00031\u0001\u00026\u0006!1/\u001b>f\u0011\u001d\t)M\u0005a\u0001\u0003\u000f\f!!\u001c3\u0011\t\u0005\u001d\u0016\u0011Z\u0005\u0005\u0003\u0017\fIKA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003=\tXo\u001c;f\u0013\u0012,g\u000e^5gS\u0016\u0014Hc\u00019\u0002R\"1\u00111[\nA\u0002A\fqaY8m\u001d\u0006lW-A\u0007tG\",W.Y:Fq&\u001cHo\u001d\u000b\bW\u0006e\u0017q]A\u007f\u0011\u001d\tY\u000e\u0006a\u0001\u0003;\fAaY8o]B!\u0011q\\Ar\u001b\t\t\tOC\u0002B\u0003\u001bIA!!:\u0002b\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000f\u0005%H\u00031\u0001\u0002l\u00069q\u000e\u001d;j_:\u001c\b\u0003BAw\u0003sl!!a<\u000b\u0007}\n\tP\u0003\u0003\u0002t\u0006U\u0018a\u00033bi\u0006\u001cx.\u001e:dKNT1!a>A\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0002|\u0006=(a\u0003&E\u0005\u000e{\u0005\u000f^5p]NDa!a@\u0015\u0001\u0004\u0001\u0018AB:dQ\u0016l\u0017-A\u0006mSN$8k\u00195f[\u0006\u001cHC\u0002B\u0003\u0005\u000f\u0011I\u0001E\u0003V\u0003\u000f\u000b)\tC\u0004\u0002\\V\u0001\r!!8\t\u000f\u0005%X\u00031\u0001\u0002l\u0006A\u0012n]\"bg\u000e\fG-\u001b8h)J,hnY1uKR\u000b'\r\\3\u0015\u0005\t=\u0001\u0003B+\u0002\u0012.\f\u0001dZ3u+B$\u0017\r^3D_2,XN\u001c+za\u0016\fV/\u001a:z)\u001d\u0001(Q\u0003B\r\u0005;AaAa\u0006\u0018\u0001\u0004\u0001\u0018!\u0003;bE2,g*Y7f\u0011\u0019\u0011Yb\u0006a\u0001a\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\t}q\u00031\u0001q\u0003-qWm\u001e#bi\u0006$\u0016\u0010]3\u0002)\u001d,GOU3oC6,7i\u001c7v[:\fV/\u001a:z)%\u0001(Q\u0005B\u0014\u0005S\u0011i\u0003\u0003\u0004\u0003\u0018a\u0001\r\u0001\u001d\u0005\u0007\u00057A\u0002\u0019\u00019\t\r\t-\u0002\u00041\u0001q\u0003\u001dqWm\u001e(b[\u0016DqAa\f\u0019\u0001\u0004\t),\u0001\beE6\u000b'n\u001c:WKJ\u001c\u0018n\u001c8\u0002?\u001d,G/\u00169eCR,7i\u001c7v[:tU\u000f\u001c7bE&d\u0017\u000e^=Rk\u0016\u0014\u0018\u0010F\u0004q\u0005k\u00119D!\u000f\t\r\t]\u0011\u00041\u0001q\u0011\u0019\u0011Y\"\u0007a\u0001a\"1!1H\rA\u0002-\f!\"[:Ok2d\u0017M\u00197f\u0003Q9W\r\u001e+bE2,7i\\7nK:$\u0018+^3ssR)\u0001O!\u0011\u0003F!1!1\t\u000eA\u0002A\fQ\u0001^1cY\u0016DaAa\u0012\u001b\u0001\u0004\u0001\u0018aB2p[6,g\u000e^\u0001\fO\u0016$(\n\u0012\"D)f\u0004X\r\u0006\u0003\u0003N\tU\u0003#B+\u0002\u0012\n=\u0003cA&\u0003R%\u0019!1\u000b \u0003\u0011)#'m\u0019+za\u0016DqAa\u0016\u001c\u0001\u0004\t)+\u0001\u0002ei\u0006)r-\u001a;TG\",W.Y\"p[6,g\u000e^)vKJLH#\u00029\u0003^\t}\u0003BBA\u00009\u0001\u0007\u0001\u000f\u0003\u0004\u0003Hq\u0001\r\u0001]\u0001\u0019e\u0016lwN^3TG\",W.Y\"p[6,g\u000e^)vKJLHc\u00019\u0003f!1\u0011q`\u000fA\u0002A\f1b\u0019:fCR,\u0017J\u001c3fqRY\u0001Oa\u001b\u0003p\t}$1\u0012BO\u0011\u0019\u0011iG\ba\u0001a\u0006I\u0011N\u001c3fq:\u000bW.\u001a\u0005\b\u0005cr\u0002\u0019\u0001B:\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e\u001e\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)!!\u0011PA%\u0003\u001d\u0019\u0017\r^1m_\u001eLAA! \u0003x\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000f\t\u0005e\u00041\u0001\u0003\u0004\u000691m\u001c7v[:\u001c\b#B+\u0002\b\n\u0015\u0005\u0003BA\"\u0005\u000fKAA!#\u0002F\tqa*Y7fIJ+g-\u001a:f]\u000e,\u0007b\u0002BG=\u0001\u0007!qR\u0001\u0012G>dW/\u001c8t!J|\u0007/\u001a:uS\u0016\u001c\b\u0003\u0003BI\u0005/\u0013)Ia'\u000e\u0005\tM%\u0002\u0002BK\u0003\u001b\tA!\u001e;jY&!!\u0011\u0014BJ\u0005\ri\u0015\r\u001d\t\u0007\u0005#\u00139\n\u001d9\t\u000f\t}e\u00041\u0001\u0003\u001c\u0006Q\u0001O]8qKJ$\u0018.Z:\u0002\u0017%tG-\u001a=Fq&\u001cHo\u001d\u000b\nW\n\u0015&q\u0015BU\u0005WCq!a7 \u0001\u0004\ti\u000e\u0003\u0004\u0003n}\u0001\r\u0001\u001d\u0005\b\u0005cz\u0002\u0019\u0001B:\u0011\u001d\tIo\ba\u0001\u0003W\f\u0011\u0002\u001a:pa&sG-\u001a=\u0015\u000bA\u0014\tLa-\t\r\t5\u0004\u00051\u0001q\u0011\u001d\u0011\t\b\ta\u0001\u0005g\n1\u0002\\5ti&sG-\u001a=fgRA!\u0011\u0018Bd\u0005\u0013\u0014Y\rE\u0003V\u0003\u000f\u0013Y\f\u0005\u0003\u0003>\n\rWB\u0001B`\u0015\u0011\u0011\tMa\u001e\u0002\u000b%tG-\u001a=\n\t\t\u0015'q\u0018\u0002\u000b)\u0006\u0014G.Z%oI\u0016D\bbBAnC\u0001\u0007\u0011Q\u001c\u0005\b\u0005c\n\u0003\u0019\u0001B:\u0011\u001d\tI/\ta\u0001\u0003W\f\u0011c\u00197bgNLg-_#yG\u0016\u0004H/[8o))\u0011\tN!7\u0003d\n\u001d(q\u001e\t\u0005\u0005'\u0014).D\u0001A\u0013\r\u00119\u000e\u0011\u0002\u0012\u0003:\fG._:jg\u0016C8-\u001a9uS>t\u0007b\u0002BnE\u0001\u0007!Q\\\u0001\u0002KB\u00191La8\n\u0007\t\u0005XMA\u0005UQJ|w/\u00192mK\"1!Q\u001d\u0012A\u0002A\f!\"\u001a:s_J\u001cE.Y:t\u0011\u001d\u0011IO\ta\u0001\u0005W\f\u0011#\\3tg\u0006<W\rU1sC6,G/\u001a:t!\u0015\t(Q\u001e9q\u0013\r\u0011Ij\u001e\u0005\u0007\u0005c\u0014\u0003\u0019\u00019\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0001\u000bIJ|\u0007oU2iK6\fG#\u00029\u0003x\ne\bBBA\u0000G\u0001\u0007\u0001\u000f\u0003\u0004\u0003|\u000e\u0002\ra[\u0001\bG\u0006\u001c8-\u00193f\u0005Qi\u0015pU)M'Fc\u0015+^3ss\n+\u0018\u000e\u001c3feN\u0019Ae!\u0001\u0011\u0007-\u001b\u0019!C\u0002\u0004\u0006y\u00121C\u00133cGN\u000bF*U;fef\u0014U/\u001b7eKJ\fq\u0001Z5bY\u0016\u001cG\u000f\u0006\u0004\u0004\f\r51q\u0002\t\u0004\u0003W!\u0003BBB\u0004O\u0001\u0007!\nC\u0004\u0002j\u001e\u0002\r!a;\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0003A\facZ3u\u0015\u0012\u00147mU)M#V,'/\u001f\"vS2$WM\u001d\u000b\u0005\u0007\u0003\u0019I\u0002C\u0004\u0002j&\u0002\r!a;\u0002\u001bM,\b\u000f]8siNd\u0015.\\5u+\u0005Y\u0017AD:vaB|'\u000f^:PM\u001a\u001cX\r^\u0001\u0005G>\u0004\u00180A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000b\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!.\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1qFB\u001b!\r)6\u0011G\u0005\u0004\u0007g1&aA!os\"I1qG\u0018\u0002\u0002\u0003\u0007\u0011QW\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\ru\u0002CBB \u0007\u0003\u001ay#D\u0001\u007f\u0013\r\u0019\u0019E \u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002l\u0007\u0013B\u0011ba\u000e2\u0003\u0003\u0005\raa\f\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u000b\u0019y\u0005C\u0005\u00048I\n\t\u00111\u0001\u00026\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00026\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0006\u00051Q-];bYN$2a[B/\u0011%\u00199$NA\u0001\u0002\u0004\u0019y#\u0001\u0007NsN\u000bF\nR5bY\u0016\u001cG\u000f\u0005\u0002LoM)qg!\u001a\u0004rA)1qMB7Q6\u00111\u0011\u000e\u0006\u0004\u0007W2\u0016a\u0002:v]RLW.Z\u0005\u0005\u0007_\u001aIGA\tBEN$(/Y2u\rVt7\r^5p]B\u0002Baa\u001d\u0004z5\u00111Q\u000f\u0006\u0005\u0007o\ni!\u0001\u0002j_&\u0019Am!\u001e\u0015\u0005\r\u0005\u0014!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u0004W\u000e\r\u0005\u0002CBCw\u0005\u0005\t\u0019\u00015\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\fB!\u0011qABG\u0013\u0011\u0019y)!\u0003\u0003\r=\u0013'.Z2u\u0001")
public class MySQLDialect
extends JdbcDialect
implements SQLConfHelper,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(MySQLDialect x$0) {
        return MySQLDialect$.MODULE$.unapply(x$0);
    }

    public static MySQLDialect apply() {
        return MySQLDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    public Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MySQLSQLBuilder mysqlSQLBuilder = new MySQLSQLBuilder(this);
        try {
            some = new Some((Object)mysqlSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (-3 == n2 && "BIT".equalsIgnoreCase(typeName) && size != 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (-7 == n2 && size > 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (12 == n2 && "TINYTEXT".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ((12 == n2 ? true : 1 == n2) && "JSON".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (-6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ByteType$.MODULE$);
            }
            return new Some((Object)ShortType$.MODULE$);
        }
        if (5 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ShortType$.MODULE$);
            }
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (4 == n2 && "MEDIUMINT UNSIGNED".equalsIgnoreCase(typeName)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (7 == n2 ? true : 6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)FloatType$.MODULE$);
            }
            return new Some((Object)DoubleType$.MODULE$);
        }
        if (93 == n2) {
            bl = true;
            n = n2;
            if ("DATETIME".equalsIgnoreCase(typeName)) {
                return new Some((Object)this.getTimestampType(md.build()));
            }
        }
        if (bl && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return "`" + colName + "`";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion >= 8) {
            return "ALTER TABLE " + tableName + " RENAME COLUMN " + this.quoteIdentifier(columnName) + " TO " + this.quoteIdentifier(newName);
        }
        throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return "ALTER TABLE " + table + " COMMENT = '" + comment + "'";
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("LONGTEXT", -1));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TINYINT", -6));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType) && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return Option$.MODULE$.apply((Object)new JdbcType("DATETIME", 93));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCommentNamespaceError(schema);
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError(schema);
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.quoteIdentifier(tableIdent.name()) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(" ");
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + this.quoteIdentifier(tableIdent.name()) + " WHERE key_name = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName) + " ON " + tableIdent.name();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + tableIdent.name();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, scala.collection.immutable.Map<String, String> messageParameters, String description) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1061: {
                    String string = errorClass;
                    String string2 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 1091: {
                    String string = errorClass;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            return super.classifyException(e, errorClass, messageParameters, description);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return super.classifyException(e, errorClass, messageParameters, description);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema);
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceError(schema);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MySQLSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public MySQLDialect copy() {
        return new MySQLDialect();
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MySQLDialect && ((MySQLDialect)x$1).canEqual(this);
    }

    private final Option getCatalystTypeForBitArray$1(MetadataBuilder md$1) {
        md$1.putLong("binarylong", 1L);
        if (this.conf().legacyMySqlBitArrayMappingEnabled()) {
            return new Some((Object)LongType$.MODULE$);
        }
        return new Some((Object)BinaryType$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$1));
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(indexComment)) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public MySQLDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }

    public class MySQLSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
            Tuple2 tuple2 = new Tuple2((Object)sortDirection, (Object)nullOrdering);
            if (tuple2 != null) {
                SortDirection sortDirection2 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering2 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection2) && NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
                    return sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection3 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering3 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection3) && NullOrdering.NULLS_LAST.equals(nullOrdering3)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 1 ELSE 0 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection4 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering4 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection4) && NullOrdering.NULLS_FIRST.equals(nullOrdering4)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 0 ELSE 1 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection5 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering5 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection5) && NullOrdering.NULLS_LAST.equals(nullOrdering5)) {
                    return sortKey + " " + sortDirection;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        public String visitStartsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        public String visitEndsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "' ESCAPE '\\\\'";
        }

        public String visitContains(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer().org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer() {
            return (MySQLDialect)this.$outer;
        }

        public MySQLSQLBuilder(MySQLDialect $outer) {
        }
    }

    public class MySQLSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ MySQLDialect $outer;

        @Override
        public String build() {
            String limitOrOffsetStmt = this.limit() > 0 ? (this.offset() > 0 ? "LIMIT " + this.offset() + ", " + this.limit() : this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()))) : (this.offset() > 0 ? "LIMIT " + this.offset() + ", 18446744073709551615" : "");
            return this.options.prepareQuery() + "SELECT " + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + limitOrOffsetStmt;
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public MySQLSQLQueryBuilder(MySQLDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

