/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r-c\u0001\u0002\u001a4\tzBQa\u0017\u0001\u0005\u0002qCQA\u0018\u0001\u0005B}Cq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001c\u0005\b\u007f\u0002\u0011\r\u0011\"\u0003o\u0011\u001d\t\t\u0001\u0001Q\u0001\n=Dq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!!\"\u0001\t\u0003\n9\tC\u0005\u0002\u0012\u0002\t\n\u0011\"\u0001\u0002\u0014\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\t\u0019\u000f\u0001C!\u0003KDqAa\n\u0001\t\u0003\u0012I\u0003C\u0004\u0003J\u0001!\tEa\u0013\t\u0013\tE\u0003A1A\u0005\u000e\tM\u0003\u0002\u0003B2\u0001\u0001\u0006iA!\u0016\t\u000f\t\u0015\u0004\u0001\"\u0011\u0003h!9!q\u0011\u0001\u0005B\t%\u0005b\u0002BF\u0001\u0011\u0005#\u0011\u0012\u0005\b\u0005\u001b\u0003A\u0011\tBE\u0011\u001d\u0011y\t\u0001C!\u0005#CqAa)\u0001\t\u0003\u0012)\u000bC\u0004\u00030\u0002!\tE!-\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!1\u0019\u0001\u0005B\t\u0015\u0007\u0002\u0003Bn\u0001\u0005\u0005I\u0011\u0001/\t\u0013\tu\u0007!!A\u0005B\t}\u0007\"\u0003Bq\u0001\u0005\u0005I\u0011\u0001Br\u0011%\u0011)\u000fAA\u0001\n\u0003\u00119\u000fC\u0005\u0003t\u0002\t\t\u0011\"\u0011\u0003v\"I!q \u0001\u0002\u0002\u0013\u00051\u0011\u0001\u0005\n\u0007\u000b\u0001\u0011\u0011!C!\u0007\u000fA\u0011ba\u0003\u0001\u0003\u0003%\te!\u0004\t\u0013\r=\u0001!!A\u0005B\rE\u0001\"CB\n\u0001\u0005\u0005I\u0011IB\u000b\u000f%\u0019IbMA\u0001\u0012\u0013\u0019YB\u0002\u00053g\u0005\u0005\t\u0012BB\u000f\u0011\u0019YF\u0006\"\u0001\u00046!I1q\u0002\u0017\u0002\u0002\u0013\u00153\u0011\u0003\u0005\t\u0007oa\u0013\u0011!CA9\"I1\u0011\b\u0017\u0002\u0002\u0013\u000551\b\u0005\n\u0007\u0003b\u0013\u0011!C\u0005\u0007\u0007\u0012q\u0002U8ti\u001e\u0014Xm\u001d#jC2,7\r\u001e\u0006\u0003iU\nAA\u001b3cG*\u0011agN\u0001\u0004gFd'B\u0001\u001d:\u0003\u0015\u0019\b/\u0019:l\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0004\u0001M)\u0001aP\"J\u001fB\u0011\u0001)Q\u0007\u0002g%\u0011!i\r\u0002\f\u0015\u0012\u00147\rR5bY\u0016\u001cG\u000f\u0005\u0002E\u000f6\tQI\u0003\u0002Gk\u0005A1-\u0019;bYf\u001cH/\u0003\u0002I\u000b\ni1+\u0015'D_:4\u0007*\u001a7qKJ\u0004\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002Q1:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)v\na\u0001\u0010:p_Rt\u0014\"\u0001'\n\u0005][\u0015a\u00029bG.\fw-Z\u0005\u00033j\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aV&\u0002\rqJg.\u001b;?)\u0005i\u0006C\u0001!\u0001\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002aGB\u0011!*Y\u0005\u0003E.\u0013qAQ8pY\u0016\fg\u000eC\u0003e\u0005\u0001\u0007Q-A\u0002ve2\u0004\"A\u001a6\u000f\u0005\u001dD\u0007C\u0001*L\u0013\tI7*\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5L\u0003m\u0019X\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8ogV\tq\u000eE\u0002qk^l\u0011!\u001d\u0006\u0003eN\f\u0011\"[7nkR\f'\r\\3\u000b\u0005Q\\\u0015AC2pY2,7\r^5p]&\u0011a/\u001d\u0002\u0004'\u0016$\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003\u0011a\u0017M\\4\u000b\u0003q\fAA[1wC&\u00111._\u0001\u001dgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:!\u0003I\u0019X\u000f\u001d9peR,GMR;oGRLwN\\:\u0002'M,\b\u000f]8si\u0016$g)\u001e8di&|gn\u001d\u0011\u0002'%\u001c8+\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8\u0015\u0007\u0001\f9\u0001\u0003\u0004\u0002\n\u001d\u0001\r!Z\u0001\tMVt7MT1nK\u0006yq-\u001a;DCR\fG._:u)f\u0004X\r\u0006\u0006\u0002\u0010\u0005\u0005\u00121FA\u0018\u0003g\u0001RASA\t\u0003+I1!a\u0005L\u0005\u0019y\u0005\u000f^5p]B!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cU\nQ\u0001^=qKNLA!a\b\u0002\u001a\tAA)\u0019;b)f\u0004X\rC\u0004\u0002$!\u0001\r!!\n\u0002\u000fM\fH\u000eV=qKB\u0019!*a\n\n\u0007\u0005%2JA\u0002J]RDa!!\f\t\u0001\u0004)\u0017\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\u0005E\u0002\u00021\u0001\u0002&\u0005!1/\u001b>f\u0011\u001d\t)\u0004\u0003a\u0001\u0003o\t!!\u001c3\u0011\t\u0005]\u0011\u0011H\u0005\u0005\u0003w\tIBA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u00039!xnQ1uC2L8\u000f\u001e+za\u0016$\u0002\"a\u0004\u0002B\u0005\r\u0013q\t\u0005\u0007\u0003[I\u0001\u0019A3\t\u000f\u0005\u0015\u0013\u00021\u0001\u0002&\u0005I\u0001O]3dSNLwN\u001c\u0005\b\u0003kI\u0001\u0019AA\u001c\u0003\t\u001awN\u001c<feRT\u0015M^1US6,7\u000f^1naR{G+[7fgR\fW\u000e\u001d(U5R!\u0011QJA-!\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*w\u0006!A/[7f\u0013\u0011\t9&!\u0015\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u001d\tYF\u0003a\u0001\u0003;\n\u0011\u0001\u001e\t\u0005\u0003?\n\u0019'\u0004\u0002\u0002b)\u0011ag_\u0005\u0005\u0003K\n\tGA\u0005US6,7\u000f^1na\u0006\u00113m\u001c8wKJ$H+[7fgR\fW\u000e\u001d(U5R{'*\u0019<b)&lWm\u001d;b[B$B!!\u0018\u0002l!9\u0011QN\u0006A\u0002\u00055\u0013a\u00017ei\u0006Yq-\u001a;K\t\n\u001bE+\u001f9f)\u0011\t\u0019(a\u001f\u0011\u000b)\u000b\t\"!\u001e\u0011\u0007\u0001\u000b9(C\u0002\u0002zM\u0012\u0001B\u00133cGRK\b/\u001a\u0005\b\u0003{b\u0001\u0019AA\u000b\u0003\t!G/\u0001\rjg\u000e\u000b7oY1eS:<GK];oG\u0006$X\rV1cY\u0016$\"!a!\u0011\t)\u000b\t\u0002Y\u0001\u0011O\u0016$HK];oG\u0006$X-U;fef$R!ZAE\u0003\u001bCa!a#\u000f\u0001\u0004)\u0017!\u0002;bE2,\u0007\"CAH\u001dA\u0005\t\u0019AAB\u0003\u001d\u0019\u0017m]2bI\u0016\f!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"!!&+\t\u0005\r\u0015qS\u0016\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005v]\u000eDWmY6fI*\u0019\u00111U&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0006u%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y!-\u001a4pe\u00164U\r^2i)\u0019\ti+a-\u0002>B\u0019!*a,\n\u0007\u0005E6J\u0001\u0003V]&$\bbBA[!\u0001\u0007\u0011qW\u0001\u000bG>tg.Z2uS>t\u0007\u0003BA0\u0003sKA!a/\u0002b\tQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000f\u0005}\u0006\u00031\u0001\u0002B\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u000b\u0019\f\u0019-Z3\n\u0007\u0005\u0015GNA\u0002NCB\f\u0001dZ3u+B$\u0017\r^3D_2,XN\u001c+za\u0016\fV/\u001a:z)\u001d)\u00171ZAh\u0003'Da!!4\u0012\u0001\u0004)\u0017!\u0003;bE2,g*Y7f\u0011\u0019\t\t.\u0005a\u0001K\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\u0005U\u0017\u00031\u0001f\u0003-qWm\u001e#bi\u0006$\u0016\u0010]3\u0002?\u001d,G/\u00169eCR,7i\u001c7v[:tU\u000f\u001c7bE&d\u0017\u000e^=Rk\u0016\u0014\u0018\u0010F\u0004f\u00037\fi.a8\t\r\u00055'\u00031\u0001f\u0011\u0019\t\tN\u0005a\u0001K\"1\u0011\u0011\u001d\nA\u0002\u0001\f!\"[:Ok2d\u0017M\u00197f\u0003-\u0019'/Z1uK&sG-\u001a=\u0015\u0017\u0015\f9/a;\u0002\u0000\nU!Q\u0005\u0005\u0007\u0003S\u001c\u0002\u0019A3\u0002\u0013%tG-\u001a=OC6,\u0007bBAw'\u0001\u0007\u0011q^\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003BAy\u0003wl!!a=\u000b\t\u0005U\u0018q_\u0001\bG\u0006$\u0018\r\\8h\u0015\r\tI0N\u0001\nG>tg.Z2u_JLA!!@\u0002t\nQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000f\t\u00051\u00031\u0001\u0003\u0004\u000591m\u001c7v[:\u001c\b#\u0002&\u0003\u0006\t%\u0011b\u0001B\u0004\u0017\n)\u0011I\u001d:bsB!!1\u0002B\t\u001b\t\u0011iA\u0003\u0003\u0003\u0010\u0005]\u0018aC3yaJ,7o]5p]NLAAa\u0005\u0003\u000e\tqa*Y7fIJ+g-\u001a:f]\u000e,\u0007b\u0002B\f'\u0001\u0007!\u0011D\u0001\u0012G>dW/\u001c8t!J|\u0007/\u001a:uS\u0016\u001c\b\u0003\u0003B\u000e\u0005C\u0011IAa\t\u000e\u0005\tu!b\u0001B\u0010w\u0006!Q\u000f^5m\u0013\u0011\t)M!\b\u0011\r\tm!\u0011E3f\u0011\u001d\tyl\u0005a\u0001\u0005G\t1\"\u001b8eKb,\u00050[:ugRI\u0001Ma\u000b\u00030\tE\"1\u0007\u0005\b\u0005[!\u0002\u0019AA\\\u0003\u0011\u0019wN\u001c8\t\r\u0005%H\u00031\u0001f\u0011\u001d\ti\u000f\u0006a\u0001\u0003_DqA!\u000e\u0015\u0001\u0004\u00119$A\u0004paRLwN\\:\u0011\t\te\"QI\u0007\u0003\u0005wQ1\u0001\u000eB\u001f\u0015\u0011\u0011yD!\u0011\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0004\u0005\u0007*\u0014!C3yK\u000e,H/[8o\u0013\u0011\u00119Ea\u000f\u0003\u0017)#%iQ(qi&|gn]\u0001\nIJ|\u0007/\u00138eKb$R!\u001aB'\u0005\u001fBa!!;\u0016\u0001\u0004)\u0007bBAw+\u0001\u0007\u0011q^\u0001\u0015a\u001e\fEN]3bIf,\u00050[:ugJ+w-\u001a=\u0016\u0005\tU\u0003\u0003\u0002B,\u0005?j!A!\u0017\u000b\t\tm#QL\u0001\t[\u0006$8\r[5oO*\u0019!qD&\n\t\t\u0005$\u0011\f\u0002\u0006%\u0016<W\r_\u0001\u0016a\u001e\fEN]3bIf,\u00050[:ugJ+w-\u001a=!\u0003E\u0019G.Y:tS\u001aLX\t_2faRLwN\u001c\u000b\u000b\u0005S\u0012\tHa\u001f\u0003\u0000\t\r\u0005\u0003\u0002B6\u0005[j\u0011!N\u0005\u0004\u0005_*$!E!oC2L8/[:Fq\u000e,\u0007\u000f^5p]\"9!1\u000f\rA\u0002\tU\u0014!A3\u0011\u0007A\u00139(C\u0002\u0003zi\u0013\u0011\u0002\u00165s_^\f'\r\\3\t\r\tu\u0004\u00041\u0001f\u0003))'O]8s\u00072\f7o\u001d\u0005\b\u0005\u0003C\u0002\u0019AAa\u0003EiWm]:bO\u0016\u0004\u0016M]1nKR,'o\u001d\u0005\u0007\u0005\u000bC\u0002\u0019A3\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003\u0001\fab];qa>\u0014Ho](gMN,G/A\ntkB\u0004xN\u001d;t)\u0006\u0014G.Z*b[BdW-\u0001\bhKR$\u0016M\u00197f'\u0006l\u0007\u000f\\3\u0015\u0007\u0015\u0014\u0019\nC\u0004\u0003\u0016r\u0001\rAa&\u0002\rM\fW\u000e\u001d7f!\u0011\u0011IJa(\u000e\u0005\tm%\u0002\u0002BO\u0005{\t!A\u001e\u001a\n\t\t\u0005&1\u0014\u0002\u0010)\u0006\u0014G.Z*b[BdW-\u00138g_\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\u0015)'q\u0015BV\u0011\u001d\u0011I+\ba\u0001\u0003_\f\u0001b\u001c7e)\u0006\u0014G.\u001a\u0005\b\u0005[k\u0002\u0019AAx\u0003!qWm\u001e+bE2,\u0017aH2p]Z,'\u000f\u001e&bm\u0006$\u0016.\\3ti\u0006l\u0007\u000fV8US6,7\u000f^1naR!\u0011Q\fBZ\u0011\u001d\tYF\ba\u0001\u0003;\nQcY8om\u0016\u0014HOS1wC\u0012\u000bG/\u001a+p\t\u0006$X\r\u0006\u0003\u0003:\n}\u0006\u0003BA0\u0005wKAA!0\u0002b\t!A)\u0019;f\u0011\u001d\u0011\tm\ba\u0001\u0005s\u000b\u0011\u0001Z\u0001\u0016kB$\u0017\r^3FqR\u0014\u0018mQ8mk6tW*\u001a;b))\tiKa2\u0003J\nM'q\u001b\u0005\b\u0005[\u0001\u0003\u0019AA\\\u0011\u001d\u0011Y\r\ta\u0001\u0005\u001b\fAA]:nIB!\u0011q\fBh\u0013\u0011\u0011\t.!\u0019\u0003#I+7/\u001e7u'\u0016$X*\u001a;b\t\u0006$\u0018\rC\u0004\u0003V\u0002\u0002\r!!\n\u0002\u0013\r|G.^7o\u0013\u0012D\bb\u0002BmA\u0001\u0007\u0011qG\u0001\t[\u0016$\u0018\rZ1uC\u0006!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tq/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002&\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002Bu\u0005_\u00042A\u0013Bv\u0013\r\u0011io\u0013\u0002\u0004\u0003:L\b\"\u0003ByI\u0005\u0005\t\u0019AA\u0013\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u001f\t\u0007\u0005s\u0014YP!;\u000e\u0003ML1A!@t\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0001\u001c\u0019\u0001C\u0005\u0003r\u001a\n\t\u00111\u0001\u0003j\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\r98\u0011\u0002\u0005\n\u0005c<\u0013\u0011!a\u0001\u0003K\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003K\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002o\u00061Q-];bYN$2\u0001YB\f\u0011%\u0011\tPKA\u0001\u0002\u0004\u0011I/A\bQ_N$xM]3t\t&\fG.Z2u!\t\u0001EfE\u0003-\u0007?\u0019Y\u0003E\u0003\u0004\"\r\u001dR,\u0004\u0002\u0004$)\u00191QE&\u0002\u000fI,h\u000e^5nK&!1\u0011FB\u0012\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\t\u0005\u0007[\u0019\u0019$\u0004\u0002\u00040)\u00191\u0011G>\u0002\u0005%|\u0017bA-\u00040Q\u001111D\u0001\u0006CB\u0004H._\u0001\bk:\f\u0007\u000f\u001d7z)\r\u00017Q\b\u0005\t\u0007\u007f\u0001\u0014\u0011!a\u0001;\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r\u0015\u0003c\u0001=\u0004H%\u00191\u0011J=\u0003\r=\u0013'.Z2u\u0001")
public class PostgresDialect
extends JdbcDialect
implements SQLConfHelper,
Product {
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Regex pgAlreadyExistsRegex;

    public static boolean unapply(PostgresDialect x$0) {
        return PostgresDialect$.MODULE$.unapply(x$0);
    }

    public static PostgresDialect apply() {
        return PostgresDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (7 == n2) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (5 == n2) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (-7 == n2) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                return new Some((Object)BinaryType$.MODULE$);
            }
        }
        if (8 == n2) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return new Some((Object)StringType$.MODULE$);
            }
        }
        if (93 == n2 && "timestamptz".equalsIgnoreCase(typeName) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (92 == n2 && "timetz".equalsIgnoreCase(typeName)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (1 == n2 && "bpchar".equalsIgnoreCase(typeName) && size == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (1111 == n2) {
            bl = true;
            n = n2;
            if ("void".equalsIgnoreCase(typeName)) {
                return new Some((Object)NullType$.MODULE$);
            }
        }
        if (bl) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("text".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (2003 == n2) {
            Option<DataType> elementType = this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, md);
            return elementType.map((Function1 & Serializable)et -> {
                Metadata metadata = md.build();
                int dim = metadata.contains("arrayDimension") ? (int)metadata.getLong("arrayDimension") : 1;
                return (DataType)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dim).foldLeft(et, (Function2 & Serializable)(acc, x$1) -> ArrayType$.MODULE$.apply(acc));
            });
        }
        return None$.MODULE$;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, MetadataBuilder md) {
        boolean bl = false;
        String string = null;
        String string2 = typeName;
        if ("bool".equals(string2)) {
            return new Some((Object)BooleanType$.MODULE$);
        }
        if ("bit".equals(string2)) {
            bl = true;
            string = string2;
            if (precision == 1) {
                return new Some((Object)BooleanType$.MODULE$);
            }
        }
        if (bl) {
            md.putBoolean("pg_bit_array_type", true);
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("int2".equals(string2)) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if ("int4".equals(string2)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if ("int8".equals(string2) ? true : "oid".equals(string2)) {
            return new Some((Object)LongType$.MODULE$);
        }
        if ("float4".equals(string2)) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if ("float8".equals(string2)) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        if ("varchar".equals(string2)) {
            return new Some((Object)new VarcharType(precision));
        }
        if ("bpchar".equals(string2) && precision == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("char".equals(string2) ? true : "bpchar".equals(string2)) {
            return new Some((Object)new CharType(precision));
        }
        if ("text".equals(string2) ? true : ("cidr".equals(string2) ? true : ("inet".equals(string2) ? true : ("json".equals(string2) ? true : ("jsonb".equals(string2) ? true : ("uuid".equals(string2) ? true : ("xml".equals(string2) ? true : ("tsvector".equals(string2) ? true : ("tsquery".equals(string2) ? true : ("macaddr".equals(string2) ? true : ("macaddr8".equals(string2) ? true : ("txid_snapshot".equals(string2) ? true : ("point".equals(string2) ? true : ("line".equals(string2) ? true : ("lseg".equals(string2) ? true : ("box".equals(string2) ? true : ("path".equals(string2) ? true : ("polygon".equals(string2) ? true : ("circle".equals(string2) ? true : ("pg_lsn".equals(string2) ? true : ("varbit".equals(string2) ? true : ("interval".equals(string2) ? true : "pg_snapshot".equals(string2))))))))))))))))))))))) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("bytea".equals(string2)) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("timestamptz".equals(string2) ? true : "timetz".equals(string2)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ("timestamp".equals(string2) ? true : "time".equals(string2)) {
            return new Some((Object)this.getTimestampType(md.build()));
        }
        if ("date".equals(string2)) {
            return new Some((Object)DateType$.MODULE$);
        }
        if (("numeric".equals(string2) ? true : "decimal".equals(string2)) && precision > 0) {
            int scale = (int)md.build().getLong("scale");
            return new Some((Object)DecimalType$.MODULE$.bounded(precision, scale));
        }
        if ("numeric".equals(string2) ? true : "decimal".equals(string2)) {
            return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        }
        if ("money".equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)StringType$.MODULE$);
    }

    @Override
    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return t.toLocalDateTime();
    }

    @Override
    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("TEXT", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BYTEA", -2));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT4", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT8", 8));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH TIME ZONE", 93));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        if (dataType instanceof ArrayType && ((et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType || et instanceof ArrayType)) {
            return this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(typeName + "[]", 2003));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE ONLY " + table + " CASCADE";
        }
        return "TRUNCATE TABLE ONLY " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) > 0) {
            connection.setAutoCommit(false);
            return;
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String indexType;
        Object indexProperties;
        String[] columnList;
        block1: {
            columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
            indexProperties = "";
            Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String indexType2 = (String)tuple2._1();
            String[] indexPropertyList = (String[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType2, (Object)indexPropertyList);
            indexType = (String)tuple22._1();
            String[] indexPropertyList2 = (String[])tuple22._2();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2))) break block1;
            indexProperties = "WITH (" + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(", ") + ")";
        }
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.quoteIdentifier(tableIdent.name()) + " " + indexType + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + (String)indexProperties;
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM pg_indexes WHERE tablename = '" + tableIdent.name() + "' AND indexname = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName);
    }

    private final Regex pgAlreadyExistsRegex() {
        return this.pgAlreadyExistsRegex;
    }

    @Override
    public AnalysisException classifyException(Throwable e, String errorClass, scala.collection.immutable.Map<String, String> messageParameters, String description) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 48220673: {
                    if (!"2BP01".equals(string)) break;
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
                case 49567037: {
                    if (!"42704".equals(string)) break;
                    String string2 = errorClass;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 49591065: {
                    if (!"42P07".equals(string)) break;
                    String string4 = errorClass;
                    String string5 = "FAILED_JDBC.CREATE_INDEX";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        throw new IndexAlreadyExistsException((String)messageParameters.apply((Object)"indexName"), (String)messageParameters.apply((Object)"tableName"), (Option)new Some((Object)e));
                    }
                    String string6 = errorClass;
                    String string7 = "FAILED_JDBC.RENAME_TABLE";
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        String newTable = (String)messageParameters.apply((Object)"newName");
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                    }
                    Option tblRegexp = this.pgAlreadyExistsRegex().findFirstMatchIn((CharSequence)sQLException.getMessage());
                    if (tblRegexp.nonEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(((Regex.MatchData)tblRegexp.get()).group(1));
                    }
                    return super.classifyException(e, errorClass, messageParameters, description);
                }
            }
            return super.classifyException(e, errorClass, messageParameters, description);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return super.classifyException(e, errorClass, messageParameters, description);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE BERNOULLI (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        if (!Predef$.MODULE$.wrapRefArray((Object[])oldTable.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newTable.namespace()))) {
            throw QueryCompilationErrors$.MODULE$.cannotRenameTableAcrossSchemaError();
        }
        return "ALTER TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " RENAME TO " + newTable.name();
    }

    @Override
    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        long l = t.getTime();
        if (9223372036825200000L == l) {
            return new Timestamp(LocalDateTime.of(9999, 12, 31, 23, 59, 59, 999999999).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Timestamp(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return t;
    }

    @Override
    public Date convertJavaDateToDate(Date d) {
        long l = d.getTime();
        if (9223372036825200000L == l) {
            return new Date(LocalDateTime.of(9999, 12, 31, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Date(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return d;
    }

    @Override
    public void updateExtraColumnMeta(Connection conn, ResultSetMetaData rsmd, int columnIdx, MetadataBuilder metadata) {
        int n = rsmd.getColumnType(columnIdx);
        switch (n) {
            case 2003: {
                String tableName = rsmd.getTableName(columnIdx);
                String columnName = rsmd.getColumnName(columnIdx);
                String query = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT pg_attribute.attndims\n             |FROM pg_attribute\n             |  JOIN pg_class ON pg_attribute.attrelid = pg_class.oid\n             |  JOIN pg_namespace ON pg_class.relnamespace = pg_namespace.oid\n             |WHERE pg_class.relname = '" + tableName + "' and pg_attribute.attname = '" + columnName + "'\n             |"));
                try {
                    Using$.MODULE$.resource((Object)conn.createStatement(), (Function1 & Serializable)stmt -> Using$.MODULE$.resource((Object)stmt.executeQuery(query), (Function1 & Serializable)rs -> {
                        if (rs.next()) {
                            return metadata.putLong("arrayDimension", rs.getLong(1));
                        }
                        return BoxedUnit.UNIT;
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                }
                catch (SQLException e) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get array dimension for column ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COLUMN_NAME$.MODULE$, (Object)columnName)}))), (Throwable)e);
                }
                return;
            }
        }
    }

    public PostgresDialect copy() {
        return new PostgresDialect();
    }

    public String productPrefix() {
        return "PostgresDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PostgresDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof PostgresDialect && ((PostgresDialect)x$1).canEqual(this);
    }

    public PostgresDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedFunctions = this.supportedAggregateFunctions();
        this.pgAlreadyExistsRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:.*)relation \"(.*)\" already exists"));
    }
}

