/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.catalyst.xml.XmlOptions$;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.xml.TextInputXmlDataSource$;
import org.apache.spark.sql.execution.datasources.xml.XmlUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\t}c\u0001\u0002\u0016,\u0001QB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0007\u0005\u0002!\taK\"\t\u000b\u0019\u0003A\u0011I$\t\u000ba\u0003A\u0011I-\t\u000ba\u0003A\u0011I1\t\u000b\u0011\u0004A\u0011I3\t\u000b\u0011\u0004A\u0011\t6\t\u000b\u0011\u0004A\u0011I9\t\u000b\u0011\u0004A\u0011I<\t\u000bu\u0004A\u0011\t@\t\ru\u0004A\u0011IA\u0007\u0011\u001d\ty\u0002\u0001C!\u0003CAq!a\b\u0001\t\u0003\t\t\u0004C\u0004\u0002 \u0001!\t!a\u000e\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T!9\u0011q\u000b\u0001\u0005B\u0005e\u0003bBA,\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003/\u0002A\u0011AAG\u0011\u001d\ty\n\u0001C!\u0003CCq!a(\u0001\t\u0003\n)\u000bC\u0004\u0002 \u0002!\t!a+\t\u000f\u0005}\u0005\u0001\"\u0001\u0002R\"9\u0011q\u0014\u0001\u0005\u0002\u0005\r\bbBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0003W\u0004A\u0011AAy\u0011\u001d\tY\u000f\u0001C!\u0003oDq!!@\u0001\t\u0003\ny\u0010C\u0004\u0002~\u0002!\tEa\u0001\t\u000f\u0005u\b\u0001\"\u0001\u0003\n!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\b\u0001\u0011\u0005#Q\u0003\u0005\b\u00057\u0001A\u0011\tB\u000f\u0011\u001d\u0011Y\u0002\u0001C!\u0005CAq!!\u0019\u0001\t\u0003\u00119\u0003C\u0004\u0003.\u0001!\tEa\f\t\u000f\t5\u0002\u0001\"\u0011\u00034!9!\u0011\b\u0001\u0005B\tm\u0002b\u0002B\u001d\u0001\u0011\u0005#q\b\u0005\b\u0005\u000b\u0002A\u0011\u000bB$\u0011\u001d\u0011y\u0005\u0001C)\u0005\u000fBqA!\u0015\u0001\t#\u00129EA\bECR\fgI]1nKJ+\u0017\rZ3s\u0015\taS&A\u0002tc2T!AL\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0007E\u00027sij\u0011a\u000e\u0006\u0003q-\n1!\u00199j\u0013\tQs\u0007\u0005\u0002<y5\t1&\u0003\u0002>W\t9A)\u0019;bg\u0016$\u0018\u0001D:qCJ\\7+Z:tS>t\u0007CA\u001eA\u0013\t\t5F\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003\t\u0016\u0003\"a\u000f\u0001\t\u000by\u0012\u0001\u0019A \u0002\r\u0019|'/\\1u)\tA\u0015*D\u0001\u0001\u0011\u0015Q5\u00011\u0001L\u0003\u0019\u0019x.\u001e:dKB\u0011A*\u0016\b\u0003\u001bN\u0003\"AT)\u000e\u0003=S!\u0001U\u001a\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u000b\u0016AB:dQ\u0016l\u0017\r\u0006\u0002I5\")\u0001\f\u0002a\u00017B\u0011AlX\u0007\u0002;*\u0011alK\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013!b\u0015;sk\u000e$H+\u001f9f)\tA%\rC\u0003d\u000b\u0001\u00071*\u0001\u0007tG\",W.Y*ue&tw-\u0001\u0004paRLwN\u001c\u000b\u0004\u0011\u001aD\u0007\"B4\u0007\u0001\u0004Y\u0015aA6fs\")\u0011N\u0002a\u0001\u0017\u0006)a/\u00197vKR\u0019\u0001j\u001b7\t\u000b\u001d<\u0001\u0019A&\t\u000b%<\u0001\u0019A7\u0011\u00059|W\"A)\n\u0005A\f&a\u0002\"p_2,\u0017M\u001c\u000b\u0004\u0011J\u001c\b\"B4\t\u0001\u0004Y\u0005\"B5\t\u0001\u0004!\bC\u00018v\u0013\t1\u0018K\u0001\u0003M_:<Gc\u0001%ys\")q-\u0003a\u0001\u0017\")\u0011.\u0003a\u0001uB\u0011an_\u0005\u0003yF\u0013a\u0001R8vE2,\u0017aB8qi&|gn\u001d\u000b\u0003\u0011~Da! \u0006A\u0002\u0005\u0005\u0001CBA\u0002\u0003\u0013Y5*\u0004\u0002\u0002\u0006)\u0019\u0011qA)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\f\u0005\u0015!aA'baR\u0019\u0001*a\u0004\t\ru\\\u0001\u0019AA\t!\u0019\t\u0019\"!\bL\u00176\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003vi&d'BAA\u000e\u0003\u0011Q\u0017M^1\n\t\u0005-\u0011QC\u0001\u0005Y>\fG\r\u0006\u0002\u0002$A!\u0011QEA\u0016\u001d\rY\u0014qE\u0005\u0004\u0003SY\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003[\tyCA\u0005ECR\fgI]1nK*\u0019\u0011\u0011F\u0016\u0015\t\u0005\r\u00121\u0007\u0005\u0007\u0003ki\u0001\u0019A&\u0002\tA\fG\u000f\u001b\u000b\u0005\u0003G\tI\u0004C\u0004\u0002<9\u0001\r!!\u0010\u0002\u000bA\fG\u000f[:\u0011\t9\fydS\u0005\u0004\u0003\u0003\n&A\u0003\u001fsKB,\u0017\r^3e}!\u001aa\"!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013R\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\nIEA\u0004wCJ\f'oZ:\u0002\u00191|\u0017\r\u001a,2'>,(oY3\u0015\t\u0005\r\u0012Q\u000b\u0005\b\u0003wy\u0001\u0019AA\u001f\u0003\u0011QGMY2\u0015\u0011\u0005\r\u00121LA0\u0003GBa!!\u0018\u0011\u0001\u0004Y\u0015aA;sY\"1\u0011\u0011\r\tA\u0002-\u000bQ\u0001^1cY\u0016Dq!!\u001a\u0011\u0001\u0004\t9'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!a\u0005\u0002j%!\u00111NA\u000b\u0005)\u0001&o\u001c9feRLWm\u001d\u000b\u0011\u0003G\ty'!\u001d\u0002t\u0005]\u00141PA@\u0003\u0013Ca!!\u0018\u0012\u0001\u0004Y\u0005BBA1#\u0001\u00071\n\u0003\u0004\u0002vE\u0001\raS\u0001\u000bG>dW/\u001c8OC6,\u0007BBA=#\u0001\u0007A/\u0001\u0006m_^,'OQ8v]\u0012Da!! \u0012\u0001\u0004!\u0018AC;qa\u0016\u0014(i\\;oI\"9\u0011\u0011Q\tA\u0002\u0005\r\u0015!\u00048v[B\u000b'\u000f^5uS>t7\u000fE\u0002o\u0003\u000bK1!a\"R\u0005\rIe\u000e\u001e\u0005\b\u0003\u0017\u000b\u0002\u0019AA4\u0003Q\u0019wN\u001c8fGRLwN\u001c)s_B,'\u000f^5fgRQ\u00111EAH\u0003#\u000b\u0019*!(\t\r\u0005u#\u00031\u0001L\u0011\u0019\t\tG\u0005a\u0001\u0017\"9\u0011Q\u0013\nA\u0002\u0005]\u0015A\u00039sK\u0012L7-\u0019;fgB!a.!'L\u0013\r\tY*\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u0017\u0013\u0002\u0019AA4\u0003\u0011Q7o\u001c8\u0015\t\u0005\r\u00121\u0015\u0005\u0007\u0003k\u0019\u0002\u0019A&\u0015\t\u0005\r\u0012q\u0015\u0005\b\u0003w!\u0002\u0019AA\u001fQ\r!\u0012Q\t\u000b\u0005\u0003G\ti\u000bC\u0004\u00020V\u0001\r!!-\u0002\u000f)\u001cxN\u001c*E\tB)\u00111WA]\u00176\u0011\u0011Q\u0017\u0006\u0005\u00037\t9L\u0003\u00029[%!\u00111XA[\u0005\u001dQ\u0015M^1S\t\u0012C3\"FA`\u0003\u000b\f9-a3\u0002NB\u0019a.!1\n\u0007\u0005\r\u0017K\u0001\u0006eKB\u0014XmY1uK\u0012\fq!\\3tg\u0006<W-\t\u0002\u0002J\u0006\u0011Sk]3!UN|g\u000e\u000b#bi\u0006\u001cX\r^.TiJLgnZ/*A%t7\u000f^3bI:\nQa]5oG\u0016\f#!a4\u0002\u000bIr#G\f\u0019\u0015\t\u0005\r\u00121\u001b\u0005\b\u0003_3\u0002\u0019AAk!\u0015\t9.!8L\u001b\t\tINC\u0002\u0002\\6\n1A\u001d3e\u0013\u0011\ty.!7\u0003\u0007I#E\tK\u0006\u0017\u0003\u007f\u000b)-a2\u0002L\u00065G\u0003BA\u0012\u0003KDq!a:\u0018\u0001\u0004\tI/A\u0006kg>tG)\u0019;bg\u0016$\bcA\u001e=\u0017\u0006\u00191m\u001d<\u0015\t\u0005\r\u0012q\u001e\u0005\u0007\u0003kA\u0002\u0019A&\u0015\t\u0005\r\u00121\u001f\u0005\b\u0003kL\u0002\u0019AAu\u0003)\u00197O\u001e#bi\u0006\u001cX\r\u001e\u000b\u0005\u0003G\tI\u0010C\u0004\u0002<i\u0001\r!!\u0010)\u0007i\t)%A\u0002y[2$B!a\t\u0003\u0002!1\u0011QG\u000eA\u0002-#B!a\t\u0003\u0006!9\u00111\b\u000fA\u0002\u0005u\u0002f\u0001\u000f\u0002FQ!\u00111\u0005B\u0006\u0011\u001d\u0011i!\ba\u0001\u0003S\f!\u0002_7m\t\u0006$\u0018m]3u\u0003\u001d\u0001\u0018M]9vKR$B!a\t\u0003\u0014!1\u0011Q\u0007\u0010A\u0002-#B!a\t\u0003\u0018!9\u00111H\u0010A\u0002\u0005u\u0002fA\u0010\u0002F\u0005\u0019qN]2\u0015\t\u0005\r\"q\u0004\u0005\u0007\u0003k\u0001\u0003\u0019A&\u0015\t\u0005\r\"1\u0005\u0005\b\u0003w\t\u0003\u0019AA\u001fQ\r\t\u0013Q\t\u000b\u0005\u0003G\u0011I\u0003\u0003\u0004\u0003,\t\u0002\raS\u0001\ni\u0006\u0014G.\u001a(b[\u0016\fA\u0001^3yiR!\u00111\u0005B\u0019\u0011\u0019\t)d\ta\u0001\u0017R!\u00111\u0005B\u001b\u0011\u001d\tY\u0004\na\u0001\u0003{A3\u0001JA#\u0003!!X\r\u001f;GS2,G\u0003BAu\u0005{Aa!!\u000e&\u0001\u0004YE\u0003BAu\u0005\u0003Bq!a\u000f'\u0001\u0004\ti\u0004K\u0002'\u0003\u000b\n1D^1mS\u0012\fG/Z*j]\u001edWMV1sS\u0006tGoQ8mk6tGC\u0001B%!\rq'1J\u0005\u0004\u0005\u001b\n&\u0001B+oSR\f!C^1mS\u0012\fG/\u001a&t_:\u001c6\r[3nC\u0006\tb/\u00197jI\u0006$X\rW7m'\u000eDW-\\1)\u0007\u0001\u0011)\u0006\u0005\u0003\u0003X\tmSB\u0001B-\u0015\r\tY%L\u0005\u0005\u0005;\u0012IF\u0001\u0004Ti\u0006\u0014G.\u001a")
public class DataFrameReader
extends org.apache.spark.sql.api.DataFrameReader<Dataset> {
    private final SparkSession sparkSession;

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> xml(String ... paths) {
        return this.xml((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        return (DataFrameReader)super.format(source);
    }

    public DataFrameReader schema(StructType schema) {
        return (DataFrameReader)super.schema(schema);
    }

    public DataFrameReader schema(String schemaString) {
        return (DataFrameReader)super.schema(schemaString);
    }

    public DataFrameReader option(String key, String value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader option(String key, boolean value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader option(String key, long value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader option(String key, double value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader options(Map<String, String> options) {
        return (DataFrameReader)super.options(options);
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        return (DataFrameReader)super.options(options);
    }

    public Dataset<Row> load() {
        return this.load((Seq)Nil$.MODULE$);
    }

    public Dataset<Row> load(String path) {
        if (this.sparkSession.sessionState().conf().legacyPathOptionBehavior()) {
            return this.option("path", path).load((Seq)package$.MODULE$.Seq().empty());
        }
        return this.load((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> load(Seq<String> paths) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("read");
        }
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        if (!legacyPathOptionBehavior && (this.extraOptions().contains("path") || this.extraOptions().contains("paths")) && paths.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenReadingError();
        }
        return (Dataset)((Object)DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.sparkSession.sessionState().conf()).flatMap((Function1 & Serializable)provider -> DataSourceV2Utils$.MODULE$.loadV2Source($this.sparkSession, (TableProvider)provider, (Option<StructType>)this.userSpecifiedSchema(), (CaseInsensitiveMap<String>)this.extraOptions(), this.source(), paths)).getOrElse((Function0 & Serializable)() -> this.loadV1Source(paths)));
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        Tuple2 tuple2;
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        Tuple2 tuple22 = tuple2 = !legacyPathOptionBehavior && paths.length() == 1 ? new Tuple2((Object)Nil$.MODULE$, (Object)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()))) : new Tuple2(paths, (Object)this.extraOptions());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq finalPaths = (Seq)tuple2._1();
        CaseInsensitiveMap finalOptions = (CaseInsensitiveMap)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)finalPaths, (Object)finalOptions);
        Seq finalPaths2 = (Seq)tuple23._1();
        CaseInsensitiveMap finalOptions2 = (CaseInsensitiveMap)tuple23._2();
        SparkSession x$1 = this.sparkSession;
        Seq x$2 = finalPaths2;
        Option x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = finalOptions2.originalMap();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, (Seq<String>)x$2, (Option<StructType>)x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        return (Dataset)super.jdbc(url, table, properties);
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        return (Dataset)super.jdbc(url, table, columnName, lowerBound, upperBound, numPartitions, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        CaseInsensitiveMap params = this.extraOptions().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(connectionProperties).asScala());
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])predicates))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String part = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new JDBCPartition(part, i);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Partition.class));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return (Dataset)super.json(path);
    }

    public Dataset<Row> json(Seq<String> paths) {
        return (Dataset)super.json(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
        StructType schema2 = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse((Function0 & Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$4(parsedOptions, x$2))));
        Function2 & Serializable createParser = (Function2 & Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions, true, JacksonParser$.MODULE$.$lessinit$greater$default$4());
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema2, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return (Dataset)super.csv(path);
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        None$ maybeFirstLine = this.userSpecifiedSchema().isEmpty() || parsedOptions.headerFlag() ? ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))) : None$.MODULE$;
        StructType schema = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse(() -> DataFrameReader.$anonfun$csv$2(this, csvDataset, (Option)maybeFirstLine, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$3(parsedOptions, x$3))));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1 & Serializable)firstLine -> {
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(actualSchema, parsedOptions, "CSV source: " + csvDataset, CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4());
            headerChecker.checkHeaderColumnNames(firstLine);
            return filteredLines.rdd().mapPartitions((Function1 & Serializable)x$4 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$4, (String)firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        }).getOrElse((Function0 & Serializable)() -> filteredLines.rdd());
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return (Dataset)super.csv(paths);
    }

    public Dataset<Row> xml(String path) {
        return (Dataset)super.xml(path);
    }

    public Dataset<Row> xml(Seq<String> paths) {
        return (Dataset)super.xml(paths);
    }

    public Dataset<Row> xml(Dataset<String> xmlDataset) {
        XmlOptions parsedOptions = new XmlOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord(), XmlOptions$.MODULE$.$lessinit$greater$default$4());
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
        StructType schema2 = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse((Function0 & Serializable)() -> TextInputXmlDataSource$.MODULE$.inferFromDataset(xmlDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$xml$4(parsedOptions, x$5))));
        RDD parsed = xmlDataset.rdd().mapPartitions((Function1 & Serializable)iter -> {
            StaxXmlParser rawParser = new StaxXmlParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema2, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, xmlDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, xmlDataset.isStreaming());
    }

    public Dataset<Row> parquet(String path) {
        return (Dataset)super.parquet(path);
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return (Dataset)super.parquet(paths);
    }

    public Dataset<Row> orc(String path) {
        return (Dataset)super.orc(path);
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return (Dataset)super.orc(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        Seq multipartIdentifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(multipartIdentifier, new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.extraOptions().toMap()).asJava()), UnresolvedRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> text(String path) {
        return (Dataset)super.text(path);
    }

    public Dataset<Row> text(Seq<String> paths) {
        return (Dataset)super.text(paths);
    }

    public Dataset<String> textFile(String path) {
        return (Dataset)super.textFile(path);
    }

    public Dataset<String> textFile(Seq<String> paths) {
        return (Dataset)super.textFile(paths);
    }

    public void validateSingleVariantColumn() {
        if (this.extraOptions().get(JSONOptions$.MODULE$.SINGLE_VARIANT_COLUMN()).isDefined() && this.userSpecifiedSchema().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.invalidSingleVariantColumn();
        }
    }

    public void validateJsonSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public void validateXmlSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$json$4(JSONOptions parsedOptions$1, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StructType $anonfun$csv$2(DataFrameReader $this, Dataset csvDataset$1, Option maybeFirstLine$1, CSVOptions parsedOptions$2) {
        return TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset$1, (Option<String>)maybeFirstLine$1, parsedOptions$2);
    }

    public static final /* synthetic */ boolean $anonfun$csv$3(CSVOptions parsedOptions$2, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$xml$4(XmlOptions parsedOptions$3, StructField x$5) {
        String string = x$5.name();
        String string2 = parsedOptions$3.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.format(sparkSession.sessionState().conf().defaultDataSourceName());
    }
}

