/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CacheManager$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tUg\u0001\u0002\u0013&\u0001ABQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001A\u0002\u0013%\u0001\nC\u0004U\u0001\u0001\u0007I\u0011B+\t\rm\u0003\u0001\u0015)\u0003J\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015Y\u0007\u0001\"\u0001\u0000\u0011\u0019Y\u0007\u0001\"\u0001\u0002>!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003k\u0002A\u0011AAG\u0011\u001d\t)\b\u0001C\u0001\u0003;Cq!!\u001e\u0001\t\u0003\tI\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u00111\u001c\u0001\u0005\n\u0005u\u0007bBAy\u0001\u0011%\u00111\u001f\u0005\t\u0005\u000b\u0001A\u0011A\u0014\u0003\b!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005\u000fBqAa\u0014\u0001\t\u0013\u0011\t\u0006\u0003\u0005\u0003V\u0001!\ta\nB,\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0005;BqAa\u0017\u0001\t\u0003\u0011)\u0007C\u0004\u0003\u0004\u0002!IA!\"\t\u000f\t=\u0005\u0001\"\u0003\u0003\u0012\"9!q\u0015\u0001\u0005\u0002\t%\u0006b\u0002BZ\u0001\u0011%!QW\u0004\b\u0005s+\u0003\u0012\u0001B^\r\u0019!S\u0005#\u0001\u0003>\"11)\tC\u0001\u0005\u007fCqA!1\"\t\u0003\u0011\u0019M\u0001\u0007DC\u000eDW-T1oC\u001e,'O\u0003\u0002'O\u0005IQ\r_3dkRLwN\u001c\u0006\u0003Q%\n1a]9m\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0005\u0001E:T\b\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003qmj\u0011!\u000f\u0006\u0003u%\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003ye\u0012q\u0001T8hO&tw\r\u0005\u0002?\u00036\tqH\u0003\u0002AK\u0005A\u0011\rZ1qi&4X-\u0003\u0002C\u007f\t9\u0012\tZ1qi&4Xm\u00159be.\u0004F.\u00198IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0003\"A\u0012\u0001\u000e\u0003\u0015\n!bY1dQ\u0016$G)\u0019;b+\u0005I\u0005c\u0001&P#6\t1J\u0003\u0002M\u001b\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u001dN\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00016J\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004\"A\u0012*\n\u0005M+#AC\"bG\",G\rR1uC\u0006q1-Y2iK\u0012$\u0015\r^1`I\u0015\fHC\u0001,Z!\t\u0011t+\u0003\u0002Yg\t!QK\\5u\u0011\u001dQ6!!AA\u0002%\u000b1\u0001\u001f\u00132\u0003-\u0019\u0017m\u00195fI\u0012\u000bG/\u0019\u0011)\u0005\u0011i\u0006C\u0001\u001a_\u0013\ty6GA\u0005ue\u0006t7/[3oi\"\u0012A!\u0019\t\u0003e\tL!aY\u001a\u0003\u0011Y|G.\u0019;jY\u0016\f!b\u00197fCJ\u001c\u0015m\u00195f)\u00051\u0016aB5t\u000b6\u0004H/_\u000b\u0002QB\u0011!'[\u0005\u0003UN\u0012qAQ8pY\u0016\fg.\u0001\u0006dC\u000eDW-U;fef$\"AV7\t\u000b9<\u0001\u0019A8\u0002\u000bE,XM]=1\u0005A4\bcA9si6\tq%\u0003\u0002tO\t9A)\u0019;bg\u0016$\bCA;w\u0019\u0001!\u0011b^7\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#\u0013'\u0005\u0002zyB\u0011!G_\u0005\u0003wN\u0012qAT8uQ&tw\r\u0005\u00023{&\u0011ap\r\u0002\u0004\u0003:LHc\u0002,\u0002\u0002\u00055\u0011Q\u0006\u0005\u0007]\"\u0001\r!a\u00011\t\u0005\u0015\u0011\u0011\u0002\t\u0005cJ\f9\u0001E\u0002v\u0003\u0013!1\"a\u0003\u0002\u0002\u0005\u0005\t\u0011!B\u0001q\n\u0019q\f\n\u001a\t\u000f\u0005=\u0001\u00021\u0001\u0002\u0012\u0005IA/\u00192mK:\u000bW.\u001a\t\u0006e\u0005M\u0011qC\u0005\u0004\u0003+\u0019$AB(qi&|g\u000e\u0005\u0003\u0002\u001a\u0005\u001db\u0002BA\u000e\u0003G\u00012!!\b4\u001b\t\tyBC\u0002\u0002\"=\na\u0001\u0010:p_Rt\u0014bAA\u0013g\u00051\u0001K]3eK\u001aLA!!\u000b\u0002,\t11\u000b\u001e:j]\u001eT1!!\n4\u0011\u001d\ty\u0003\u0003a\u0001\u0003c\tAb\u001d;pe\u0006<W\rT3wK2\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oI\u0013aB:u_J\fw-Z\u0005\u0005\u0003w\t)D\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eF\u0005W\u0003\u007f\t9%a\u0018\u0002b!1!&\u0003a\u0001\u0003\u0003\u00022!]A\"\u0013\r\t)e\n\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003\u0013J\u0001\u0019AA&\u0003-\u0001H.\u00198U_\u000e\u000b7\r[3\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u00059An\\4jG\u0006d'\u0002BA+\u0003/\nQ\u0001\u001d7b]NT1!!\u0017(\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA/\u0003\u001f\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\"9\u0011qB\u0005A\u0002\u0005E\u0001bBA\u0018\u0013\u0001\u0007\u0011\u0011G\u0001\u0013G\u0006\u001c\u0007.Z)vKJL\u0018J\u001c;fe:\fG\u000eF\u0006W\u0003O\nI'!\u001c\u0002r\u0005M\u0004B\u0002\u0016\u000b\u0001\u0004\t\t\u0005C\u0004\u0002l)\u0001\r!a\u0013\u0002!Utgn\u001c:nC2L'0\u001a3QY\u0006t\u0007bBA8\u0015\u0001\u0007\u00111J\u0001\u000f]>\u0014X.\u00197ju\u0016$\u0007\u000b\\1o\u0011\u001d\tyA\u0003a\u0001\u0003#Aq!a\f\u000b\u0001\u0004\t\t$\u0001\u0007v]\u000e\f7\r[3Rk\u0016\u0014\u0018\u0010F\u0004W\u0003s\n))!#\t\r9\\\u0001\u0019AA>a\u0011\ti(!!\u0011\tE\u0014\u0018q\u0010\t\u0004k\u0006\u0005EaCAB\u0003s\n\t\u0011!A\u0003\u0002a\u00141a\u0018\u00134\u0011\u0019\t9i\u0003a\u0001Q\u000691-Y:dC\u0012,\u0007BBAF\u0017\u0001\u0007\u0001.\u0001\u0005cY>\u001c7.\u001b8h)\u00151\u0016qRAN\u0011\u0019qG\u00021\u0001\u0002\u0012B\"\u00111SAL!\u0011\t(/!&\u0011\u0007U\f9\nB\u0006\u0002\u001a\u0006=\u0015\u0011!A\u0001\u0006\u0003A(aA0%i!1\u0011q\u0011\u0007A\u0002!$\u0012BVAP\u0003C\u000b)+a*\t\r)j\u0001\u0019AA!\u0011\u001d\t\u0019+\u0004a\u0001\u0003\u0017\nA\u0001\u001d7b]\"1\u0011qQ\u0007A\u0002!Da!a#\u000e\u0001\u0004AGc\u0002,\u0002,\u00065\u0016q\u0016\u0005\u0007U9\u0001\r!!\u0011\t\u000f\u0005\rf\u00021\u0001\u0002L!1\u0011q\u0011\bA\u0002!\fA#\u001e8dC\u000eDW-U;fefLe\u000e^3s]\u0006dG#\u0003,\u00026\u0006]\u0016\u0011XA^\u0011\u0019Qs\u00021\u0001\u0002B!9\u00111U\bA\u0002\u0005-\u0003BBAD\u001f\u0001\u0007\u0001\u000e\u0003\u0004\u0002\f>\u0001\r\u0001[\u0001\u0013k:\u001c\u0017m\u00195f)\u0006\u0014G.Z(s-&,w\u000fF\u0004W\u0003\u0003\f\u0019-!7\t\r)\u0002\u0002\u0019AA!\u0011\u001d\t)\r\u0005a\u0001\u0003\u000f\fAA\\1nKB1\u0011\u0011ZAj\u0003/qA!a3\u0002P:!\u0011QDAg\u0013\u0005!\u0014bAAig\u00059\u0001/Y2lC\u001e,\u0017\u0002BAk\u0003/\u00141aU3r\u0015\r\t\tn\r\u0005\u0007\u0003\u000f\u0003\u0002\u0019\u00015\u0002)%\u001cX*\u0019;dQ\u0016$G+\u00192mK>\u0013h+[3x)\u001dA\u0017q\\Aq\u0003GDq!a)\u0012\u0001\u0004\tY\u0005C\u0004\u0002FF\u0001\r!a2\t\u000f\u0005\u0015\u0018\u00031\u0001\u0002h\u0006!1m\u001c8g!\u0011\tI/!<\u000e\u0005\u0005-(B\u0001\u001e(\u0013\u0011\ty/a;\u0003\u000fM\u000bFjQ8oM\u0006\u0011RO\\2bG\",')_\"p]\u0012LG/[8o)%1\u0016Q_A|\u0005\u0003\u0011\u0019\u0001\u0003\u0004+%\u0001\u0007\u0011\u0011\t\u0005\b\u0003s\u0014\u0002\u0019AA~\u00035I7/T1uG\",G\r\u00157b]B1!'!@\u0002L!L1!a@4\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\u0002\bJ\u0001\r\u0001\u001b\u0005\u0007\u0003\u0017\u0013\u0002\u0019\u00015\u0002/\u0005t\u0017\r\\={K\u000e{G.^7o\u0007\u0006\u001c\u0007.Z)vKJLHc\u0002,\u0003\n\t5!q\u0002\u0005\b\u0005\u0017\u0019\u0002\u0019AA!\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0011\u001595\u00031\u0001R\u0011\u001d\u0011\tb\u0005a\u0001\u0005'\taaY8mk6t\u0007CBAe\u0003'\u0014)\u0002\u0005\u0003\u0003\u0018\tuQB\u0001B\r\u0015\u0011\u0011Y\"a\u0016\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0005?\u0011IBA\u0005BiR\u0014\u0018NY;uK\u0006i!/Z2bG\",')\u001f)mC:$RA\u0016B\u0013\u0005OAaA\u000b\u000bA\u0002\u0005\u0005\u0003bBAR)\u0001\u0007\u00111J\u0001\u0013e\u0016\u001c\u0017m\u00195f\u0005f\u001cuN\u001c3ji&|g\u000eF\u0003W\u0005[\u0011y\u0003\u0003\u0004++\u0001\u0007\u0011\u0011\t\u0005\b\u0005c)\u0002\u0019\u0001B\u001a\u0003%\u0019wN\u001c3ji&|g\u000eE\u00033\u0003{\f\u0006.\u0001\tm_>\\W\u000f]\"bG\",G\rR1uCR!!\u0011\bB\u001e!\u0011\u0011\u00141C)\t\r94\u0002\u0019\u0001B\u001fa\u0011\u0011yDa\u0011\u0011\tE\u0014(\u0011\t\t\u0004k\n\rCa\u0003B#\u0005w\t\t\u0011!A\u0003\u0002a\u00141a\u0018\u00136)\u0019\u0011ID!\u0013\u0003N!9!1J\fA\u0002\u0005\u0005\u0013aB:fgNLwN\u001c\u0005\b\u0003G;\u0002\u0019AA&\u0003aawn\\6va\u000e\u000b7\r[3e\t\u0006$\u0018-\u00138uKJt\u0017\r\u001c\u000b\u0005\u0005s\u0011\u0019\u0006C\u0004\u0002$b\u0001\r!a\u0013\u0002\u001bU\u001cXmQ1dQ\u0016$G)\u0019;b)\u0011\tYE!\u0017\t\u000f\u0005\r\u0016\u00041\u0001\u0002L\u0005i!/Z2bG\",')\u001f)bi\"$RA\u0016B0\u0005CBaA\u000b\u000eA\u0002\u0005\u0005\u0003b\u0002B25\u0001\u0007\u0011qC\u0001\re\u0016\u001cx.\u001e:dKB\u000bG\u000f\u001b\u000b\b-\n\u001d$\u0011\u000eB>\u0011\u0019Q3\u00041\u0001\u0002B!9!1M\u000eA\u0002\t-\u0004\u0003\u0002B7\u0005oj!Aa\u001c\u000b\t\tE$1O\u0001\u0003MNT1A!\u001e,\u0003\u0019A\u0017\rZ8pa&!!\u0011\u0010B8\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\tE4\u00041\u0001\u0003~A!!Q\u000eB@\u0013\u0011\u0011\tIa\u001c\u0003\u0015\u0019KG.Z*zgR,W.\u0001\tm_>\\W\u000f]!oIJ+gM]3tQR9\u0001Na\"\u0003\n\n-\u0005bBAR9\u0001\u0007\u00111\n\u0005\b\u0005cb\u0002\u0019\u0001B?\u0011\u001d\u0011i\t\ba\u0001\u0005W\nQ\"];bY&4\u0017.\u001a3QCRD\u0017a\u0007:fMJ,7\u000f\u001b$jY\u0016Le\u000eZ3y\u0013\u001atUmY3tg\u0006\u0014\u0018\u0010F\u0004i\u0005'\u0013\u0019K!*\t\u000f\tUU\u00041\u0001\u0003\u0018\u0006Ia-\u001b7f\u0013:$W\r\u001f\t\u0005\u00053\u0013y*\u0004\u0002\u0003\u001c*\u0019!QT\u0013\u0002\u0017\u0011\fG/Y:pkJ\u001cWm]\u0005\u0005\u0005C\u0013YJA\u0005GS2,\u0017J\u001c3fq\"9!\u0011O\u000fA\u0002\tu\u0004b\u0002BG;\u0001\u0007!1N\u0001\tSN\u001cVO\u0019#jeR)\u0001Na+\u00030\"9!Q\u0016\u0010A\u0002\t-\u0014aE9vC2Lg-[3e!\u0006$\b\u000eU1sK:$\bb\u0002BY=\u0001\u0007!1N\u0001\u0013cV\fG.\u001b4jK\u0012\u0004\u0016\r\u001e5DQ&dG-A\u0010hKR|%o\u00117p]\u0016\u001cVm]:j_:<\u0016\u000e\u001e5D_:4\u0017nZ:PM\u001a$B!!\u0011\u00038\"9!1J\u0010A\u0002\u0005\u0005\u0013\u0001D\"bG\",W*\u00198bO\u0016\u0014\bC\u0001$\"'\r\t\u0013g\u000e\u000b\u0003\u0005w\u000b\u0011\u0003\\8h\u0007\u0006\u001c\u0007.Z(qKJ\fG/[8o)\r1&Q\u0019\u0005\t\u0005\u000f\u001cC\u00111\u0001\u0003J\u0006\ta\rE\u00033\u0005\u0017\u0014y-C\u0002\u0003NN\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004q\tE\u0017b\u0001Bjs\tAAj\\4F]R\u0014\u0018\u0010")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void logCacheOperation(Function0<LogEntry> f) {
        CacheManager$.MODULE$.logCacheOperation(f);
    }

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$)));
        CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cleared all Dataframe cache entries"}))).log((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query) {
        this.cacheQuery(query, (Option<String>)None$.MODULE$, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQueryInternal(query.sparkSession(), query.queryExecution().analyzed(), query.queryExecution().normalized(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, planToCache, QueryExecution$.MODULE$.normalize$default$3());
        this.cacheQueryInternal(spark, planToCache, normalized, tableName, storageLevel);
    }

    private void cacheQueryInternal(SparkSession spark, LogicalPlan unnormalizedPlan, LogicalPlan normalizedPlan, Option<String> tableName, StorageLevel storageLevel) {
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null)) {
            return;
        }
        if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Asked to cache already cached data.");
            return;
        }
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        InMemoryRelation inMemoryRelation = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(unnormalizedPlan, sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
        });
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Data has already been cached.");
            } else {
                CachedData cd;
                CachedData cachedData = cd = new CachedData(normalizedPlan, inMemoryRelation);
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Added Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, (Object)cd)})))));
            }
        }
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.uncacheQueryInternal(query.sparkSession(), query.queryExecution().normalized(), cascade, blocking);
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query, cascade, false);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.uncacheQueryInternal(spark, normalized, cascade, blocking);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade) {
        this.uncacheQuery(spark, plan, cascade, false);
    }

    private void uncacheQueryInternal(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameResult((QueryPlan)plan)), cascade, blocking);
    }

    public void uncacheTableOrView(SparkSession spark, Seq<String> name, boolean cascade) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$3, (Seq<String>)name, spark.sessionState().conf())), cascade, false);
    }

    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, SQLConf conf) {
        LogicalRelation logicalRelation;
        Option<CatalogTable> option;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan2).catalogTable()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof DataSourceV2Relation) {
            DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2;
            Option option2 = dataSourceV2Relation.catalog();
            Option option3 = dataSourceV2Relation.identifier();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                CatalogPlugin catalog = (CatalogPlugin)some.value();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    Identifier v2Ident = (Identifier)some2.value();
                    return CacheManager.isSameName$1(CatalogV2Implicits$.MODULE$.IdentifierHelper(v2Ident).toQualifiedNameParts(catalog), name, conf);
                }
            }
        }
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            CatalogTable catalogTable = view.desc();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof HiveTableRelation) {
            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan2;
            CatalogTable catalogTable = hiveTableRelation.tableMeta();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        return false;
    }

    private void uncacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> isMatchedPlan, boolean cascade, boolean blocking) {
        Function1 & Serializable shouldRemove = cascade ? (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists(isMatchedPlan)) : isMatchedPlan;
        IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$2(shouldRemove, cd)));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$4(cd, x$5)))))));
        }
        plansToUncache.foreach((Function1 & Serializable)x$6 -> {
            CacheManager.$anonfun$uncacheByCondition$5(blocking, x$6);
            return BoxedUnit.UNIT;
        });
        CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " Dataframe "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SIZE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)plansToUncache.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cache entries, with logical plans being "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)((IterableOnceOps)plansToUncache.map((Function1 & Serializable)x$7 -> x$7.plan())).mkString(",\n"))})))));
        if (!cascade) {
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$9(isMatchedPlan, cd)));
            return;
        }
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        long rowCount2 = tuple22._1$mcJ$sp();
        Map newColStats2 = (Map)tuple22._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(normalized, x$9)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$11)))))));
        }
        needToRecache.foreach((Function1 & Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(query.queryExecution().normalized());
    }

    public Option<CachedData> lookupCachedData(SparkSession session, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(session, plan, QueryExecution$.MODULE$.normalize$default$3());
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalized);
    }

    public Option<CachedData> org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(LogicalPlan plan) {
        Option result;
        block0: {
            result = this.cachedData().find((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
            if (!result.isDefined()) break block0;
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit for input plan:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " matched with cache entry:"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)plan)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, result.get())})))));
        }
        return result;
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof IgnoreCachedData) {
                    IgnoreCachedData ignoreCachedData = (IgnoreCachedData)A1;
                    return (B1)ignoreCachedData;
                }
                return (B1)this.$outer.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(A1).map((Function1 & Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)cachedPlan, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            HintInfo hint = (HintInfo)tuple2._1();
                            LogicalPlan p = (LogicalPlan)tuple2._2();
                            return new ResolvedHint(p, hint);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }).getOrElse((Function0 & Serializable)() -> A1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof IgnoreCachedData) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        LogicalPlan result = newPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (result.fastEquals((TreeNode)plan)) {
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache miss for input plan:\\n", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)plan)}))));
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Last 20 Dataframe cache entry logical plans:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, (Object)((IterableOnceOps)((IndexedSeqOps)this.cachedData().take(20)).map((Function1 & Serializable)x$13 -> x$13.plan())).mkString(",\n"))})))));
        } else {
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit plan change summary:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN_COMPARISON$.MODULE$, (Object)org.apache.spark.sql.catalyst.util.package$.MODULE$.sideBySide(plan.treeString(), result.treeString()).mkString("\n"))})))));
        }
        return result;
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$14)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                return this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            }
            return false;
        }
        if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            return this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        }
        return false;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            needToRefresh = ((IterableOnceOps)fileIndex.rootPaths().map((Function1 & Serializable)x$16 -> x$16.makeQualified(fs.getUri(), fs.getWorkingDirectory()))).exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)this.isSubDir(qualifiedPath, x$17)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public boolean isSubDir(Path qualifiedPathParent, Path qualifiedPathChild) {
        return package$.MODULE$.Iterator().iterate((Object)qualifiedPathChild, (Function1 & Serializable)x$18 -> x$18.getParent()).takeWhile((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$isSubDir$2(x$19))).exists((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.equals((Object)qualifiedPathParent)));
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        .colon.colon disableConfigs;
        block0: {
            disableConfigs = new .colon.colon((Object)SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED(), (List)Nil$.MODULE$);
            if (BoxesRunTime.unboxToBoolean(session.conf().get(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING()))) break block0;
            disableConfigs = (Seq)disableConfigs.$colon$plus((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_APPLY_FINAL_STAGE_SHUFFLE_OPTIMIZATIONS());
        }
        return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, (Seq<ConfigEntry<Object>>)disableConfigs);
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    private static final boolean isSameName$1(Seq nameInCache, Seq name$2, SQLConf conf$1) {
        return nameInCache.length() == name$2.length() && ((IterableOnceOps)nameInCache.zip((IterableOnce)name$2)).forall(conf$1.resolver().tupled());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$2(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$4(CachedData cd$2, CachedData x$5) {
        return x$5 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$uncacheByCondition$5(boolean blocking$1, CachedData x$6) {
        x$6.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$9(Function1 isMatchedPlan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().exists(isMatchedPlan$1) && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan normalized$1, CachedData x$9) {
        return x$9.plan().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameResult((QueryPlan)normalized$1)));
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$3, CachedData x$11) {
        return x$11 == cd$3;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$2, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = $this.getOrCloneSessionWithConfigsOff(spark$2);
        InMemoryRelation x$1 = newCache = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan(), sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        });
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Re-cached Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, (Object)recomputedPlan)})))));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$14) {
        return x$14.plan().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$15, fs$1, qualifiedPath$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isSubDir$2(Path x$19) {
        return x$19 != null;
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
    }
}

