/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CollatedFilter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DataSourceUtils$
implements PredicateHelper {
    public static final DataSourceUtils$ MODULE$ = new DataSourceUtils$();
    private static final String PARTITIONING_COLUMNS_KEY;
    private static final String PARTITION_OVERWRITE_MODE;
    private static final String CLUSTERING_COLUMNS_KEY;
    private static final Formats formats;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        AliasHelper.$init$((AliasHelper)MODULE$);
        Logging.$init$((Logging)MODULE$);
        PredicateHelper.$init$((PredicateHelper)MODULE$);
        PARTITIONING_COLUMNS_KEY = "__partition_columns";
        PARTITION_OVERWRITE_MODE = "partitionOverwriteMode";
        CLUSTERING_COLUMNS_KEY = "__clustering_columns";
        formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String PARTITIONING_COLUMNS_KEY() {
        return PARTITIONING_COLUMNS_KEY;
    }

    public String PARTITION_OVERWRITE_MODE() {
        return PARTITION_OVERWRITE_MODE;
    }

    public String CLUSTERING_COLUMNS_KEY() {
        return CLUSTERING_COLUMNS_KEY;
    }

    private Formats formats() {
        return formats;
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Nil$.MODULE$));
    }

    public void checkFieldNames(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable)field -> {
            DataSourceUtils$.$anonfun$checkFieldNames$1(format, field);
            return BoxedUnit.UNIT;
        });
    }

    public void verifySchema(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable)field -> {
            DataSourceUtils$.$anonfun$verifySchema$1(format, field);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isDataPath(Path path) {
        return this.isDataFile(path.getName());
    }

    public boolean isDataFile(String fileName) {
        return !fileName.startsWith("_") && !fileName.startsWith(".");
    }

    public boolean supportNestedPredicatePushdown(BaseRelation relation) {
        BaseRelation baseRelation = relation;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            Seq supportedDatasources = Utils$.MODULE$.stringToSeq(((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST())).toLowerCase(Locale.ROOT));
            return supportedDatasources.contains((Object)hadoopFsRelation.toString());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private RebaseDateTime.RebaseSpec getRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig, String minVersion, String metadataKey) {
        if (!Utils$.MODULE$.isTesting()) ** GOTO lbl-1000
        v0 = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
        var7_5 = "true";
        if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
            v1 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        } else lbl-1000:
        // 2 sources

        {
            v1 = (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getRebaseSpec$1(java.lang.String scala.Function1 java.lang.String java.lang.String ), (Ljava/lang/String;)Lscala/Enumeration$Value;)((String)minVersion, lookupFileMeta, (String)metadataKey)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getRebaseSpec$2(java.lang.String ), ()Lscala/Enumeration$Value;)((String)modeByConfig));
        }
        var8_7 = policy = v1;
        v2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        var9_8 = var8_7;
        if (!(v2 != null ? v2.equals(var9_8) == false : var9_8 != null)) {
            return new RebaseDateTime.RebaseSpec(LegacyBehaviorPolicy$.MODULE$.LEGACY(), Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_TIMEZONE_METADATA_KEY())));
        }
        return new RebaseDateTime.RebaseSpec(policy, RebaseDateTime.RebaseSpec$.MODULE$.apply$default$2());
    }

    public RebaseDateTime.RebaseSpec datetimeRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.0.0", package$.MODULE$.SPARK_LEGACY_DATETIME_METADATA_KEY());
    }

    public RebaseDateTime.RebaseSpec int96RebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.1.0", package$.MODULE$.SPARK_LEGACY_INT96_METADATA_KEY());
    }

    public SparkUpgradeException newRebaseExceptionInRead(String format) {
        Tuple2 tuple2;
        block6: {
            String string = format;
            switch (string == null ? 0 : string.hashCode()) {
                case -2017918496: {
                    if (!"Parquet INT96".equals(string)) break;
                    tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.INT96_REBASE_MODE());
                    break block6;
                }
                case 2053458: {
                    if (!"Avro".equals(string)) break;
                    tuple2 = new Tuple2((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key(), (Object)"datetimeRebaseMode");
                    break block6;
                }
                case 871641556: {
                    if (!"Parquet".equals(string)) break;
                    tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.DATETIME_REBASE_MODE());
                    break block6;
                }
            }
            throw SparkException$.MODULE$.internalError("Unrecognized format " + format + ".");
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String config = (String)tuple22._1();
        String option = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)config, (Object)option);
        String config2 = (String)tuple23._1();
        String option2 = (String)tuple23._2();
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInReadingDatesError(format, config2, option2);
    }

    public SparkUpgradeException newRebaseExceptionInWrite(String format) {
        String string;
        block5: {
            String string2 = format;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -2017918496: {
                    if (!"Parquet INT96".equals(string2)) break;
                    string = SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE().key();
                    break block5;
                }
                case 2053458: {
                    if (!"Avro".equals(string2)) break;
                    string = SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE().key();
                    break block5;
                }
                case 871641556: {
                    if (!"Parquet".equals(string2)) break;
                    string = SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE().key();
                    break block5;
                }
            }
            throw SparkException$.MODULE$.internalError("Unrecognized format " + format + ".");
        }
        String config = string;
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInWritingDatesError(format, config);
    }

    public Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createTimestampRebaseFuncInRead(RebaseDateTime.RebaseSpec rebaseSpec, String format) {
        Enumeration.Value value = rebaseSpec.mode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x$2 -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(rebaseSpec.timeZone(), x$2);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> createTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            String timeZone = SQLConf$.MODULE$.get().sessionLocalTimeZone();
            return (JFunction1.mcJJ.sp & Serializable)x$3 -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(timeZone, x$3);
        }
        Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public Map<String, String> generateDatasourceOptions(CaseInsensitiveStringMap extraOptions, CatalogTable table) {
        Option pathOption = table.storage().locationUri().map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$4)));
        Map options = (Map)table.storage().properties().$plus$plus((IterableOnce)pathOption);
        if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR()))) {
            table.storage().properties().foreach((Function1 & Serializable)x0$1 -> {
                DataSourceUtils$.$anonfun$generateDatasourceOptions$2(extraOptions, table, x0$1);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set lowerCasedDuplicatedKeys = (scala.collection.immutable.Set)((SetOps)table.storage().properties().keySet().map((Function1 & Serializable)x$5 -> x$5.toLowerCase(Locale.ROOT))).intersect((Set)CollectionConverters$.MODULE$.SetHasAsScala(extraOptions.keySet()).asScala());
            return (Map)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(extraOptions.asCaseSensitiveMap()).asScala().filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$generateDatasourceOptions$4(lowerCasedDuplicatedKeys, x0$2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)options);
        }
        return options;
    }

    public Tuple2<Seq<Expression>, Seq<Expression>> getPartitionFiltersAndDataFilters(StructType partitionSchema, Seq<Expression> normalizedFilters) {
        Seq partitionColumns = (Seq)normalizedFilters.flatMap((Function1 & Serializable)expr -> expr.collect((PartialFunction)new Serializable(partitionSchema){
            private static final long serialVersionUID = 0L;
            private final StructType partitionSchema$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.partitionSchema$1.names()), (Object)attributeReference.name())) {
                        return (B1)attributeReference;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)expression;
                    if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])this.partitionSchema$1.names()), (Object)attributeReference.name())) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.partitionSchema$1 = partitionSchema$1;
            }
        }));
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply((Iterable)partitionColumns);
        Tuple2 tuple2 = normalizedFilters.partition((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$getPartitionFiltersAndDataFilters$2(partitionSet, f)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionFilters = (Seq)tuple2._1();
        Seq dataFilters = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionFilters, (Object)dataFilters);
        Seq partitionFilters2 = (Seq)tuple22._1();
        Seq dataFilters2 = (Seq)tuple22._2();
        Seq extraPartitionFilter = (Seq)dataFilters2.flatMap((Function1 & Serializable)x$7 -> MODULE$.extractPredicatesWithinOutputSet((Expression)x$7, partitionSet));
        return new Tuple2((Object)ExpressionSet$.MODULE$.apply((IterableOnce)partitionFilters2.$plus$plus((IterableOnce)extraPartitionFilter)).toSeq(), (Object)dataFilters2);
    }

    public boolean containsFiltersWithCollation(Filter filter) {
        Filter filter2;
        while (true) {
            Filter child;
            if ((filter2 = filter) instanceof And) {
                And and = (And)filter2;
                Filter left = and.left();
                Filter right = and.right();
                if (!this.containsFiltersWithCollation(left)) {
                    filter = right;
                    continue;
                }
                return true;
            }
            if (filter2 instanceof Or) {
                Or or = (Or)filter2;
                Filter left = or.left();
                Filter right = or.right();
                if (!this.containsFiltersWithCollation(left)) {
                    filter = right;
                    continue;
                }
                return true;
            }
            if (!(filter2 instanceof Not)) break;
            Not not = (Not)filter2;
            filter = child = not.child();
        }
        return filter2 instanceof CollatedFilter;
    }

    public static final /* synthetic */ void $anonfun$checkFieldNames$1(FileFormat format$1, StructField field) {
        if (!format$1.supportFieldName(field.name())) {
            throw QueryCompilationErrors$.MODULE$.invalidColumnNameAsPathError(format$1.getClass().getSimpleName(), field.name());
        }
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            MODULE$.checkFieldNames(format$1, structType);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifySchema$1(FileFormat format$2, StructField field) {
        if (!format$2.supportDataType(field.dataType())) {
            throw QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByDataSourceError(format$2.toString(), field);
        }
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$1(String minVersion$1, Function1 lookupFileMeta$1, String metadataKey$1, String version) {
        if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(version), minVersion$1) || lookupFileMeta$1.apply((Object)metadataKey$1) != null) {
            return LegacyBehaviorPolicy$.MODULE$.LEGACY();
        }
        return LegacyBehaviorPolicy$.MODULE$.CORRECTED();
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$2(String modeByConfig$1) {
        return LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig$1);
    }

    public static final /* synthetic */ void $anonfun$generateDatasourceOptions$2(CaseInsensitiveStringMap extraOptions$1, CatalogTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (extraOptions$1.containsKey((Object)k)) {
                String string = extraOptions$1.get((Object)k);
                String string2 = v;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw QueryCompilationErrors$.MODULE$.failToResolveDataSourceForTableError(table$1, k);
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateDatasourceOptions$4(scala.collection.immutable.Set lowerCasedDuplicatedKeys$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return lowerCasedDuplicatedKeys$1.contains((Object)k.toLowerCase(Locale.ROOT));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionFiltersAndDataFilters$2(AttributeSet partitionSet$1, Expression f) {
        return f.references().nonEmpty() && f.references().subsetOf(partitionSet$1);
    }

    private DataSourceUtils$() {
    }
}

