/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskOutputFileAlreadyExistException;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.ExecutedWriteSummary;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStatsTracker;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df!\u0002\r\u001a\u0003\u00031\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\")1\u000e\u0001C\u0001Y\"9!\u000f\u0001b\u0001\n#\u0019\bB\u0002=\u0001A\u0003%A\u000fC\u0004z\u0001\t\u0007I\u0011\u0003>\t\u000f\u0005\u001d\u0001\u0001)A\u0005w\"Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011CA\u0006\u0011-\t\u0019\u0002\u0001a\u0001\u0002\u0004%\t\"!\u0006\t\u0017\u0005\u0005\u0002\u00011A\u0001B\u0003&\u0011Q\u0002\u0005\n\u0003G\u0001!\u0019!C\t\u0003KA\u0001\"a\u0010\u0001A\u0003%\u0011q\u0005\u0005\b\u0003\u0003\u0002A\u0011CA\"\u0011\u001d\t)\u0005\u0001C\t\u0003\u0007Bq!a\u0012\u0001\t\u0013\tI\u0005\u0003\u00043\u0001\u0019\u0005\u0011Q\u000f\u0005\b\u0003w\u0002AQAA?\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!!'\u0001\t\u000b\nY\nC\u0004\u0002$\u0002!)!a\u0011\t\u000f\u0005\u0015\u0006\u0001\"\u0012\u0002D\t!b)\u001b7f\r>\u0014X.\u0019;ECR\fwK]5uKJT!AG\u000e\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00039u\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005yy\u0012aA:rY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019s\u0006\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005!A.\u00198h\u0015\u0005a\u0013\u0001\u00026bm\u0006L!AL\u0015\u0003\r=\u0013'.Z2u!\r\u0001TgN\u0007\u0002c)\u0011!gM\u0001\u0006oJLG/\u001a\u0006\u0003iu\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005Y\n$A\u0003#bi\u0006<&/\u001b;feB\u0011\u0001hO\u0007\u0002s)\u0011!(H\u0001\tG\u0006$\u0018\r\\=ti&\u0011A(\u000f\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0006eKN\u001c'/\u001b9uS>t\u0007CA A\u001b\u0005I\u0012BA!\u001a\u0005M9&/\u001b;f\u0015>\u0014G)Z:de&\u0004H/[8o\u0003I!\u0018m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015!C7baJ,G-^2f\u0015\tA\u0015%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0015\u0016\u0013!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u0006I1m\\7nSR$XM\u001d\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000b!![8\u000b\u0005E{\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005Ms%A\u0005$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2\fQbY;ti>lW*\u001a;sS\u000e\u001c\b\u0003\u0002,`E\u0016t!aV/\u0011\u0005a[V\"A-\u000b\u0005i+\u0013A\u0002\u001fs_>$hHC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6,\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u00141!T1q\u0015\tq6\f\u0005\u0002WG&\u0011A-\u0019\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005\u0019LW\"A4\u000b\u0005!\\\u0012AB7fiJL7-\u0003\u0002kO\nI1+\u0015'NKR\u0014\u0018nY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b5tw\u000e]9\u0011\u0005}\u0002\u0001\"B\u001f\u0006\u0001\u0004q\u0004\"\u0002\"\u0006\u0001\u0004\u0019\u0005\"B&\u0006\u0001\u0004a\u0005\"\u0002+\u0006\u0001\u0004)\u0016\u0001E'B1~3\u0015\nT#`\u0007>+f\nV#S+\u0005!\bCA;w\u001b\u0005Y\u0016BA<\\\u0005\rIe\u000e^\u0001\u0012\u001b\u0006CvLR%M\u000b~\u001bu*\u0016(U\u000bJ\u0003\u0013!E;qI\u0006$X\r\u001a)beRLG/[8ogV\t1\u0010\u0005\u0003}\u0003\u0007\u0011W\"A?\u000b\u0005y|\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003Y\u0016AC2pY2,7\r^5p]&\u0019\u0011QA?\u0003\u0007M+G/\u0001\nva\u0012\fG/\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013!D2veJ,g\u000e^,sSR,'/\u0006\u0002\u0002\u000eA\u0019q(a\u0004\n\u0007\u0005E\u0011D\u0001\u0007PkR\u0004X\u000f^,sSR,'/A\tdkJ\u0014XM\u001c;Xe&$XM]0%KF$B!a\u0006\u0002\u001eA\u0019Q/!\u0007\n\u0007\u0005m1L\u0001\u0003V]&$\b\"CA\u0010\u0017\u0005\u0005\t\u0019AA\u0007\u0003\rAH%M\u0001\u000fGV\u0014(/\u001a8u/JLG/\u001a:!\u00035\u0019H/\u0019;t)J\f7m[3sgV\u0011\u0011q\u0005\t\u0007\u0003S\t\u0019$!\u000f\u000f\t\u0005-\u0012q\u0006\b\u00041\u00065\u0012\"\u0001/\n\u0007\u0005E2,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\u0004'\u0016\f(bAA\u00197B\u0019q(a\u000f\n\u0007\u0005u\u0012DA\u000bXe&$X\rV1tWN#\u0018\r^:Ue\u0006\u001c7.\u001a:\u0002\u001dM$\u0018\r^:Ue\u0006\u001c7.\u001a:tA\u0005!\"/\u001a7fCN,7)\u001e:sK:$xK]5uKJ$\"!a\u0006\u0002!I,G.Z1tKJ+7o\\;sG\u0016\u001c\u0018\u0001E3oe&\u001c\u0007n\u0016:ji\u0016,%O]8s+\u0011\tY%a\u0015\u0015\t\u00055\u0013q\u000e\u000b\u0005\u0003\u001f\n)\u0007\u0005\u0003\u0002R\u0005MC\u0002\u0001\u0003\b\u0003+\n\"\u0019AA,\u0005\u0005!\u0016\u0003BA-\u0003?\u00022!^A.\u0013\r\tif\u0017\u0002\b\u001d>$\b.\u001b8h!\r)\u0018\u0011M\u0005\u0004\u0003GZ&aA!os\"A\u0011qM\t\u0005\u0002\u0004\tI'A\u0001g!\u0015)\u00181NA(\u0013\r\tig\u0017\u0002\ty\tLh.Y7f}!A\u0011\u0011O\t\u0005\u0002\u0004\t\u0019(\u0001\u0003qCRD\u0007\u0003B;\u0002l\t$B!a\u0006\u0002x!1\u0011\u0011\u0010\nA\u0002]\naA]3d_J$\u0017\u0001E<sSR,w+\u001b;i\u001b\u0016$(/[2t)\u0019\t9\"a \u0002\u0002\"1\u0011\u0011P\nA\u0002]Bq!a!\u0014\u0001\u0004\t))A\u0003d_VtG\u000fE\u0002v\u0003\u000fK1!!#\\\u0005\u0011auN\\4\u0002#]\u0014\u0018\u000e^3XSRD\u0017\n^3sCR|'\u000f\u0006\u0003\u0002\u0018\u0005=\u0005bBAI)\u0001\u0007\u00111S\u0001\tSR,'/\u0019;peB)\u0011\u0011FAKo%!\u0011qSA\u001c\u0005!IE/\u001a:bi>\u0014\u0018AB2p[6LG\u000f\u0006\u0002\u0002\u001eB\u0019q(a(\n\u0007\u0005\u0005\u0016DA\bXe&$X\rV1tWJ+7/\u001e7u\u0003\u0015\t'm\u001c:u\u0003\u0015\u0019Gn\\:f\u0001")
public abstract class FileFormatDataWriter
implements DataWriter<InternalRow> {
    private final WriteJobDescription description;
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private final Map<String, SQLMetric> customMetrics;
    private final int MAX_FILE_COUNTER;
    private final Set<String> updatedPartitions;
    private OutputWriter currentWriter;
    private final Seq<WriteTaskStatsTracker> statsTrackers;

    public void writeAll(java.util.Iterator<InternalRow> x$1) throws IOException {
        super.writeAll(x$1);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public int MAX_FILE_COUNTER() {
        return this.MAX_FILE_COUNTER;
    }

    public Set<String> updatedPartitions() {
        return this.updatedPartitions;
    }

    public OutputWriter currentWriter() {
        return this.currentWriter;
    }

    public void currentWriter_$eq(OutputWriter x$1) {
        this.currentWriter = x$1;
    }

    public Seq<WriteTaskStatsTracker> statsTrackers() {
        return this.statsTrackers;
    }

    public void releaseCurrentWriter() {
        if (this.currentWriter() != null) {
            try {
                this.currentWriter().close();
                this.statsTrackers().foreach((Function1 & Serializable)x$3 -> {
                    x$3.closeFile(this.currentWriter().path());
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                this.currentWriter_$eq(null);
            }
            return;
        }
    }

    public void releaseResources() {
        this.releaseCurrentWriter();
    }

    private <T> T enrichWriteError(Function0<String> path, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FetchFailedException) {
                FetchFailedException fetchFailedException = (FetchFailedException)throwable2;
                throw fetchFailedException;
            }
            if (throwable2 instanceof FileAlreadyExistsException) {
                FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                if (SQLConf$.MODULE$.get().fastFailFileFormatOutput()) {
                    throw new TaskOutputFileAlreadyExistException((Throwable)fileAlreadyExistsException);
                }
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw QueryExecutionErrors$.MODULE$.taskFailedWhileWritingRowsError((String)path.apply(), throwable3);
            }
            throw throwable;
        }
        return (T)object;
    }

    public abstract void write(InternalRow var1);

    public final void writeWithMetrics(InternalRow record, long count) {
        if (count % (long)CustomMetrics$.MODULE$.NUM_ROWS_PER_UPDATE() == 0L) {
            CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.currentMetricsValues()).toImmutableArraySeq(), this.customMetrics);
        }
        this.enrichWriteError((Function0<String>)(Function0 & Serializable)() -> (String)Option$.MODULE$.apply((Object)this.currentWriter()).map((Function1 & Serializable)x$4 -> x$4.path()).getOrElse((Function0 & Serializable)() -> $this.description.path()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.write(record));
    }

    public void writeWithIterator(Iterator<InternalRow> iterator) {
        long count = 0L;
        while (iterator.hasNext()) {
            this.writeWithMetrics((InternalRow)iterator.next(), count);
            ++count;
        }
        CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.currentMetricsValues()).toImmutableArraySeq(), this.customMetrics);
    }

    public final WriteTaskResult commit() {
        return (WriteTaskResult)this.enrichWriteError((Function0<String>)(Function0 & Serializable)() -> $this.description.path(), (Function0 & Serializable)() -> {
            this.releaseResources();
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> $this.committer.commitTask($this.taskAttemptContext));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FileCommitProtocol.TaskCommitMessage taskCommitMessage = (FileCommitProtocol.TaskCommitMessage)tuple2._1();
            long taskCommitTime = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)taskCommitMessage, (Object)BoxesRunTime.boxToLong((long)taskCommitTime));
            FileCommitProtocol.TaskCommitMessage taskCommitMessage2 = (FileCommitProtocol.TaskCommitMessage)tuple22._1();
            long taskCommitTime2 = tuple22._2$mcJ$sp();
            ExecutedWriteSummary summary = new ExecutedWriteSummary((scala.collection.immutable.Set<String>)this.updatedPartitions().toSet(), (Seq<WriteTaskStats>)((Seq)this.statsTrackers().map((Function1 & Serializable)x$6 -> x$6.getFinalStats(taskCommitTime2))));
            return new WriteTaskResult(taskCommitMessage2, summary);
        });
    }

    public final void abort() {
        this.enrichWriteError((Function0<String>)(Function0 & Serializable)() -> $this.description.path(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                this.releaseResources();
            }
            finally {
                $this.committer.abortTask($this.taskAttemptContext);
            }
        });
    }

    public final void close() {
    }

    public FileFormatDataWriter(WriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer, Map<String, SQLMetric> customMetrics) {
        this.description = description;
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        this.customMetrics = customMetrics;
        this.MAX_FILE_COUNTER = 1000000;
        this.updatedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.statsTrackers = (Seq)description.statsTrackers().map((Function1 & Serializable)x$2 -> x$2.newTaskInstance());
    }
}

