/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BloomFilterMightContain;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.FileSourceConstantMetadataStructField$;
import org.apache.spark.sql.catalyst.expressions.FileSourceGeneratedMetadataStructField$;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNaN;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.planning.ScanOperation$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FileSourceScanExec$;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.FileSourceStrategy$MetadataStructColumn$1$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.collection.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class FileSourceStrategy$
extends SparkStrategy
implements PredicateHelper {
    public static final FileSourceStrategy$ MODULE$ = new FileSourceStrategy$();

    static {
        AliasHelper.$init$((AliasHelper)MODULE$);
        PredicateHelper.$init$((PredicateHelper)MODULE$);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private boolean shouldPruneBuckets(Option<BucketSpec> bucketSpec) {
        Option<BucketSpec> option = bucketSpec;
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketSpec spec = (BucketSpec)some.value();
            return spec.bucketColumnNames().length() == 1 && spec.numBuckets() > 1;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    private BitSet getExpressionBuckets(Expression expr, String bucketColumnName, int numBuckets) {
        Expression a;
        IsNull isNull;
        Expression a2;
        BinaryComparison binaryComparison;
        Option option;
        boolean bl = false;
        IsNaN isNaN = null;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a3 = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a3 instanceof Attribute) {
                Attribute attribute = (Attribute)a3;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    String string = attribute.name();
                    String string2 = bucketColumnName;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return FileSourceStrategy$.getBucketSetFromValue$1(attribute, v, numBuckets);
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression a4 = in.value();
            Seq list = in.list();
            if (a4 instanceof Attribute) {
                Attribute attribute = (Attribute)a4;
                if (list.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$getExpressionBuckets$3(x$1)))) {
                    String string = attribute.name();
                    String string3 = bucketColumnName;
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable)e -> e.eval(package$.MODULE$.EmptyRow())), numBuckets);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression a5 = inSet.child();
            Set hset = inSet.hset();
            if (a5 instanceof Attribute) {
                Attribute attribute = (Attribute)a5;
                String string = attribute.name();
                String string4 = bucketColumnName;
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    return FileSourceStrategy$.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                }
            }
        }
        if (expression instanceof IsNull && (a2 = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a2;
            String string = attribute.name();
            String string5 = bucketColumnName;
            if (!(string != null ? !string.equals(string5) : string5 != null)) {
                return FileSourceStrategy$.getBucketSetFromValue$1(attribute, null, numBuckets);
            }
        }
        if (expression instanceof IsNaN) {
            bl = true;
            isNaN = (IsNaN)expression;
            Expression a6 = isNaN.child();
            if (a6 instanceof Attribute) {
                Attribute attribute = (Attribute)a6;
                String string = attribute.name();
                String string6 = bucketColumnName;
                if (!(string != null ? !string.equals(string6) : string6 != null)) {
                    DataType dataType = attribute.dataType();
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    if (!(dataType != null ? !dataType.equals(floatType$) : floatType$ != null)) {
                        return FileSourceStrategy$.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToFloat((float)Float.NaN), numBuckets);
                    }
                }
            }
        }
        if (bl && (a = isNaN.child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a;
            String string = attribute.name();
            String string7 = bucketColumnName;
            if (!(string != null ? !string.equals(string7) : string7 != null)) {
                DataType dataType = attribute.dataType();
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(doubleType$) : doubleType$ != null)) {
                    return FileSourceStrategy$.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToDouble((double)Double.NaN), numBuckets);
                }
            }
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$amp(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.getExpressionBuckets(left, bucketColumnName, numBuckets).$bar(this.getExpressionBuckets(right, bucketColumnName, numBuckets));
        }
        BitSet matchedBuckets = new BitSet(numBuckets);
        matchedBuckets.setUntil(numBuckets);
        return matchedBuckets;
    }

    private Option<BitSet> genBucketSet(Seq<Expression> normalizedFilters, BucketSpec bucketSpec) {
        if (normalizedFilters.isEmpty()) {
            return None$.MODULE$;
        }
        String bucketColumnName = (String)bucketSpec.bucketColumnNames().head();
        int numBuckets = bucketSpec.numBuckets();
        Expression normalizedFiltersAndExpr = (Expression)normalizedFilters.reduce((Function2)And$.MODULE$);
        BitSet matchedBuckets = this.getExpressionBuckets(normalizedFiltersAndExpr, bucketColumnName, numBuckets);
        int numBucketsSelected = matchedBuckets.cardinality();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Pruned ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_PRUNED$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(numBuckets - numBucketsSelected)))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"out of ", " buckets."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TOTAL$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)numBuckets))})))));
        if (numBucketsSelected == numBuckets) {
            return None$.MODULE$;
        }
        return new Some((Object)matchedBuckets);
    }

    public Seq<SparkPlan> apply(LogicalPlan plan2) {
        Option option;
        LogicalPlan logicalPlan2 = plan2;
        if (logicalPlan2 != null && !(option = ScanOperation$.MODULE$.unapply(logicalPlan2)).isEmpty()) {
            Seq projects = (Seq)((Tuple4)option.get())._1();
            Seq stayUpFilters = (Seq)((Tuple4)option.get())._2();
            Seq filters = (Seq)((Tuple4)option.get())._3();
            LogicalPlan l = (LogicalPlan)((Tuple4)option.get())._4();
            if (l instanceof LogicalRelation) {
                LogicalRelation logicalRelation = (LogicalRelation)l;
                BaseRelation fsRelation = logicalRelation.relation();
                Option<CatalogTable> table = logicalRelation.catalogTable();
                if (fsRelation instanceof HadoopFsRelation) {
                    SparkPlan withProjections;
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
                    LazyRef MetadataStructColumn$module = new LazyRef();
                    ExpressionSet filterSet = ExpressionSet$.MODULE$.apply((IterableOnce)filters);
                    Seq<Expression> normalizedFilters = DataSourceStrategy$.MODULE$.normalizeExprs((Seq<Expression>)((Seq)filters.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.deterministic()))), logicalRelation.output());
                    Seq partitionColumns = logicalRelation.resolve(hadoopFsRelation.partitionSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
                    AttributeSet partitionSet = AttributeSet$.MODULE$.apply((Iterable)partitionColumns);
                    ExpressionSet partitionKeyFilters = DataSourceStrategy$.MODULE$.getPushedDownFilters((Seq<Expression>)partitionColumns, normalizedFilters);
                    Option<BucketSpec> bucketSpec = hadoopFsRelation.bucketSpec();
                    Option<BitSet> bucketSet = this.shouldPruneBuckets(bucketSpec) ? this.genBucketSet(normalizedFilters, (BucketSpec)bucketSpec.get()) : None$.MODULE$;
                    Seq dataColumns = logicalRelation.resolve(hadoopFsRelation.dataSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver());
                    Seq dataColumnsWithoutPartitionCols = (Seq)dataColumns.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionSet.contains(elem)));
                    Seq normalizedFiltersWithScalarSubqueries = (Seq)((IterableOps)normalizedFilters.filterNot((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$apply$3(e)))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$apply$4(x$3)));
                    Seq dataFilters = (Seq)normalizedFiltersWithScalarSubqueries.flatMap((Function1 & Serializable)f -> {
                        if (f.references().intersect(partitionSet).nonEmpty()) {
                            return MODULE$.extractPredicatesWithinOutputSet((Expression)f, AttributeSet$.MODULE$.apply((Iterable)dataColumnsWithoutPartitionCols));
                        }
                        return new Some(f);
                    });
                    boolean supportNestedPredicatePushdown = DataSourceUtils$.MODULE$.supportNestedPredicatePushdown(hadoopFsRelation);
                    Seq pushedFilters = (Seq)dataFilters.flatMap((Function1 & Serializable)x$4 -> DataSourceStrategy$.MODULE$.translateFilter((Expression)x$4, supportNestedPredicatePushdown));
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed Filters: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PUSHED_FILTERS$.MODULE$, (Object)pushedFilters.mkString(","))}))));
                    ExpressionSet afterScanFilters = filterSet.$minus$minus((IterableOnce)partitionKeyFilters.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileSourceStrategy$.$anonfun$apply$8(x$5))));
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Post-Scan Filters: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.POST_SCAN_FILTERS$.MODULE$, (Object)afterScanFilters.mkString(","))}))));
                    AttributeSet filterAttributes = AttributeSet$.MODULE$.apply((Iterable)afterScanFilters.$plus$plus((IterableOnce)stayUpFilters));
                    Seq requiredExpressions = (Seq)filterAttributes.toSeq().$plus$plus((IterableOnce)projects);
                    AttributeSet requiredAttributes = AttributeSet$.MODULE$.apply((Iterable)requiredExpressions);
                    Seq readDataColumns = (Seq)dataColumnsWithoutPartitionCols.filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredAttributes.contains(elem)));
                    Option metadataStructOpt = logicalRelation.output().collectFirst((PartialFunction)new Serializable(MetadataStructColumn$module, hadoopFsRelation){
                        private static final long serialVersionUID = 0L;
                        private final LazyRef MetadataStructColumn$module$1;
                        private final HadoopFsRelation x6$1;

                        public final <A1 extends AttributeReference, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Option<AttributeReference> option;
                            A1 A1 = x1;
                            if (A1 != null && !(option = FileSourceStrategy$.MODULE$.org$apache$spark$sql$execution$datasources$FileSourceStrategy$$MetadataStructColumn$2(this.MetadataStructColumn$module$1, this.x6$1).unapply(A1)).isEmpty()) {
                                AttributeReference attr = (AttributeReference)option.get();
                                return (B1)attr;
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(AttributeReference x1) {
                            Option<AttributeReference> option;
                            AttributeReference attributeReference = x1;
                            return attributeReference != null && !(option = FileSourceStrategy$.MODULE$.org$apache$spark$sql$execution$datasources$FileSourceStrategy$$MetadataStructColumn$2(this.MetadataStructColumn$module$1, this.x6$1).unapply(attributeReference)).isEmpty();
                        }
                        {
                            this.MetadataStructColumn$module$1 = MetadataStructColumn$module$1;
                            this.x6$1 = x6$1;
                        }
                    });
                    Buffer constantMetadataColumns = (Buffer)Buffer$.MODULE$.empty();
                    Buffer generatedMetadataColumns = (Buffer)Buffer$.MODULE$.empty();
                    Map metadataColumnsByName = (Map)Map$.MODULE$.empty();
                    metadataStructOpt.foreach((Function1 & Serializable)metadataStruct -> {
                        FileSourceStrategy$.$anonfun$apply$11(readDataColumns, partitionColumns, metadataColumnsByName, generatedMetadataColumns, constantMetadataColumns, metadataStruct);
                        return BoxedUnit.UNIT;
                    });
                    StructType outputDataSchema = package$.MODULE$.AttributeSeq((Seq)readDataColumns.$plus$plus((IterableOnce)generatedMetadataColumns)).toStructType();
                    Seq outputAttributes = (Seq)((IterableOps)((IterableOps)readDataColumns.$plus$plus((IterableOnce)generatedMetadataColumns)).$plus$plus((IterableOnce)partitionColumns)).$plus$plus((IterableOnce)constantMetadataColumns);
                    FileSourceScanExec scan = new FileSourceScanExec(hadoopFsRelation, (Seq<Attribute>)outputAttributes, outputDataSchema, (Seq<Expression>)partitionKeyFilters.toSeq(), bucketSet, (Option<Object>)None$.MODULE$, (Seq<Expression>)FileSourceStrategy$.rebindFileSourceMetadataAttributesInFilters$1(dataFilters, metadataColumnsByName, MetadataStructColumn$module, hadoopFsRelation), (Option<TableIdentifier>)table.map((Function1 & Serializable)x$7 -> x$7.identifier()), FileSourceScanExec$.MODULE$.apply$default$9());
                    SparkPlan withMetadataProjections = (SparkPlan)metadataStructOpt.map((Function1 & Serializable)metadataStruct -> {
                        Attribute[] structColumns = (Attribute[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)metadataStruct.dataType()).fields()), (Function1 & Serializable)field -> ((Attribute)metadataColumnsByName.apply((Object)field.name())).withName(field.name()).withNullability(field.nullable()), ClassTag$.MODULE$.apply(Attribute.class));
                        KnownNotNull x$5 = new KnownNotNull((Expression)CreateStruct$.MODULE$.apply((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)structColumns).toImmutableArraySeq()));
                        String x$6 = FileFormat$.MODULE$.METADATA_NAME();
                        ExprId x$7 = metadataStruct.exprId();
                        Seq x$8 = Alias$.MODULE$.apply$default$4((Expression)x$5, x$6);
                        Option x$9 = Alias$.MODULE$.apply$default$5((Expression)x$5, x$6);
                        Seq x$10 = Alias$.MODULE$.apply$default$6((Expression)x$5, x$6);
                        Alias metadataAlias = new Alias((Expression)x$5, x$6, x$7, x$8, x$9, x$10);
                        return new ProjectExec((Seq<NamedExpression>)((Seq)((SeqOps)readDataColumns.$plus$plus((IterableOnce)partitionColumns)).$colon$plus((Object)metadataAlias)), scan);
                    }).getOrElse((Function0 & Serializable)() -> scan);
                    Seq finalFilters = (Seq)Option$.MODULE$.option2Iterable(afterScanFilters.toSeq().reduceOption((Function2)And$.MODULE$)).toSeq().$plus$plus((IterableOnce)stayUpFilters);
                    SparkPlan withFilter = (SparkPlan)finalFilters.foldLeft((Object)withMetadataProjections, (Function2 & Serializable)(plan, cond) -> new FilterExec((Expression)cond, (SparkPlan)plan));
                    Seq seq = projects;
                    Seq seq2 = withFilter.output();
                    SparkPlan sparkPlan = withProjections = !(seq != null ? !seq.equals(seq2) : seq2 != null) ? withFilter : new ProjectExec((Seq<NamedExpression>)projects, withFilter);
                    return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
                }
            }
        }
        return Nil$.MODULE$;
    }

    private static final int getBucketNumber$1(Attribute attr, Object v, int numBuckets$1) {
        return BucketingUtils$.MODULE$.getBucketIdFromValue(attr, numBuckets$1, v);
    }

    private static final BitSet getBucketSetFromIterable$1(Attribute attr, Iterable iter, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        ((IterableOnceOps)iter.map((Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)FileSourceStrategy$.getBucketNumber$1(attr, v, numBuckets$1)))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)bucketNum -> matchedBuckets.set(bucketNum));
        return matchedBuckets;
    }

    private static final BitSet getBucketSetFromValue$1(Attribute attr, Object v, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        matchedBuckets.set(FileSourceStrategy$.getBucketNumber$1(attr, v, numBuckets$1));
        return matchedBuckets;
    }

    public static final /* synthetic */ boolean $anonfun$getExpressionBuckets$3(Expression x$1) {
        return x$1 instanceof Literal;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Expression e) {
        return e.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION()) && !e.containsPattern(TreePattern$.MODULE$.SCALAR_SUBQUERY());
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(Expression x$3) {
        return x$3 instanceof BloomFilterMightContain;
    }

    public static final /* synthetic */ boolean $anonfun$apply$8(Expression x$5) {
        return x$5.references().nonEmpty();
    }

    private static final /* synthetic */ FileSourceStrategy$MetadataStructColumn$1$ MetadataStructColumn$lzycompute$1(LazyRef MetadataStructColumn$module$1, HadoopFsRelation x6$1) {
        FileSourceStrategy$MetadataStructColumn$1$ fileSourceStrategy$MetadataStructColumn$1$;
        LazyRef lazyRef = MetadataStructColumn$module$1;
        synchronized (lazyRef) {
            fileSourceStrategy$MetadataStructColumn$1$ = MetadataStructColumn$module$1.initialized() ? (FileSourceStrategy$MetadataStructColumn$1$)MetadataStructColumn$module$1.value() : (FileSourceStrategy$MetadataStructColumn$1$)MetadataStructColumn$module$1.initialize((Object)new FileSourceStrategy$MetadataStructColumn$1$(x6$1));
        }
        return fileSourceStrategy$MetadataStructColumn$1$;
    }

    public final FileSourceStrategy$MetadataStructColumn$1$ org$apache$spark$sql$execution$datasources$FileSourceStrategy$$MetadataStructColumn$2(LazyRef MetadataStructColumn$module$1, HadoopFsRelation x6$1) {
        if (MetadataStructColumn$module$1.initialized()) {
            return (FileSourceStrategy$MetadataStructColumn$1$)MetadataStructColumn$module$1.value();
        }
        return FileSourceStrategy$.MetadataStructColumn$lzycompute$1(MetadataStructColumn$module$1, x6$1);
    }

    public static final /* synthetic */ void $anonfun$apply$11(Seq readDataColumns$1, Seq partitionColumns$1, Map metadataColumnsByName$1, Buffer generatedMetadataColumns$1, Buffer constantMetadataColumns$1, AttributeReference metadataStruct) {
        Set schemaColumns = ((IterableOnceOps)((IterableOps)readDataColumns$1.$plus$plus((IterableOnce)partitionColumns$1)).map((Function1 & Serializable)x$6 -> x$6.name().toLowerCase(Locale.ROOT))).toSet();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)metadataStruct.dataType()).fields()), (Function1 & Serializable)x0$1 -> {
            Option option;
            Option option2;
            StructField structField = x0$1;
            if (structField != null && !(option2 = FileSourceGeneratedMetadataStructField$.MODULE$.unapply(structField)).isEmpty()) {
                StructField field = (StructField)((Tuple2)option2.get())._1();
                String internalName = (String)((Tuple2)option2.get())._2();
                if (schemaColumns.contains((Object)internalName)) {
                    throw new AnalysisException("_LEGACY_ERROR_TEMP_3069", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"internalName"), (Object)internalName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)(FileFormat$.MODULE$.METADATA_NAME() + "." + field.name()))})));
                }
                String x$1 = internalName;
                boolean x$2 = true;
                DataType x$3 = field.copy$default$2();
                Metadata x$4 = field.copy$default$4();
                AttributeReference attr = DataTypeUtils$.MODULE$.toAttribute(field.copy(x$1, x$3, true, x$4));
                metadataColumnsByName$1.put((Object)field.name(), (Object)attr);
                return (Buffer)generatedMetadataColumns$1.$plus$eq((Object)attr);
            }
            if (structField != null && !(option = FileSourceConstantMetadataStructField$.MODULE$.unapply(structField)).isEmpty()) {
                StructField field = (StructField)option.get();
                AttributeReference attr = DataTypeUtils$.MODULE$.toAttribute(field);
                metadataColumnsByName$1.put((Object)field.name(), (Object)attr);
                return (Buffer)constantMetadataColumns$1.$plus$eq((Object)attr);
            }
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3070", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)structField.toString())})));
        });
    }

    private static final Seq rebindFileSourceMetadataAttributesInFilters$1(Seq filters, Map metadataColumnsByName$1, LazyRef MetadataStructColumn$module$1, HadoopFsRelation x6$1) {
        return (Seq)filters.map((Function1 & Serializable)filter -> (Expression)filter.transform((PartialFunction)new Serializable(metadataColumnsByName$1, MetadataStructColumn$module$1, x6$1){
            private static final long serialVersionUID = 0L;
            private final Map metadataColumnsByName$1;
            private final LazyRef MetadataStructColumn$module$1;
            private final HadoopFsRelation x6$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    DataType fields;
                    AttributeReference attributeReference;
                    AttributeReference attributeReference2 = (AttributeReference)A1;
                    Option<AttributeReference> option = FileSourceStrategy$.MODULE$.org$apache$spark$sql$execution$datasources$FileSourceStrategy$$MetadataStructColumn$2(this.MetadataStructColumn$module$1, this.x6$1).unapply(attributeReference2);
                    if (!option.isEmpty() && (attributeReference = (AttributeReference)option.get()) != null && (fields = attributeReference.dataType()) instanceof StructType) {
                        StructType structType = (StructType)fields;
                        Seq reboundFields = (Seq)structType.map((Function1 & Serializable)field -> (Attribute)$this.metadataColumnsByName$1.apply((Object)field.name()));
                        return (B1)CreateStruct$.MODULE$.apply(reboundFields);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof AttributeReference) {
                    DataType fields;
                    AttributeReference attributeReference;
                    AttributeReference attributeReference2 = (AttributeReference)expression;
                    Option<AttributeReference> option = FileSourceStrategy$.MODULE$.org$apache$spark$sql$execution$datasources$FileSourceStrategy$$MetadataStructColumn$2(this.MetadataStructColumn$module$1, this.x6$1).unapply(attributeReference2);
                    if (!option.isEmpty() && (attributeReference = (AttributeReference)option.get()) != null && (fields = attributeReference.dataType()) instanceof StructType) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.metadataColumnsByName$1 = metadataColumnsByName$1;
                this.MetadataStructColumn$module$1 = MetadataStructColumn$module$1;
                this.x6$1 = x6$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.datasources.FileSourceStrategy$$anonfun$$nestedInanonfun$apply$14$1 org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        }).transform((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof GetStructField) {
                    GetStructField getStructField = (GetStructField)A1;
                    Expression createNamedStruct = getStructField.child();
                    int ordinal = getStructField.ordinal();
                    if (createNamedStruct instanceof CreateNamedStruct) {
                        CreateNamedStruct createNamedStruct2 = (CreateNamedStruct)createNamedStruct;
                        return (B1)createNamedStruct2.valExprs().apply(ordinal);
                    }
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                GetStructField getStructField;
                Expression createNamedStruct;
                Expression expression = x2;
                return expression instanceof GetStructField && (createNamedStruct = (getStructField = (GetStructField)expression).child()) instanceof CreateNamedStruct;
            }
        }));
    }

    private FileSourceStrategy$() {
    }
}

