/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CsvOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\u0007\u000e\u0001qAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1BQA\u000f\u0001\u0005BmBQ!\u0016\u0001\u0005BYCQ\u0001\u001d\u0001\u0005BEDq!a\u0001\u0001\t\u0003\n)\u0001\u0003\u0004\u0002P\u0001!\t\u0005\f\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\tY\u0006\u0001C!\u0003;Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002x\u0001!\t%!\u001f\u0003\u001b\r\u001bfKR5mK\u001a{'/\\1u\u0015\tqq\"A\u0002dgZT!\u0001E\t\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003%M\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001i\u0012\u0005\u0005\u0002\u001f?5\tq\"\u0003\u0002!\u001f\t\u0019B+\u001a=u\u0005\u0006\u001cX\r\u001a$jY\u00164uN]7biB\u0011!%J\u0007\u0002G)\u0011AeE\u0001\bg>,(oY3t\u0013\t13E\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u000e\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u0001.!\tqsG\u0004\u00020kA\u0011\u0001gM\u0007\u0002c)\u0011!gG\u0001\u0007yI|w\u000e\u001e \u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003mM\n1\"[:Ta2LG/\u00192mKR!A\b\u0011$L!\tid(D\u00014\u0013\ty4GA\u0004C_>dW-\u00198\t\u000b\u0005\u001b\u0001\u0019\u0001\"\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\r#U\"A\n\n\u0005\u0015\u001b\"\u0001D*qCJ\\7+Z:tS>t\u0007\"B$\u0004\u0001\u0004A\u0015aB8qi&|gn\u001d\t\u0005]%kS&\u0003\u0002Ks\t\u0019Q*\u00199\t\u000b1\u001b\u0001\u0019A'\u0002\tA\fG\u000f\u001b\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000b!AZ:\u000b\u0005I;\u0012A\u00025bI>|\u0007/\u0003\u0002U\u001f\n!\u0001+\u0019;i\u0003-IgNZ3s'\u000eDW-\\1\u0015\t]\u0003\u0017M\u0019\t\u0004{aS\u0016BA-4\u0005\u0019y\u0005\u000f^5p]B\u00111LX\u0007\u00029*\u0011QlE\u0001\u0006if\u0004Xm]\u0005\u0003?r\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015\tE\u00011\u0001C\u0011\u00159E\u00011\u0001I\u0011\u0015\u0019G\u00011\u0001e\u0003\u00151\u0017\u000e\\3t!\r)'.\u001c\b\u0003M\"t!\u0001M4\n\u0003QJ!![\u001a\u0002\u000fA\f7m[1hK&\u00111\u000e\u001c\u0002\u0004'\u0016\f(BA54!\tqe.\u0003\u0002p\u001f\nQa)\u001b7f'R\fG/^:\u0002\u0019A\u0014X\r]1sK^\u0013\u0018\u000e^3\u0015\u000bI,hO`@\u0011\u0005y\u0019\u0018B\u0001;\u0010\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015\tU\u00011\u0001C\u0011\u00159X\u00011\u0001y\u0003\rQwN\u0019\t\u0003srl\u0011A\u001f\u0006\u0003wF\u000b\u0011\"\\1qe\u0016$WoY3\n\u0005uT(a\u0001&pE\")q)\u0002a\u0001\u0011\"1\u0011\u0011A\u0003A\u0002i\u000b!\u0002Z1uCN\u001b\u0007.Z7b\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015!\u0005\u001d\u0011QEA\u0014\u0003S\ti#!\r\u0002>\u0005}\u0002cB\u001f\u0002\n\u00055\u00111C\u0005\u0004\u0003\u0017\u0019$!\u0003$v]\u000e$\u0018n\u001c82!\rq\u0012qB\u0005\u0004\u0003#y!a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u000b\u0015\f)\"!\u0007\n\u0007\u0005]AN\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010'\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002$\u0005u!aC%oi\u0016\u0014h.\u00197S_^DQ!\u0011\u0004A\u0002\tCa!!\u0001\u0007\u0001\u0004Q\u0006BBA\u0016\r\u0001\u0007!,A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011\u0019\tyC\u0002a\u00015\u0006q!/Z9vSJ,GmU2iK6\f\u0007bBA\u001a\r\u0001\u0007\u0011QG\u0001\bM&dG/\u001a:t!\u0011)'.a\u000e\u0011\u0007\t\nI$C\u0002\u0002<\r\u0012aAR5mi\u0016\u0014\b\"B$\u0007\u0001\u0004A\u0005bBA!\r\u0001\u0007\u00111I\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%\u0013+\u0001\u0003d_:4\u0017\u0002BA'\u0003\u000f\u0012QbQ8oM&<WO]1uS>t\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0016\u0011\u0007u\n9&C\u0002\u0002ZM\u00121!\u00138u\u0003\u0019)\u0017/^1mgR\u0019A(a\u0018\t\u000f\u0005\u0005\u0014\u00021\u0001\u0002d\u0005)q\u000e\u001e5feB\u0019Q(!\u001a\n\u0007\u0005\u001d4GA\u0002B]f\fqb];qa>\u0014H\u000fR1uCRK\b/\u001a\u000b\u0004y\u00055\u0004bBA8\u0015\u0001\u0007\u0011\u0011O\u0001\tI\u0006$\u0018\rV=qKB\u00191,a\u001d\n\u0007\u0005UDL\u0001\u0005ECR\fG+\u001f9f\u0003i\tG\u000e\\8x\tV\u0004H.[2bi\u0016$7i\u001c7v[:t\u0015-\\3t+\u0005a\u0004")
public class CSVFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "csv";
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        CSVDataSource csvDataSource = CSVDataSource$.MODULE$.apply(parsedOptions);
        return csvDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        return CSVDataSource$.MODULE$.apply(parsedOptions).inferSchema(sparkSession, files, parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        CSVOptions csvOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        csvOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, csvOptions){
            private final CSVOptions csvOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new CsvOutputWriter(path, dataSchema, context, this.csvOptions$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return ".csv" + CodecStreams$.MODULE$.getCompressionExtension((JobContext)context);
            }
            {
                this.csvOptions$1 = csvOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        boolean isColumnPruningEnabled = parsedOptions.isColumnPruningEnabled(requiredSchema);
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(dataSchema, parsedOptions.columnNameOfCorruptRecord());
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw QueryCompilationErrors$.MODULE$.queryFromRawFilesIncludeCorruptRecordColumnError();
            }
        }
        Seq actualFilters = (Seq)filters.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])x$1.references()), (Object)parsedOptions.columnNameOfCorruptRecord())));
        return (Function1 & Serializable)file -> {
            Configuration conf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            StructType actualDataSchema = StructType$.MODULE$.apply((Seq)dataSchema.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$3(parsedOptions, x$2))));
            StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$4(parsedOptions, x$3))));
            UnivocityParser parser = new UnivocityParser(actualDataSchema, actualRequiredSchema, parsedOptions, actualFilters);
            StructType schema = isColumnPruningEnabled ? actualRequiredSchema : actualDataSchema;
            boolean isStartOfFile = file.start() == 0L;
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(schema, parsedOptions, "CSV file: " + file.urlEncodedPath(), isStartOfFile);
            return CSVDataSource$.MODULE$.apply(parsedOptions).readFile(conf, (PartitionedFile)file, parser, headerChecker, requiredSchema);
        };
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFileFormat;
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof VariantType) {
            return false;
        }
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$3(CSVOptions parsedOptions$1, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$4(CSVOptions parsedOptions$1, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

