/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.v2.FileTable$;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.MetadataLogFileIndex;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df!B\f\u0019\u0003\u00039\u0003\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\r\u0003!\u0011!Q\u0001\n\u0011C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\tC\u0002\u0011\t\u0011)A\u0005E\")A\u000e\u0001C\u0001[\"AA\u000f\u0001EC\u0002\u0013\u0005Q\u000f\u0003\u0005{\u0001!\u0015\r\u0011\"\u0001|\u0011!a\b\u0001#b\u0001\n\u0003Z\b\"B?\u0001\t\u0003r\bbBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\ty\u0003\u0001D\u0001\u0003cAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002^\u00011\t!a\u0018\t\u000f\u0005\u0005\u0004A\"\u0001\u0002d!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBAD\u0001\u0011E\u0011\u0011R\u0004\b\u0003\u001bC\u0002\u0012AAH\r\u00199\u0002\u0004#\u0001\u0002\u0012\"1An\u0005C\u0001\u00033C\u0011\"a'\u0014\u0005\u0004%I!!(\t\u0011\u0005\u00156\u0003)A\u0005\u0003?\u0013\u0011BR5mKR\u000b'\r\\3\u000b\u0005eQ\u0012A\u0001<3\u0015\tYB$A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u000f\u001f\u0003%)\u00070Z2vi&|gN\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!B:qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001QAB4\b\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!A.\u00198h\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\r=\u0013'.Z2u!\t\td'D\u00013\u0015\t\u0019D'A\u0004dCR\fGn\\4\u000b\u0005Ur\u0012!C2p]:,7\r^8s\u0013\t9$GA\u0003UC\ndW\r\u0005\u00022s%\u0011!H\r\u0002\r'V\u0004\bo\u001c:ugJ+\u0017\r\u001a\t\u0003cqJ!!\u0010\u001a\u0003\u001bM+\b\u000f]8siN<&/\u001b;f\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\u0001\u0015)D\u0001\u001f\u0013\t\u0011eD\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0004paRLwN\\:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001ds\u0012\u0001B;uS2L!!\u0013$\u00031\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016\u001cFO]5oO6\u000b\u0007/A\u0003qCRD7\u000fE\u0002M-fs!!T*\u000f\u00059\u000bV\"A(\u000b\u0005A3\u0013A\u0002\u001fs_>$h(C\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!V+A\u0004qC\u000e\\\u0017mZ3\u000b\u0003IK!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002U+B\u0011!L\u0018\b\u00037r\u0003\"AT+\n\u0005u+\u0016A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X+\u0002'U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1\u0011\u0007\r$g-D\u0001V\u0013\t)WK\u0001\u0004PaRLwN\u001c\t\u0003O*l\u0011\u0001\u001b\u0006\u0003Sz\tQ\u0001^=qKNL!a\u001b5\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0004=S:LGO\u0010\u000b\u0006]B\f(o\u001d\t\u0003_\u0002i\u0011\u0001\u0007\u0005\u0006}\u0015\u0001\ra\u0010\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0005\u0006C\u0016\u0001\rAY\u0001\nM&dW-\u00138eKb,\u0012A\u001e\t\u0003obl\u0011AG\u0005\u0003sj\u0011!\u0004U1si&$\u0018n\u001c8j]\u001e\fu/\u0019:f\r&dW-\u00138eKb\f!\u0002Z1uCN\u001b\u0007.Z7b+\u00051\u0017AB:dQ\u0016l\u0017-\u0001\u0007qCJ$\u0018\u000e^5p]&tw\rF\u0001\u0000!\u0015\u0019\u0017\u0011AA\u0003\u0013\r\t\u0019!\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u001b\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003\u001f\tIAA\u0005Ue\u0006t7OZ8s[\u0006Q\u0001O]8qKJ$\u0018.Z:\u0015\u0005\u0005U\u0001CBA\f\u00037I\u0016,\u0004\u0002\u0002\u001a)\u0011q\tL\u0005\u0005\u0003;\tIBA\u0002NCB\fAbY1qC\nLG.\u001b;jKN$\"!a\t\u0011\r\u0005]\u0011QEA\u0015\u0013\u0011\t9#!\u0007\u0003\u0007M+G\u000fE\u00022\u0003WI1!!\f3\u0005=!\u0016M\u00197f\u0007\u0006\u0004\u0018MY5mSRL\u0018aC5oM\u0016\u00148k\u00195f[\u0006$2AYA\u001a\u0011\u001d\t)\u0004\u0004a\u0001\u0003o\tQAZ5mKN\u0004B\u0001\u0014,\u0002:A!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013A\u00014t\u0015\r\t\u0019EI\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005\u001d\u0013Q\b\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001E:vaB|'\u000f^:ECR\fG+\u001f9f)\u0011\ti%a\u0015\u0011\u0007\r\fy%C\u0002\u0002RU\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002V5\u0001\r!a\u0016\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042aZA-\u0013\r\tY\u0006\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006Qam\u001c:nCRt\u0015-\\3\u0016\u0003e\u000b!CZ1mY\n\f7m\u001b$jY\u00164uN]7biV\u0011\u0011Q\r\u0019\u0005\u0003O\n\t\bE\u0003[\u0003S\ni'C\u0002\u0002l\u0001\u0014Qa\u00117bgN\u0004B!a\u001c\u0002r1\u0001AaCA:\u001f\u0005\u0005\t\u0011!B\u0001\u0003k\u00121a\u0018\u00132#\u0011\t9(! \u0011\u0007\r\fI(C\u0002\u0002|U\u0013qAT8uQ&tw\rE\u0002x\u0003\u007fJ1!!!\u001b\u0005)1\u0015\u000e\\3G_Jl\u0017\r^\u0001\nO2|'\rU1uQN,\"!!\u0014\u0002\u001b5,'oZ3e\u001fB$\u0018n\u001c8t)\r!\u00151\u0012\u0005\u0006\u0007F\u0001\r\u0001R\u0001\n\r&dW\rV1cY\u0016\u0004\"a\\\n\u0014\u0007M\t\u0019\nE\u0002d\u0003+K1!a&V\u0005\u0019\te.\u001f*fMR\u0011\u0011qR\u0001\r\u0007\u0006\u0003\u0016IQ%M\u0013RKUiU\u000b\u0003\u0003?\u0003b!a\u0006\u0002\"\u0006%\u0012\u0002BAR\u00033\u0011q!\u00128v[N+G/A\u0007D\u0003B\u000b%)\u0013'J)&+5\u000b\t")
public abstract class FileTable
implements Table,
SupportsRead,
SupportsWrite {
    private PartitioningAwareFileIndex fileIndex;
    private StructType dataSchema;
    private StructType schema;
    private final SparkSession sparkSession;
    private final CaseInsensitiveStringMap options;
    private final Seq<String> paths;
    private final Option<StructType> userSpecifiedSchema;
    private volatile byte bitmap$0;

    public Column[] columns() {
        return super.columns();
    }

    private PartitioningAwareFileIndex fileIndex$lzycompute() {
        FileTable fileTable = this;
        synchronized (fileTable) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                PartitioningAwareFileIndex partitioningAwareFileIndex;
                scala.collection.immutable.Map caseSensitiveMap = CollectionConverters$.MODULE$.MapHasAsScala(this.options.asCaseSensitiveMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Configuration hadoopConf = this.sparkSession.sessionState().newHadoopConfWithOptions((scala.collection.immutable.Map<String, String>)caseSensitiveMap);
                if (FileStreamSink$.MODULE$.hasMetadata(this.paths, hadoopConf, this.sparkSession.sessionState().conf())) {
                    partitioningAwareFileIndex = new MetadataLogFileIndex(this.sparkSession, new Path((String)this.paths.head()), (scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala((Map)this.options).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.userSpecifiedSchema);
                } else {
                    Seq<String> x$1 = this.paths;
                    Configuration x$2 = hadoopConf;
                    boolean x$3 = true;
                    boolean x$4 = true;
                    boolean x$5 = this.globPaths();
                    Integer x$6 = DataSource$.MODULE$.checkAndGlobPathIfNecessary$default$5();
                    Seq<Path> rootPathsSpecified = DataSource$.MODULE$.checkAndGlobPathIfNecessary(x$1, x$2, true, true, x$6, x$5);
                    FileStatusCache fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(this.sparkSession);
                    partitioningAwareFileIndex = new InMemoryFileIndex(this.sparkSession, rootPathsSpecified, (scala.collection.immutable.Map<String, String>)caseSensitiveMap, this.userSpecifiedSchema, fileStatusCache, InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7());
                }
                this.fileIndex = partitioningAwareFileIndex;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.fileIndex;
    }

    public PartitioningAwareFileIndex fileIndex() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fileIndex$lzycompute();
        }
        return this.fileIndex;
    }

    private StructType dataSchema$lzycompute() {
        FileTable fileTable = this;
        synchronized (fileTable) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                StructType schema2 = (StructType)this.userSpecifiedSchema.map((Function1 & Serializable)schema -> {
                    StructType partitionSchema = this.fileIndex().partitionSchema();
                    Function2 resolver = $this.sparkSession.sessionState().conf().resolver();
                    return StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)partitionSchema.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileTable.$anonfun$dataSchema$3(resolver$1, f, p))))));
                }).orElse((Function0 & Serializable)() -> this.inferSchema(this.fileIndex().allFiles())).getOrElse((Function0 & Serializable)() -> {
                    throw QueryCompilationErrors$.MODULE$.dataSchemaNotSpecifiedError(this.formatName());
                });
                PartitioningAwareFileIndex partitioningAwareFileIndex = this.fileIndex();
                this.dataSchema = partitioningAwareFileIndex instanceof MetadataLogFileIndex ? schema2 : schema2.asNullable();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataSchema$lzycompute();
        }
        return this.dataSchema;
    }

    private StructType schema$lzycompute() {
        FileTable fileTable = this;
        synchronized (fileTable) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                boolean caseSensitive = this.sparkSession.sessionState().conf().caseSensitiveAnalysis();
                SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication((DataType)this.dataSchema(), caseSensitive);
                this.dataSchema().foreach((Function1 & Serializable)field -> {
                    FileTable.$anonfun$schema$1(this, field);
                    return BoxedUnit.UNIT;
                });
                StructType partitionSchema = this.fileIndex().partitionSchema();
                SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication((DataType)partitionSchema, caseSensitive);
                scala.collection.immutable.Set partitionNameSet = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Function1 & Serializable)x$1 -> PartitioningUtils$.MODULE$.getColName((StructField)x$1, caseSensitive), ClassTag$.MODULE$.apply(String.class))).toSet();
                StructField[] fields = (StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])this.dataSchema().fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)FileTable.$anonfun$schema$3(caseSensitive, partitionNameSet, field)))), (Object)partitionSchema.fields(), ClassTag$.MODULE$.apply(StructField.class));
                this.schema = new StructType(fields);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.schema;
    }

    public StructType schema() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.schema$lzycompute();
        }
        return this.schema;
    }

    public Transform[] partitioning() {
        return CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.fileIndex().partitionSchema().names()).toImmutableArraySeq()).asTransforms();
    }

    public Map<String, String> properties() {
        return this.options.asCaseSensitiveMap();
    }

    public Set<TableCapability> capabilities() {
        return FileTable$.MODULE$.org$apache$spark$sql$execution$datasources$v2$FileTable$$CAPABILITIES();
    }

    public abstract Option<StructType> inferSchema(Seq<FileStatus> var1);

    public boolean supportsDataType(DataType dataType) {
        return true;
    }

    public abstract String formatName();

    public abstract Class<? extends FileFormat> fallbackFileFormat();

    private boolean globPaths() {
        String entry = this.options.get((Object)DataSource$.MODULE$.GLOB_PATHS_KEY());
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)entry).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileTable.$anonfun$globPaths$1(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
    }

    public CaseInsensitiveStringMap mergedOptions(CaseInsensitiveStringMap options) {
        scala.collection.mutable.Map finalOptions = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(this.options.asCaseSensitiveMap()).asScala().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(options.asCaseSensitiveMap()).asScala());
        return new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MutableMapHasAsJava(finalOptions).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$3(Function2 resolver$1, StructField f$1, StructField p) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)p.name(), (Object)f$1.name()));
    }

    public static final /* synthetic */ void $anonfun$schema$1(FileTable $this, StructField field) {
        if (!$this.supportsDataType(field.dataType())) {
            throw QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByDataSourceError($this.formatName(), field);
        }
    }

    public static final /* synthetic */ boolean $anonfun$schema$3(boolean caseSensitive$1, scala.collection.immutable.Set partitionNameSet$1, StructField field) {
        String colName = PartitioningUtils$.MODULE$.getColName(field, caseSensitive$1);
        return partitionNameSet$1.contains((Object)colName);
    }

    public static final /* synthetic */ boolean $anonfun$globPaths$1(String x$2) {
        String string = x$2;
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public FileTable(SparkSession sparkSession, CaseInsensitiveStringMap options, Seq<String> paths, Option<StructType> userSpecifiedSchema) {
        this.sparkSession = sparkSession;
        this.options = options;
        this.paths = paths;
        this.userSpecifiedSchema = userSpecifiedSchema;
    }
}

