/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreReaderInfo;
import org.apache.spark.sql.execution.datasources.v2.state.StateTable;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataPartitionReader;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataTableEntry;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.TransformWithStateOperatorProperties;
import org.apache.spark.sql.execution.streaming.TransformWithStateOperatorProperties$;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001\u0002\b\u0010\u0001\u0001BQ!\u0010\u0001\u0005\u0002yB\u0001\"\u0011\u0001\t\u0006\u0004%IA\u0011\u0005\t\u000f\u0002A)\u0019!C\u0005\u0011\"A\u0011\u000b\u0001EC\u0002\u0013%!\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u0011Q\u0006\u0001\u0005\n\u0005=\u0002bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!a\"\u0001\t\u0013\tIIA\bTi\u0006$X\rR1uCN{WO]2f\u0015\t\u0001\u0012#A\u0003ti\u0006$XM\u0003\u0002\u0013'\u0005\u0011aO\r\u0006\u0003)U\t1\u0002Z1uCN|WO]2fg*\u0011acF\u0001\nKb,7-\u001e;j_:T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019R\u0001A\u0011*c]\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\t1\fgn\u001a\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3E\u0001\u0004PE*,7\r\u001e\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nqaY1uC2|wM\u0003\u0002//\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003a-\u0012Q\u0002V1cY\u0016\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0018\u0003\u001d\u0019x.\u001e:dKNL!AN\u001a\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003qmj\u0011!\u000f\u0006\u0003ue\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003ye\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u007fA\u0011\u0001\tA\u0007\u0002\u001f\u000591/Z:tS>tW#A\"\u0011\u0005\u0011+U\"A\f\n\u0005\u0019;\"\u0001D*qCJ\\7+Z:tS>t\u0017A\u00035bI>|\u0007oQ8oMV\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!1m\u001c8g\u0015\tq5$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003!.\u0013QbQ8oM&<WO]1uS>t\u0017\u0001F:fe&\fG.\u001b>fI\"\u000bGm\\8q\u0007>tg-F\u0001T!\t!v+D\u0001V\u0015\t1\u0016$\u0001\u0003vi&d\u0017B\u0001-V\u0005e\u0019VM]5bY&T\u0018M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0013MDwN\u001d;OC6,G#A.\u0011\u0005q+gBA/d!\tq\u0016-D\u0001`\u0015\t\u0001w$\u0001\u0004=e>|GO\u0010\u0006\u0002E\u0006)1oY1mC&\u0011A-Y\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002eC\u0006Aq-\u001a;UC\ndW\rF\u0003k[V\f\u0019\u0001\u0005\u0002+W&\u0011An\u000b\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006]\u001a\u0001\ra\\\u0001\u0007g\u000eDW-\\1\u0011\u0005A\u001cX\"A9\u000b\u0005I<\u0012!\u0002;za\u0016\u001c\u0018B\u0001;r\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006m\u001a\u0001\ra^\u0001\ra\u0006\u0014H/\u001b;j_:Lgn\u001a\t\u0004qf\\X\"A1\n\u0005i\f'!B!se\u0006L\bC\u0001?\u0000\u001b\u0005i(B\u0001@.\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0007\u0005\u0005QPA\u0005Ue\u0006t7OZ8s[\"9\u0011Q\u0001\u0004A\u0002\u0005\u001d\u0011A\u00039s_B,'\u000f^5fgB1\u0011\u0011BA\u00077nk!!a\u0003\u000b\u0005Y+\u0013\u0002BA\b\u0003\u0017\u00111!T1q\u0003-IgNZ3s'\u000eDW-\\1\u0015\u0007=\f)\u0002C\u0004\u0002\u0018\u001d\u0001\r!!\u0007\u0002\u000f=\u0004H/[8ogB!\u00111DA\u0010\u001b\t\tiB\u0003\u0002W/%!\u0011\u0011EA\u000f\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r]\u0001\u0019gV\u0004\bo\u001c:ug\u0016CH/\u001a:oC2lU\r^1eCR\fGCAA\u0014!\rA\u0018\u0011F\u0005\u0004\u0003W\t'a\u0002\"p_2,\u0017M\\\u0001\u0014EVLG\u000eZ*uCR,7\u000b^8sK\u000e{gN\u001a\u000b\u0007\u0003c\ty$a\u0011\u0011\t\u0005M\u00121H\u0007\u0003\u0003kQ1\u0001EA\u001c\u0015\r\tI$F\u0001\ngR\u0014X-Y7j]\u001eLA!!\u0010\u00026\tq1\u000b^1uKN#xN]3D_:4\u0007BBA!\u0013\u0001\u00071,\u0001\ndQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007bBA#\u0013\u0001\u0007\u0011qI\u0001\bE\u0006$8\r[%e!\rA\u0018\u0011J\u0005\u0004\u0003\u0017\n'\u0001\u0002'p]\u001e\f\u0011C];o'R\fG/\u001a,be\u000eCWmY6t)\u0019\t\t&a\u0016\u0002bA\u0019\u00010a\u0015\n\u0007\u0005U\u0013M\u0001\u0003V]&$\bbBA-\u0015\u0001\u0007\u00111L\u0001\u000eg>,(oY3PaRLwN\\:\u0011\u0007\u0001\u000bi&C\u0002\u0002`=\u0011!c\u0015;bi\u0016\u001cv.\u001e:dK>\u0003H/[8og\"9\u00111\r\u0006A\u0002\u0005\u0015\u0014AE:uCR,7\u000b^8sK6+G/\u00193bi\u0006\u0004B\u0001_=\u0002hA!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n=\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003c\nYGA\fTi\u0006$X-T3uC\u0012\fG/\u0019+bE2,WI\u001c;ss\u0006)r-\u001a;Ti\u0006$Xm\u0015;pe\u0016lU\r^1eCR\fG\u0003BA3\u0003oBq!!\u001f\f\u0001\u0004\tY&\u0001\nti\u0006$XmU8ve\u000e,w\n\u001d;j_:\u001c\u0018\u0001H4fiN#xN]3NKR\fG-\u0019;b\u0003:$'+\u001e8DQ\u0016\u001c7n\u001d\u000b\u0005\u0003\u007f\n)\tE\u0002A\u0003\u0003K1!a!\u0010\u0005Q\u0019F/\u0019;f'R|'/\u001a*fC\u0012,'/\u00138g_\"9\u0011\u0011\f\u0007A\u0002\u0005m\u0013AF4fi.+\u0017p\u0015;bi\u0016,enY8eKJ\u001c\u0006/Z2\u0015\r\u0005-\u0015\u0011SAN!\u0011\t\u0019$!$\n\t\u0005=\u0015Q\u0007\u0002\u0014\u0017\u0016L8\u000b^1uK\u0016s7m\u001c3feN\u0003Xm\u0019\u0005\b\u0003'k\u0001\u0019AAK\u0003=\u0019w\u000e\u001c$b[&d\u0017pU2iK6\f\u0007\u0003BA\u001a\u0003/KA!!'\u00026\tI2\u000b^1uKN#xN]3D_24\u0015-\\5msN\u001b\u0007.Z7b\u0011\u001d\ti*\u0004a\u0001\u0003K\nQb\u001d;pe\u0016lU\r^1eCR\f\u0007")
public class StateDataSource
implements TableProvider,
DataSourceRegister,
Logging {
    private SparkSession session;
    private Configuration hadoopConf;
    private SerializableConfiguration serializedHadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap x$1) {
        return super.inferPartitioning(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession session$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.session = SparkSession$.MODULE$.active();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.session;
    }

    private SparkSession session() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    private Configuration hadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopConf = this.session().sessionState().newHadoopConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hadoopConf;
    }

    private Configuration hadoopConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hadoopConf$lzycompute();
        }
        return this.hadoopConf;
    }

    private SerializableConfiguration serializedHadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serializedHadoopConf = new SerializableConfiguration(this.hadoopConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.serializedHadoopConf;
    }

    private SerializableConfiguration serializedHadoopConf() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.serializedHadoopConf$lzycompute();
        }
        return this.serializedHadoopConf;
    }

    @Override
    public String shortName() {
        return "statestore";
    }

    public Table getTable(StructType schema, Transform[] partitioning2, Map<String, String> properties) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), properties);
        StateStoreConf stateConf = this.buildStateStoreConf(sourceOptions.resolvedCpLocation(), sourceOptions.batchId());
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        if (stateStoreReaderInfo.keyStateEncoderSpecOpt().isDefined()) {
            keyStateEncoderSpec = (KeyStateEncoderSpec)stateStoreReaderInfo.keyStateEncoderSpecOpt().get();
        } else {
            StructType keySchema = (StructType)SchemaUtil$.MODULE$.getSchemaAsDataType(schema, "key");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(keySchema);
        }
        KeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return new StateTable(this.session(), schema, sourceOptions, stateConf, keyStateEncoderSpec2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt());
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        StructType structType;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), options);
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
        try {
            Tuple2 tuple2;
            Enumeration.Value value = sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$5());
            } else {
                Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$5());
                } else {
                    Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Predef$.MODULE$.require(stateStoreReaderInfo.stateStoreColFamilySchemaOpt().isDefined());
                        StateStoreColFamilySchema resultSchema = (StateStoreColFamilySchema)stateStoreReaderInfo.stateStoreColFamilySchemaOpt().get();
                        tuple2 = new Tuple2((Object)resultSchema.keySchema(), (Object)resultSchema.valueSchema());
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            StructType keySchema = (StructType)tuple22._1();
            StructType valueSchema = (StructType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)keySchema, (Object)valueSchema);
            StructType keySchema2 = (StructType)tuple23._1();
            StructType valueSchema2 = (StructType)tuple23._2();
            structType = SchemaUtil$.MODULE$.getSourceSchema(sourceOptions, keySchema2, valueSchema2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
            }
            throw throwable;
        }
        return structType;
    }

    public boolean supportsExternalMetadata() {
        return false;
    }

    private StateStoreConf buildStateStoreConf(String checkpointLocation, long batchId) {
        OffsetSeqLog offsetLog = new OffsetSeqLog(this.session(), new Path(checkpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_OFFSETS()).toString());
        Option option = offsetLog.get(batchId);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetSeq value = (OffsetSeq)some.value();
            OffsetSeqMetadata metadata = (OffsetSeqMetadata)value.metadata().getOrElse((Function0 & Serializable)() -> {
                throw StateDataSourceErrors$.MODULE$.offsetMetadataLogUnavailable(batchId, checkpointLocation);
            });
            RuntimeConfig clonedRuntimeConf = new RuntimeConfig(this.session().sessionState().conf().clone());
            OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, clonedRuntimeConf);
            return StateStoreConf$.MODULE$.apply(clonedRuntimeConf.sqlConf());
        }
        throw StateDataSourceErrors$.MODULE$.offsetLogUnavailable(batchId, checkpointLocation);
    }

    private void runStateVarChecks(StateSourceOptions sourceOptions, StateMetadataTableEntry[] stateStoreMetadata) {
        String twsShortName = "transformWithStateExec";
        if (sourceOptions.stateVarName().isDefined()) {
            Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
            StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
            String string = opMetadata.operatorName();
            String string2 = twsShortName;
            if (string == null ? string2 != null : !string.equals(string2)) {
                String errorMsg = "Providing state variable names is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), errorMsg);
            }
            String operatorProperties = opMetadata.operatorPropertiesJson();
            if (operatorProperties.isEmpty()) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "No state variable names are defined for the transformWithState operator");
            }
            String stateVarName = (String)sourceOptions.stateVarName().get();
            TransformWithStateOperatorProperties twsOperatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(operatorProperties);
            List<TransformWithStateVariableInfo> stateVars = twsOperatorProperties.stateVariables();
            if (stateVars.filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$runStateVarChecks$1(stateVarName, stateVar))).size() != 1) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "State variable " + stateVarName + " is not defined for the transformWithState operator.");
            }
            if (sourceOptions.readChangeFeed()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)StateSourceOptions$.MODULE$.READ_CHANGE_FEED(), (List)new .colon.colon((Object)StateSourceOptions$.MODULE$.STATE_VAR_NAME(), (List)Nil$.MODULE$)));
            }
            return;
        }
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1) {
            String string = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata))).operatorName();
            String string3 = twsShortName;
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified("stateVarName");
            }
        }
    }

    private StateMetadataTableEntry[] getStateStoreMetadata(StateSourceOptions stateSourceOptions) {
        StateMetadataTableEntry[] allStateStoreMetadata = (StateMetadataTableEntry[])new StateMetadataPartitionReader(stateSourceOptions.stateCheckpointLocation().getParent().toString(), this.serializedHadoopConf(), stateSourceOptions.batchId()).stateMetadata().toArray(ClassTag$.MODULE$.apply(StateMetadataTableEntry.class));
        StateMetadataTableEntry[] stateStoreMetadata = (StateMetadataTableEntry[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allStateStoreMetadata), (Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStateStoreMetadata$1(stateSourceOptions, entry)));
        return stateStoreMetadata;
    }

    private StateStoreReaderInfo getStoreMetadataAndRunChecks(StateSourceOptions sourceOptions) {
        StateMetadataTableEntry[] storeMetadata = this.getStateStoreMetadata(sourceOptions);
        this.runStateVarChecks(sourceOptions, storeMetadata);
        None$ keyStateEncoderSpecOpt = None$.MODULE$;
        None$ stateStoreColFamilySchemaOpt = None$.MODULE$;
        None$ transformWithStateVariableInfoOpt = None$.MODULE$;
        Enumeration.Value value = sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            None$ none$;
            String stateVarName = (String)sourceOptions.stateVarName().getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME());
            if (storeMetadata.length > 0 && ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).version() == 2 && ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName().contains("transformWithStateExec")) {
                StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
                TransformWithStateOperatorProperties operatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(storeMetadataEntry.operatorPropertiesJson());
                List stateVarInfoList = operatorProperties.stateVariables().filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$2(stateVarName, stateVar)));
                Predef$.MODULE$.require(stateVarInfoList.size() == 1, (Function0 & Serializable)() -> "Failed to find unique state variable info for state variable " + stateVarName + " in operator " + sourceOptions.operatorId());
                TransformWithStateVariableInfo stateVarInfo = (TransformWithStateVariableInfo)stateVarInfoList.head();
                transformWithStateVariableInfoOpt = new Some((Object)stateVarInfo);
                Path schemaFilePath = new Path((String)storeMetadataEntry.stateSchemaFilePath().get());
                none$ = new Some((Object)schemaFilePath);
            } else {
                none$ = None$.MODULE$;
            }
            None$ oldSchemaFilePath = none$;
            try {
                int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
                Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
                StateStoreId storeId = new StateStoreId(stateCheckpointLocation.toString(), sourceOptions.operatorId(), partitionId, sourceOptions.storeName());
                StateStoreProviderId providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
                StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerId, this.hadoopConf(), (Option<Path>)oldSchemaFilePath, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
                List<StateStoreColFamilySchema> stateSchema = manager.readSchemaFile();
                StateStoreColFamilySchema resultSchema = (StateStoreColFamilySchema)stateSchema.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$4(stateVarName, x$2))).head();
                keyStateEncoderSpecOpt = new Some((Object)this.getKeyStateEncoderSpec(resultSchema, storeMetadata));
                stateStoreColFamilySchemaOpt = new Some((Object)resultSchema);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
                }
                throw throwable;
            }
        }
        return new StateStoreReaderInfo((Option<KeyStateEncoderSpec>)keyStateEncoderSpecOpt, (Option<StateStoreColFamilySchema>)stateStoreColFamilySchemaOpt, (Option<TransformWithStateVariableInfo>)transformWithStateVariableInfoOpt);
    }

    private KeyStateEncoderSpec getKeyStateEncoderSpec(StateStoreColFamilySchema colFamilySchema, StateMetadataTableEntry[] storeMetadata) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        if (storeMetadata.length == 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Metadata for state store not found, possible cause is this checkpoint is created by older version of spark. If the query has session window aggregation, the state can't be read correctly and runtime exception will be thrown. Run the streaming query in newer spark version to generate state metadata can fix the issue.");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
        } else {
            Predef$.MODULE$.require(storeMetadata.length == 1);
            StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
            if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() == 0) {
                keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
            } else if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() > 0) {
                keyStateEncoderSpec = new PrefixKeyScanStateEncoderSpec(colFamilySchema.keySchema(), storeMetadataEntry.numColsPrefixKey());
            } else if (storeMetadataEntry.version() == 2) {
                Predef$.MODULE$.require(colFamilySchema.keyStateEncoderSpec().isDefined());
                keyStateEncoderSpec = (KeyStateEncoderSpec)colFamilySchema.keyStateEncoderSpec().get();
            } else {
                throw StateDataSourceErrors$.MODULE$.internalError("Failed to read key state encoder spec for operator=" + storeMetadataEntry.operatorId());
            }
        }
        NoPrefixKeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return keyStateEncoderSpec2;
    }

    public static final /* synthetic */ boolean $anonfun$runStateVarChecks$1(String stateVarName$1, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = stateVarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getStateStoreMetadata$1(StateSourceOptions stateSourceOptions$1, StateMetadataTableEntry entry) {
        if (entry.operatorId() != (long)stateSourceOptions$1.operatorId()) return false;
        String string = entry.stateStoreName();
        String string2 = stateSourceOptions$1.storeName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$2(String stateVarName$2, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = stateVarName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$4(String stateVarName$2, StateStoreColFamilySchema x$2) {
        String string = x$2.colFamilyName();
        String string2 = stateVarName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public StateDataSource() {
        Logging.$init$((Logging)this);
    }
}

