/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.datasources.v2.state.FromSnapshotOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StatePartitionReaderBase;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreInputPartition;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.StateVariableType$;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.SupportsFineGrainedReplay;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005e4A\u0001D\u0007\u0001=!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\")\u0011\u000b\u0001C\u0001%\"A1\f\u0001EC\u0002\u0013%A\f\u0003\u0005a\u0001!\u0015\r\u0011\"\u0011b\u0011\u0015!\b\u0001\"\u0011v\u0005Q\u0019F/\u0019;f!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe*\u0011abD\u0001\u0006gR\fG/\u001a\u0006\u0003!E\t!A\u001e\u001a\u000b\u0005I\u0019\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001F\u000b\u0002\u0013\u0015DXmY;uS>t'B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011C\u0001\u0001 !\t\u0001\u0013%D\u0001\u000e\u0013\t\u0011SB\u0001\rTi\u0006$X\rU1si&$\u0018n\u001c8SK\u0006$WM\u001d\"bg\u0016\f\u0011b\u001d;pe\u0016\u001cuN\u001c4\u0011\u0005\u0015JS\"\u0001\u0014\u000b\u000599#B\u0001\u0015\u0014\u0003%\u0019HO]3b[&tw-\u0003\u0002+M\tq1\u000b^1uKN#xN]3D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011Q\u0006M\u0007\u0002])\u0011qfF\u0001\u0005kRLG.\u0003\u00022]\tI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002!i%\u0011Q'\u0004\u0002\u0019'R\fG/Z*u_J,\u0017J\u001c9viB\u000b'\u000f^5uS>t\u0017AB:dQ\u0016l\u0017\r\u0005\u00029w5\t\u0011H\u0003\u0002;+\u0005)A/\u001f9fg&\u0011A(\u000f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aE6fsN#\u0018\r^3F]\u000e|G-\u001a:Ta\u0016\u001c\u0007CA\u0013@\u0013\t\u0001eEA\nLKf\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s'B,7-\u0001\u000bti\u0006$XMV1sS\u0006\u0014G.Z%oM>|\u0005\u000f\u001e\t\u0004\u0007\u001aCU\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r=\u0003H/[8o!\tI%*D\u0001(\u0013\tYuE\u0001\u0010Ue\u0006t7OZ8s[^KG\u000f[*uCR,g+\u0019:jC\ndW-\u00138g_\u0006a2\u000f^1uKN#xN]3D_24\u0015-\\5msN\u001b\u0007.Z7b\u001fB$\bcA\"G\u001dB\u0011QeT\u0005\u0003!\u001a\u0012\u0011d\u0015;bi\u0016\u001cFo\u001c:f\u0007>dg)Y7jYf\u001c6\r[3nC\u00061A(\u001b8jiz\"\u0002b\u0015+V-^C\u0016L\u0017\t\u0003A\u0001AQa\t\u0005A\u0002\u0011BQa\u000b\u0005A\u00021BQA\r\u0005A\u0002MBQA\u000e\u0005A\u0002]BQ!\u0010\u0005A\u0002yBQ!\u0011\u0005A\u0002\tCQ\u0001\u0014\u0005A\u00025\u000bQa\u001d;pe\u0016,\u0012!\u0018\t\u0003KyK!a\u0018\u0014\u0003\u001dI+\u0017\rZ*uCR,7\u000b^8sK\u0006!\u0011\u000e^3s+\u0005\u0011\u0007cA2l]:\u0011A-\u001b\b\u0003K\"l\u0011A\u001a\u0006\u0003Ov\ta\u0001\u0010:p_Rt\u0014\"A#\n\u0005)$\u0015a\u00029bG.\fw-Z\u0005\u0003Y6\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003U\u0012\u0003\"a\u001c:\u000e\u0003AT!!]\u000b\u0002\u0011\r\fG/\u00197zgRL!a\u001d9\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0006G2|7/\u001a\u000b\u0002mB\u00111i^\u0005\u0003q\u0012\u0013A!\u00168ji\u0002")
public class StatePartitionReader
extends StatePartitionReaderBase {
    private ReadStateStore store;
    private Iterator<InternalRow> iter;
    private final StateStoreInputPartition partition;
    private final Option<TransformWithStateVariableInfo> stateVariableInfoOpt;
    private volatile byte bitmap$0;

    private ReadStateStore store$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ReadStateStore readStateStore;
                Option<FromSnapshotOptions> option = this.partition.sourceOptions().fromSnapshotOptions();
                if (None$.MODULE$.equals(option)) {
                    readStateStore = this.provider().getReadStore(this.partition.sourceOptions().batchId() + 1L);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    FromSnapshotOptions fromSnapshotOptions = (FromSnapshotOptions)some.value();
                    if (!(this.provider() instanceof SupportsFineGrainedReplay)) {
                        throw StateStoreErrors$.MODULE$.stateStoreProviderDoesNotSupportFineGrainedReplay(this.provider().getClass().toString());
                    }
                    readStateStore = ((SupportsFineGrainedReplay)((Object)this.provider())).replayReadStateFromSnapshot(fromSnapshotOptions.snapshotStartBatchId() + 1L, this.partition.sourceOptions().batchId() + 1L);
                } else {
                    throw new MatchError(option);
                }
                this.store = readStateStore;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.store;
    }

    private ReadStateStore store() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.store$lzycompute();
        }
        return this.store;
    }

    private Iterator<InternalRow> iter$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String stateVarName = (String)this.stateVariableInfoOpt.map((Function1 & Serializable)x$2 -> x$2.stateName()).getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME());
                this.iter = SchemaUtil$.MODULE$.isMapStateVariable(this.stateVariableInfoOpt) ? SchemaUtil$.MODULE$.unifyMapStateRowPair(this.store().iterator(stateVarName), this.keySchema(), this.partition.partition()) : this.store().iterator(stateVarName).map((Function1 & Serializable)pair -> {
                    Option<TransformWithStateVariableInfo> option = $this.stateVariableInfoOpt;
                    if (option instanceof Some) {
                        Enumeration.Value stateVarType;
                        Some some = (Some)option;
                        TransformWithStateVariableInfo stateVarInfo = (TransformWithStateVariableInfo)some.value();
                        Enumeration.Value value = stateVarType = stateVarInfo.stateVariableType();
                        Enumeration.Value value2 = StateVariableType$.MODULE$.ValueState();
                        Enumeration.Value value3 = value;
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                            return SchemaUtil$.MODULE$.unifyStateRowPair((Tuple2<UnsafeRow, UnsafeRow>)new Tuple2((Object)pair.key(), (Object)pair.value()), $this.partition.partition());
                        }
                        Enumeration.Value value4 = StateVariableType$.MODULE$.ListState();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            UnsafeRow key = pair.key();
                            Iterator<UnsafeRow> result = this.store().valuesIterator(key, stateVarName);
                            ObjectRef unsafeRowArr = ObjectRef.create((Object)((Seq)package$.MODULE$.Seq().empty()));
                            result.foreach((Function1 & Serializable)entry -> {
                                unsafeRowArr.elem = (Seq)((Seq)unsafeRowArr.elem).$colon$plus((Object)entry.copy());
                                return BoxedUnit.UNIT;
                            });
                            GenericArrayData arrData = new GenericArrayData(((Seq)unsafeRowArr.elem).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class)));
                            return SchemaUtil$.MODULE$.unifyStateRowPairWithMultipleValues((Tuple2<UnsafeRow, GenericArrayData>)new Tuple2((Object)pair.key(), (Object)arrData), $this.partition.partition());
                        }
                        throw new IllegalStateException("Unsupported state variable type: " + stateVarType);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return SchemaUtil$.MODULE$.unifyStateRowPair((Tuple2<UnsafeRow, UnsafeRow>)new Tuple2((Object)pair.key(), (Object)pair.value()), $this.partition.partition());
                    }
                    throw new MatchError(option);
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.iter;
    }

    @Override
    public Iterator<InternalRow> iter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.iter$lzycompute();
        }
        return this.iter;
    }

    @Override
    public void close() {
        this.store().abort();
        super.close();
    }

    public StatePartitionReader(StateStoreConf storeConf, SerializableConfiguration hadoopConf, StateStoreInputPartition partition, StructType schema, KeyStateEncoderSpec keyStateEncoderSpec, Option<TransformWithStateVariableInfo> stateVariableInfoOpt, Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt) {
        this.partition = partition;
        this.stateVariableInfoOpt = stateVariableInfoOpt;
        super(storeConf, hadoopConf, partition, schema, keyStateEncoderSpec, stateVariableInfoOpt, stateStoreColFamilySchemaOpt);
    }
}

