/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.execution.datasources.v2.state.FromSnapshotOptions;
import org.apache.spark.sql.execution.datasources.v2.state.ReadChangeFeedOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StatePartitionReaderFactory;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreInputPartition;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStatePartitionReaderFactory;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001B\t\u0013\u0001\rB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011}\u0003!\u0011!Q\u0001\n\u0001DQ\u0001\u001a\u0001\u0005\u0002\u0015DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004}\u0001\u0001\u0006I\u0001\u001d\u0005\u0006{\u0002!\tE \u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003o\u0001A\u0011BA\u001d\u0005%\u0019F/\u0019;f'\u000e\fgN\u0003\u0002\u0014)\u0005)1\u000f^1uK*\u0011QCF\u0001\u0003mJR!a\u0006\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00033i\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!C\u0006\u000e\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019y%M[3diB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005e\u0016\fGM\u0003\u000225\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003g9\u0012AaU2b]B\u0011Q&N\u0005\u0003m9\u0012QAQ1uG\"\fqa]3tg&|g\u000e\u0005\u0002:u5\t!$\u0003\u0002<5\ta1\u000b]1sWN+7o]5p]\u000611o\u00195f[\u0006\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u000e\u0002\u000bQL\b/Z:\n\u0005\t{$AC*ueV\u001cG\u000fV=qK\u0006i1o\\;sG\u0016|\u0005\u000f^5p]N\u0004\"!\u0012$\u000e\u0003II!a\u0012\n\u0003%M#\u0018\r^3T_V\u00148-Z(qi&|gn]\u0001\u000fgR\fG/Z*u_J,7i\u001c8g!\tQe*D\u0001L\u0015\t\u0019BJ\u0003\u0002N1\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003\u001f.\u0013ab\u0015;bi\u0016\u001cFo\u001c:f\u0007>tg-A\nlKf\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s'B,7\r\u0005\u0002K%&\u00111k\u0013\u0002\u0014\u0017\u0016L8\u000b^1uK\u0016s7m\u001c3feN\u0003XmY\u0001\u0015gR\fG/\u001a,be&\f'\r\\3J]\u001a|w\n\u001d;\u0011\u0007YK6,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u0019y\u0005\u000f^5p]B\u0011A,X\u0007\u0002\u0019&\u0011a\f\u0014\u0002\u001f)J\fgn\u001d4pe6<\u0016\u000e\u001e5Ti\u0006$XMV1sS\u0006\u0014G.Z%oM>\fAd\u001d;bi\u0016\u001cFo\u001c:f\u0007>dg)Y7jYf\u001c6\r[3nC>\u0003H\u000fE\u0002W3\u0006\u0004\"A\u00132\n\u0005\r\\%!G*uCR,7\u000b^8sK\u000e{GNR1nS2L8k\u00195f[\u0006\fa\u0001P5oSRtD\u0003\u00034hQ&T7\u000e\\7\u0011\u0005\u0015\u0003\u0001\"B\u001c\t\u0001\u0004A\u0004\"\u0002\u001f\t\u0001\u0004i\u0004\"B\"\t\u0001\u0004!\u0005\"\u0002%\t\u0001\u0004I\u0005\"\u0002)\t\u0001\u0004\t\u0006\"\u0002+\t\u0001\u0004)\u0006\"B0\t\u0001\u0004\u0001\u0017a\u00055bI>|\u0007oQ8oM\n\u0013x.\u00193dCN$X#\u00019\u0011\u0007E$h/D\u0001s\u0015\t\u0019H$A\u0005ce>\fGmY1ti&\u0011QO\u001d\u0002\n\u0005J|\u0017\rZ2bgR\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003wb\u0014\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006!\u0002.\u00193p_B\u001cuN\u001c4Ce>\fGmY1ti\u0002\n!B]3bIN\u001b\u0007.Z7b)\u0005i\u0014a\u00059mC:Le\u000e];u!\u0006\u0014H/\u001b;j_:\u001cHCAA\u0002!\u00151\u0016QAA\u0005\u0013\r\t9a\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004[\u0005-\u0011bAA\u0007]\tq\u0011J\u001c9viB\u000b'\u000f^5uS>t\u0017aE2sK\u0006$XMU3bI\u0016\u0014h)Y2u_JLHCAA\n!\ri\u0013QC\u0005\u0004\u0003/q#A\u0006)beRLG/[8o%\u0016\fG-\u001a:GC\u000e$xN]=\u0002\u000fQ|')\u0019;dQR\tA'A\u0006eKN\u001c'/\u001b9uS>tGCAA\u0011!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003O9VBAA\u0015\u0015\r\tYCI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=r+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_9\u0016!I:uCR,7\t[3dWB|\u0017N\u001c;QCJ$\u0018\u000e^5p]NdunY1uS>tWCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n!AZ:\u000b\u0007\u0005\u0015c$\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003\u0013\nyD\u0001\u0003QCRD\u0007")
public class StateScan
implements Scan,
Batch {
    private final SparkSession session;
    private final StructType schema;
    private final StateSourceOptions sourceOptions;
    private final StateStoreConf stateStoreConf;
    private final KeyStateEncoderSpec keyStateEncoderSpec;
    private final Option<TransformWithStateVariableInfo> stateVariableInfoOpt;
    private final Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt;
    private final Broadcast<SerializableConfiguration> hadoopConfBroadcast;

    public MicroBatchStream toMicroBatchStream(String x$1) {
        return super.toMicroBatchStream(x$1);
    }

    public ContinuousStream toContinuousStream(String x$1) {
        return super.toContinuousStream(x$1);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return super.supportedCustomMetrics();
    }

    public CustomTaskMetric[] reportDriverMetrics() {
        return super.reportDriverMetrics();
    }

    public Scan.ColumnarSupportMode columnarSupportMode() {
        return super.columnarSupportMode();
    }

    private Broadcast<SerializableConfiguration> hadoopConfBroadcast() {
        return this.hadoopConfBroadcast;
    }

    public StructType readSchema() {
        return this.schema;
    }

    public InputPartition[] planInputPartitions() {
        FileSystem fs2 = this.stateCheckpointPartitionsLocation().getFileSystem(((SerializableConfiguration)this.hadoopConfBroadcast().value()).value());
        FileStatus[] partitions = fs2.listStatus(this.stateCheckpointPartitionsLocation(), new PathFilter(null, fs2){
            private final FileSystem fs$1;

            public boolean accept(Path path) {
                return this.fs$1.getFileStatus(path).isDirectory() && Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(path.getName()))).isSuccess() && StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(path.getName())) >= 0;
            }
            {
                this.fs$1 = fs$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1(org.apache.hadoop.fs.Path )}, serializedLambda);
            }
        });
        if (ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])partitions)).isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.noPartitionDiscoveredInStateStore(this.sourceOptions);
        }
        UUID queryId = UUID.randomUUID();
        FileStatus[] partitionsSorted = (FileStatus[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])partitions), (Function1 & Serializable)fs -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fs.getPath().getName()))), (Ordering)Ordering.Int$.MODULE$);
        int[] partitionNums = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionsSorted), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1.getPath().getName()))), (ClassTag)ClassTag$.MODULE$.Int());
        int head = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(partitionNums)));
        int tail = partitionNums[partitionNums.length - 1];
        Predef$.MODULE$.assert(head == 0, (Function0 & Serializable)() -> "Partition should start with 0");
        Predef$.MODULE$.assert(tail - head + 1 == partitionNums.length, (Function0 & Serializable)() -> "No continuous partitions in state: " + Predef$.MODULE$.wrapIntArray(partitionNums).mkString("Array(", ", ", ")"));
        Option<FromSnapshotOptions> option = this.sourceOptions.fromSnapshotOptions();
        if (None$.MODULE$.equals(option)) {
            return (InputPartition[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partitionNums), (Function1 & Serializable)pn -> StateScan.$anonfun$planInputPartitions$5(this, queryId, BoxesRunTime.unboxToInt((Object)pn)), ClassTag$.MODULE$.apply(StateStoreInputPartition.class))), ClassTag$.MODULE$.apply(InputPartition.class));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            FromSnapshotOptions fromSnapshotOptions = (FromSnapshotOptions)some.value();
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partitionNums), (Object)BoxesRunTime.boxToInteger((int)fromSnapshotOptions.snapshotPartitionId()))) {
                return (InputPartition[])((Object[])new InputPartition[]{new StateStoreInputPartition(fromSnapshotOptions.snapshotPartitionId(), queryId, this.sourceOptions)});
            }
            throw StateStoreErrors$.MODULE$.stateStoreSnapshotPartitionNotFound(fromSnapshotOptions.snapshotPartitionId(), this.sourceOptions.operatorId(), this.sourceOptions.stateCheckpointLocation().toString());
        }
        throw new MatchError(option);
    }

    public PartitionReaderFactory createReaderFactory() {
        Enumeration.Value value = this.sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType userFacingSchema = this.schema;
            StructType stateSchema = StreamStreamJoinStateHelper$.MODULE$.readSchema(this.session, this.sourceOptions.stateCheckpointLocation().toString(), this.sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, false);
            return new StreamStreamJoinStatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), userFacingSchema, stateSchema);
        }
        Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            StructType userFacingSchema = this.schema;
            StructType stateSchema = StreamStreamJoinStateHelper$.MODULE$.readSchema(this.session, this.sourceOptions.stateCheckpointLocation().toString(), this.sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, false);
            return new StreamStreamJoinStatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), userFacingSchema, stateSchema);
        }
        Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new StatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), this.schema, this.keyStateEncoderSpec, this.stateVariableInfoOpt, this.stateStoreColFamilySchemaOpt);
        }
        throw new MatchError((Object)value);
    }

    public Batch toBatch() {
        return this;
    }

    public String description() {
        String desc;
        block2: {
            Option<FromSnapshotOptions> option;
            desc = "StateScan [stateCkptLocation=" + this.sourceOptions.stateCheckpointLocation() + "][batchId=" + this.sourceOptions.batchId() + "][operatorId=" + this.sourceOptions.operatorId() + "][storeName=" + this.sourceOptions.storeName() + "]";
            Enumeration.Value value = this.sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.none();
            if (value == null ? value2 != null : !value.equals(value2)) {
                desc = desc + "[joinSide=" + this.sourceOptions.joinSide() + "]";
            }
            if ((option = this.sourceOptions.fromSnapshotOptions()) instanceof Some) {
                Some some = (Some)option;
                FromSnapshotOptions fromSnapshotOptions = (FromSnapshotOptions)some.value();
                desc = desc + "[snapshotStartBatchId=" + fromSnapshotOptions.snapshotStartBatchId() + "]";
                desc = desc + "[snapshotPartitionId=" + fromSnapshotOptions.snapshotPartitionId() + "]";
            }
            Option<ReadChangeFeedOptions> option2 = this.sourceOptions.readChangeFeedOptions();
            if (!(option2 instanceof Some)) break block2;
            Some some = (Some)option2;
            ReadChangeFeedOptions fromSnapshotOptions = (ReadChangeFeedOptions)some.value();
            desc = desc + "[changeStartBatchId=" + fromSnapshotOptions.changeStartBatchId();
            desc = desc + "[changeEndBatchId=" + fromSnapshotOptions.changeEndBatchId();
        }
        return desc;
    }

    private Path stateCheckpointPartitionsLocation() {
        return new Path(this.sourceOptions.stateCheckpointLocation(), Integer.toString(this.sourceOptions.operatorId()));
    }

    public static final /* synthetic */ StateStoreInputPartition $anonfun$planInputPartitions$5(StateScan $this, UUID queryId$1, int pn) {
        return new StateStoreInputPartition(pn, queryId$1, $this.sourceOptions);
    }

    public StateScan(SparkSession session, StructType schema, StateSourceOptions sourceOptions, StateStoreConf stateStoreConf, KeyStateEncoderSpec keyStateEncoderSpec, Option<TransformWithStateVariableInfo> stateVariableInfoOpt, Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt) {
        this.session = session;
        this.schema = schema;
        this.sourceOptions = sourceOptions;
        this.stateStoreConf = stateStoreConf;
        this.keyStateEncoderSpec = keyStateEncoderSpec;
        this.stateVariableInfoOpt = stateVariableInfoOpt;
        this.stateStoreColFamilySchemaOpt = stateStoreColFamilySchemaOpt;
        this.hadoopConfBroadcast = session.sparkContext().broadcast((Object)new SerializableConfiguration(session.sessionState().newHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
    }
}

