/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.DataSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.FromSnapshotOptions;
import org.apache.spark.sql.execution.datasources.v2.state.ReadChangeFeedOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.streaming.CommitLog;
import org.apache.spark.sql.execution.streaming.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class StateSourceOptions$
implements DataSourceOptions,
Serializable {
    public static final StateSourceOptions$ MODULE$ = new StateSourceOptions$();
    private static final String PATH;
    private static final String BATCH_ID;
    private static final String OPERATOR_ID;
    private static final String STORE_NAME;
    private static final String JOIN_SIDE;
    private static final String SNAPSHOT_START_BATCH_ID;
    private static final String SNAPSHOT_PARTITION_ID;
    private static final String READ_CHANGE_FEED;
    private static final String CHANGE_START_BATCH_ID;
    private static final String CHANGE_END_BATCH_ID;
    private static final String STATE_VAR_NAME;
    private static Map<String, Option<String>> org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions;

    static {
        DataSourceOptions.$init$((DataSourceOptions)MODULE$);
        PATH = MODULE$.newOption("path");
        BATCH_ID = MODULE$.newOption("batchId");
        OPERATOR_ID = MODULE$.newOption("operatorId");
        STORE_NAME = MODULE$.newOption("storeName");
        JOIN_SIDE = MODULE$.newOption("joinSide");
        SNAPSHOT_START_BATCH_ID = MODULE$.newOption("snapshotStartBatchId");
        SNAPSHOT_PARTITION_ID = MODULE$.newOption("snapshotPartitionId");
        READ_CHANGE_FEED = MODULE$.newOption("readChangeFeed");
        CHANGE_START_BATCH_ID = MODULE$.newOption("changeStartBatchId");
        CHANGE_END_BATCH_ID = MODULE$.newOption("changeEndBatchId");
        STATE_VAR_NAME = MODULE$.newOption("stateVarName");
    }

    public String newOption(String name) {
        return DataSourceOptions.newOption$((DataSourceOptions)this, (String)name);
    }

    public void newOption(String name, String alternative) {
        DataSourceOptions.newOption$((DataSourceOptions)this, (String)name, (String)alternative);
    }

    public Set<String> getAllOptions() {
        return DataSourceOptions.getAllOptions$((DataSourceOptions)this);
    }

    public boolean isValidOption(String name) {
        return DataSourceOptions.isValidOption$((DataSourceOptions)this, (String)name);
    }

    public Option<String> getAlternativeOption(String name) {
        return DataSourceOptions.getAlternativeOption$((DataSourceOptions)this, (String)name);
    }

    public Map<String, Option<String>> org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions() {
        return org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions;
    }

    public final void org$apache$spark$sql$catalyst$DataSourceOptions$_setter_$org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions_$eq(Map<String, Option<String>> x$1) {
        org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions = x$1;
    }

    public String PATH() {
        return PATH;
    }

    public String BATCH_ID() {
        return BATCH_ID;
    }

    public String OPERATOR_ID() {
        return OPERATOR_ID;
    }

    public String STORE_NAME() {
        return STORE_NAME;
    }

    public String JOIN_SIDE() {
        return JOIN_SIDE;
    }

    public String SNAPSHOT_START_BATCH_ID() {
        return SNAPSHOT_START_BATCH_ID;
    }

    public String SNAPSHOT_PARTITION_ID() {
        return SNAPSHOT_PARTITION_ID;
    }

    public String READ_CHANGE_FEED() {
        return READ_CHANGE_FEED;
    }

    public String CHANGE_START_BATCH_ID() {
        return CHANGE_START_BATCH_ID;
    }

    public String CHANGE_END_BATCH_ID() {
        return CHANGE_END_BATCH_ID;
    }

    public String STATE_VAR_NAME() {
        return STATE_VAR_NAME;
    }

    public StateSourceOptions apply(SparkSession sparkSession, Configuration hadoopConf, java.util.Map<String, String> properties) {
        return this.apply(sparkSession, hadoopConf, new CaseInsensitiveStringMap(properties));
    }

    public StateSourceOptions apply(SparkSession sparkSession, Configuration hadoopConf, CaseInsensitiveStringMap options) {
        Enumeration.Value joinSide;
        Enumeration.Value value;
        String checkpointLocation = (String)Option$.MODULE$.apply((Object)options.get((Object)this.PATH())).orElse((Function0 & Serializable)() -> {
            throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(MODULE$.PATH());
        }).get();
        int operatorId = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)options.get((Object)this.OPERATOR_ID())).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3)))).orElse((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)0))).get());
        if (operatorId < 0) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.OPERATOR_ID());
        }
        String storeName = (String)Option$.MODULE$.apply((Object)options.get((Object)this.STORE_NAME())).map((Function1 & Serializable)x$4 -> x$4.trim()).getOrElse((Function0 & Serializable)() -> StateStoreId$.MODULE$.DEFAULT_STORE_NAME());
        if (storeName.isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsEmpty(this.STORE_NAME());
        }
        Option stateVarName = Option$.MODULE$.apply((Object)options.get((Object)this.STATE_VAR_NAME())).map((Function1 & Serializable)x$5 -> x$5.trim());
        try {
            value = (Enumeration.Value)Option$.MODULE$.apply((Object)options.get((Object)this.JOIN_SIDE())).map((Function1 & Serializable)s -> StateSourceOptions$JoinSideValues$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable)() -> StateSourceOptions$JoinSideValues$.MODULE$.none());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.JOIN_SIDE(), "Valid values are " + StateSourceOptions$JoinSideValues$.MODULE$.values().mkString(","));
        }
        Enumeration.Value value2 = joinSide = value;
        Enumeration.Value value3 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (value2 == null ? value3 != null : !value2.equals(value3)) {
            String string = storeName;
            String string2 = StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.JOIN_SIDE(), (List)new .colon.colon((Object)this.STORE_NAME(), (List)Nil$.MODULE$)));
            }
        }
        String resolvedCpLocation = this.resolvedCheckpointLocation(hadoopConf, checkpointLocation);
        ObjectRef batchId = ObjectRef.create((Object)Option$.MODULE$.apply((Object)options.get((Object)this.BATCH_ID())).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6)))));
        Option snapshotStartBatchId = Option$.MODULE$.apply((Object)options.get((Object)this.SNAPSHOT_START_BATCH_ID())).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7))));
        Option snapshotPartitionId = Option$.MODULE$.apply((Object)options.get((Object)this.SNAPSHOT_PARTITION_ID())).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$8))));
        boolean readChangeFeed = Option$.MODULE$.apply((Object)options.get((Object)this.READ_CHANGE_FEED())).exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$9))));
        Option changeStartBatchId = Option$.MODULE$.apply((Object)options.get((Object)this.CHANGE_START_BATCH_ID())).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$10))));
        Option changeEndBatchId = Option$.MODULE$.apply((Object)options.get((Object)this.CHANGE_END_BATCH_ID())).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$11))));
        None$ fromSnapshotOptions = None$.MODULE$;
        None$ readChangeFeedOptions = None$.MODULE$;
        if (readChangeFeed) {
            Enumeration.Value value4 = joinSide;
            Enumeration.Value value5 = StateSourceOptions$JoinSideValues$.MODULE$.none();
            if (value4 == null ? value5 != null : !value4.equals(value5)) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.JOIN_SIDE(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (((Option)batchId.elem).isDefined()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.BATCH_ID(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (snapshotStartBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.SNAPSHOT_START_BATCH_ID(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (snapshotPartitionId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.SNAPSHOT_PARTITION_ID(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (changeStartBatchId.isEmpty()) {
                throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(this.CHANGE_START_BATCH_ID());
            }
            changeEndBatchId = new Some(changeEndBatchId.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.getLastCommittedBatch(sparkSession, resolvedCpLocation)));
            if (BoxesRunTime.unboxToLong((Object)changeStartBatchId.get()) < 0L) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.CHANGE_START_BATCH_ID());
            }
            if (BoxesRunTime.unboxToLong((Object)changeEndBatchId.get()) < BoxesRunTime.unboxToLong((Object)changeStartBatchId.get())) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.CHANGE_END_BATCH_ID(), this.CHANGE_END_BATCH_ID() + " cannot be smaller than " + this.CHANGE_START_BATCH_ID() + ". Please check the input to " + this.CHANGE_END_BATCH_ID() + ", or if you are using its default value, make sure that " + this.CHANGE_START_BATCH_ID() + " is less than " + changeEndBatchId.get() + ".");
            }
            batchId.elem = new Some(changeEndBatchId.get());
            readChangeFeedOptions = Option$.MODULE$.apply((Object)new ReadChangeFeedOptions(BoxesRunTime.unboxToLong((Object)changeStartBatchId.get()), BoxesRunTime.unboxToLong((Object)changeEndBatchId.get())));
        } else {
            if (changeStartBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.CHANGE_START_BATCH_ID(), "Only specify this option when " + this.READ_CHANGE_FEED() + " is set to true.");
            }
            if (changeEndBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.CHANGE_END_BATCH_ID(), "Only specify this option when " + this.READ_CHANGE_FEED() + " is set to true.");
            }
            batchId.elem = new Some(((Option)batchId.elem).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.getLastCommittedBatch(sparkSession, resolvedCpLocation)));
            if (BoxesRunTime.unboxToLong((Object)((Option)batchId.elem).get()) < 0L) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.BATCH_ID());
            }
            if (snapshotStartBatchId.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$12 -> x$12 < 0L)) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.SNAPSHOT_START_BATCH_ID());
            }
            if (snapshotStartBatchId.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$13 -> x$13 > BoxesRunTime.unboxToLong((Object)((Option)batchId$2.elem).get()))) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.SNAPSHOT_START_BATCH_ID(), "value should be less than or equal to " + ((Option)batchId.elem).get());
            }
            if (snapshotPartitionId.exists((Function1)(JFunction1.mcZI.sp & Serializable)x$14 -> x$14 < 0)) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.SNAPSHOT_PARTITION_ID());
            }
            if (snapshotPartitionId.isDefined() && snapshotStartBatchId.isEmpty()) {
                throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(this.SNAPSHOT_START_BATCH_ID());
            }
            if (snapshotPartitionId.isEmpty() && snapshotStartBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(this.SNAPSHOT_PARTITION_ID());
            }
            if (snapshotStartBatchId.isDefined() && snapshotPartitionId.isDefined()) {
                fromSnapshotOptions = new Some((Object)new FromSnapshotOptions(BoxesRunTime.unboxToLong((Object)snapshotStartBatchId.get()), BoxesRunTime.unboxToInt((Object)snapshotPartitionId.get())));
            }
        }
        return new StateSourceOptions(resolvedCpLocation, BoxesRunTime.unboxToLong((Object)((Option)batchId.elem).get()), operatorId, storeName, joinSide, readChangeFeed, (Option<FromSnapshotOptions>)fromSnapshotOptions, (Option<ReadChangeFeedOptions>)readChangeFeedOptions, (Option<String>)stateVarName);
    }

    private String resolvedCheckpointLocation(Configuration hadoopConf, String checkpointLocation) {
        Path checkpointPath = new Path(checkpointLocation);
        FileSystem fs = checkpointPath.getFileSystem(hadoopConf);
        return checkpointPath.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toUri().toString();
    }

    private long getLastCommittedBatch(SparkSession session, String checkpointLocation) {
        Some some;
        Tuple2 tuple2;
        CommitLog commitLog = new CommitLog(session, new Path(checkpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_COMMITS()).toString());
        Option option = commitLog.getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            long lastId = tuple2._1$mcJ$sp();
            return lastId;
        }
        if (None$.MODULE$.equals(option)) {
            throw StateDataSourceErrors$.MODULE$.committedBatchUnavailable(checkpointLocation);
        }
        throw new MatchError(option);
    }

    public StateSourceOptions apply(String resolvedCpLocation, long batchId, int operatorId, String storeName, Enumeration.Value joinSide, boolean readChangeFeed, Option<FromSnapshotOptions> fromSnapshotOptions, Option<ReadChangeFeedOptions> readChangeFeedOptions, Option<String> stateVarName) {
        return new StateSourceOptions(resolvedCpLocation, batchId, operatorId, storeName, joinSide, readChangeFeed, fromSnapshotOptions, readChangeFeedOptions, stateVarName);
    }

    public Option<Tuple9<String, Object, Object, String, Enumeration.Value, Object, Option<FromSnapshotOptions>, Option<ReadChangeFeedOptions>, Option<String>>> unapply(StateSourceOptions x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple9((Object)x$0.resolvedCpLocation(), (Object)BoxesRunTime.boxToLong((long)x$0.batchId()), (Object)BoxesRunTime.boxToInteger((int)x$0.operatorId()), (Object)x$0.storeName(), (Object)x$0.joinSide(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.readChangeFeed()), x$0.fromSnapshotOptions(), x$0.readChangeFeedOptions(), x$0.stateVarName()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StateSourceOptions$.class);
    }

    private StateSourceOptions$() {
    }
}

