/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder$;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001B\u0013'\u0001MB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!1\u0007A!A!\u0002\u00139\u0007\"\u00026\u0001\t\u0003Y\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u0002;\t\u000fY\u0004!\u0019!C\u0005o\"1a\u0010\u0001Q\u0001\naDqa \u0001C\u0002\u0013%q\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002=\t\u0011\u0005\r\u0001A1A\u0005\n]Dq!!\u0002\u0001A\u0003%\u0001\u0010C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011q\u0003\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u00111\u0004\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011q\u0004\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u00111\n\u0001!\u0002\u0013\t)\u0003C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002P!A\u00111\u000b\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!A\u0011q\f\u0001!\u0002\u0013\tI\u0006C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA:\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017;\u0011\"a$'\u0003\u0003E\t!!%\u0007\u0011\u00152\u0013\u0011!E\u0001\u0003'CaA\u001b\u0012\u0005\u0002\u0005m\u0005\"CAOEE\u0005I\u0011AAP\u0005a\u0019u.\u001c9pg&$XmS3z'R\fG/Z#oG>$WM\u001d\u0006\u0003O!\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005%R\u0013!C3yK\u000e,H/[8o\u0015\tYC&A\u0002tc2T!!\f\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0002\u0014AB1qC\u000eDWMC\u00012\u0003\ry'oZ\u0002\u0001+\r!dkO\n\u0003\u0001U\u00022AN\u001c:\u001b\u00051\u0013B\u0001\u001d'\u0005E\u0019F/\u0019;f)f\u0004Xm]#oG>$WM\u001d\t\u0003umb\u0001\u0001B\u0003=\u0001\t\u0007QHA\u0001W#\tqD\t\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005IA\u0004O_RD\u0017N\\4\u0011\u0005}*\u0015B\u0001$A\u0005\r\te._\u0001\u000bW\u0016LXI\\2pI\u0016\u0014\bcA%O\t6\t!J\u0003\u0002L\u0019\u0006AQM\\2pI\u0016\u00148O\u0003\u0002NU\u0005A1-\u0019;bYf\u001cH/\u0003\u0002P\u0015\n\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0002\u0015U\u001cXM]&fs\u0016s7\rE\u0002S'Vk\u0011AK\u0005\u0003)*\u0012q!\u00128d_\u0012,'\u000f\u0005\u0002;-\u0012)q\u000b\u0001b\u0001{\t\t1*\u0001\u0006wC2,enY8eKJ\u00042AU*:\u0003%\u0019H/\u0019;f\u001d\u0006lW\r\u0005\u0002]G:\u0011Q,\u0019\t\u0003=\u0002k\u0011a\u0018\u0006\u0003AJ\na\u0001\u0010:p_Rt\u0014B\u00012A\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0004\u0015A\u00025bgR#H\u000e\u0005\u0002@Q&\u0011\u0011\u000e\u0011\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q1A.\u001c8paF\u0004BA\u000e\u0001Vs!)qI\u0002a\u0001\u0011\")\u0001K\u0002a\u0001#\")\u0001L\u0002a\u00013\")!L\u0002a\u00017\"9aM\u0002I\u0001\u0002\u00049\u0017\u0001F;tKJ\\U-_#yaJ,7o]5p]\u0016s7-F\u0001u!\rIe*V\u0001\u0016kN,'oS3z\u000bb\u0004(/Z:tS>tWI\\2!\u0003]\u00198\r[3nC\u001a{'o\u0012:pkBLgnZ&fsJ{w/F\u0001y!\tIH0D\u0001{\u0015\tY(&A\u0003usB,7/\u0003\u0002~u\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u00021M\u001c\u0007.Z7b\r>\u0014xI]8va&twmS3z%><\b%A\ntG\",W.\u0019$peV\u001bXM]&fsJ{w/\u0001\u000btG\",W.\u0019$peV\u001bXM]&fsJ{w\u000fI\u0001\u0019g\u000eDW-\\1G_J\u001cu.\u001c9pg&$XmS3z%><\u0018!G:dQ\u0016l\u0017MR8s\u0007>l\u0007o\\:ji\u0016\\U-\u001f*po\u0002\n\u0011#^:fe.+\u0017\u0010\u0015:pU\u0016\u001cG/[8o+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002T\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\u0016\u0005=!\u0001E+og\u00064W\r\u0015:pU\u0016\u001cG/[8o\u0003I)8/\u001a:LKf\u0004&o\u001c6fGRLwN\u001c\u0011\u0002+\u001d\u0014x.\u001e9j]\u001e\\U-\u001f)s_*,7\r^5p]\u00061rM]8va&twmS3z!J|'.Z2uS>t\u0007%\u0001\fd_6\u0004xn]5uK.+\u0017\u0010\u0015:pU\u0016\u001cG/[8o\u0003]\u0019w.\u001c9pg&$XmS3z!J|'.Z2uS>t\u0007%A\u000bhe>,\b/\u001b8h\u0017\u0016L8+\u001a:jC2L'0\u001a:\u0016\u0005\u0005\u0015\u0002#BA\u0014\u0003\u000b\"e\u0002BA\u0015\u0003\u0003rA!a\u000b\u0002@9!\u0011QFA\u001f\u001d\u0011\ty#a\u000f\u000f\t\u0005E\u0012\u0011\b\b\u0005\u0003g\t9DD\u0002_\u0003kI\u0011!M\u0005\u0003_AJ!!\f\u0018\n\u0005-b\u0013BA'+\u0013\tYE*C\u0002\u0002D)\u000b\u0011#\u0012=qe\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s\u0013\u0011\t9%!\u0013\u0003\u0015M+'/[1mSj,'OC\u0002\u0002D)\u000bac\u001a:pkBLgnZ&fsN+'/[1mSj,'\u000fI\u0001\u0012kN,'oS3z'\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAA)!\u0015\t9#!\u0012V\u0003I)8/\u001a:LKf\u001cVM]5bY&TXM\u001d\u0011\u00027U\u001cXM]&fsJ{w\u000fV8PE*$Um]3sS\u0006d\u0017N_3s+\t\tI\u0006E\u0003\u0002(\u0005mS+\u0003\u0003\u0002^\u0005%#\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001H;tKJ\\U-\u001f*poR{wJ\u00196EKN,'/[1mSj,'\u000fI\u0001\u0012K:\u001cw\u000eZ3He>,\b/\u001b8h\u0017\u0016LHCAA3!\u0011\ti!a\u001a\n\t\u0005%\u0014q\u0002\u0002\n+:\u001c\u0018MZ3S_^\fQ\"\u001a8d_\u0012,Wk]3s\u0017\u0016LH\u0003BA3\u0003_Ba!!\u001d\u001d\u0001\u0004)\u0016aB;tKJ\\U-_\u0001\u0013K:\u001cw\u000eZ3D_6\u0004xn]5uK.+\u0017\u0010\u0006\u0003\u0002f\u0005]\u0004BBA9;\u0001\u0007Q\u000b\u0006\u0004\u0002f\u0005m\u0014q\u0010\u0005\b\u0003{r\u0002\u0019AA3\u0003-9'o\\;qS:<7*Z=\t\u000f\u0005Ed\u00041\u0001\u0002f\u0005iA-Z2pI\u0016,6/\u001a:LKf$2!VAC\u0011\u001d\t9i\ba\u0001\u0003K\n1A]8x\u0003I!WmY8eK\u000e{W\u000e]8tSR,7*Z=\u0015\u0007U\u000bi\tC\u0004\u0002\b\u0002\u0002\r!!\u001a\u00021\r{W\u000e]8tSR,7*Z=Ti\u0006$X-\u00128d_\u0012,'\u000f\u0005\u00027EM\u0019!%!&\u0011\u0007}\n9*C\u0002\u0002\u001a\u0002\u0013a!\u00118z%\u00164GCAAI\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU1\u0011\u0011UA\\\u0003s+\"!a)+\u0007\u001d\f)k\u000b\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!C;oG\",7m[3e\u0015\r\t\t\fQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA[\u0003W\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u00159FE1\u0001>\t\u0015aDE1\u0001>\u0001")
public class CompositeKeyStateEncoder<K, V>
extends StateTypesEncoder<V> {
    private final Encoder<K> userKeyEnc;
    private final String stateName;
    private final ExpressionEncoder<K> userKeyExpressionEnc;
    private final StructType schemaForGroupingKeyRow;
    private final StructType schemaForUserKeyRow;
    private final StructType schemaForCompositeKeyRow;
    private final UnsafeProjection userKeyProjection;
    private final UnsafeProjection groupingKeyProjection;
    private final UnsafeProjection compositeKeyProjection;
    private final ExpressionEncoder.Serializer<Object> groupingKeySerializer;
    private final ExpressionEncoder.Serializer<K> userKeySerializer;
    private final ExpressionEncoder.Deserializer<K> userKeyRowToObjDeserializer;

    public static <K, V> boolean $lessinit$greater$default$5() {
        return CompositeKeyStateEncoder$.MODULE$.$lessinit$greater$default$5();
    }

    private ExpressionEncoder<K> userKeyExpressionEnc() {
        return this.userKeyExpressionEnc;
    }

    private StructType schemaForGroupingKeyRow() {
        return this.schemaForGroupingKeyRow;
    }

    private StructType schemaForUserKeyRow() {
        return this.schemaForUserKeyRow;
    }

    private StructType schemaForCompositeKeyRow() {
        return this.schemaForCompositeKeyRow;
    }

    private UnsafeProjection userKeyProjection() {
        return this.userKeyProjection;
    }

    private UnsafeProjection groupingKeyProjection() {
        return this.groupingKeyProjection;
    }

    private UnsafeProjection compositeKeyProjection() {
        return this.compositeKeyProjection;
    }

    private ExpressionEncoder.Serializer<Object> groupingKeySerializer() {
        return this.groupingKeySerializer;
    }

    private ExpressionEncoder.Serializer<K> userKeySerializer() {
        return this.userKeySerializer;
    }

    private ExpressionEncoder.Deserializer<K> userKeyRowToObjDeserializer() {
        return this.userKeyRowToObjDeserializer;
    }

    @Override
    public UnsafeRow encodeGroupingKey() {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(this.stateName);
        }
        Object groupingKey = keyOption.get();
        InternalRow groupingKeyRow = this.groupingKeySerializer().apply(groupingKey);
        return this.groupingKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupingKeyRow})));
    }

    public UnsafeRow encodeUserKey(K userKey) {
        InternalRow userKeyRow = this.userKeySerializer().apply(userKey);
        return this.userKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{userKeyRow})));
    }

    public UnsafeRow encodeCompositeKey(K userKey) {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(this.stateName);
        }
        Object groupingKey = keyOption.get();
        InternalRow keyRow = this.groupingKeySerializer().apply(groupingKey);
        InternalRow userKeyRow = this.userKeySerializer().apply(userKey);
        return this.compositeKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{keyRow, userKeyRow})));
    }

    public UnsafeRow encodeCompositeKey(UnsafeRow groupingKey, UnsafeRow userKey) {
        return this.compositeKeyProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupingKey, userKey})));
    }

    public K decodeUserKey(UnsafeRow row) {
        return (K)this.userKeyRowToObjDeserializer().apply((InternalRow)row);
    }

    public K decodeCompositeKey(UnsafeRow row) {
        return (K)this.userKeyRowToObjDeserializer().apply((InternalRow)row.getStruct(1, this.userKeyEnc.schema().length()));
    }

    public CompositeKeyStateEncoder(ExpressionEncoder<Object> keyEncoder, Encoder<K> userKeyEnc, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        this.userKeyEnc = userKeyEnc;
        this.stateName = stateName;
        super(keyEncoder, valEncoder, stateName, hasTtl);
        this.userKeyExpressionEnc = package$.MODULE$.encoderFor(userKeyEnc);
        this.schemaForGroupingKeyRow = new StructType().add("key", (DataType)keyEncoder.schema());
        this.schemaForUserKeyRow = new StructType().add("userKey", (DataType)userKeyEnc.schema());
        this.schemaForCompositeKeyRow = TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(keyEncoder.schema(), userKeyEnc.schema());
        this.userKeyProjection = UnsafeProjection$.MODULE$.create(this.schemaForUserKeyRow());
        this.groupingKeyProjection = UnsafeProjection$.MODULE$.create(this.schemaForGroupingKeyRow());
        this.compositeKeyProjection = UnsafeProjection$.MODULE$.create(this.schemaForCompositeKeyRow());
        this.groupingKeySerializer = keyEncoder.createSerializer();
        this.userKeySerializer = this.userKeyExpressionEnc().createSerializer();
        this.userKeyRowToObjDeserializer = this.userKeyExpressionEnc().resolveAndBind(this.userKeyExpressionEnc().resolveAndBind$default$1(), this.userKeyExpressionEnc().resolveAndBind$default$2()).createDeserializer();
    }
}

