/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.ListStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.SingleKeyTTLStateImpl;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.util.NextIterator;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001B\f\u0019\u0001\u0015B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u000b\u001d\u0004A\u0011\u00015\t\u0011A\u0004\u0001R1A\u0005\nED\u0001\"\u001e\u0001\t\u0006\u0004%IA\u001e\u0005\u0006o\u0002!I\u0001\u001f\u0005\u0006y\u0002!\t% \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\tI\u0002\u0001C!\u00037Aq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002.\u0001!\t%a\f\t\r\u0005M\u0002\u0001\"\u0011y\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002P\u0001!I!!\u0015\t\u0011\u0005]\u0003\u0001\"\u0001\u001d\u0003\u000bA\u0001\"!\u0017\u0001\t\u0003a\u00121\f\u0005\t\u0003K\u0002A\u0011\u0001\u000f\u0002h\t!B*[:u'R\fG/Z%na2<\u0016\u000e\u001e5U)2S!!\u0007\u000e\u0002\u0013M$(/Z1nS:<'BA\u000e\u001d\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001e=\u0005\u00191/\u001d7\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001!\u0006\u0002'eM\u0019\u0001aJ\u0016\u0011\u0005!JS\"\u0001\r\n\u0005)B\"!F*j]\u001edWmS3z)Rc5\u000b^1uK&k\u0007\u000f\u001c\t\u0004Y9\u0002T\"A\u0017\u000b\u0005ea\u0012BA\u0018.\u0005%a\u0015n\u001d;Ti\u0006$X\r\u0005\u00022e1\u0001A!B\u001a\u0001\u0005\u0004!$!A*\u0012\u0005UZ\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$a\u0002(pi\"Lgn\u001a\t\u0003mqJ!!P\u001c\u0003\u0007\u0005s\u00170A\u0003ti>\u0014X\r\u0005\u0002A\u00076\t\u0011I\u0003\u0002C1\u0005)1\u000f^1uK&\u0011A)\u0011\u0002\u000b'R\fG/Z*u_J,\u0017!C:uCR,g*Y7f!\t9eJ\u0004\u0002I\u0019B\u0011\u0011jN\u0007\u0002\u0015*\u00111\nJ\u0001\u0007yI|w\u000e\u001e \n\u00055;\u0014A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!T\u001c\u0002\u0015-,\u00170\u0012=qe\u0016s7\rE\u0002T1nj\u0011\u0001\u0016\u0006\u0003+Z\u000b\u0001\"\u001a8d_\u0012,'o\u001d\u0006\u0003/r\t\u0001bY1uC2L8\u000f^\u0005\u00033R\u0013\u0011#\u0012=qe\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s\u0003)1\u0018\r\\#oG>$WM\u001d\t\u00049v\u0003T\"\u0001\u000f\n\u0005yc\"aB#oG>$WM]\u0001\niRd7i\u001c8gS\u001e\u0004\"\u0001L1\n\u0005\tl#!\u0003+U\u0019\u000e{gNZ5h\u0003A\u0011\u0017\r^2i)&lWm\u001d;b[Bl5\u000f\u0005\u00027K&\u0011am\u000e\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\bS*\\G.\u001c8p!\rA\u0003\u0001\r\u0005\u0006}\u001d\u0001\ra\u0010\u0005\u0006\u000b\u001e\u0001\rA\u0012\u0005\u0006#\u001e\u0001\rA\u0015\u0005\u00065\u001e\u0001\ra\u0017\u0005\u0006?\u001e\u0001\r\u0001\u0019\u0005\u0006G\u001e\u0001\r\u0001Z\u0001\u0012gR\fG/\u001a+za\u0016\u001cXI\\2pI\u0016\u0014X#\u0001:\u0011\u0007!\u001a\b'\u0003\u0002u1\t\t2\u000b^1uKRK\b/Z:F]\u000e|G-\u001a:\u0002\u001fQ$H.\u0012=qSJ\fG/[8o\u001bN,\u0012\u0001Z\u0001\u000bS:LG/[1mSj,G#A=\u0011\u0005YR\u0018BA>8\u0005\u0011)f.\u001b;\u0002\r\u0015D\u0018n\u001d;t)\u0005q\bC\u0001\u001c\u0000\u0013\r\t\ta\u000e\u0002\b\u0005>|G.Z1o\u0003\r9W\r\u001e\u000b\u0003\u0003\u000f\u0001R!!\u0003\u0002\u0014ArA!a\u0003\u0002\u00109\u0019\u0011*!\u0004\n\u0003aJ1!!\u00058\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0006\u0002\u0018\tA\u0011\n^3sCR|'OC\u0002\u0002\u0012]\n1\u0001];u)\rI\u0018Q\u0004\u0005\b\u0003?i\u0001\u0019AA\u0011\u0003!qWm^*uCR,\u0007\u0003\u0002\u001c\u0002$AJ1!!\n8\u0005\u0015\t%O]1z\u0003-\t\u0007\u000f]3oIZ\u000bG.^3\u0015\u0007e\fY\u0003\u0003\u0004\u0002 9\u0001\r\u0001M\u0001\u000bCB\u0004XM\u001c3MSN$HcA=\u00022!9\u0011qD\bA\u0002\u0005\u0005\u0012!B2mK\u0006\u0014\u0018\u0001\u0005<bY&$\u0017\r^3OK^\u001cF/\u0019;f)\rI\u0018\u0011\b\u0005\b\u0003?\t\u0002\u0019AA\u0011\u00039\u0019G.Z1s\u0013\u001a,\u0005\u0010]5sK\u0012$2\u0001ZA \u0011\u001d\t\tE\u0005a\u0001\u0003\u0007\n1b\u001a:pkBLgnZ&fsB!\u0011QIA&\u001b\t\t9EC\u0002\u0002JY\u000b1\"\u001a=qe\u0016\u001c8/[8og&!\u0011QJA$\u0005%)fn]1gKJ{w/\u0001\u000bvaN,'\u000f\u001e+U\u0019\u001a{'o\u0015;bi\u0016\\U-\u001f\u000b\u0004s\u0006M\u0003bBA+'\u0001\u0007\u00111I\u0001\u0013K:\u001cw\u000eZ3e\u000fJ|W\u000f]5oO.+\u00170\u0001\fhKR<\u0016\u000e\u001e5pkR,eNZ8sG&tw\r\u0016+M\u000319W\r\u001e+U\u0019Z\u000bG.^3t)\t\ti\u0006\u0005\u0004\u0002\n\u0005M\u0011q\f\t\u0006m\u0005\u0005\u0004\u0007Z\u0005\u0004\u0003G:$A\u0002+va2,''A\nhKR4\u0016\r\\;fg&sG\u000b\u0016'Ti\u0006$X\r\u0006\u0002\u0002jA)\u0011\u0011BA\nI\u0002")
public class ListStateImplWithTTL<S>
extends SingleKeyTTLStateImpl
implements ListState<S> {
    private StateTypesEncoder<S> org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    private long ttlExpirationMs;
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final Encoder<S> valEncoder;
    private TTLConfig ttlConfig;
    public final long org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs;
    private volatile byte bitmap$0;

    private StateTypesEncoder<S> stateTypesEncoder$lzycompute() {
        ListStateImplWithTTL listStateImplWithTTL = this;
        synchronized (listStateImplWithTTL) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(this.keyExprEnc, this.valEncoder, this.stateName, true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    }

    public StateTypesEncoder<S> org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.stateTypesEncoder$lzycompute();
        }
        return this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    }

    private long ttlExpirationMs$lzycompute() {
        ListStateImplWithTTL listStateImplWithTTL = this;
        synchronized (listStateImplWithTTL) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(this.ttlConfig.ttlDuration(), this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.ttlConfig = null;
        return this.ttlExpirationMs;
    }

    private long ttlExpirationMs() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.ttlExpirationMs$lzycompute();
        }
        return this.ttlExpirationMs;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, this.keyExprEnc.schema(), TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(this.valEncoder.schema(), true), new NoPrefixKeyStateEncoderSpec(this.keyExprEnc.schema()), true, this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get().nonEmpty();
    }

    public Iterator<S> get() {
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedKey, this.stateName);
        return new NextIterator<S>(this, unsafeRowValuesIterator){
            private final /* synthetic */ ListStateImplWithTTL $outer;
            private final Iterator unsafeRowValuesIterator$1;

            public S getNext() {
                Iterator iter = this.unsafeRowValuesIterator$1.dropWhile((Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getNext$1(this, row)));
                if (iter.hasNext()) {
                    UnsafeRow currentRow = (UnsafeRow)iter.next();
                    return this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue(currentRow);
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }

            public static final /* synthetic */ boolean $anonfun$getNext$1($anon$1 $this, UnsafeRow row) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().isExpired(row, $this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unsafeRowValuesIterator$1 = unsafeRowValuesIterator$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getNext$1$adapted(org.apache.spark.sql.execution.streaming.ListStateImplWithTTL$$anon$1 org.apache.spark.sql.catalyst.expressions.UnsafeRow )}, serializedLambda);
            }
        };
    }

    public void put(Object newState) {
        this.validateNewState(newState);
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(newState), (Function1 & Serializable)v -> {
            ListStateImplWithTTL.$anonfun$put$1(this, isFirst, encodedKey, v);
            return BoxedUnit.UNIT;
        });
        this.upsertTTLForStateKey(encodedKey);
    }

    public void appendValue(S newState) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(newState, this.stateName);
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        this.store.merge(encodedKey, this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(newState, this.ttlExpirationMs()), this.stateName);
        this.upsertTTLForStateKey(encodedKey);
    }

    public void appendList(Object newState) {
        this.validateNewState(newState);
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(newState), (Function1 & Serializable)v -> {
            ListStateImplWithTTL.$anonfun$appendList$1(this, encodedKey, v);
            return BoxedUnit.UNIT;
        });
        this.upsertTTLForStateKey(encodedKey);
    }

    public void clear() {
        this.store.remove(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey(), this.stateName);
        this.clearTTLState();
    }

    private void validateNewState(Object newState) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(newState, this.stateName);
        StateStoreErrors$.MODULE$.requireNonEmptyListStateValue(newState, this.stateName);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(newState), (Function1 & Serializable)v -> {
            StateStoreErrors$.MODULE$.requireNonNullStateValue(v, this.stateName);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public long clearIfExpired(UnsafeRow groupingKey) {
        LongRef numValuesExpired = LongRef.create((long)0L);
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(groupingKey, this.stateName);
        this.store.remove(groupingKey, this.stateName);
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        unsafeRowValuesIterator.foreach((Function1 & Serializable)encodedValue -> {
            ListStateImplWithTTL.$anonfun$clearIfExpired$1(this, isFirst, groupingKey, numValuesExpired, encodedValue);
            return BoxedUnit.UNIT;
        });
        return numValuesExpired.elem;
    }

    private void upsertTTLForStateKey(UnsafeRow encodedGroupingKey) {
        this.upsertTTLForStateKey(this.ttlExpirationMs(), encodedGroupingKey);
    }

    public Iterator<S> getWithoutEnforcingTTL() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedGroupingKey, this.stateName);
        return unsafeRowValuesIterator.map((Function1 & Serializable)valueUnsafeRow -> this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue((UnsafeRow)valueUnsafeRow));
    }

    public Iterator<Tuple2<S, Object>> getTTLValues() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedGroupingKey, this.stateName);
        return unsafeRowValuesIterator.map((Function1 & Serializable)valueUnsafeRow -> new Tuple2(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue((UnsafeRow)valueUnsafeRow), this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeTtlExpirationMs((UnsafeRow)valueUnsafeRow).get()));
    }

    public Iterator<Object> getValuesInTTLState() {
        return this.getValuesInTTLState(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey());
    }

    public static final /* synthetic */ void $anonfun$put$1(ListStateImplWithTTL $this, BooleanRef isFirst$1, UnsafeRow encodedKey$1, Object v) {
        UnsafeRow encodedValue = $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(v, $this.ttlExpirationMs());
        if (isFirst$1.elem) {
            $this.store.put(encodedKey$1, encodedValue, $this.stateName);
            isFirst$1.elem = false;
            return;
        }
        $this.store.merge(encodedKey$1, encodedValue, $this.stateName);
    }

    public static final /* synthetic */ void $anonfun$appendList$1(ListStateImplWithTTL $this, UnsafeRow encodedKey$2, Object v) {
        UnsafeRow encodedValue = $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(v, $this.ttlExpirationMs());
        $this.store.merge(encodedKey$2, encodedValue, $this.stateName);
    }

    public static final /* synthetic */ void $anonfun$clearIfExpired$1(ListStateImplWithTTL $this, BooleanRef isFirst$2, UnsafeRow groupingKey$1, LongRef numValuesExpired$1, UnsafeRow encodedValue) {
        if (!$this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().isExpired(encodedValue, $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs)) {
            if (isFirst$2.elem) {
                $this.store.put(groupingKey$1, encodedValue, $this.stateName);
                isFirst$2.elem = false;
                return;
            }
            $this.store.merge(groupingKey$1, encodedValue, $this.stateName);
            return;
        }
        ++numValuesExpired$1.elem;
    }

    public ListStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<S> valEncoder, TTLConfig ttlConfig, long batchTimestampMs) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        this.ttlConfig = ttlConfig;
        this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs = batchTimestampMs;
        super(stateName, store, keyExprEnc, batchTimestampMs);
        this.initialize();
    }
}

