/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!1\u0007A!A!\u0002\u00139\u0007\"\u00025\u0001\t\u0003I\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007s\u0002\u0001\u000b\u0011B:\t\u000fi\u0004!\u0019!C\u0005e\"11\u0010\u0001Q\u0001\nMDq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002@\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\f\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\ti\u0003\u0001C!\u0003_Aq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u00111\f\u0001\u0005B\u0005u#\u0001D'baN#\u0018\r^3J[Bd'B\u0001\r\u001a\u0003%\u0019HO]3b[&twM\u0003\u0002\u001b7\u0005IQ\r_3dkRLwN\u001c\u0006\u00039u\t1a]9m\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\u000b\u0004KMj4\u0003\u0002\u0001'Y}\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007\u0003B\u00170cqj\u0011A\f\u0006\u00031mI!\u0001\r\u0018\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004\"AM\u001a\r\u0001\u0011)A\u0007\u0001b\u0001k\t\t1*\u0005\u00027sA\u0011qeN\u0005\u0003q!\u0012qAT8uQ&tw\r\u0005\u0002(u%\u00111\b\u000b\u0002\u0004\u0003:L\bC\u0001\u001a>\t\u0015q\u0004A1\u00016\u0005\u00051\u0006C\u0001!D\u001b\u0005\t%B\u0001\"\u001e\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001#B\u0005\u001daunZ4j]\u001e\fQa\u001d;pe\u0016\u0004\"a\u0012&\u000e\u0003!S!!S\f\u0002\u000bM$\u0018\r^3\n\u0005-C%AC*uCR,7\u000b^8sK\u0006I1\u000f^1uK:\u000bW.\u001a\t\u0003\u001dVs!aT*\u0011\u0005ACS\"A)\u000b\u0005I\u001b\u0013A\u0002\u001fs_>$h(\u0003\u0002UQ\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!\u0006&\u0001\u0006lKf,\u0005\u0010\u001d:F]\u000e\u00042AW0:\u001b\u0005Y&B\u0001/^\u0003!)gnY8eKJ\u001c(B\u00010\u001c\u0003!\u0019\u0017\r^1msN$\u0018B\u00011\\\u0005E)\u0005\u0010\u001d:fgNLwN\\#oG>$WM]\u0001\u000bkN,'oS3z\u000b:\u001c\u0007cA2ec5\t1$\u0003\u0002f7\t9QI\\2pI\u0016\u0014\u0018A\u0003<bY\u0016s7m\u001c3feB\u00191\r\u001a\u001f\u0002\rqJg.\u001b;?)\u0019QG.\u001c8paB!1\u000eA\u0019=\u001b\u00059\u0002\"B#\u0007\u0001\u00041\u0005\"\u0002'\u0007\u0001\u0004i\u0005\"\u0002-\u0007\u0001\u0004I\u0006\"B1\u0007\u0001\u0004\u0011\u0007\"\u00024\u0007\u0001\u00049\u0017\u0001G:dQ\u0016l\u0017MR8s\u0007>l\u0007o\\:ji\u0016\\U-\u001f*poV\t1\u000f\u0005\u0002uo6\tQO\u0003\u0002w7\u0005)A/\u001f9fg&\u0011\u00010\u001e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!G:dQ\u0016l\u0017MR8s\u0007>l\u0007o\\:ji\u0016\\U-\u001f*po\u0002\n\u0011c]2iK6\fgi\u001c:WC2,XMU8x\u0003I\u00198\r[3nC\u001a{'OV1mk\u0016\u0014vn\u001e\u0011\u0002#M$\u0018\r^3UsB,7/\u00128d_\u0012,'/F\u0001\u007f!\u0011Yw0\r\u001f\n\u0007\u0005\u0005qC\u0001\rD_6\u0004xn]5uK.+\u0017p\u0015;bi\u0016,enY8eKJ\f!c\u001d;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3sA\u00051Q\r_5tiN$\"!!\u0003\u0011\u0007\u001d\nY!C\u0002\u0002\u000e!\u0012qAQ8pY\u0016\fg.\u0001\u0005hKR4\u0016\r\\;f)\ra\u00141\u0003\u0005\u0007\u0003+q\u0001\u0019A\u0019\u0002\u0007-,\u00170A\u0006d_:$\u0018-\u001b8t\u0017\u0016LH\u0003BA\u0005\u00037Aa!!\u0006\u0010\u0001\u0004\t\u0014aC;qI\u0006$XMV1mk\u0016$b!!\t\u0002(\u0005%\u0002cA\u0014\u0002$%\u0019\u0011Q\u0005\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003+\u0001\u0002\u0019A\u0019\t\r\u0005-\u0002\u00031\u0001=\u0003\u00151\u0018\r\\;f\u0003!IG/\u001a:bi>\u0014HCAA\u0019!\u0019\t\u0019$!\u0010\u0002D9!\u0011QGA\u001d\u001d\r\u0001\u0016qG\u0005\u0002S%\u0019\u00111\b\u0015\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005!IE/\u001a:bi>\u0014(bAA\u001eQA)q%!\u00122y%\u0019\u0011q\t\u0015\u0003\rQ+\b\u000f\\33\u0003\u0011YW-_:\u0015\u0005\u00055\u0003#BA\u001a\u0003{\t\u0014A\u0002<bYV,7\u000f\u0006\u0002\u0002TA)\u00111GA\u001fy\u0005I!/Z7pm\u0016\\U-\u001f\u000b\u0005\u0003C\tI\u0006\u0003\u0004\u0002\u0016Q\u0001\r!M\u0001\u0006G2,\u0017M\u001d\u000b\u0003\u0003C\u0001")
public class MapStateImpl<K, V>
implements MapState<K, V>,
Logging {
    private final StateStore store;
    private final String stateName;
    private final StructType schemaForCompositeKeyRow;
    private final StructType schemaForValueRow;
    private final CompositeKeyStateEncoder<K, V> stateTypesEncoder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schemaForCompositeKeyRow() {
        return this.schemaForCompositeKeyRow;
    }

    private StructType schemaForValueRow() {
        return this.schemaForValueRow;
    }

    private CompositeKeyStateEncoder<K, V> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    public boolean exists() {
        return this.store.prefixScan(this.stateTypesEncoder().encodeGroupingKey(), this.stateName).nonEmpty();
    }

    public V getValue(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow encodedCompositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        UnsafeRow unsafeRowValue = this.store.get(encodedCompositeKey, this.stateName);
        if (unsafeRowValue == null) {
            return null;
        }
        return this.stateTypesEncoder().decodeValue(unsafeRowValue);
    }

    public boolean containsKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        return this.getValue(key) != null;
    }

    public void updateValue(K key, V value) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        StateStoreErrors$.MODULE$.requireNonNullStateValue(value, this.stateName);
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(value);
        UnsafeRow encodedCompositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        this.store.put(encodedCompositeKey, encodedValue, this.stateName);
    }

    public Iterator<Tuple2<K, V>> iterator() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        return this.store.prefixScan(encodedGroupingKey, this.stateName).map((Function1 & Serializable)x0$1 -> {
            UnsafeRowPair unsafeRowPair = x0$1;
            if (unsafeRowPair != null) {
                UnsafeRowPair unsafeRowPair2 = unsafeRowPair;
                return new Tuple2(this.stateTypesEncoder().decodeCompositeKey(unsafeRowPair2.key()), this.stateTypesEncoder().decodeValue(unsafeRowPair2.value()));
            }
            throw new MatchError((Object)unsafeRowPair);
        });
    }

    public Iterator<K> keys() {
        return this.iterator().map((Function1 & Serializable)x$1 -> x$1._1());
    }

    public Iterator<V> values() {
        return this.iterator().map((Function1 & Serializable)x$2 -> x$2._2());
    }

    public void removeKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow compositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        this.store.remove(compositeKey, this.stateName);
    }

    public void clear() {
        this.keys().foreach((Function1 & Serializable)itr -> {
            this.removeKey(itr);
            return BoxedUnit.UNIT;
        });
    }

    public MapStateImpl(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<K> userKeyEnc, Encoder<V> valEncoder) {
        this.store = store;
        this.stateName = stateName;
        Logging.$init$((Logging)this);
        this.schemaForCompositeKeyRow = TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(keyExprEnc.schema(), userKeyEnc.schema());
        this.schemaForValueRow = valEncoder.schema();
        this.stateTypesEncoder = new CompositeKeyStateEncoder<K, V>(keyExprEnc, userKeyEnc, valEncoder, stateName, CompositeKeyStateEncoder$.MODULE$.$lessinit$greater$default$5());
        store.createColFamilyIfAbsent(stateName, this.schemaForCompositeKeyRow(), this.schemaForValueRow(), new PrefixKeyScanStateEncoderSpec(this.schemaForCompositeKeyRow(), 1), store.createColFamilyIfAbsent$default$5(), store.createColFamilyIfAbsent$default$6());
    }
}

