/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.CompositeKeyTTLRow;
import org.apache.spark.sql.execution.streaming.CompositeKeyTTLStateImpl;
import org.apache.spark.sql.execution.streaming.MapStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\u000e\u001d\u0001%B\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001B\u0001B\u0003%q\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!a\u0007A!A!\u0002\u0013i\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011I\u0004!\u0011!Q\u0001\nMDQA\u001e\u0001\u0005\u0002]D\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005-\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0004\u0001\u0005\u0004%I!a\u0004\t\u000f\u0005E\u0001\u0001)A\u0005g\"9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\ty\u0003\u0001C!\u0003cAq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003[\u0002A\u0011IA\u000b\u0011\u001d\ty\u0007\u0001C!\u0003cB\u0001\"a\"\u0001\t\u0003\u0001\u0013\u0011\u0012\u0005\t\u0003+\u0003A\u0011\u0001\u0011\u0002\u0018\"A\u0011q\u0014\u0001\u0005\u0002\u0001\n\tKA\nNCB\u001cF/\u0019;f\u00136\u0004HnV5uQR#FJ\u0003\u0002\u001e=\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003?\u0001\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007)\n4i\u0005\u0003\u0001Wu*\u0005c\u0001\u0017._5\tA$\u0003\u0002/9\tA2i\\7q_NLG/Z&fsR#Fj\u0015;bi\u0016LU\u000e\u001d7\u0011\u0005A\nD\u0002\u0001\u0003\u0006e\u0001\u0011\ra\r\u0002\u0002\u0017F\u0011AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\b\u001d>$\b.\u001b8h!\t)4(\u0003\u0002=m\t\u0019\u0011I\\=\u0011\ty\u0002uFQ\u0007\u0002\u007f)\u0011Q\u0004I\u0005\u0003\u0003~\u0012\u0001\"T1q'R\fG/\u001a\t\u0003a\r#Q\u0001\u0012\u0001C\u0002M\u0012\u0011A\u0016\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\n\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0015\u001e\u0013q\u0001T8hO&tw-A\u0003ti>\u0014X\r\u0005\u0002N!6\taJ\u0003\u0002P9\u0005)1\u000f^1uK&\u0011\u0011K\u0014\u0002\u000b'R\fG/Z*u_J,\u0017!C:uCR,g*Y7f!\t!6L\u0004\u0002V3B\u0011aKN\u0007\u0002/*\u0011\u0001\fK\u0001\u0007yI|w\u000e\u001e \n\u0005i3\u0014A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!A\u0017\u001c\u0002\u0015-,\u00170\u0012=qe\u0016s7\rE\u0002aKjj\u0011!\u0019\u0006\u0003E\u000e\f\u0001\"\u001a8d_\u0012,'o\u001d\u0006\u0003I\u0002\n\u0001bY1uC2L8\u000f^\u0005\u0003M\u0006\u0014\u0011#\u0012=qe\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s\u0003))8/\u001a:LKf,en\u0019\t\u0004S*|S\"\u0001\u0011\n\u0005-\u0004#aB#oG>$WM]\u0001\u000bm\u0006dWI\\2pI\u0016\u0014\bcA5k\u0005\u0006IA\u000f\u001e7D_:4\u0017n\u001a\t\u0003}AL!!] \u0003\u0013Q#FjQ8oM&<\u0017\u0001\u00052bi\u000eDG+[7fgR\fW\u000e]'t!\t)D/\u0003\u0002vm\t!Aj\u001c8h\u0003\u0019a\u0014N\\5u}QA\u00010\u001f>|yvtx\u0010\u0005\u0003-\u0001=\u0012\u0005\"B&\t\u0001\u0004a\u0005\"\u0002*\t\u0001\u0004\u0019\u0006\"\u00020\t\u0001\u0004y\u0006\"B4\t\u0001\u0004A\u0007\"\u00027\t\u0001\u0004i\u0007\"\u00028\t\u0001\u0004y\u0007\"\u0002:\t\u0001\u0004\u0019\u0018!E:uCR,G+\u001f9fg\u0016s7m\u001c3feV\u0011\u0011Q\u0001\t\u0006Y\u0005\u001dqFQ\u0005\u0004\u0003\u0013a\"\u0001G\"p[B|7/\u001b;f\u0017\u0016L8\u000b^1uK\u0016s7m\u001c3fe\u0006\u00112\u000f^1uKRK\b/Z:F]\u000e|G-\u001a:!\u0003=!H\u000f\\#ya&\u0014\u0018\r^5p]6\u001bX#A:\u0002!Q$H.\u0012=qSJ\fG/[8o\u001bN\u0004\u0013AC5oSRL\u0017\r\\5{KR\u0011\u0011q\u0003\t\u0004k\u0005e\u0011bAA\u000em\t!QK\\5u\u0003\u0019)\u00070[:ugR\u0011\u0011\u0011\u0005\t\u0004k\u0005\r\u0012bAA\u0013m\t9!i\\8mK\u0006t\u0017\u0001C4fiZ\u000bG.^3\u0015\u0007\t\u000bY\u0003\u0003\u0004\u0002.=\u0001\raL\u0001\u0004W\u0016L\u0018aC2p]R\f\u0017N\\:LKf$B!!\t\u00024!1\u0011Q\u0006\tA\u0002=\n1\"\u001e9eCR,g+\u00197vKR1\u0011qCA\u001d\u0003wAa!!\f\u0012\u0001\u0004y\u0003BBA\u001f#\u0001\u0007!)A\u0003wC2,X-\u0001\u0005ji\u0016\u0014\u0018\r^8s)\t\t\u0019\u0005\u0005\u0004\u0002F\u0005=\u0013Q\u000b\b\u0005\u0003\u000f\nYED\u0002W\u0003\u0013J\u0011aN\u0005\u0004\u0003\u001b2\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003#\n\u0019F\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tiE\u000e\t\u0006k\u0005]sFQ\u0005\u0004\u000332$A\u0002+va2,''\u0001\u0003lKf\u001cHCAA0!\u0015\t)%a\u00140\u0003\u00191\u0018\r\\;fgR\u0011\u0011Q\r\t\u0006\u0003\u000b\nyEQ\u0001\ne\u0016lwN^3LKf$B!a\u0006\u0002l!1\u0011QF\u000bA\u0002=\nQa\u00197fCJ\fab\u00197fCJLe-\u0012=qSJ,G\rF\u0003t\u0003g\n\u0019\tC\u0004\u0002v]\u0001\r!a\u001e\u0002\u001d\u001d\u0014x.\u001e9j]\u001e\\U-\u001f*poB!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~\r\f1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011QA>\u0005%)fn]1gKJ{w\u000fC\u0004\u0002\u0006^\u0001\r!a\u001e\u0002\u0015U\u001cXM]&fsJ{w/\u0001\fhKR<\u0016\u000e\u001e5pkR,eNZ8sG&tw\r\u0016+M)\u0011\tY)!%\u0011\tU\niIQ\u0005\u0004\u0003\u001f3$AB(qi&|g\u000e\u0003\u0004\u0002\u0014b\u0001\raL\u0001\bkN,'oS3z\u0003-9W\r\u001e+U\u0019Z\u000bG.^3\u0015\t\u0005e\u0015Q\u0014\t\u0006k\u00055\u00151\u0014\t\u0006k\u0005]#i\u001d\u0005\u0007\u0003'K\u0002\u0019A\u0018\u0002-\u001d,GoS3z-\u0006dW/Z:J]R#Fj\u0015;bi\u0016$\"!a)\u0011\r\u0005\u0015\u0013qJAS!\u0015)\u0014qK\u0018t\u0001")
public class MapStateImplWithTTL<K, V>
extends CompositeKeyTTLStateImpl<K>
implements MapState<K, V>,
Logging {
    private final StateStore store;
    private final String stateName;
    public final ExpressionEncoder<Object> org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$keyExprEnc;
    private final Encoder<K> userKeyEnc;
    private final Encoder<V> valEncoder;
    public final long org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs;
    private final CompositeKeyStateEncoder<K, V> org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder;
    private final long ttlExpirationMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CompositeKeyStateEncoder<K, V> org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder() {
        return this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder;
    }

    private long ttlExpirationMs() {
        return this.ttlExpirationMs;
    }

    private void initialize() {
        StructType schemaForCompositeKeyRow = TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$keyExprEnc.schema(), this.userKeyEnc.schema());
        this.store.createColFamilyIfAbsent(this.stateName, schemaForCompositeKeyRow, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(this.valEncoder.schema(), true), new PrefixKeyScanStateEncoderSpec(schemaForCompositeKeyRow, 1), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.iterator().nonEmpty();
    }

    public V getValue(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        if (retRow != null) {
            if (!this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(retRow, this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs)) {
                return this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(retRow);
            }
            return null;
        }
        return null;
    }

    public boolean containsKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        return this.getValue(key) != null;
    }

    public void updateValue(K key, V value) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        StateStoreErrors$.MODULE$.requireNonNullStateValue(value, this.stateName);
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        UnsafeRow encodedUserKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeUserKey(key);
        UnsafeRow encodedValue = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeValue(value, this.ttlExpirationMs());
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        this.store.put(encodedCompositeKey, encodedValue, this.stateName);
        this.upsertTTLForStateKey(this.ttlExpirationMs(), encodedGroupingKey, encodedUserKey);
    }

    public Iterator<Tuple2<K, V>> iterator() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRowPair> unsafeRowPairIterator = this.store.prefixScan(encodedGroupingKey, this.stateName);
        return new NextIterator<Tuple2<K, V>>(this, unsafeRowPairIterator){
            private final /* synthetic */ MapStateImplWithTTL $outer;
            private final Iterator unsafeRowPairIterator$1;

            public Tuple2<K, V> getNext() {
                Iterator iter = this.unsafeRowPairIterator$1.dropWhile((Function1 & Serializable)rowPair -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getNext$1(this, rowPair)));
                if (iter.hasNext()) {
                    UnsafeRowPair currentRowPair = (UnsafeRowPair)iter.next();
                    K key = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeCompositeKey(currentRowPair.key());
                    V value = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(currentRowPair.value());
                    return new Tuple2(key, value);
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }

            public static final /* synthetic */ boolean $anonfun$getNext$1($anon$1 $this, UnsafeRowPair rowPair) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(rowPair.value(), $this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unsafeRowPairIterator$1 = unsafeRowPairIterator$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getNext$1$adapted(org.apache.spark.sql.execution.streaming.MapStateImplWithTTL$$anon$1 org.apache.spark.sql.execution.streaming.state.UnsafeRowPair )}, serializedLambda);
            }
        };
    }

    public Iterator<K> keys() {
        return this.iterator().map((Function1 & Serializable)x$1 -> x$1._1());
    }

    public Iterator<V> values() {
        return this.iterator().map((Function1 & Serializable)x$2 -> x$2._2());
    }

    public void removeKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow compositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        this.store.remove(compositeKey, this.stateName);
    }

    public void clear() {
        this.keys().foreach((Function1 & Serializable)itr -> {
            this.removeKey(itr);
            return BoxedUnit.UNIT;
        });
        this.clearTTLState();
    }

    @Override
    public long clearIfExpired(UnsafeRow groupingKeyRow, UnsafeRow userKeyRow) {
        long numRemovedElements;
        block0: {
            UnsafeRow compositeKeyRow = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(groupingKeyRow, userKeyRow);
            UnsafeRow retRow = this.store.get(compositeKeyRow, this.stateName);
            numRemovedElements = 0L;
            if (retRow == null || !this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(retRow, this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs)) break block0;
            this.store.remove(compositeKeyRow, this.stateName);
            ++numRemovedElements;
        }
        return numRemovedElements;
    }

    public Option<V> getWithoutEnforcingTTL(K userKey) {
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(userKey);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        if (retRow != null) {
            Object resState = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(retRow);
            return new Some(resState);
        }
        return None$.MODULE$;
    }

    public Option<Tuple2<V, Object>> getTTLValue(K userKey) {
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(userKey);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        return Option$.MODULE$.apply((Object)retRow).flatMap((Function1 & Serializable)row -> {
            Option<Object> ttlExpiration = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeTtlExpirationMs((UnsafeRow)row);
            return ttlExpiration.map((Function1 & Serializable)expiration -> MapStateImplWithTTL.$anonfun$getTTLValue$2(this, row, BoxesRunTime.unboxToLong((Object)expiration)));
        });
    }

    public Iterator<Tuple2<K, Object>> getKeyValuesInTTLState() {
        Iterator<CompositeKeyTTLRow> ttlIterator = this.ttlIndexIterator();
        UnsafeRow implicitGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        ObjectRef nextValue = ObjectRef.create((Object)None$.MODULE$);
        return new Iterator<Tuple2<K, Object>>(this, nextValue, ttlIterator, implicitGroupingKey){
            private final /* synthetic */ MapStateImplWithTTL $outer;
            private final ObjectRef nextValue$1;
            private final Iterator ttlIterator$1;
            private final UnsafeRow implicitGroupingKey$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Tuple2<K, Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Tuple2<K, Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Tuple2<K, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> partition(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<K, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<K, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Tuple2<K, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Tuple2<K, Object>> filter(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> filterNot(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> filterImpl(Function1<Tuple2<K, Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Tuple2<K, Object>> withFilter(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<K, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Tuple2<K, Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Tuple2<K, Object>> distinctBy(Function1<Tuple2<K, Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Tuple2<K, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<K, Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Tuple2<K, Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Tuple2<K, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<K, Object>> takeWhile(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<K, Object>> dropWhile(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> span(Function1<Tuple2<K, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<K, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<K, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Tuple2<K, Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Tuple2<K, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U$> Iterator<Tuple2<K, Object>> tapEach(Function1<Tuple2<K, Object>, U$> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Tuple2<K, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<K, Object>>, Iterator<Tuple2<K, Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U$> void foreach(Function1<Tuple2<K, Object>, U$> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Tuple2<K, Object>> find(Function1<Tuple2<K, Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<K, Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<K, Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Tuple2<K, Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Tuple2<K, Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<K, Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<K, Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<K, Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<K, Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> maxByOption(Function1<Tuple2<K, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<K, Object>> minByOption(Function1<Tuple2<K, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<K, Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<K, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<K, Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Tuple2<K, Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Tuple2<K, Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Tuple2<K, Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Tuple2<K, Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V> Map<K$, V> toMap(.less.colon.less<Tuple2<K, Object>, Tuple2<K$, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Tuple2<K, Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Tuple2<K, Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Tuple2<K, Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Tuple2<K, Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S$ extends Stepper<?>> S$ stepper(StepperShape<Tuple2<K, Object>, S$> shape) {
                return (S$)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public boolean hasNext() {
                while (((Option)this.nextValue$1.elem).isEmpty() && this.ttlIterator$1.hasNext()) {
                    CompositeKeyTTLRow nextTtlValue = (CompositeKeyTTLRow)this.ttlIterator$1.next();
                    UnsafeRow groupingKey = nextTtlValue.groupingKey();
                    if (!groupingKey.equals((Object)this.implicitGroupingKey$1.getStruct(0, this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$keyExprEnc.schema().length()))) continue;
                    K userKey = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeUserKey(nextTtlValue.userKey());
                    this.nextValue$1.elem = new Some((Object)new Tuple2(userKey, (Object)BoxesRunTime.boxToLong((long)nextTtlValue.expirationMs())));
                }
                return ((Option)this.nextValue$1.elem).isDefined();
            }

            public Tuple2<K, Object> next() {
                Tuple2 result = (Tuple2)((Option)this.nextValue$1.elem).get();
                this.nextValue$1.elem = None$.MODULE$;
                return result;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nextValue$1 = nextValue$1;
                this.ttlIterator$1 = ttlIterator$1;
                this.implicitGroupingKey$1 = implicitGroupingKey$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }
        };
    }

    public static final /* synthetic */ Tuple2 $anonfun$getTTLValue$2(MapStateImplWithTTL $this, UnsafeRow row$1, long expiration) {
        return new Tuple2($this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(row$1), (Object)BoxesRunTime.boxToLong((long)expiration));
    }

    public MapStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<K> userKeyEnc, Encoder<V> valEncoder, TTLConfig ttlConfig, long batchTimestampMs) {
        this.store = store;
        this.stateName = stateName;
        this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$keyExprEnc = keyExprEnc;
        this.userKeyEnc = userKeyEnc;
        this.valEncoder = valEncoder;
        this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs = batchTimestampMs;
        super(stateName, store, keyExprEnc, userKeyEnc, batchTimestampMs);
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder = new CompositeKeyStateEncoder<K, V>(keyExprEnc, userKeyEnc, valEncoder, stateName, true);
        this.ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(ttlConfig.ttlDuration(), batchTimestampMs);
        this.initialize();
    }
}

