/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u0011\"\u0001:B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003W\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001d\u0011\u0007A1A\u0005\n\rDaa\u001a\u0001!\u0002\u0013!\u0007\"\u00025\u0001\t\u0003J\u0007\"\u0002=\u0001\t\u0003I\b\"\u0002?\u0001\t\u0003i\b\"CA\u0001\u0001\u0005\u0005I\u0011AA\u0002\u0011%\tI\u0001AI\u0001\n\u0003\tY\u0001C\u0005\u0002\"\u0001\t\n\u0011\"\u0001\u0002$!I\u0011q\u0005\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0006\u0005\n\u0003w\u0001\u0011\u0011!C\u0001\u0003{A\u0011\"!\u0012\u0001\u0003\u0003%\t!a\u0012\t\u0013\u0005M\u0003!!A\u0005B\u0005U\u0003\"CA2\u0001\u0005\u0005I\u0011AA3\u0011%\tI\u0007AA\u0001\n\u0003\nY\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003o\u0002\u0011\u0011!C!\u0003s:\u0011\"! \"\u0003\u0003E\t!a \u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0003\u0003Ca!\u0018\r\u0005\u0002\u0005e\u0005\"CA:1\u0005\u0005IQIA;\u0011%\tY\nGA\u0001\n\u0003\u000bi\nC\u0005\u0002$b\t\n\u0011\"\u0001\u0002$!I\u0011Q\u0015\r\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003sC\u0012\u0013!C\u0001\u0003GA\u0011\"a/\u0019\u0003\u0003%I!!0\u0003-A\u0013xnY3tg&tw\rV5nK\u0016CXmY;u_JT!AI\u0012\u0002\u0013M$(/Z1nS:<'B\u0001\u0013&\u0003%)\u00070Z2vi&|gN\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001_UJtH\u0011\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y:T\"A\u0011\n\u0005a\n#a\u0004+sS\u001e<WM]#yK\u000e,Ho\u001c:\u0011\u0005ijT\"A\u001e\u000b\u0005q:\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005yZ$a\u0002'pO\u001eLgn\u001a\t\u0003a\u0001K!!Q\u0019\u0003\u000fA\u0013x\u000eZ;diB\u00111i\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!aR\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u0001&2\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005)\u000b\u0014!\u00069s_\u000e,7o]5oORKW.\u001a+sS\u001e<WM]\u000b\u0002!B\u0011a'U\u0005\u0003%\u0006\u0012Q\u0003\u0015:pG\u0016\u001c8/\u001b8h)&lW\r\u0016:jO\u001e,'/\u0001\fqe>\u001cWm]:j]\u001e$\u0016.\\3Ue&<w-\u001a:!\u0003\u0015\u0019Gn\\2l+\u00051\u0006CA,[\u001b\u0005A&BA-(\u0003\u0011)H/\u001b7\n\u0005mC&!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004?\u0002\f\u0007C\u0001\u001c\u0001\u0011\u0015qU\u00011\u0001Q\u0011\u001d!V\u0001%AA\u0002Y\u000b!\"\u001b8uKJ4\u0018\r\\'t+\u0005!\u0007C\u0001\u0019f\u0013\t1\u0017G\u0001\u0003M_:<\u0017aC5oi\u0016\u0014h/\u00197Ng\u0002\nq!\u001a=fGV$X\r\u0006\u0002k[B\u0011\u0001g[\u0005\u0003YF\u0012A!\u00168ji\")a\u000e\u0003a\u0001_\u0006qAO]5hO\u0016\u0014\b*\u00198eY\u0016\u0014\b\u0003\u0002\u0019qeVL!!]\u0019\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u001ct\u0013\t!\u0018E\u0001\u000eNS\u000e\u0014xNQ1uG\",\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u00021m&\u0011q/\r\u0002\b\u0005>|G.Z1o\u0003aqw\u000e^5gs\n\u000bGo\u00195GC2d\u0017N\\4CK\"Lg\u000e\u001a\u000b\u0003UjDQa_\u0005A\u0002\u0011\f\u0011C]3bY\u0016c\u0017\r]:fIRKW.Z't\u00035qW\r\u001f;CCR\u001c\u0007\u000eV5nKR\u0011AM \u0005\u0006\u007f*\u0001\r\u0001Z\u0001\u0004]><\u0018\u0001B2paf$RaXA\u0003\u0003\u000fAqAT\u0006\u0011\u0002\u0003\u0007\u0001\u000bC\u0004U\u0017A\u0005\t\u0019\u0001,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0002\u0016\u0004!\u0006=1FAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m\u0011'\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0005\u0016\u0004-\u0006=\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00027b]\u001eT!!!\u000e\u0002\t)\fg/Y\u0005\u0005\u0003s\tyC\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u007f\u00012\u0001MA!\u0013\r\t\u0019%\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\ny\u0005E\u00021\u0003\u0017J1!!\u00142\u0005\r\te.\u001f\u0005\n\u0003#\u0002\u0012\u0011!a\u0001\u0003\u007f\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA,!\u0019\tI&a\u0018\u0002J5\u0011\u00111\f\u0006\u0004\u0003;\n\u0014AC2pY2,7\r^5p]&!\u0011\u0011MA.\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007U\f9\u0007C\u0005\u0002RI\t\t\u00111\u0001\u0002J\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY#!\u001c\t\u0013\u0005E3#!AA\u0002\u0005}\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005}\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0012AB3rk\u0006d7\u000fF\u0002v\u0003wB\u0011\"!\u0015\u0017\u0003\u0003\u0005\r!!\u0013\u0002-A\u0013xnY3tg&tw\rV5nK\u0016CXmY;u_J\u0004\"A\u000e\r\u0014\u000ba\t\u0019)a$\u0011\u000f\u0005\u0015\u00151\u0012)W?6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013\u000b\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\u000b9IA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0005\u0003+\u000b\u0019$\u0001\u0002j_&\u0019A*a%\u0015\u0005\u0005}\u0014!B1qa2LH#B0\u0002 \u0006\u0005\u0006\"\u0002(\u001c\u0001\u0004\u0001\u0006b\u0002+\u001c!\u0003\u0005\rAV\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BAU\u0003k\u0003R\u0001MAV\u0003_K1!!,2\u0005\u0019y\u0005\u000f^5p]B)\u0001'!-Q-&\u0019\u00111W\u0019\u0003\rQ+\b\u000f\\33\u0011!\t9,HA\u0001\u0002\u0004y\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a0\u0011\t\u00055\u0012\u0011Y\u0005\u0005\u0003\u0007\fyC\u0001\u0004PE*,7\r\u001e")
public class ProcessingTimeExecutor
implements TriggerExecutor,
Logging,
Product,
Serializable {
    private final ProcessingTimeTrigger processingTimeTrigger;
    private final Clock clock;
    private final long intervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private MicroBatchExecutionContext org$apache$spark$sql$execution$streaming$TriggerExecutor$$execCtx;

    public static Clock $lessinit$greater$default$2() {
        return ProcessingTimeExecutor$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<ProcessingTimeTrigger, Clock>> unapply(ProcessingTimeExecutor x$0) {
        return ProcessingTimeExecutor$.MODULE$.unapply(x$0);
    }

    public static Clock apply$default$2() {
        return ProcessingTimeExecutor$.MODULE$.apply$default$2();
    }

    public static ProcessingTimeExecutor apply(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return ProcessingTimeExecutor$.MODULE$.apply(processingTimeTrigger, clock);
    }

    public static Function1<Tuple2<ProcessingTimeTrigger, Clock>, ProcessingTimeExecutor> tupled() {
        return ProcessingTimeExecutor$.MODULE$.tupled();
    }

    public static Function1<ProcessingTimeTrigger, Function1<Clock, ProcessingTimeExecutor>> curried() {
        return ProcessingTimeExecutor$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public void setNextBatch(MicroBatchExecutionContext execContext) {
        TriggerExecutor.setNextBatch$(this, execContext);
    }

    @Override
    public boolean runOneBatch(Function1<MicroBatchExecutionContext, Object> batchRunner) {
        return TriggerExecutor.runOneBatch$(this, batchRunner);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public MicroBatchExecutionContext org$apache$spark$sql$execution$streaming$TriggerExecutor$$execCtx() {
        return this.org$apache$spark$sql$execution$streaming$TriggerExecutor$$execCtx;
    }

    @Override
    public void org$apache$spark$sql$execution$streaming$TriggerExecutor$$execCtx_$eq(MicroBatchExecutionContext x$1) {
        this.org$apache$spark$sql$execution$streaming$TriggerExecutor$$execCtx = x$1;
    }

    public ProcessingTimeTrigger processingTimeTrigger() {
        return this.processingTimeTrigger;
    }

    public Clock clock() {
        return this.clock;
    }

    private long intervalMs() {
        return this.intervalMs;
    }

    @Override
    public void execute(Function1<MicroBatchExecutionContext, Object> triggerHandler) {
        while (true) {
            Object object;
            boolean terminated;
            long triggerTimeMs = this.clock().getTimeMillis();
            long nextTriggerTimeMs = this.nextBatchTime(triggerTimeMs);
            boolean bl = terminated = !this.runOneBatch(triggerHandler);
            if (this.intervalMs() > 0L) {
                long batchElapsedTimeMs = this.clock().getTimeMillis() - triggerTimeMs;
                if (batchElapsedTimeMs > this.intervalMs()) {
                    this.notifyBatchFallingBehind(batchElapsedTimeMs);
                }
                if (terminated) {
                    return;
                }
                object = BoxesRunTime.boxToLong((long)this.clock().waitTillTime(nextTriggerTimeMs));
                continue;
            }
            if (terminated) {
                return;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void notifyBatchFallingBehind(long realElapsedTimeMs) {
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current batch is falling behind. The trigger interval is "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "} milliseconds, but spent "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TRIGGER_INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.intervalMs()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " milliseconds"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ELAPSED_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)realElapsedTimeMs))})))));
    }

    public long nextBatchTime(long now) {
        if (this.intervalMs() == 0L) {
            return now;
        }
        return now / this.intervalMs() * this.intervalMs() + this.intervalMs();
    }

    public ProcessingTimeExecutor copy(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return new ProcessingTimeExecutor(processingTimeTrigger, clock);
    }

    public ProcessingTimeTrigger copy$default$1() {
        return this.processingTimeTrigger();
    }

    public Clock copy$default$2() {
        return this.clock();
    }

    public String productPrefix() {
        return "ProcessingTimeExecutor";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.processingTimeTrigger();
            }
            case 1: {
                return this.clock();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcessingTimeExecutor;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "processingTimeTrigger";
            }
            case 1: {
                return "clock";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ProcessingTimeExecutor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ProcessingTimeExecutor processingTimeExecutor = (ProcessingTimeExecutor)x$1;
        ProcessingTimeTrigger processingTimeTrigger = this.processingTimeTrigger();
        ProcessingTimeTrigger processingTimeTrigger2 = processingTimeExecutor.processingTimeTrigger();
        if (processingTimeTrigger == null) {
            if (processingTimeTrigger2 != null) {
                return false;
            }
        } else if (!processingTimeTrigger.equals(processingTimeTrigger2)) return false;
        Clock clock = this.clock();
        Clock clock2 = processingTimeExecutor.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!clock.equals(clock2)) return false;
        if (!processingTimeExecutor.canEqual(this)) return false;
        return true;
    }

    public ProcessingTimeExecutor(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        this.processingTimeTrigger = processingTimeTrigger;
        this.clock = clock;
        TriggerExecutor.$init$(this);
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.intervalMs = processingTimeTrigger.intervalMs();
        Predef$.MODULE$.require(this.intervalMs() >= 0L);
    }
}

