/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\r\u001a\u0001\u0019B\u0001b\r\u0001\u0003\u0006\u0004%I\u0001\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005k!A!\b\u0001BC\u0002\u0013%1\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000bM\u0003A\u0011\u0001+\t\u000fi\u0003\u0001\u0019!C\u00017\"9q\f\u0001a\u0001\n\u0003\u0001\u0007B\u00024\u0001A\u0003&A\fC\u0004h\u0001\t\u0007I\u0011\u00025\t\rY\u0004\u0001\u0015!\u0003j\u0011\u001d9\bA1A\u0005\u0002mCa\u0001\u001f\u0001!\u0002\u0013a\u0006bB=\u0001\u0005\u0004%IA\u001f\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003|\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA#\u0001\u0011%\u0011q\t\u0005\b\u00037\u0002A\u0011AA/\u0005A\u0001&o\\4sKN\u001c(+\u001a9peR,'O\u0003\u0002\u001b7\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00039u\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005yy\u0012aA:rY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Ej\u0011a\f\u0006\u0003a}\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003e=\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g.F\u00016!\t1t'D\u0001\u001e\u0013\tATD\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0007ta\u0006\u00148nU3tg&|g\u000eI\u0001\riJLwmZ3s\u00072|7m[\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011qhH\u0001\u0005kRLG.\u0003\u0002B}\t)1\t\\8dW\u0006iAO]5hO\u0016\u00148\t\\8dW\u0002\n1\u0002\\8hS\u000e\fG\u000e\u00157b]V\tQ\tE\u0002)\r\"K!aR\u0015\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA%Q\u001b\u0005Q%BA&M\u0003\u001dawnZ5dC2T!!\u0014(\u0002\u000bAd\u0017M\\:\u000b\u0005=k\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005ES%a\u0003'pO&\u001c\u0017\r\u001c)mC:\fA\u0002\\8hS\u000e\fG\u000e\u00157b]\u0002\na\u0001P5oSRtD\u0003B+X1f\u0003\"A\u0016\u0001\u000e\u0003eAQaM\u0004A\u0002UBQAO\u0004A\u0002qBQaQ\u0004A\u0002\u0015\u000b\u0001\u0005\\1ti:{W\t_3dkRLwN\u001c)s_\u001e\u0014Xm]:Fm\u0016tG\u000fV5nKV\tA\f\u0005\u0002);&\u0011a,\u000b\u0002\u0005\u0019>tw-\u0001\u0013mCN$hj\\#yK\u000e,H/[8o!J|wM]3tg\u00163XM\u001c;US6,w\fJ3r)\t\tG\r\u0005\u0002)E&\u00111-\u000b\u0002\u0005+:LG\u000fC\u0004f\u0013\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'A\u0011mCN$hj\\#yK\u000e,H/[8o!J|wM]3tg\u00163XM\u001c;US6,\u0007%\u0001\bqe><'/Z:t\u0005V4g-\u001a:\u0016\u0003%\u00042A[8r\u001b\u0005Y'B\u00017n\u0003\u001diW\u000f^1cY\u0016T!A\\\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002qW\n)\u0011+^3vKB\u0011!\u000f^\u0007\u0002g*\u0011!$H\u0005\u0003kN\u0014ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010\u0015:pOJ,7o]\u0001\u0010aJ|wM]3tg\n+hMZ3sA\u0005Ybn\u001c#bi\u0006\u0004&o\\4sKN\u001cXI^3oi&sG/\u001a:wC2\fAD\\8ECR\f\u0007K]8he\u0016\u001c8/\u0012<f]RLe\u000e^3sm\u0006d\u0007%A\buS6,7\u000f^1na\u001a{'/\\1u+\u0005Y\bc\u0001?\u0002\b5\tQP\u0003\u0002\u007f\u007f\u00061am\u001c:nCRTA!!\u0001\u0002\u0004\u0005!A/[7f\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005{\n\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\u0002!QLW.Z:uC6\u0004hi\u001c:nCR\u0004\u0013A\u0004:fG\u0016tG\u000f\u0015:pOJ,7o]\u000b\u0003\u0003#\u0001B\u0001KA\nc&\u0019\u0011QC\u0015\u0003\u000b\u0005\u0013(/Y=\u0002\u00191\f7\u000f\u001e)s_\u001e\u0014Xm]:\u0016\u0003E\fa\"\u001e9eCR,\u0007K]8he\u0016\u001c8\u000fF\u0002b\u0003?Aa!!\t\u0014\u0001\u0004\t\u0018a\u00038foB\u0013xn\u001a:fgN\fa\"\u00193e\u001d\u0016<\bK]8he\u0016\u001c8\u000fF\u0002b\u0003OAa!!\t\u0015\u0001\u0004\t\u0018AD;qI\u0006$X-\u00133mK:,7o\u001d\u000b\nC\u00065\u00121HA \u0003\u0007Bq!a\f\u0016\u0001\u0004\t\t$\u0001\u0002jIB!\u00111GA\u001c\u001b\t\t)DC\u0002@\u0003\u0007IA!!\u000f\u00026\t!Q+V%E\u0011\u001d\ti$\u0006a\u0001\u0003c\tQA];o\u0013\u0012Da!!\u0011\u0016\u0001\u0004a\u0016\u0001H2veJ,g\u000e\u001e+sS\u001e<WM]*uCJ$H+[7fgR\fW\u000e\u001d\u0005\u0007\u0003C)\u0002\u0019A9\u0002\u0013A|7\u000f^#wK:$HcA1\u0002J!9\u00111\n\fA\u0002\u00055\u0013!B3wK:$\b\u0003BA(\u0003+r1A]A)\u0013\r\t\u0019f]\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&!\u0011qKA-\u0005\u0015)e/\u001a8u\u0015\r\t\u0019f]\u0001\u0010M>\u0014X.\u0019;US6,7\u000f^1naR!\u0011qLA;!\u0011\t\t'a\u001c\u000f\t\u0005\r\u00141\u000e\t\u0004\u0003KJSBAA4\u0015\r\tI'J\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055\u0014&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\n\u0019H\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[J\u0003BBA</\u0001\u0007A,\u0001\u0004nS2d\u0017n\u001d")
public class ProgressReporter
implements Logging {
    private final SparkSession sparkSession;
    private final Clock triggerClock;
    private final Function0<LogicalPlan> logicalPlan;
    private long lastNoExecutionProgressEventTime;
    private final Queue<StreamingQueryProgress> progressBuffer;
    private final long noDataProgressEventInterval;
    private final DateTimeFormatter timestampFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Clock triggerClock() {
        return this.triggerClock;
    }

    public Function0<LogicalPlan> logicalPlan() {
        return this.logicalPlan;
    }

    public long lastNoExecutionProgressEventTime() {
        return this.lastNoExecutionProgressEventTime;
    }

    public void lastNoExecutionProgressEventTime_$eq(long x$1) {
        this.lastNoExecutionProgressEventTime = x$1;
    }

    private Queue<StreamingQueryProgress> progressBuffer() {
        return this.progressBuffer;
    }

    public long noDataProgressEventInterval() {
        return this.noDataProgressEventInterval;
    }

    private DateTimeFormatter timestampFormat() {
        return this.timestampFormat;
    }

    public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.progressBuffer().lastOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQueryProgress;
    }

    public void updateProgress(StreamingQueryProgress newProgress) {
        this.lastNoExecutionProgressEventTime_$eq(this.triggerClock().getTimeMillis());
        this.addNewProgress(newProgress);
        this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query made progress: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STREAMING_QUERY_PROGRESS$.MODULE$, (Object)newProgress)}))));
    }

    private void addNewProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            this.progressBuffer().$plus$eq((Object)newProgress);
            while (this.progressBuffer().length() >= this.sparkSession().sessionState().conf().streamingProgressRetention()) {
                this.progressBuffer().dequeue();
            }
        }
    }

    public void updateIdleness(UUID id, UUID runId, long currentTriggerStartTimestamp, StreamingQueryProgress newProgress) {
        long now = this.triggerClock().getTimeMillis();
        if (now - this.noDataProgressEventInterval() >= this.lastNoExecutionProgressEventTime()) {
            this.addNewProgress(newProgress);
            if (this.lastNoExecutionProgressEventTime() > Long.MIN_VALUE) {
                this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryIdleEvent(id, runId, this.formatTimestamp(currentTriggerStartTimestamp)));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query has been idle and waiting for new data more than "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIME_UNITS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.noDataProgressEventInterval()))})))));
            }
            this.lastNoExecutionProgressEventTime_$eq(now);
            return;
        }
    }

    private void postEvent(StreamingQueryListener.Event event) {
        this.sparkSession().streams().postListenerEvent(event);
    }

    public String formatTimestamp(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.of("Z")).format(this.timestampFormat());
    }

    public ProgressReporter(SparkSession sparkSession, Clock triggerClock, Function0<LogicalPlan> logicalPlan2) {
        this.sparkSession = sparkSession;
        this.triggerClock = triggerClock;
        this.logicalPlan = logicalPlan2;
        Logging.$init$((Logging)this);
        this.lastNoExecutionProgressEventTime = Long.MIN_VALUE;
        this.progressBuffer = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.noDataProgressEventInterval = sparkSession.sessionState().conf().streamingNoDataProgressEventInterval();
        this.timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(DateTimeUtils$.MODULE$.getZoneId("UTC"));
    }
}

