/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.TransformWithStateOperatorProperties;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TransformWithStateOperatorProperties$
implements Logging,
Serializable {
    public static final TransformWithStateOperatorProperties$ MODULE$ = new TransformWithStateOperatorProperties$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public TransformWithStateOperatorProperties fromJson(String json) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        Map jsonMap = (Map)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((Object)json, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())), (Formats)formats, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})));
        return new TransformWithStateOperatorProperties((String)jsonMap.apply((Object)"timeMode"), (String)jsonMap.apply((Object)"outputMode"), (List<TransformWithStateVariableInfo>)((List)jsonMap.apply((Object)"stateVariables")).map((Function1 & Serializable)stateVarMap -> TransformWithStateVariableInfo$.MODULE$.fromMap((Map<String, Object>)stateVarMap)));
    }

    public void validateOperatorProperties(TransformWithStateOperatorProperties oldOperatorProperties, TransformWithStateOperatorProperties newOperatorProperties) {
        String string = oldOperatorProperties.timeMode();
        String string2 = newOperatorProperties.timeMode();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw StateStoreErrors$.MODULE$.invalidConfigChangedAfterRestart("timeMode", oldOperatorProperties.timeMode(), newOperatorProperties.timeMode());
        }
        String string3 = oldOperatorProperties.outputMode();
        String string4 = newOperatorProperties.outputMode();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            throw StateStoreErrors$.MODULE$.invalidConfigChangedAfterRestart("outputMode", oldOperatorProperties.outputMode(), newOperatorProperties.outputMode());
        }
        List<TransformWithStateVariableInfo> oldStateVariableInfos = oldOperatorProperties.stateVariables();
        Map newStateVariableInfos = newOperatorProperties.stateVariables().map((Function1 & Serializable)stateVarInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)stateVarInfo.stateName()), stateVarInfo)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        oldStateVariableInfos.foreach((Function1 & Serializable)oldInfo -> {
            TransformWithStateOperatorProperties$.$anonfun$validateOperatorProperties$2(newStateVariableInfos, oldInfo);
            return BoxedUnit.UNIT;
        });
    }

    public TransformWithStateOperatorProperties apply(String timeMode, String outputMode, List<TransformWithStateVariableInfo> stateVariables) {
        return new TransformWithStateOperatorProperties(timeMode, outputMode, stateVariables);
    }

    public Option<Tuple3<String, String, List<TransformWithStateVariableInfo>>> unapply(TransformWithStateOperatorProperties x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.timeMode(), (Object)x$0.outputMode(), x$0.stateVariables()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransformWithStateOperatorProperties$.class);
    }

    public static final /* synthetic */ void $anonfun$validateOperatorProperties$2(Map newStateVariableInfos$1, TransformWithStateVariableInfo oldInfo) {
        Option newInfo = newStateVariableInfos$1.get((Object)oldInfo.stateName());
        Option option = newInfo;
        if (option instanceof Some) {
            Some some = (Some)option;
            TransformWithStateVariableInfo stateVarInfo = (TransformWithStateVariableInfo)some.value();
            Enumeration.Value value = oldInfo.stateVariableType();
            Enumeration.Value value2 = stateVarInfo.stateVariableType();
            if (value == null ? value2 != null : !value.equals(value2)) {
                throw StateStoreErrors$.MODULE$.invalidVariableTypeChange(stateVarInfo.stateName(), oldInfo.stateVariableType().toString(), stateVarInfo.stateVariableType().toString());
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private TransformWithStateOperatorProperties$() {
    }
}

