/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.streaming.ValueState;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005}4AAD\b\u00019!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u000bm\u0003A\u0011\u0001/\t\u000f\r\u0004!\u0019!C\u0005I\"1\u0001\u000e\u0001Q\u0001\n\u0015DQ!\u001b\u0001\u0005\n)DQA\u001c\u0001\u0005B=DQa\u001d\u0001\u0005BQDQ\u0001\u001f\u0001\u0005BeDQA\u001f\u0001\u0005BmDQA \u0001\u0005B)\u0014aBV1mk\u0016\u001cF/\u0019;f\u00136\u0004HN\u0003\u0002\u0011#\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003%M\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005uY3\u0003\u0002\u0001\u001fIQ\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007cA\u0013(S5\taE\u0003\u0002\u0011'%\u0011\u0001F\n\u0002\u000b-\u0006dW/Z*uCR,\u0007C\u0001\u0016,\u0019\u0001!Q\u0001\f\u0001C\u00025\u0012\u0011aU\t\u0003]E\u0002\"aH\u0018\n\u0005A\u0002#a\u0002(pi\"Lgn\u001a\t\u0003?IJ!a\r\u0011\u0003\u0007\u0005s\u0017\u0010\u0005\u00026q5\taG\u0003\u00028+\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002:m\t9Aj\\4hS:<\u0017!B:u_J,\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 \u0010\u0003\u0015\u0019H/\u0019;f\u0013\t\u0001UH\u0001\u0006Ti\u0006$Xm\u0015;pe\u0016\f\u0011b\u001d;bi\u0016t\u0015-\\3\u0011\u0005\rSeB\u0001#I!\t)\u0005%D\u0001G\u0015\t95$\u0001\u0004=e>|GOP\u0005\u0003\u0013\u0002\na\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011\nI\u0001\u000bW\u0016LX\t\u001f9s\u000b:\u001c\u0007cA(Uc5\t\u0001K\u0003\u0002R%\u0006AQM\\2pI\u0016\u00148O\u0003\u0002T'\u0005A1-\u0019;bYf\u001cH/\u0003\u0002V!\n\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0002\u0015Y\fG.\u00128d_\u0012,'\u000fE\u0002Y3&j\u0011aE\u0005\u00035N\u0011q!\u00128d_\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006;~\u0003\u0017M\u0019\t\u0004=\u0002IS\"A\b\t\u000bi*\u0001\u0019A\u001e\t\u000b\u0005+\u0001\u0019\u0001\"\t\u000b5+\u0001\u0019\u0001(\t\u000bY+\u0001\u0019A,\u0002#M$\u0018\r^3UsB,7/\u00128d_\u0012,'/F\u0001f!\rqf-K\u0005\u0003O>\u0011\u0011c\u0015;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3s\u0003I\u0019H/\u0019;f)f\u0004Xm]#oG>$WM\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0001l!\tyB.\u0003\u0002nA\t!QK\\5u\u0003\u0019)\u00070[:ugR\t\u0001\u000f\u0005\u0002 c&\u0011!\u000f\t\u0002\b\u0005>|G.Z1o\u0003%9W\r^(qi&|g\u000eF\u0001v!\ryb/K\u0005\u0003o\u0002\u0012aa\u00149uS>t\u0017aA4fiR\t\u0011&\u0001\u0004va\u0012\fG/\u001a\u000b\u0003WrDQ! \u0007A\u0002%\n\u0001B\\3x'R\fG/Z\u0001\u0006G2,\u0017M\u001d")
public class ValueStateImpl<S>
implements ValueState<S>,
Logging {
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final Encoder<S> valEncoder;
    private final StateTypesEncoder<S> stateTypesEncoder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StateTypesEncoder<S> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, this.keyExprEnc.schema(), this.valEncoder.schema(), new NoPrefixKeyStateEncoderSpec(this.keyExprEnc.schema()), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get() != null;
    }

    public Option<S> getOption() {
        return Option$.MODULE$.apply(this.get());
    }

    public S get() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            return this.stateTypesEncoder().decodeValue(retRow);
        }
        return null;
    }

    public void update(S newState) {
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(newState);
        this.store.put(this.stateTypesEncoder().encodeGroupingKey(), encodedValue, this.stateName);
    }

    public void clear() {
        this.store.remove(this.stateTypesEncoder().encodeGroupingKey(), this.stateName);
    }

    public ValueStateImpl(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<S> valEncoder) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        Logging.$init$((Logging)this);
        this.stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(keyExprEnc, valEncoder, stateName, StateTypesEncoder$.MODULE$.apply$default$4());
        this.initialize();
    }
}

