/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.SingleKeyTTLStateImpl;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.ValueState;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u000b\u0019\u0004A\u0011A4\t\u000f=\u0004!\u0019!C\u0005a\"1A\u000f\u0001Q\u0001\nEDq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004x\u0001\u0001\u0006Ia\u0019\u0005\u0006q\u0002!I!\u001f\u0005\u0006{\u0002!\tE \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!a\u0005\u0001\t\u0003\n)\u0002\u0003\u0004\u0002\u001c\u0001!\t%\u001f\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011!\t\t\u0004\u0001C\u00017\u0005\u001d\u0001\u0002CA\u001a\u0001\u0011\u00051$!\u000e\t\u0011\u0005}\u0002\u0001\"\u0001\u001c\u0003\u0003\u0012QCV1mk\u0016\u001cF/\u0019;f\u00136\u0004HnV5uQR#FJ\u0003\u0002\u00193\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00035m\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005qi\u0012aA:rY*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005\u0015\n4c\u0001\u0001'UA\u0011q\u0005K\u0007\u0002/%\u0011\u0011f\u0006\u0002\u0016'&tw\r\\3LKf$F\u000bT*uCR,\u0017*\u001c9m!\rYSfL\u0007\u0002Y)\u0011\u0001dG\u0005\u0003]1\u0012!BV1mk\u0016\u001cF/\u0019;f!\t\u0001\u0014\u0007\u0004\u0001\u0005\u000bI\u0002!\u0019A\u001a\u0003\u0003M\u000b\"\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u000f9{G\u000f[5oOB\u0011QgO\u0005\u0003yY\u00121!\u00118z\u0003\u0015\u0019Ho\u001c:f!\ty$)D\u0001A\u0015\t\tu#A\u0003ti\u0006$X-\u0003\u0002D\u0001\nQ1\u000b^1uKN#xN]3\u0002\u0013M$\u0018\r^3OC6,\u0007C\u0001$N\u001d\t95\n\u0005\u0002Im5\t\u0011J\u0003\u0002KG\u00051AH]8pizJ!\u0001\u0014\u001c\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019Z\n!b[3z\u000bb\u0004(/\u00128d!\r\u0011vKO\u0007\u0002'*\u0011A+V\u0001\tK:\u001cw\u000eZ3sg*\u0011akG\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001l\u0015\u0002\u0012\u000bb\u0004(/Z:tS>tWI\\2pI\u0016\u0014\u0018A\u0003<bY\u0016s7m\u001c3feB\u00191\fX\u0018\u000e\u0003mI!!X\u000e\u0003\u000f\u0015s7m\u001c3fe\u0006IA\u000f\u001e7D_:4\u0017n\u001a\t\u0003W\u0001L!!\u0019\u0017\u0003\u0013Q#FjQ8oM&<\u0017\u0001\u00052bi\u000eDG+[7fgR\fW\u000e]'t!\t)D-\u0003\u0002fm\t!Aj\u001c8h\u0003\u0019a\u0014N\\5u}Q9\u0001.\u001b6lY6t\u0007cA\u0014\u0001_!)Qh\u0002a\u0001}!)Ai\u0002a\u0001\u000b\")\u0001k\u0002a\u0001#\")\u0011l\u0002a\u00015\")al\u0002a\u0001?\")!m\u0002a\u0001G\u0006\t2\u000f^1uKRK\b/Z:F]\u000e|G-\u001a:\u0016\u0003E\u00042a\n:0\u0013\t\u0019xCA\tTi\u0006$X\rV=qKN,enY8eKJ\f!c\u001d;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3sA\u0005yA\u000f\u001e7FqBL'/\u0019;j_:l5/F\u0001d\u0003A!H\u000f\\#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$\u0012A\u001f\t\u0003kmL!\u0001 \u001c\u0003\tUs\u0017\u000e^\u0001\u0007KbL7\u000f^:\u0015\u0003}\u00042!NA\u0001\u0013\r\t\u0019A\u000e\u0002\b\u0005>|G.Z1o\u0003%9W\r^(qi&|g\u000e\u0006\u0002\u0002\nA!Q'a\u00030\u0013\r\tiA\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0007\u001d,G\u000fF\u00010\u0003\u0019)\b\u000fZ1uKR\u0019!0a\u0006\t\r\u0005e\u0001\u00031\u00010\u0003!qWm^*uCR,\u0017!B2mK\u0006\u0014\u0018AD2mK\u0006\u0014\u0018JZ#ya&\u0014X\r\u001a\u000b\u0004G\u0006\u0005\u0002bBA\u0012%\u0001\u0007\u0011QE\u0001\fOJ|W\u000f]5oO.+\u0017\u0010\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY#V\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u00020\u0005%\"!C+og\u00064WMU8x\u0003Y9W\r^,ji\"|W\u000f^#oM>\u00148-\u001b8h)Rc\u0015aC4fiR#FJV1mk\u0016$\"!a\u000e\u0011\u000bU\nY!!\u000f\u0011\u000bU\nYdL2\n\u0007\u0005ubG\u0001\u0004UkBdWMM\u0001\u0014O\u0016$h+\u00197vKNLe\u000e\u0016+M'R\fG/\u001a\u000b\u0003\u0003\u0007\u0002R!!\u0012\u0002P\rtA!a\u0012\u0002L9\u0019\u0001*!\u0013\n\u0003]J1!!\u00147\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0015\u0002T\tA\u0011\n^3sCR|'OC\u0002\u0002NY\u0002")
public class ValueStateImplWithTTL<S>
extends SingleKeyTTLStateImpl
implements ValueState<S> {
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final Encoder<S> valEncoder;
    private final long batchTimestampMs;
    private final StateTypesEncoder<S> stateTypesEncoder;
    private final long ttlExpirationMs;

    private StateTypesEncoder<S> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    private long ttlExpirationMs() {
        return this.ttlExpirationMs;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, this.keyExprEnc.schema(), TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(this.valEncoder.schema(), true), new NoPrefixKeyStateEncoderSpec(this.keyExprEnc.schema()), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get() != null;
    }

    public Option<S> getOption() {
        return Option$.MODULE$.apply(this.get());
    }

    public S get() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            S resState = this.stateTypesEncoder().decodeValue(retRow);
            if (!this.stateTypesEncoder().isExpired(retRow, this.batchTimestampMs)) {
                return resState;
            }
            return null;
        }
        return null;
    }

    public void update(S newState) {
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(newState, this.ttlExpirationMs());
        UnsafeRow serializedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        this.store.put(serializedGroupingKey, encodedValue, this.stateName);
        this.upsertTTLForStateKey(this.ttlExpirationMs(), serializedGroupingKey);
    }

    public void clear() {
        this.store.remove(this.stateTypesEncoder().encodeGroupingKey(), this.stateName);
        this.clearTTLState();
    }

    @Override
    public long clearIfExpired(UnsafeRow groupingKey) {
        long result;
        block0: {
            UnsafeRow retRow = this.store.get(groupingKey, this.stateName);
            result = 0L;
            if (retRow == null || !this.stateTypesEncoder().isExpired(retRow, this.batchTimestampMs)) break block0;
            this.store.remove(groupingKey, this.stateName);
            result = 1L;
        }
        return result;
    }

    public Option<S> getWithoutEnforcingTTL() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            S resState = this.stateTypesEncoder().decodeValue(retRow);
            return new Some(resState);
        }
        return None$.MODULE$;
    }

    public Option<Tuple2<S, Object>> getTTLValue() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Option<Object> ttlExpiration = this.stateTypesEncoder().decodeTtlExpirationMs(retRow);
            return ttlExpiration.map((Function1 & Serializable)expiration -> ValueStateImplWithTTL.$anonfun$getTTLValue$1(this, retRow, BoxesRunTime.unboxToLong((Object)expiration)));
        }
        return None$.MODULE$;
    }

    public Iterator<Object> getValuesInTTLState() {
        return this.getValuesInTTLState(this.stateTypesEncoder().encodeGroupingKey());
    }

    public static final /* synthetic */ Tuple2 $anonfun$getTTLValue$1(ValueStateImplWithTTL $this, UnsafeRow retRow$1, long expiration) {
        return new Tuple2($this.stateTypesEncoder().decodeValue(retRow$1), (Object)BoxesRunTime.boxToLong((long)expiration));
    }

    public ValueStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, Encoder<S> valEncoder, TTLConfig ttlConfig, long batchTimestampMs) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        this.batchTimestampMs = batchTimestampMs;
        super(stateName, store, keyExprEnc, batchTimestampMs);
        this.stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(keyExprEnc, valEncoder, stateName, true);
        this.ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(ttlConfig.ttlDuration(), batchTimestampMs);
        this.initialize();
    }
}

