/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileMappings;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV1;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV2;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriter;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriterV1;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogWriterV2;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r-e\u0001\u0002&L\u0001iC\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tg\u0002\u0011\t\u0011)A\u0005i\"AA\u0010\u0001B\u0001B\u0003%Q\u0010C\u0005\u0002\f\u0001\u0011\t\u0011)A\u0005Q\"I\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011)\t\t\u0003\u0001EC\u0002\u0013%\u00111\u0005\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"a\u000f\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\n\u00037\u0002!\u0019!C\u0005\u0003;B\u0001\"a\u0019\u0001A\u0003%\u0011q\f\u0005\u000b\u0003K\u0002\u0001R1A\u0005\n\u0005\u001d\u0004bBA9\u0001\u0011%\u00111\u000f\u0005\n\u0003\u007f\u0002\u0001\u0019!C\u0005\u0003\u0003C\u0011\"a$\u0001\u0001\u0004%I!!%\t\u0011\u0005u\u0005\u0001)Q\u0005\u0003\u0007C\u0011\"a(\u0001\u0001\u0004%I!!)\t\u0013\u0005\r\u0006\u00011A\u0005\n\u0005\u0015\u0006\u0002CAU\u0001\u0001\u0006K!!#\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0006\"CA[\u0001\u0001\u0007I\u0011BA\\\u0011!\tY\f\u0001Q!\n\u0005=\u0006\"CAc\u0001\u0001\u0007I\u0011BAd\u0011%\ty\r\u0001a\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002V\u0002\u0001\u000b\u0015BAe\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002b\u0002!I!a9\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"I\u0011q \u0001\u0012\u0002\u0013\u0005!\u0011\u0001\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011%\u0011)\u0003AI\u0001\n\u0003\u0011\t\u0001C\u0005\u0003(\u0001\u0001\r\u0011\"\u0003\u0003*!I!\u0011\u0007\u0001A\u0002\u0013%!1\u0007\u0005\t\u0005o\u0001\u0001\u0015)\u0003\u0003,!I!1\b\u0001A\u0002\u0013%!\u0011\u0006\u0005\n\u0005{\u0001\u0001\u0019!C\u0005\u0005\u007fA\u0001Ba\u0011\u0001A\u0003&!1\u0006\u0005\b\u0005\u000f\u0002A\u0011\u0001B\u0015\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005SAqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0005\u0003p\u0001\t\n\u0011\"\u0001\u0003r!I!Q\u000f\u0001\u0012\u0002\u0013\u0005!q\u000f\u0005\b\u0005w\u0002A\u0011\u0001B?\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001bCqA!%\u0001\t\u0003\u0011\u0019\nC\u0004\u0003\u0016\u0002!\tAa&\t\u000f\tm\u0006\u0001\"\u0003\u0003>\"9!\u0011\u001a\u0001\u0005\u0002\t-\u0007b\u0002Bh\u0001\u0011%!\u0011\u001b\u0005\b\u0005C\u0004A\u0011\u0001Br\u0011%\u0011I\u000fAI\u0001\n\u0003\u0011Y\u000fC\u0004\u0003p\u0002!IA!=\t\u000f\r\u0015\u0001\u0001\"\u0003\u0004\b!91q\u0002\u0001\u0005\n\rE\u0001bBB\u000b\u0001\u0011%1q\u0003\u0005\b\u00077\u0001A\u0011BB\u000f\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_Aqaa\u0010\u0001\t\u0013\u0019\t\u0005C\u0004\u0004H\u0001!Ia!\u0013\t\u000f\r5\u0003\u0001\"\u0003\u0004P!911\u000b\u0001\u0005\n\rU\u0003bBB.\u0001\u0011E3Q\f\u0005\b\u0007?\u0002A\u0011BB1\u0011\u001d\u00199\u0007\u0001C\u0005\u0007SBqaa\u001c\u0001\t\u0013\u0019\thB\u0005\u0004|-\u000b\t\u0011#\u0001\u0004~\u0019A!jSA\u0001\u0012\u0003\u0019y\bC\u0004\u0002\u0010\u0019#\ta!!\t\u0013\r\re)%A\u0005\u0002\r\u0015\u0005\"CBE\rF\u0005I\u0011ABC\u0005I\u0011vnY6t\t\n3\u0015\u000e\\3NC:\fw-\u001a:\u000b\u00051k\u0015!B:uCR,'B\u0001(P\u0003%\u0019HO]3b[&twM\u0003\u0002Q#\u0006IQ\r_3dkRLwN\u001c\u0006\u0003%N\u000b1a]9m\u0015\t!V+A\u0003ta\u0006\u00148N\u0003\u0002W/\u00061\u0011\r]1dQ\u0016T\u0011\u0001W\u0001\u0004_J<7\u0001A\n\u0004\u0001m\u000b\u0007C\u0001/`\u001b\u0005i&\"\u00010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001l&AB!osJ+g\r\u0005\u0002cK6\t1M\u0003\u0002e'\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002gG\n9Aj\\4hS:<\u0017A\u00033ggJ{w\u000e\u001e#jeB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a[/\u000e\u00031T!!\\-\u0002\rq\u0012xn\u001c;?\u0013\tyW,\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8^\u00031awnY1m)\u0016l\u0007\u000fR5s!\t)(0D\u0001w\u0015\t9\b0\u0001\u0002j_*\t\u00110\u0001\u0003kCZ\f\u0017BA>w\u0005\u00111\u0015\u000e\\3\u0002\u0015!\fGm\\8q\u0007>tg\rE\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003d_:4'bAA\u0003+\u00061\u0001.\u00193p_BL1!!\u0003\u0000\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006I1m\u001c3fG:\u000bW.Z\u0001\nY><w-\u001b8h\u0013\u0012\fa\u0001P5oSRtD\u0003DA\n\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001cAA\u000b\u00015\t1\nC\u0003h\r\u0001\u0007\u0001\u000eC\u0003t\r\u0001\u0007A\u000fC\u0003}\r\u0001\u0007Q\u0010\u0003\u0005\u0002\f\u0019\u0001\n\u00111\u0001i\u0011!\tiA\u0002I\u0001\u0002\u0004A\u0017A\u00014n+\t\t)\u0003\u0005\u0003\u0002(\u0005%R\"A'\n\u0007\u0005-RJA\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0002\u0005\u0019\u001cXCAA\u0019!\u0011\t\u0019$a\u000e\u000e\u0005\u0005U\"\u0002BA\u0017\u0003\u0007IA!!\u000f\u00026\tQa)\u001b7f'f\u001cH/Z7\u0002\u0007\u0019\u001c\b%\u0001\u0007p]2L(,\u001b9GS2,7/\u0006\u0002\u0002BI1\u00111IA%\u0003+2a!!\u0012\f\u0001\u0005\u0005#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014!D8oYfT\u0016\u000e\u001d$jY\u0016\u001c\b\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\ty\u0005_\u0001\u0005Y\u0006tw-\u0003\u0003\u0002T\u00055#AB(cU\u0016\u001cG\u000f\u0005\u0003\u00024\u0005]\u0013\u0002BA-\u0003k\u0011!\u0002U1uQ\u001aKG\u000e^3s\u0003Iyg\u000e\\=DQ\u0006tw-\u001a7pO\u001aKG.Z:\u0016\u0005\u0005}#CBA1\u0003\u0013\n)F\u0002\u0004\u0002F5\u0001\u0011qL\u0001\u0014_:d\u0017p\u00115b]\u001e,Gn\\4GS2,7\u000fI\u0001\ngB\f'o[\"p]\u001a,\"!!\u001b\u0011\t\u0005-\u0014QN\u0007\u0002'&\u0019\u0011qN*\u0003\u0013M\u0003\u0018M]6D_:4\u0017!B2pI\u0016\u001cWCAA;!\u0011\t9(a\u001f\u000e\u0005\u0005e$BA<T\u0013\u0011\ti(!\u001f\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017AD7bqN+WM\u001c,feNLwN\\\u000b\u0003\u0003\u0007\u0003R\u0001XAC\u0003\u0013K1!a\"^\u0005\u0019y\u0005\u000f^5p]B\u0019A,a#\n\u0007\u00055UL\u0001\u0003M_:<\u0017AE7bqN+WM\u001c,feNLwN\\0%KF$B!a%\u0002\u001aB\u0019A,!&\n\u0007\u0005]UL\u0001\u0003V]&$\b\"CAN#\u0005\u0005\t\u0019AAB\u0003\rAH%M\u0001\u0010[\u0006D8+Z3o-\u0016\u00148/[8oA\u0005qQ.\u001b8TK\u0016tg+\u001a:tS>tWCAAE\u0003Ii\u0017N\\*fK:4VM]:j_:|F%Z9\u0015\t\u0005M\u0015q\u0015\u0005\n\u00037#\u0012\u0011!a\u0001\u0003\u0013\u000bq\"\\5o'\u0016,gNV3sg&|g\u000eI\u0001\u000fe>|G\u000fR5s\u0007\",7m[3e+\t\ty\u000bE\u0002]\u0003cK1!a-^\u0005\u001d\u0011un\u001c7fC:\f!C]8pi\u0012K'o\u00115fG.,Gm\u0018\u0013fcR!\u00111SA]\u0011%\tYjFA\u0001\u0002\u0004\ty+A\bs_>$H)\u001b:DQ\u0016\u001c7.\u001a3!Q\rA\u0012q\u0018\t\u00049\u0006\u0005\u0017bAAb;\nAao\u001c7bi&dW-\u0001\u0007gS2,W*\u00199qS:<7/\u0006\u0002\u0002JB!\u0011QCAf\u0013\r\tim\u0013\u0002\u0014%>\u001c7n\u001d#C\r&dW-T1qa&twm]\u0001\u0011M&dW-T1qa&twm]0%KF$B!a%\u0002T\"I\u00111\u0014\u000e\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u000eM&dW-T1qa&twm\u001d\u0011)\u0007m\ty,A\bd_BLh)\u001b7f\u001b\u0006\u0004\b/\u001b8h)\t\t\u0019*A\fdCB$XO]3GS2,W*\u00199SK\u001a,'/\u001a8dKR\u0011\u0011\u0011Z\u0001\u0014O\u0016$8\t[1oO\u0016dwn\u001a,feNLwN\u001c\u000b\u0005\u0003K\fY\u000fE\u0002]\u0003OL1!!;^\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\tiO\ba\u0001\u0003_\u000b\u0011#^:f\u0007>dW/\u001c8GC6LG.[3t\u0003I9W\r^\"iC:<W\rT8h/JLG/\u001a:\u0015\r\u0005M\u0018\u0011`A\u007f!\u0011\t)\"!>\n\u0007\u0005]8JA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wm\u0016:ji\u0016\u0014\bbBA~?\u0001\u0007\u0011\u0011R\u0001\bm\u0016\u00148/[8o\u0011%\tio\bI\u0001\u0002\u0004\ty+\u0001\u000fhKR\u001c\u0005.\u00198hK2{wm\u0016:ji\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\r!\u0006BAX\u0005\u000bY#Aa\u0002\u0011\t\t%!1C\u0007\u0003\u0005\u0017QAA!\u0004\u0003\u0010\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005#i\u0016AC1o]>$\u0018\r^5p]&!!Q\u0003B\u0006\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013O\u0016$8\t[1oO\u0016dwn\u001a*fC\u0012,'\u000f\u0006\u0004\u0003\u001c\t\u0005\"1\u0005\t\u0005\u0003+\u0011i\"C\u0002\u0003 -\u0013\u0011d\u0015;bi\u0016\u001cFo\u001c:f\u0007\"\fgnZ3m_\u001e\u0014V-\u00193fe\"9\u00111`\u0011A\u0002\u0005%\u0005\"CAwCA\u0005\t\u0019AAX\u0003q9W\r^\"iC:<W\r\\8h%\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uII\nQ\u0003\\8bI\u000eCWmY6q_&tG/T3ue&\u001c7/\u0006\u0002\u0003,A!\u0011Q\u0003B\u0017\u0013\r\u0011yc\u0013\u0002\u001a%>\u001c7n\u001d#C\r&dW-T1oC\u001e,'/T3ue&\u001c7/A\rm_\u0006$7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:`I\u0015\fH\u0003BAJ\u0005kA\u0011\"a'%\u0003\u0003\u0005\rAa\u000b\u0002-1|\u0017\rZ\"iK\u000e\\\u0007o\\5oi6+GO]5dg\u0002B3!JA`\u0003U\u0019\u0018M^3DQ\u0016\u001c7\u000e]8j]RlU\r\u001e:jGN\f\u0011d]1wK\u000eCWmY6q_&tG/T3ue&\u001c7o\u0018\u0013fcR!\u00111\u0013B!\u0011%\tYjJA\u0001\u0002\u0004\u0011Y#\u0001\ftCZ,7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:!Q\rA\u0013qX\u0001\u001cY\u0006$Xm\u001d;M_\u0006$7\t[3dWB|\u0017N\u001c;NKR\u0014\u0018nY:\u000271\fG/Z:u'\u00064Xm\u00115fG.\u0004x.\u001b8u\u001b\u0016$(/[2t\u0003M\u0019\u0018M^3DQ\u0016\u001c7\u000e]8j]R$v\u000e\u00124t)9\t\u0019Ja\u0014\u0003T\tU#\u0011\fB/\u0005SBaA!\u0015,\u0001\u0004!\u0018!D2iK\u000e\\\u0007o\\5oi\u0012K'\u000fC\u0004\u0002|.\u0002\r!!#\t\u000f\t]3\u00061\u0001\u0002\n\u00069a.^7LKf\u001c\bb\u0002B.W\u0001\u0007\u0011\u0011Z\u0001\u0015G\u0006\u0004H/\u001e:fI\u001aKG.Z'baBLgnZ:\t\u0013\t}3\u0006%AA\u0002\t\u0005\u0014aE2pYVlgNR1nS2LX*\u00199qS:<\u0007#\u0002/\u0002\u0006\n\r\u0004CB5\u0003f!\f)/C\u0002\u0003hI\u00141!T1q\u0011%\u0011Yg\u000bI\u0001\u0002\u0004\u0011i'A\tnCb\u001cu\u000e\\;n]\u001a\u000bW.\u001b7z\u0013\u0012\u0004R\u0001XAC\u0003K\fQd]1wK\u000eCWmY6q_&tG\u000fV8EMN$C-\u001a4bk2$H%N\u000b\u0003\u0005gRCA!\u0019\u0003\u0006\u0005i2/\u0019<f\u0007\",7m\u001b9pS:$Hk\u001c#gg\u0012\"WMZ1vYR$c'\u0006\u0002\u0003z)\"!Q\u000eB\u0003\u0003Uaw.\u00193DQ\u0016\u001c7\u000e]8j]R4%o\\7EMN$bAa \u0003\u0006\n\u001d\u0005\u0003BA\u000b\u0005\u0003K1Aa!L\u0005e\u0011vnY6t\t\n\u001b\u0005.Z2la>Lg\u000e^'fi\u0006$\u0017\r^1\t\u000f\u0005mh\u00061\u0001\u0002\n\"1!\u0011\u0012\u0018A\u0002Q\f\u0001\u0002\\8dC2$\u0015N]\u0001\u0019O\u0016$H*\u0019;fgR\u001cf.\u00199tQ>$h+\u001a:tS>tG\u0003BAE\u0005\u001fCq!a?0\u0001\u0004\tI)\u0001\thKRd\u0015\r^3tiZ+'o]5p]R\u0011\u0011\u0011R\u0001\u0010M&tGm\u0014:qQ\u0006tg)\u001b7fgR1!\u0011\u0014BV\u0005_\u0003RAa'\u0003&\"tAA!(\u0003\":\u00191Na(\n\u0003yK1Aa)^\u0003\u001d\u0001\u0018mY6bO\u0016LAAa*\u0003*\n\u00191+Z9\u000b\u0007\t\rV\fC\u0004\u0003.F\u0002\rA!'\u0002\u0019Q\u0014\u0018mY6fI\u001aKG.Z:\t\u000f\tE\u0016\u00071\u0001\u00034\u0006A\u0011\r\u001c7GS2,7\u000f\u0005\u0004\u0003\u001c\n\u0015&Q\u0017\t\u0005\u0003g\u00119,\u0003\u0003\u0003:\u0006U\"A\u0003$jY\u0016\u001cF/\u0019;vg\u0006!B-\u001a7fi\u0016\u001c\u0005.\u00198hK2|wMR5mKN$B!a%\u0003@\"9!\u0011\u0019\u001aA\u0002\t\r\u0017\u0001\u0005<feNLwN\\:U_\u0012+G.\u001a;f!\u0015a&QYAE\u0013\r\u00119-\u0018\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0012g\u0016$X*\u0019=TK\u0016tg+\u001a:tS>tG\u0003BAJ\u0005\u001bDq!a?4\u0001\u0004\tI)\u0001\ntQ>,H\u000eZ*lSB$U\r\\3uS>tGCBAX\u0005'\u0014i\u000eC\u0004\u0003VR\u0002\rAa6\u0002'9,XNV3sg&|gn\u001d+p%\u0016$\u0018-\u001b8\u0011\u0007q\u0013I.C\u0002\u0003\\v\u00131!\u00138u\u0011\u001d\u0011y\u000e\u000ea\u0001\u0003\u0013\u000b1#\\5o-\u0016\u00148/[8ogR{G)\u001a7fi\u0016\f\u0011\u0003Z3mKR,w\n\u001c3WKJ\u001c\u0018n\u001c8t)\u0019\t\u0019J!:\u0003h\"9!Q[\u001bA\u0002\t]\u0007\"\u0003BpkA\u0005\t\u0019AAE\u0003m!W\r\\3uK>cGMV3sg&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001e\u0016\u0005\u0003\u0013\u0013)!A\ftCZ,\u0017*\\7vi\u0006\u0014G.\u001a$jY\u0016\u001cHk\u001c#ggRA!1\u001fB~\u0005{\u001c\u0019\u0001\u0005\u0004\u0003\u001c\n\u0015&Q\u001f\t\u0005\u0003+\u001190C\u0002\u0003z.\u0013ACU8dWN$%)S7nkR\f'\r\\3GS2,\u0007bBA~o\u0001\u0007\u0011\u0011\u0012\u0005\b\u0005\u007f<\u0004\u0019AB\u0001\u0003)awnY1m\r&dWm\u001d\t\u0006\u00057\u0013)\u000b\u001e\u0005\b\u00057:\u0004\u0019AAe\u0003eaw.\u00193J[6,H/\u00192mK\u001aKG.Z:Ge>lGIZ:\u0015\r\u0005M5\u0011BB\u0007\u0011\u001d\u0019Y\u0001\u000fa\u0001\u0005g\fa\"[7nkR\f'\r\\3GS2,7\u000f\u0003\u0004\u0003\nb\u0002\r\u0001^\u0001+e\u0016lwN^3M_\u000e\fG\u000e\\=EK2,G/\u001a3T'R3\u0015\u000e\\3t\rJ|W\u000e\u00124t\u001b\u0006\u0004\b/\u001b8h)\u0011\t\u0019ja\u0005\t\u000f\t}\u0018\b1\u0001\u0004\u0002\u0005yr-\u001a;J[6,H/\u00192mK\u001aKG.Z:Ge>lg+\u001a:tS>t',\u001b9\u0015\t\tM8\u0011\u0004\u0005\b\u0003wT\u0004\u0019AAE\u00031Q\u0018\u000e\u001d+p\t\u001a\u001ch)\u001b7f)\u0019\t\u0019ja\b\u0004$!91\u0011E\u001eA\u0002\r\u0005\u0011!\u00024jY\u0016\u001c\bbBB\u0013w\u0001\u00071qE\u0001\u000bI\u001a\u001c(,\u001b9GS2,\u0007\u0003BA\u001a\u0007SIAaa\u000b\u00026\t!\u0001+\u0019;i\u00035awn\u001a$jY\u0016\u001c\u0018J\u001c#jeR1\u00111SB\u0019\u0007kAaaa\r=\u0001\u0004!\u0018a\u00013je\"91q\u0007\u001fA\u0002\re\u0012aA7tOB\u0019!ma\u000f\n\u0007\ru2M\u0001\nNKN\u001c\u0018mZ3XSRD7i\u001c8uKb$\u0018A\u00048fo\u001235KR5mK:\u000bW.\u001a\u000b\u0004Q\u000e\r\u0003BBB#{\u0001\u0007\u0001.A\u0007m_\u000e\fGNR5mK:\u000bW.Z\u0001\u0010I\u001a\u001c()\u0019;dQjK\u0007OR5mKR!1qEB&\u0011\u001d\tYP\u0010a\u0001\u0003\u0013\u000b\u0001\u0003\u001a4t\u0007\"\fgnZ3m_\u001e4\u0015\u000e\\3\u0015\t\r\u001d2\u0011\u000b\u0005\b\u0003w|\u0004\u0019AAE\u0003EawnY1m\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a\u000b\u0004i\u000e]\u0003BBB-\u0001\u0002\u0007A/A\u0005qCJ,g\u000e\u001e#je\u00069An\\4OC6,W#\u00015\u0002\u0017\u001147OR5mKB\u000bG\u000f\u001b\u000b\u0005\u0007O\u0019\u0019\u0007\u0003\u0004\u0004f\t\u0003\r\u0001[\u0001\tM&dWMT1nK\u0006iAn\\2bY\u001aKG.\u001a)bi\"$R\u0001^B6\u0007[BaA!#D\u0001\u0004!\bBBB3\u0007\u0002\u0007\u0001.\u0001\tmSN$(k\\2lg\u0012\u0013e)\u001b7fgR!11OB=!\u001da6QOB\u0001\u0007\u0003I1aa\u001e^\u0005\u0019!V\u000f\u001d7fe!1!\u0011\u0012#A\u0002Q\f!CU8dWN$%IR5mK6\u000bg.Y4feB\u0019\u0011Q\u0003$\u0014\u0005\u0019[FCAB?\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0011\u0016\u0004Q\n\u0015\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S\u0007")
public class RocksDBFileManager
implements Logging {
    private CheckpointFileManager fm;
    private SparkConf sparkConf;
    private final String dfsRootDir;
    private final File localTempDir;
    private Configuration hadoopConf;
    private final String codecName;
    private final String loggingId;
    private final FileSystem fs;
    private final PathFilter onlyZipFiles;
    private final PathFilter onlyChangelogFiles;
    private Option<Object> maxSeenVersion;
    private long minSeenVersion;
    private volatile boolean rootDirChecked;
    private volatile RocksDBFileMappings fileMappings;
    private volatile RocksDBFileManagerMetrics loadCheckpointMetrics;
    private volatile RocksDBFileManagerMetrics saveCheckpointMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$5() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return RocksDBFileManager$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CheckpointFileManager fm$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fm = CheckpointFileManager$.MODULE$.create(new Path(this.dfsRootDir), this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private PathFilter onlyZipFiles() {
        return this.onlyZipFiles;
    }

    private PathFilter onlyChangelogFiles() {
        return this.onlyChangelogFiles;
    }

    private SparkConf sparkConf$lzycompute() {
        RocksDBFileManager rocksDBFileManager = this;
        synchronized (rocksDBFileManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkConf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable)() -> new SparkConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkConf;
    }

    private SparkConf sparkConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkConf$lzycompute();
        }
        return this.sparkConf;
    }

    private CompressionCodec codec() {
        return CompressionCodec$.MODULE$.createCodec(this.sparkConf(), this.codecName);
    }

    private Option<Object> maxSeenVersion() {
        return this.maxSeenVersion;
    }

    private void maxSeenVersion_$eq(Option<Object> x$1) {
        this.maxSeenVersion = x$1;
    }

    private long minSeenVersion() {
        return this.minSeenVersion;
    }

    private void minSeenVersion_$eq(long x$1) {
        this.minSeenVersion = x$1;
    }

    private boolean rootDirChecked() {
        return this.rootDirChecked;
    }

    private void rootDirChecked_$eq(boolean x$1) {
        this.rootDirChecked = x$1;
    }

    private RocksDBFileMappings fileMappings() {
        return this.fileMappings;
    }

    private void fileMappings_$eq(RocksDBFileMappings x$1) {
        this.fileMappings = x$1;
    }

    public void copyFileMapping() {
        ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>> newVersionToRocksDBFiles = new ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>>();
        ConcurrentHashMap<String, RocksDBImmutableFile> newLocalFilesToDfsFiles = new ConcurrentHashMap<String, RocksDBImmutableFile>();
        newVersionToRocksDBFiles.putAll(this.fileMappings().versionToRocksDBFiles());
        newLocalFilesToDfsFiles.putAll(this.fileMappings().localFilesToDfsFiles());
        this.fileMappings_$eq(new RocksDBFileMappings(newVersionToRocksDBFiles, newLocalFilesToDfsFiles));
    }

    public RocksDBFileMappings captureFileMapReference() {
        return this.fileMappings();
    }

    private short getChangelogVersion(boolean useColumnFamilies) {
        short changelogVersion = useColumnFamilies ? (short)2 : 1;
        return changelogVersion;
    }

    public StateStoreChangelogWriter getChangeLogWriter(long version, boolean useColumnFamilies) {
        short changelogVersion;
        Path changelogFile = this.dfsChangelogFile(version);
        if (!this.rootDirChecked()) {
            Path rootDir = new Path(this.dfsRootDir);
            if (!this.fm().exists(rootDir)) {
                this.fm().mkdirs(rootDir);
            }
            this.rootDirChecked_$eq(true);
        }
        short s = changelogVersion = this.getChangelogVersion(useColumnFamilies);
        StateStoreChangelogWriter changelogWriter = switch (s) {
            case 1 -> new StateStoreChangelogWriterV1(this.fm(), changelogFile, this.codec());
            case 2 -> new StateStoreChangelogWriterV2(this.fm(), changelogFile, this.codec());
            default -> throw QueryExecutionErrors$.MODULE$.invalidChangeLogWriterVersion((long)changelogVersion);
        };
        return changelogWriter;
    }

    public boolean getChangeLogWriter$default$2() {
        return false;
    }

    public StateStoreChangelogReader getChangelogReader(long version, boolean useColumnFamilies) {
        short changelogVersion;
        Path changelogFile = this.dfsChangelogFile(version);
        short s = changelogVersion = this.getChangelogVersion(useColumnFamilies);
        StateStoreChangelogReader changelogReader = switch (s) {
            case 1 -> new StateStoreChangelogReaderV1(this.fm(), changelogFile, this.codec());
            case 2 -> new StateStoreChangelogReaderV2(this.fm(), changelogFile, this.codec());
            default -> throw QueryExecutionErrors$.MODULE$.invalidChangeLogReaderVersion((long)changelogVersion);
        };
        return changelogReader;
    }

    public boolean getChangelogReader$default$2() {
        return false;
    }

    private RocksDBFileManagerMetrics loadCheckpointMetrics() {
        return this.loadCheckpointMetrics;
    }

    private void loadCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.loadCheckpointMetrics = x$1;
    }

    private RocksDBFileManagerMetrics saveCheckpointMetrics() {
        return this.saveCheckpointMetrics;
    }

    private void saveCheckpointMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.saveCheckpointMetrics = x$1;
    }

    public RocksDBFileManagerMetrics latestLoadCheckpointMetrics() {
        return this.loadCheckpointMetrics();
    }

    public RocksDBFileManagerMetrics latestSaveCheckpointMetrics() {
        return this.saveCheckpointMetrics();
    }

    public void saveCheckpointToDfs(File checkpointDir, long version, long numKeys, RocksDBFileMappings capturedFileMappings, Option<Map<String, Object>> columnFamilyMapping, Option<Object> maxColumnFamilyId) {
        this.logFilesInDir(checkpointDir, this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Saving checkpoint files "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        Tuple2<Seq<File>, Seq<File>> tuple2 = this.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localOtherFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)localImmutableFiles, (Object)localOtherFiles);
        Seq localImmutableFiles2 = (Seq)tuple22._1();
        Seq localOtherFiles2 = (Seq)tuple22._2();
        Seq<RocksDBImmutableFile> rocksDBFiles = this.saveImmutableFilesToDfs(version, (Seq<File>)localImmutableFiles2, capturedFileMappings);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.apply(rocksDBFiles, numKeys, columnFamilyMapping, maxColumnFamilyId);
        File metadataFile = this.localMetadataFile(checkpointDir);
        metadata.writeToFile(metadataFile);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Written metadata for version ", ":\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.METADATA_JSON$.MODULE$, (Object)metadata.prettyJson())})))));
        if (version <= 1L && numKeys <= 0L && !this.rootDirChecked()) {
            Path path = new Path(this.dfsRootDir);
            if (!this.fm().exists(path)) {
                this.fm().mkdirs(path);
            }
            this.rootDirChecked_$eq(true);
        }
        this.zipToDfsFile((Seq<File>)((Seq)localOtherFiles2.$colon$plus((Object)metadataFile)), this.dfsBatchZipFile(version));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Saved checkpoint file for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
    }

    public Option<Map<String, Object>> saveCheckpointToDfs$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> saveCheckpointToDfs$default$6() {
        return None$.MODULE$;
    }

    public RocksDBCheckpointMetadata loadCheckpointFromDfs(long version, File localDir) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Loading checkpoint files for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        this.fileMappings().versionToRocksDBFiles().keySet().removeIf(x$3 -> RocksDBFileManager.$anonfun$loadCheckpointFromDfs$2(version, BoxesRunTime.unboxToLong((Object)x$3)));
        if (version == 0L) {
            if (localDir.exists()) {
                Utils$.MODULE$.deleteRecursively(localDir);
            }
            this.fileMappings().localFilesToDfsFiles().clear();
            localDir.mkdirs();
            rocksDBCheckpointMetadata = RocksDBCheckpointMetadata$.MODULE$.apply((Seq<RocksDBImmutableFile>)((Seq)scala.package$.MODULE$.Seq().empty()), 0L);
        } else {
            ((IterableOnceOps)this.listRocksDBFiles(localDir)._2()).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.delete()));
            Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), localDir);
            File metadataFile = this.localMetadataFile(localDir);
            RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Read metadata for version ", ":\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.METADATA_JSON$.MODULE$, (Object)metadata.prettyJson())})))));
            this.loadImmutableFilesFromDfs(metadata.immutableFiles(), localDir);
            this.fileMappings().versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), metadata.immutableFiles());
            metadataFile.delete();
            rocksDBCheckpointMetadata = metadata;
        }
        RocksDBCheckpointMetadata metadata = rocksDBCheckpointMetadata;
        this.logFilesInDir(localDir, this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded checkpoint files "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        return metadata;
    }

    public long getLatestSnapshotVersion(long version) {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            if (this.fm().exists(this.dfsBatchZipFile(version))) {
                return version;
            }
            return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path, this.onlyZipFiles())), (Function1 & Serializable)x$5 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$5.getPath().getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6))), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 <= version)), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public long getLatestVersion() {
        Path path = new Path(this.dfsRootDir);
        if (this.fm().exists(path)) {
            Path[] files = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path)), (Function1 & Serializable)x$8 -> x$8.getPath(), ClassTag$.MODULE$.apply(Path.class));
            long[] changelogFileVersions = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$2(this, x$9)))), (Function1 & Serializable)x$10 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$10.getName()), ".changelog"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$11))), (ClassTag)ClassTag$.MODULE$.Long());
            long[] snapshotFileVersions = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$getLatestVersion$5(this, x$12)))), (Function1 & Serializable)x$13 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$13.getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14))), (ClassTag)ClassTag$.MODULE$.Long());
            long[] versions = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps(changelogFileVersions), (Object)snapshotFileVersions, (ClassTag)ClassTag$.MODULE$.Long());
            return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps(versions), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        }
        return 0L;
    }

    public Seq<String> findOrphanFiles(Seq<String> trackedFiles, Seq<FileStatus> allFiles) {
        Map fileModificationTimes = ((IterableOnceOps)allFiles.map((Function1 & Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getPath().getName()), (Object)BoxesRunTime.boxToLong((long)file.getModificationTime())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (trackedFiles.nonEmpty() && allFiles.size() > trackedFiles.size()) {
            long oldestTrackedFileModificationTime = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)trackedFiles.flatMap((Function1 & Serializable)x$15 -> fileModificationTimes.get(x$15))).min((Ordering)Ordering.Long$.MODULE$));
            Seq orphanFiles = ((MapOps)fileModificationTimes.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$findOrphanFiles$3(oldestTrackedFileModificationTime, x$16)))).keys().toSeq();
            if (orphanFiles.nonEmpty()) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " orphan files: "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)orphanFiles.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_MODIFICATION_TIME$.MODULE$, (Object)((IterableOnceOps)orphanFiles.take(20)).mkString(", "))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"... (display at most 20 filenames) that should be deleted."}))).log((Seq)Nil$.MODULE$))));
            }
            return orphanFiles;
        }
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private void deleteChangelogFiles(long[] versionsToDelete) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(versionsToDelete), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            try {
                this.fm().delete(this.dfsChangelogFile(version));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted changelog file ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
            }
            catch (Exception e) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting changelog file for version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_VERSION$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))), (Throwable)e);
            }
        });
    }

    public void setMaxSeenVersion(long version) {
        if (this.maxSeenVersion().isDefined()) {
            this.maxSeenVersion_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)Math.max(BoxesRunTime.unboxToLong((Object)this.maxSeenVersion().get()), version))));
            return;
        }
        this.maxSeenVersion_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)));
    }

    private boolean shouldSkipDeletion(int numVersionsToRetain, long minVersionsToDelete) {
        if (minVersionsToDelete > 0L && this.maxSeenVersion().isDefined()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Estimated maximum version is "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_SEEN_VERSION$.MODULE$, this.maxSeenVersion().get())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" and minimum version is ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MIN_SEEN_VERSION$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.minSeenVersion()))})))));
            long versionsToDelete = BoxesRunTime.unboxToLong((Object)this.maxSeenVersion().get()) - this.minSeenVersion() + 1L - (long)numVersionsToRetain;
            if (versionsToDelete < minVersionsToDelete) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping deleting files."}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" Need at least ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MIN_VERSIONS_TO_DELETE$.MODULE$, (Object)BoxesRunTime.boxToLong((long)minVersionsToDelete))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" stale versions for batch deletion but found only"}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSIONS_TO_DELETE$.MODULE$, (Object)BoxesRunTime.boxToLong((long)versionsToDelete))})))));
                return true;
            }
        }
        return false;
    }

    public void deleteOldVersions(int numVersionsToRetain, long minVersionsToDelete) {
        if (this.shouldSkipDeletion(numVersionsToRetain, minVersionsToDelete)) {
            return;
        }
        Path path = new Path(this.dfsRootDir);
        Path[] allFiles = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(path)), (Function1 & Serializable)x$17 -> x$17.getPath(), ClassTag$.MODULE$.apply(Path.class));
        Path[] snapshotFiles = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$2(this, file)));
        Path[] changelogFiles = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$3(this, file)));
        long[] sortedSnapshotVersions = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])snapshotFiles), (Function1 & Serializable)x$18 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$18.getName()), ".zip"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$19))), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions))) {
            return;
        }
        long maxSnapshotVersionPresent = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions)));
        long minVersionToRetain = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcZJ.sp & Serializable)x$20 -> x$20 <= maxSnapshotVersionPresent - (long)numVersionsToRetain + 1L)), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> package$.MODULE$.max(x, y)));
        long[] snapshotVersionsToDelete = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcZJ.sp & Serializable)x$21 -> x$21 < minVersionToRetain);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete))) {
            return;
        }
        scala.collection.mutable.HashMap fileToMaxUsedVersion = new scala.collection.mutable.HashMap();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(sortedSnapshotVersions), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            Seq files = (Seq)Option$.MODULE$.apply(this.fileMappings().versionToRocksDBFiles().get(BoxesRunTime.boxToLong((long)version))).getOrElse((Function0 & Serializable)() -> {
                Seq<RocksDBImmutableFile> newResolvedFiles = this.getImmutableFilesFromVersionZip(version);
                this.fileMappings().versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), newResolvedFiles);
                return newResolvedFiles;
            });
            files.foreach((Function1 & Serializable)f -> {
                fileToMaxUsedVersion.update((Object)f.dfsFileName(), (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(version, BoxesRunTime.unboxToLong((Object)fileToMaxUsedVersion.getOrElse((Object)f.dfsFileName(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> version$5)))));
                return BoxedUnit.UNIT;
            });
        });
        scala.collection.mutable.HashMap filesToDelete = (scala.collection.mutable.HashMap)fileToMaxUsedVersion.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$deleteOldVersions$13(snapshotVersionsToDelete, x0$1)));
        Path sstDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR());
        Path logDir = new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR());
        Seq allSstFiles = this.fm().exists(sstDir) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.fm().list(sstDir)).toImmutableArraySeq() : (Seq)scala.package$.MODULE$.Seq().empty();
        Seq allLogFiles = this.fm().exists(logDir) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)this.fm().list(logDir)).toImmutableArraySeq() : (Seq)scala.package$.MODULE$.Seq().empty();
        filesToDelete.$plus$plus$eq((IterableOnce)this.findOrphanFiles((Seq<String>)fileToMaxUsedVersion.keys().toSeq(), (Seq<FileStatus>)((Seq)allSstFiles.$plus$plus((IterableOnce)allLogFiles))).map((Function1 & Serializable)x$22 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$22), (Object)BoxesRunTime.boxToLong((long)-1L))));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)filesToDelete.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"files not used in versions >= ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)minVersionToRetain))})))));
        IntRef failedToDelete = IntRef.create((int)0);
        filesToDelete.foreach((Function1 & Serializable)x0$2 -> {
            RocksDBFileManager.$anonfun$deleteOldVersions$16(this, failedToDelete, x0$2);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete), (Function1)(JFunction1.mcVJ.sp & Serializable)version -> {
            Path versionFile = this.dfsBatchZipFile(version);
            try {
                this.fm().delete(versionFile);
                this.fileMappings().versionToRocksDBFiles().remove(BoxesRunTime.boxToLong((long)version));
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted version " + version);
            }
            catch (Exception e) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting version file ", " for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)versionFile)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_VERSION$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))})))), (Throwable)e);
            }
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " files "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(filesToDelete.size() - failedToDelete$1.elem)))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(failed to delete"}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " files) "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_FAILED_TO_DELETE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)failedToDelete$1.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"not used in versions >= ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MIN_VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)minVersionToRetain))})))));
        long[] changelogVersionsToDelete = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])changelogFiles), (Function1 & Serializable)x$23 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$23.getName()), ".changelog"), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$24))), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$25 -> x$25 < minVersionToRetain);
        this.deleteChangelogFiles(changelogVersionsToDelete);
        this.minSeenVersion_$eq(minVersionToRetain);
    }

    public long deleteOldVersions$default$2() {
        return 0L;
    }

    private Seq<RocksDBImmutableFile> saveImmutableFilesToDfs(long version, Seq<File> localFiles, RocksDBFileMappings capturedFileMappings) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Saving RocksDB files to DFS for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))));
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        Seq immutableFiles = (Seq)localFiles.map((Function1 & Serializable)localFile -> {
            Option existingDfsFile = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(capturedFileMappings.localFilesToDfsFiles()).asScala().get((Object)localFile.getName());
            if (existingDfsFile.isDefined() && ((RocksDBImmutableFile)existingDfsFile.get()).sizeBytes() == localFile.length()) {
                RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)existingDfsFile.get();
                ++filesReused$1.elem;
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reusing file ", " for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)dfsFile)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, localFile)})))));
                return RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFile.dfsFileName(), dfsFile.sizeBytes());
            }
            String localFileName = localFile.getName();
            String dfsFileName = this.newDFSFileName(localFileName);
            Path dfsFile = this.dfsFilePath(dfsFileName);
            this.fs().copyFromLocalFile(new Path(localFile.getAbsoluteFile().toURI()), dfsFile);
            long localFileSize = localFile.length();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, localFile)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", " bytes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)dfsFile), new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)localFileSize))})))));
            ++filesCopied$1.elem;
            bytesCopied$1.elem += localFileSize;
            RocksDBImmutableFile immutableDfsFile = RocksDBImmutableFile$.MODULE$.apply(localFile.getName(), dfsFileName, localFileSize);
            capturedFileMappings.localFilesToDfsFiles().put(localFileName, immutableDfsFile);
            return immutableDfsFile;
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " files "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_COPIED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesCopied$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes) from local to"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)bytesCopied$1.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" DFS for version ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.VERSION_NUM$.MODULE$, (Object)BoxesRunTime.boxToLong((long)version))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " files reused without copying."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_REUSED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesReused$1.elem))})))));
        capturedFileMappings.versionToRocksDBFiles().put(BoxesRunTime.boxToLong((long)version), (Seq<RocksDBImmutableFile>)immutableFiles);
        this.removeLocallyDeletedSSTFilesFromDfsMapping(localFiles);
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.saveCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
        return immutableFiles;
    }

    private void loadImmutableFilesFromDfs(Seq<RocksDBImmutableFile> immutableFiles, File localDir) {
        Map requiredFileNameToFileDetails = ((IterableOnceOps)immutableFiles.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.localFileName()), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Seq localImmutableFiles = (Seq)this.listRocksDBFiles(localDir)._1();
        this.removeLocallyDeletedSSTFilesFromDfsMapping((Seq<File>)localImmutableFiles);
        localImmutableFiles.foreach((Function1 & Serializable)existingFile -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$2(this, requiredFileNameToFileDetails, existingFile);
            return BoxedUnit.UNIT;
        });
        LongRef filesCopied = LongRef.create((long)0L);
        LongRef bytesCopied = LongRef.create((long)0L);
        LongRef filesReused = LongRef.create((long)0L);
        immutableFiles.foreach((Function1 & Serializable)file -> {
            RocksDBFileManager.$anonfun$loadImmutableFilesFromDfs$6(this, localDir, filesCopied, bytesCopied, filesReused, file);
            return BoxedUnit.UNIT;
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " files "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_COPIED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesCopied$2.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes) from DFS to local with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)bytesCopied$2.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " files reused."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES_REUSED$.MODULE$, (Object)BoxesRunTime.boxToLong((long)filesReused$2.elem))})))));
        long x$1 = bytesCopied.elem;
        long x$2 = filesCopied.elem;
        long x$3 = filesReused.elem;
        Option<Object> x$4 = RocksDBFileManagerMetrics$.MODULE$.apply$default$4();
        this.loadCheckpointMetrics_$eq(new RocksDBFileManagerMetrics(x$2, x$1, x$3, x$4));
    }

    private void removeLocallyDeletedSSTFilesFromDfsMapping(Seq<File> localFiles) {
        Set currentLocalFiles = ((IterableOnceOps)localFiles.map((Function1 & Serializable)x$26 -> x$26.getName())).toSet();
        Iterable mappingsToClean = (Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.fileMappings().localFilesToDfsFiles()).asScala().keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)currentLocalFiles.contains((Object)elem)));
        mappingsToClean.foreach((Function1 & Serializable)f -> {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cleaning ", " from the localFilesToDfsFiles map"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, f)}))));
            return this.fileMappings().localFilesToDfsFiles().remove(f);
        });
    }

    private Seq<RocksDBImmutableFile> getImmutableFilesFromVersionZip(long version) {
        Utils$.MODULE$.deleteRecursively(this.localTempDir);
        this.localTempDir.mkdirs();
        Utils$.MODULE$.unzipFilesFromFile(this.fs(), this.dfsBatchZipFile(version), this.localTempDir);
        File metadataFile = this.localMetadataFile(this.localTempDir);
        RocksDBCheckpointMetadata metadata = RocksDBCheckpointMetadata$.MODULE$.readFromFile(metadataFile);
        return metadata.immutableFiles();
    }

    private void zipToDfsFile(Seq<File> files, Path dfsZipFile) {
        LazyRef filesStr$lzy = new LazyRef();
        ObjectRef in = ObjectRef.create(null);
        CheckpointFileManager.CancellableFSDataOutputStream out = this.fm().createAtomic(dfsZipFile, true);
        LongRef totalBytes = LongRef.create((long)0L);
        ZipOutputStream zout = new ZipOutputStream((OutputStream)((Object)out));
        try {
            try {
                files.foreach((Function1 & Serializable)file -> {
                    RocksDBFileManager.$anonfun$zipToDfsFile$1(zout, in, totalBytes, file);
                    return BoxedUnit.UNIT;
                });
                zout.close();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Zipped ", " bytes (before compression) to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)totalBytes$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files))})))));
                RocksDBFileManagerMetrics qual$1 = this.saveCheckpointMetrics();
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)totalBytes.elem));
                long x$2 = qual$1.copy$default$1();
                long x$3 = qual$1.copy$default$2();
                long x$4 = qual$1.copy$default$3();
                this.saveCheckpointMetrics_$eq(qual$1.copy(x$2, x$3, x$4, (Option<Object>)x$1));
            }
            catch (Exception e) {
                out.cancel();
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error zipping to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)RocksDBFileManager.filesStr$1(filesStr$lzy, dfsZipFile, files))}))), (Throwable)e);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)in.elem));
            IOUtils.closeQuietly((OutputStream)zout);
        }
    }

    private void logFilesInDir(File dir, MessageWithContext msg) {
        LazyRef files$lzy = new LazyRef();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msg.$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" - ", " files\\n\\t"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FILES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)RocksDBFileManager.files$2(files$lzy, dir).length))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)Predef$.MODULE$.wrapRefArray((Object[])RocksDBFileManager.files$2(files$lzy, dir)).mkString("\n\t"))})))));
    }

    private String newDFSFileName(String localFileName) {
        String baseName = FilenameUtils.getBaseName((String)localFileName);
        String extension = FilenameUtils.getExtension((String)localFileName);
        return baseName + "-" + UUID.randomUUID() + "." + extension;
    }

    private Path dfsBatchZipFile(long version) {
        return new Path(this.dfsRootDir + "/" + version + ".zip");
    }

    private Path dfsChangelogFile(long version) {
        return new Path(this.dfsRootDir + "/" + version + ".changelog");
    }

    private File localMetadataFile(File parentDir) {
        return new File(parentDir, "metadata");
    }

    public String logName() {
        return Logging.logName$((Logging)this) + " " + this.loggingId;
    }

    private Path dfsFilePath(String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isSstFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.SST_FILES_DFS_SUBDIR()), fileName);
        }
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new Path(new Path(this.dfsRootDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_DFS_SUBDIR()), fileName);
        }
        return new Path(this.dfsRootDir, fileName);
    }

    private File localFilePath(File localDir, String fileName) {
        if (RocksDBImmutableFile$.MODULE$.isLogFile(fileName)) {
            return new File(new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()), fileName);
        }
        return new File(localDir, fileName);
    }

    private Tuple2<Seq<File>, Seq<File>> listRocksDBFiles(File localDir) {
        File[] topLevelFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])localDir.listFiles()), (Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileManager.$anonfun$listRocksDBFiles$1(x$27)));
        File[] archivedLogFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File(localDir, RocksDBImmutableFile$.MODULE$.LOG_FILES_LOCAL_SUBDIR()).listFiles()).getOrElse((Function0 & Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)))), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isLogFile(file.getName())));
        Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RocksDBImmutableFile$.MODULE$.isSstFile(f.getName())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File[] topLevelSstFiles = (File[])tuple2._1();
        File[] topLevelOtherFiles = (File[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelSstFiles, (Object)topLevelOtherFiles);
        File[] topLevelSstFiles2 = (File[])tuple22._1();
        File[] topLevelOtherFiles2 = (File[])tuple22._2();
        return new Tuple2((Object)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])topLevelSstFiles2), (Object)archivedLogFiles, ClassTag$.MODULE$.apply(File.class))).toImmutableArraySeq(), (Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)topLevelOtherFiles2).toImmutableArraySeq());
    }

    public static final /* synthetic */ boolean $anonfun$loadCheckpointFromDfs$2(long version$2, long x$3) {
        return x$3 >= version$2;
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$2(RocksDBFileManager $this, Path x$9) {
        return $this.onlyChangelogFiles().accept(x$9);
    }

    public static final /* synthetic */ boolean $anonfun$getLatestVersion$5(RocksDBFileManager $this, Path x$12) {
        return $this.onlyZipFiles().accept(x$12);
    }

    public static final /* synthetic */ boolean $anonfun$findOrphanFiles$3(long oldestTrackedFileModificationTime$1, Tuple2 x$16) {
        return x$16._2$mcJ$sp() < oldestTrackedFileModificationTime$1;
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$2(RocksDBFileManager $this, Path file) {
        return $this.onlyZipFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$3(RocksDBFileManager $this, Path file) {
        return $this.onlyChangelogFiles().accept(file);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldVersions$13(long[] snapshotVersionsToDelete$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long v = tuple2._2$mcJ$sp();
            return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.longArrayOps(snapshotVersionsToDelete$1), (Object)BoxesRunTime.boxToLong((long)v));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteOldVersions$16(RocksDBFileManager $this, IntRef failedToDelete$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String dfsFileName = (String)tuple2._1();
            long maxUsedVersion = tuple2._2$mcJ$sp();
            try {
                Path dfsFile = $this.dfsFilePath(dfsFileName);
                $this.fm().delete(dfsFile);
                if (maxUsedVersion == -1L) {
                    $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted orphan file " + dfsFileName);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted file " + dfsFileName + " that was last used in version " + maxUsedVersion);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                ++failedToDelete$1.elem;
                if (maxUsedVersion == -1L) {
                    $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting orphan file ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)dfsFileName)}))), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting file ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)dfsFileName)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"last used in version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_FILE_VERSION$.MODULE$, (Object)BoxesRunTime.boxToLong((long)maxUsedVersion))})))), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$2(RocksDBFileManager $this, Map requiredFileNameToFileDetails$1, File existingFile) {
        boolean isSameFile;
        long existingFileSize = existingFile.length();
        Option requiredFile = requiredFileNameToFileDetails$1.get((Object)existingFile.getName());
        Option prevDfsFile = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.fileMappings().localFilesToDfsFiles()).asScala().get((Object)existingFile.getName());
        if (requiredFile.isDefined() && prevDfsFile.isDefined()) {
            String string = ((RocksDBImmutableFile)requiredFile.get()).dfsFileName();
            String string2 = ((RocksDBImmutableFile)prevDfsFile.get()).dfsFileName();
            v1 = !(string != null ? !string.equals(string2) : string2 != null) && existingFile.length() == ((RocksDBImmutableFile)requiredFile.get()).sizeBytes();
        } else {
            v1 = isSameFile = false;
        }
        if (!isSameFile) {
            existingFile.delete();
            $this.fileMappings().localFilesToDfsFiles().remove(existingFile.getName());
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted local file ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)existingFile)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with size ", " mapped"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)existingFileSize))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" to previous dfsFile ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, prevDfsFile.getOrElse((Function0 & Serializable)() -> "null"))})))));
            return;
        }
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reusing ", " present at "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)prevDfsFile)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXISTING_FILE$.MODULE$, (Object)existingFile)}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)requiredFile)})))));
    }

    public static final /* synthetic */ void $anonfun$loadImmutableFilesFromDfs$6(RocksDBFileManager $this, File localDir$1, LongRef filesCopied$2, LongRef bytesCopied$2, LongRef filesReused$2, RocksDBImmutableFile file) {
        String localFileName = file.localFileName();
        File localFile = $this.localFilePath(localDir$1, localFileName);
        if (!localFile.exists()) {
            Path dfsFile = $this.dfsFilePath(file.dfsFileName());
            $this.fs().copyToLocalFile(dfsFile, new Path(localFile.getAbsoluteFile().toURI()));
            long localFileSize = localFile.length();
            long expectedSize = file.sizeBytes();
            if (localFileSize != expectedSize) {
                throw QueryExecutionErrors$.MODULE$.unexpectedFileSize(dfsFile, localFile, expectedSize, localFileSize);
            }
            ++filesCopied$2.elem;
            bytesCopied$2.elem += localFileSize;
            $this.fileMappings().localFilesToDfsFiles().put(localFileName, file);
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DFS_FILE$.MODULE$, (Object)dfsFile)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)localFile)}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)BoxesRunTime.boxToLong((long)localFileSize))})))));
            return;
        }
        ++filesReused$2.elem;
    }

    private static final /* synthetic */ String filesStr$lzycompute$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        String string;
        LazyRef lazyRef = filesStr$lzy$1;
        synchronized (lazyRef) {
            string = filesStr$lzy$1.initialized() ? (String)filesStr$lzy$1.value() : (String)filesStr$lzy$1.initialize((Object)(dfsZipFile$1 + "\n\t" + files$1.mkString("\n\t")));
        }
        return string;
    }

    private static final String filesStr$1(LazyRef filesStr$lzy$1, Path dfsZipFile$1, Seq files$1) {
        if (filesStr$lzy$1.initialized()) {
            return (String)filesStr$lzy$1.value();
        }
        return RocksDBFileManager.filesStr$lzycompute$1(filesStr$lzy$1, dfsZipFile$1, files$1);
    }

    public static final /* synthetic */ void $anonfun$zipToDfsFile$1(ZipOutputStream zout$1, ObjectRef in$1, LongRef totalBytes$1, File file) {
        zout$1.putNextEntry(new ZipEntry(file.getName()));
        in$1.elem = new FileInputStream(file);
        int bytes = IOUtils.copy((InputStream)((InputStream)in$1.elem), (OutputStream)zout$1);
        ((InputStream)in$1.elem).close();
        zout$1.closeEntry();
        totalBytes$1.elem += (long)bytes;
    }

    private static final /* synthetic */ String[] files$lzycompute$1(LazyRef files$lzy$1, File dir$1) {
        String[] stringArray;
        LazyRef lazyRef = files$lzy$1;
        synchronized (lazyRef) {
            stringArray = files$lzy$1.initialized() ? (String[])files$lzy$1.value() : (String[])files$lzy$1.initialize(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)Utils$.MODULE$.recursiveList(dir$1)).getOrElse((Function0 & Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))), (Function1 & Serializable)f -> f.getAbsolutePath() + " - " + f.length() + " bytes", ClassTag$.MODULE$.apply(String.class)));
        }
        return stringArray;
    }

    private static final String[] files$2(LazyRef files$lzy$1, File dir$1) {
        if (files$lzy$1.initialized()) {
            return (String[])files$lzy$1.value();
        }
        return RocksDBFileManager.files$lzycompute$1(files$lzy$1, dir$1);
    }

    public static final /* synthetic */ boolean $anonfun$listRocksDBFiles$1(File x$27) {
        return !x$27.isDirectory();
    }

    public RocksDBFileManager(String dfsRootDir, File localTempDir, Configuration hadoopConf, String codecName, String loggingId) {
        this.dfsRootDir = dfsRootDir;
        this.localTempDir = localTempDir;
        this.hadoopConf = hadoopConf;
        this.codecName = codecName;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        this.fs = new Path(dfsRootDir).getFileSystem(hadoopConf);
        this.onlyZipFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".zip");
            }
        };
        this.onlyChangelogFiles = new PathFilter(null){

            public boolean accept(Path path) {
                return path.toString().endsWith(".changelog");
            }
        };
        this.maxSeenVersion = None$.MODULE$;
        this.minSeenVersion = 1L;
        this.rootDirChecked = false;
        this.fileMappings = new RocksDBFileMappings(new ConcurrentHashMap<Object, Seq<RocksDBImmutableFile>>(), new ConcurrentHashMap<String, RocksDBImmutableFile>());
        this.loadCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.saveCheckpointMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
    }
}

