/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.MultiValuedStateEncoder;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoder;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RocksDBKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.RocksDBValueStateEncoder;
import org.apache.spark.sql.execution.streaming.state.SingleValueStateEncoder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;

public final class RocksDBStateEncoder$ {
    public static final RocksDBStateEncoder$ MODULE$ = new RocksDBStateEncoder$();

    public RocksDBKeyStateEncoder getKeyEncoder(KeyStateEncoderSpec keyStateEncoderSpec, boolean useColumnFamilies, Option<Object> virtualColFamilyId) {
        KeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        if (keyStateEncoderSpec2 instanceof NoPrefixKeyStateEncoderSpec) {
            NoPrefixKeyStateEncoderSpec noPrefixKeyStateEncoderSpec = (NoPrefixKeyStateEncoderSpec)keyStateEncoderSpec2;
            StructType keySchema = noPrefixKeyStateEncoderSpec.keySchema();
            return new NoPrefixKeyStateEncoder(keySchema, useColumnFamilies, virtualColFamilyId);
        }
        if (keyStateEncoderSpec2 instanceof PrefixKeyScanStateEncoderSpec) {
            PrefixKeyScanStateEncoderSpec prefixKeyScanStateEncoderSpec = (PrefixKeyScanStateEncoderSpec)keyStateEncoderSpec2;
            StructType keySchema = prefixKeyScanStateEncoderSpec.keySchema();
            int numColsPrefixKey = prefixKeyScanStateEncoderSpec.numColsPrefixKey();
            return new PrefixKeyScanStateEncoder(keySchema, numColsPrefixKey, useColumnFamilies, virtualColFamilyId);
        }
        if (keyStateEncoderSpec2 instanceof RangeKeyScanStateEncoderSpec) {
            RangeKeyScanStateEncoderSpec rangeKeyScanStateEncoderSpec = (RangeKeyScanStateEncoderSpec)keyStateEncoderSpec2;
            StructType keySchema = rangeKeyScanStateEncoderSpec.keySchema();
            Seq<Object> orderingOrdinals = rangeKeyScanStateEncoderSpec.orderingOrdinals();
            return new RangeKeyScanStateEncoder(keySchema, orderingOrdinals, useColumnFamilies, virtualColFamilyId);
        }
        throw new IllegalArgumentException("Unsupported key state encoder spec: " + keyStateEncoderSpec);
    }

    public Option<Object> getKeyEncoder$default$3() {
        return None$.MODULE$;
    }

    public RocksDBValueStateEncoder getValueEncoder(StructType valueSchema, boolean useMultipleValuesPerKey) {
        if (useMultipleValuesPerKey) {
            return new MultiValuedStateEncoder(valueSchema);
        }
        return new SingleValueStateEncoder(valueSchema);
    }

    public byte[] getColumnFamilyIdBytes(short virtualColFamilyId) {
        byte[] encodedBytes = new byte[RocksDBStateStoreProvider$.MODULE$.VIRTUAL_COL_FAMILY_PREFIX_BYTES()];
        Platform.putShort((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (short)virtualColFamilyId);
        return encodedBytes;
    }

    public byte[] encodeUnsafeRow(UnsafeRow row) {
        byte[] bytesToEncode = row.getBytes();
        byte[] encodedBytes = new byte[bytesToEncode.length + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()];
        Platform.putByte((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (byte)RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_VERSION());
        Platform.copyMemory((Object)bytesToEncode, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), (long)bytesToEncode.length);
        return encodedBytes;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, int numFields) {
        if (bytes != null) {
            UnsafeRow row = new UnsafeRow(numFields);
            return this.decodeToUnsafeRow(bytes, row);
        }
        return null;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, UnsafeRow reusedRow) {
        if (bytes != null) {
            reusedRow.pointTo((Object)bytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), bytes.length - RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES());
            return reusedRow;
        }
        return null;
    }

    private RocksDBStateEncoder$() {
    }
}

