/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaValidationResult;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class StateSchemaCompatibilityChecker$ {
    public static final StateSchemaCompatibilityChecker$ MODULE$ = new StateSchemaCompatibilityChecker$();
    private static final int SCHEMA_FORMAT_V3 = 3;

    public Option<Path> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<Path> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public int SCHEMA_FORMAT_V3() {
        return SCHEMA_FORMAT_V3;
    }

    private void disallowBinaryInequalityColumn(StructType schema) {
        if (!UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)schema)) {
            throw new SparkUnsupportedOperationException("STATE_STORE_UNSUPPORTED_OPERATION_BINARY_INEQUALITY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.json())})));
        }
    }

    public StateSchemaValidationResult validateAndMaybeEvolveStateSchema(StatefulOperatorStateInfo stateInfo, Configuration hadoopConf, List<StateStoreColFamilySchema> newStateSchema, SessionState sessionState, int stateSchemaVersion, Map<String, String> extraOptions, String storeName, Option<Path> oldSchemaFilePath, Option<Path> newSchemaFilePath) {
        newStateSchema.foreach((Function1 & Serializable)schema -> {
            StateSchemaCompatibilityChecker$.MODULE$.disallowBinaryInequalityColumn(schema.keySchema());
            return BoxedUnit.UNIT;
        });
        StateStoreConf storeConf = new StateStoreConf(sessionState.conf(), extraOptions);
        StateStoreProviderId providerId = new StateStoreProviderId(new StateStoreId(stateInfo.checkpointLocation(), stateInfo.operatorId(), 0, storeName), stateInfo.queryRunId());
        StateSchemaCompatibilityChecker checker = new StateSchemaCompatibilityChecker(providerId, hadoopConf, oldSchemaFilePath, newSchemaFilePath);
        BooleanRef evolvedSchema = BooleanRef.create((boolean)false);
        Option result = (Option)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> checker.validateAndMaybeEvolveStateSchema(newStateSchema, !storeConf.formatValidationCheckValue(), stateSchemaVersion)).toEither().fold((Function1 & Serializable)x$7 -> new Some(x$7), (Function1 & Serializable)hasEvolvedSchema -> StateSchemaCompatibilityChecker$.$anonfun$validateAndMaybeEvolveStateSchema$11(evolvedSchema, BoxesRunTime.unboxToBoolean((Object)hasEvolvedSchema)));
        if (storeConf.stateSchemaCheckEnabled() && result.isDefined()) {
            throw (Throwable)result.get();
        }
        String schemaFileLocation = evolvedSchema.elem ? (stateSchemaVersion == this.SCHEMA_FORMAT_V3() ? ((Path)newSchemaFilePath.get()).toString() : checker.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation().toString()) : (stateSchemaVersion == this.SCHEMA_FORMAT_V3() ? ((Path)oldSchemaFilePath.get()).toString() : checker.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation().toString());
        return new StateSchemaValidationResult(evolvedSchema.elem, schemaFileLocation);
    }

    public Map<String, String> validateAndMaybeEvolveStateSchema$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public String validateAndMaybeEvolveStateSchema$default$7() {
        return StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
    }

    public Option<Path> validateAndMaybeEvolveStateSchema$default$8() {
        return None$.MODULE$;
    }

    public Option<Path> validateAndMaybeEvolveStateSchema$default$9() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$validateAndMaybeEvolveStateSchema$11(BooleanRef evolvedSchema$1, boolean hasEvolvedSchema) {
        evolvedSchema$1.elem = hasEvolvedSchema;
        return None$.MODULE$;
    }

    private StateSchemaCompatibilityChecker$() {
    }
}

