/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper$SchemaReader$;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper$SchemaWriter$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u0010!\u0001=B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001da\u0006A1A\u0005\nuCaA\u0018\u0001!\u0002\u0013q\u0005bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007K\u0002\u0001\u000b\u0011B1\t\u000b\u0019\u0004A\u0011A4\t\u000b]\u0004A\u0011B4\t\u000ba\u0004A\u0011B=\t\u000fa\u0004A\u0011\u0001\u0014\u0002\n!9\u00111\b\u0001\u0005\n\u0005u\u0002bBA-\u0001\u0011%\u00111\f\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\t)\b\u0001C\u0005\u0003o:q!! !\u0011\u0003\tyH\u0002\u0004 A!\u0005\u0011\u0011\u0011\u0005\u0007+N!\t!a!\t\u0013\u0005\u00155C1A\u0005\u0002\u0005\u001d\u0005\u0002CAE'\u0001\u0006I!a\u0001\t\u000f\u0005-5\u0003\"\u0003\u0002\u000e\"9\u0011\u0011N\n\u0005\u0002\u0005E\u0005\"CAm'E\u0005I\u0011AAn\u0011%\t\tpEI\u0001\n\u0003\t\u0019\u0010C\u0005\u0002xN\t\n\u0011\"\u0001\u0002z\"I\u0011Q`\n\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0003\u007f\u001c\u0012\u0013!C\u0001\u0003sD\u0011B!\u0001\u0014#\u0003%\t!!?\u0003?M#\u0018\r^3TG\",W.Y\"p[B\fG/\u001b2jY&$\u0018p\u00115fG.,'O\u0003\u0002\"E\u0005)1\u000f^1uK*\u00111\u0005J\u0001\ngR\u0014X-Y7j]\u001eT!!\n\u0014\u0002\u0013\u0015DXmY;uS>t'BA\u0014)\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003S)\nQa\u001d9be.T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011c\u0001\u00011mA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0015\u0002\u0011%tG/\u001a:oC2L!a\u000f\u001d\u0003\u000f1{wmZ5oO\u0006Q\u0001O]8wS\u0012,'/\u00133\u0011\u0005yzT\"\u0001\u0011\n\u0005\u0001\u0003#\u0001F*uCR,7\u000b^8sKB\u0013xN^5eKJLE-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t\r|gN\u001a\u0006\u0003\u000f*\na\u0001[1e_>\u0004\u0018BA%E\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006\tr\u000e\u001c3TG\",W.\u0019$jY\u0016\u0004\u0016\r\u001e5\u0011\u0007Ebe*\u0003\u0002Ne\t1q\n\u001d;j_:\u0004\"a\u0014*\u000e\u0003AS!!\u0015$\u0002\u0005\u0019\u001c\u0018BA*Q\u0005\u0011\u0001\u0016\r\u001e5\u0002#9,woU2iK6\fg)\u001b7f!\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\u0006/bK&l\u0017\t\u0003}\u0001AQ\u0001P\u0003A\u0002uBQ!Q\u0003A\u0002\tCqAS\u0003\u0011\u0002\u0003\u00071\nC\u0004U\u000bA\u0005\t\u0019A&\u0002%M\u001c\u0007.Z7b\r&dW\rT8dCRLwN\\\u000b\u0002\u001d\u0006\u00192o\u00195f[\u00064\u0015\u000e\\3M_\u000e\fG/[8oA\u0005\u0011a-\\\u000b\u0002CB\u0011!mY\u0007\u0002E%\u0011AM\t\u0002\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s\u0003\r1W\u000eI\u0001\u000fe\u0016\fGmU2iK6\fg)\u001b7f)\u0005A\u0007cA5ri:\u0011!n\u001c\b\u0003W:l\u0011\u0001\u001c\u0006\u0003[:\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005A\u0014\u0014a\u00029bG.\fw-Z\u0005\u0003eN\u0014A\u0001T5ti*\u0011\u0001O\r\t\u0003}UL!A\u001e\u0011\u00033M#\u0018\r^3Ti>\u0014XmQ8m\r\u0006l\u0017\u000e\\=TG\",W.Y\u0001\u001dO\u0016$X\t_5ti&twmS3z\u0003:$g+\u00197vKN\u001b\u0007.Z7b\u0003A\u0019'/Z1uKN\u001b\u0007.Z7b\r&dW\rF\u0002{{~\u0004\"!M>\n\u0005q\u0014$\u0001B+oSRDQA \u0007A\u0002!\f\u0011d\u001d;bi\u0016\u001cFo\u001c:f\u0007>dg)Y7jYf\u001c6\r[3nC\"9\u0011\u0011\u0001\u0007A\u0002\u0005\r\u0011AE:uCR,7k\u00195f[\u00064VM]:j_:\u00042!MA\u0003\u0013\r\t9A\r\u0002\u0004\u0013:$H#\u0002>\u0002\f\u00055\u0001\"\u0002@\u000e\u0001\u0004A\u0007bBA\b\u001b\u0001\u0007\u0011\u0011C\u0001\rg\u000eDW-\\1Xe&$XM\u001d\t\u0005\u0003'\t)D\u0004\u0003\u0002\u0016\u0005Eb\u0002BA\f\u0003_qA!!\u0007\u0002.9!\u00111DA\u0016\u001d\u0011\ti\"!\u000b\u000f\t\u0005}\u0011q\u0005\b\u0005\u0003C\t)CD\u0002l\u0003GI\u0011!L\u0005\u0003W1J!!\u000b\u0016\n\u0005\u001dB\u0013BA\u0013'\u0013\t\u0019C%\u0003\u0002\"E%\u0019\u00111\u0007\u0011\u0002\u0019M\u001b\u0007.Z7b\u0011\u0016d\u0007/\u001a:\n\t\u0005]\u0012\u0011\b\u0002\r'\u000eDW-\\1Xe&$XM\u001d\u0006\u0004\u0003g\u0001\u0013!E:dQ\u0016l\u0017m]\"p[B\fG/\u001b2mKR1\u0011qHA#\u0003+\u00022!MA!\u0013\r\t\u0019E\r\u0002\b\u0005>|G.Z1o\u0011\u001d\t9E\u0004a\u0001\u0003\u0013\nAb\u001d;pe\u0016$7k\u00195f[\u0006\u0004B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f2\u0013!\u0002;za\u0016\u001c\u0018\u0002BA*\u0003\u001b\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t9F\u0004a\u0001\u0003\u0013\naa]2iK6\f\u0017!B2iK\u000e\\Gc\u0002>\u0002^\u0005\u0005\u0014Q\r\u0005\u0007\u0003?z\u0001\u0019\u0001;\u0002\u0013=dGmU2iK6\f\u0007BBA2\u001f\u0001\u0007A/A\u0005oK^\u001c6\r[3nC\"9\u0011qM\bA\u0002\u0005}\u0012!E5h]>\u0014XMV1mk\u0016\u001c6\r[3nC\u0006\tc/\u00197jI\u0006$X-\u00118e\u001b\u0006L(-Z#w_24Xm\u0015;bi\u0016\u001c6\r[3nCRA\u0011qHA7\u0003c\n\u0019\b\u0003\u0004\u0002pA\u0001\r\u0001[\u0001\u000f]\u0016<8\u000b^1uKN\u001b\u0007.Z7b\u0011\u001d\t9\u0007\u0005a\u0001\u0003\u007fAq!!\u0001\u0011\u0001\u0004\t\u0019!\u0001\u0006tG\",W.\u0019$jY\u0016$2ATA=\u0011\u0019\tY(\u0005a\u0001\u001d\u0006y1\u000f^8sK\u000e\u0003Hj\\2bi&|g.A\u0010Ti\u0006$XmU2iK6\f7i\\7qCRL'-\u001b7jif\u001c\u0005.Z2lKJ\u0004\"AP\n\u0014\u0005M\u0001DCAA@\u0003A\u00196\tS#N\u0003~3uJU'B)~36'\u0006\u0002\u0002\u0004\u0005\t2k\u0011%F\u001b\u0006{fi\u0014*N\u0003R{fk\r\u0011\u0002=\u0011L7/\u00197m_^\u0014\u0015N\\1ss&sW-];bY&$\u0018pQ8mk6tGc\u0001>\u0002\u0010\"9\u0011qK\fA\u0002\u0005%C\u0003FAJ\u00033\u000b\u0019+!*\u0002(\u0006U\u0016qWAi\u0003+\f9\u000eE\u0002?\u0003+K1!a&!\u0005m\u0019F/\u0019;f'\u000eDW-\\1WC2LG-\u0019;j_:\u0014Vm];mi\"9\u00111\u0014\rA\u0002\u0005u\u0015!C:uCR,\u0017J\u001c4p!\r\u0011\u0017qT\u0005\u0004\u0003C\u0013#!G*uCR,g-\u001e7Pa\u0016\u0014\u0018\r^8s'R\fG/Z%oM>DQ!\u0011\rA\u0002\tCa!a\u001c\u0019\u0001\u0004A\u0007bBAU1\u0001\u0007\u00111V\u0001\rg\u0016\u001c8/[8o'R\fG/\u001a\t\u0005\u0003[\u000b\t,\u0004\u0002\u00020*\u0011\u0011HJ\u0005\u0005\u0003g\u000byK\u0001\u0007TKN\u001c\u0018n\u001c8Ti\u0006$X\rC\u0004\u0002\u0002a\u0001\r!a\u0001\t\u0013\u0005e\u0006\u0004%AA\u0002\u0005m\u0016\u0001D3yiJ\fw\n\u001d;j_:\u001c\b\u0003CA_\u0003\u000b\fY-a3\u000f\t\u0005}\u0016\u0011\u0019\t\u0003WJJ1!a13\u0003\u0019\u0001&/\u001a3fM&!\u0011qYAe\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u0007\u0014\u0004\u0003BA_\u0003\u001bLA!a4\u0002J\n11\u000b\u001e:j]\u001eD\u0011\"a5\u0019!\u0003\u0005\r!a3\u0002\u0013M$xN]3OC6,\u0007b\u0002&\u0019!\u0003\u0005\ra\u0013\u0005\b)b\u0001\n\u00111\u0001L\u0003-2\u0018\r\\5eCR,\u0017I\u001c3NCf\u0014W-\u0012<pYZ,7\u000b^1uKN\u001b\u0007.Z7bI\u0011,g-Y;mi\u00122TCAAoU\u0011\tY,a8,\u0005\u0005\u0005\b\u0003BAr\u0003[l!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a;3\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\f)OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1F^1mS\u0012\fG/Z!oI6\u000b\u0017PY3Fm>dg/Z*uCR,7k\u00195f[\u0006$C-\u001a4bk2$HeN\u000b\u0003\u0003kTC!a3\u0002`\u0006Yc/\u00197jI\u0006$X-\u00118e\u001b\u0006L(-Z#w_24Xm\u0015;bi\u0016\u001c6\r[3nC\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0002|*\u001a1*a8\u0002WY\fG.\u001b3bi\u0016\fe\u000eZ'bs\n,WI^8mm\u0016\u001cF/\u0019;f'\u000eDW-\\1%I\u00164\u0017-\u001e7uIe\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007")
public class StateSchemaCompatibilityChecker
implements Logging {
    private final Option<Path> newSchemaFilePath;
    private final Path org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation;
    private final CheckpointFileManager fm;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Path> $lessinit$greater$default$4() {
        return StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Path> $lessinit$greater$default$3() {
        return StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Path> validateAndMaybeEvolveStateSchema$default$9() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$9();
    }

    public static Option<Path> validateAndMaybeEvolveStateSchema$default$8() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$8();
    }

    public static String validateAndMaybeEvolveStateSchema$default$7() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$7();
    }

    public static Map<String, String> validateAndMaybeEvolveStateSchema$default$6() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$6();
    }

    public static int SCHEMA_FORMAT_V3() {
        return StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation() {
        return this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation;
    }

    private CheckpointFileManager fm() {
        return this.fm;
    }

    public List<StateStoreColFamilySchema> readSchemaFile() {
        List<StateStoreColFamilySchema> list;
        try (FSDataInputStream inStream = this.fm().open(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation());){
            try {
                String versionStr = inStream.readUTF();
                SchemaHelper.SchemaReader schemaReader = SchemaHelper$SchemaReader$.MODULE$.createSchemaReader(versionStr);
                list = schemaReader.read(inStream);
            }
            catch (Throwable e) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to read schema file from ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation())}))), e);
                throw e;
            }
        }
        return list;
    }

    private List<StateStoreColFamilySchema> getExistingKeyAndValueSchema() {
        if (this.fm().exists(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation())) {
            return this.readSchemaFile();
        }
        return package$.MODULE$.List().empty();
    }

    private void createSchemaFile(List<StateStoreColFamilySchema> stateStoreColFamilySchema, int stateSchemaVersion) {
        if (stateSchemaVersion == StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3() && this.newSchemaFilePath.isEmpty()) {
            throw new IllegalStateException("Schema file path is required for schema version 3");
        }
        SchemaHelper.SchemaWriter schemaWriter = SchemaHelper$SchemaWriter$.MODULE$.createSchemaWriter(stateSchemaVersion);
        this.createSchemaFile(stateStoreColFamilySchema, schemaWriter);
    }

    public void createSchemaFile(List<StateStoreColFamilySchema> stateStoreColFamilySchema, SchemaHelper.SchemaWriter schemaWriter) {
        Path path;
        Option<Path> option = this.newSchemaFilePath;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path path2 = (Path)some.value();
            this.fm().mkdirs(path2.getParent());
            path = path2;
        } else if (None$.MODULE$.equals(option)) {
            path = this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation();
        } else {
            throw new MatchError(option);
        }
        Path schemaFilePath = path;
        CheckpointFileManager.CancellableFSDataOutputStream outStream = this.fm().createAtomic(schemaFilePath, false);
        try {
            schemaWriter.write(stateStoreColFamilySchema, outStream);
            outStream.close();
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to write schema file to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)schemaFilePath)}))), e);
            outStream.cancel();
            throw e;
        }
    }

    private boolean schemasCompatible(StructType storedSchema, StructType schema) {
        return DataType$.MODULE$.equalsIgnoreNameAndCompatibleNullability((DataType)schema, (DataType)storedSchema);
    }

    private void check(StateStoreColFamilySchema oldSchema, StateStoreColFamilySchema newSchema, boolean ignoreValueSchema) {
        Tuple2 tuple2 = new Tuple2((Object)oldSchema.keySchema(), (Object)oldSchema.valueSchema());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructType storedKeySchema = (StructType)tuple2._1();
        StructType storedValueSchema = (StructType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storedKeySchema, (Object)storedValueSchema);
        StructType storedKeySchema2 = (StructType)tuple22._1();
        StructType storedValueSchema2 = (StructType)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)newSchema.keySchema(), (Object)newSchema.valueSchema());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        StructType keySchema = (StructType)tuple23._1();
        StructType valueSchema = (StructType)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)keySchema, (Object)valueSchema);
        StructType keySchema2 = (StructType)tuple24._1();
        StructType valueSchema2 = (StructType)tuple24._2();
        if (storedKeySchema2.equals((Object)keySchema2) && (ignoreValueSchema || storedValueSchema2.equals((Object)valueSchema2))) {
            return;
        }
        if (!this.schemasCompatible(storedKeySchema2, keySchema2)) {
            throw StateStoreErrors$.MODULE$.stateStoreKeySchemaNotCompatible(storedKeySchema2.toString(), keySchema2.toString());
        }
        if (!ignoreValueSchema && !this.schemasCompatible(storedValueSchema2, valueSchema2)) {
            throw StateStoreErrors$.MODULE$.stateStoreValueSchemaNotCompatible(storedValueSchema2.toString(), valueSchema2.toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Detected schema change which is compatible. Allowing to put rows.");
    }

    public boolean validateAndMaybeEvolveStateSchema(List<StateStoreColFamilySchema> newStateSchema, boolean ignoreValueSchema, int stateSchemaVersion) {
        boolean colFamiliesAddedOrRemoved;
        block1: {
            List existingStateSchemaList = (List)this.getExistingKeyAndValueSchema().sortBy((Function1 & Serializable)x$3 -> x$3.colFamilyName(), (Ordering)Ordering.String$.MODULE$);
            List newStateSchemaList = (List)newStateSchema.sortBy((Function1 & Serializable)x$4 -> x$4.colFamilyName(), (Ordering)Ordering.String$.MODULE$);
            if (existingStateSchemaList.isEmpty()) {
                this.createSchemaFile((List<StateStoreColFamilySchema>)newStateSchemaList, stateSchemaVersion);
                return true;
            }
            Map existingSchemaMap = existingStateSchemaList.map((Function1 & Serializable)schema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)schema.colFamilyName()), schema)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            newStateSchemaList.foreach((Function1 & Serializable)newSchema -> {
                StateSchemaCompatibilityChecker.$anonfun$validateAndMaybeEvolveStateSchema$4(this, existingSchemaMap, ignoreValueSchema, newSchema);
                return BoxedUnit.UNIT;
            });
            List list = newStateSchemaList.map((Function1 & Serializable)x$5 -> x$5.colFamilyName());
            List list2 = existingStateSchemaList.map((Function1 & Serializable)x$6 -> x$6.colFamilyName());
            boolean bl = (list == null ? list2 != null : !list.equals(list2)) ? true : (colFamiliesAddedOrRemoved = false);
            if (stateSchemaVersion != StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3() || !colFamiliesAddedOrRemoved) break block1;
            this.createSchemaFile((List<StateStoreColFamilySchema>)newStateSchemaList, stateSchemaVersion);
        }
        return colFamiliesAddedOrRemoved;
    }

    private Path schemaFile(Path storeCpLocation) {
        return new Path(new Path(storeCpLocation, "_metadata"), "schema");
    }

    public static final /* synthetic */ void $anonfun$validateAndMaybeEvolveStateSchema$4(StateSchemaCompatibilityChecker $this, Map existingSchemaMap$1, boolean ignoreValueSchema$1, StateStoreColFamilySchema newSchema) {
        existingSchemaMap$1.get((Object)newSchema.colFamilyName()).foreach((Function1 & Serializable)existingStateSchema -> {
            $this.check(existingStateSchema, newSchema, ignoreValueSchema$1);
            return BoxedUnit.UNIT;
        });
    }

    public StateSchemaCompatibilityChecker(StateStoreProviderId providerId, Configuration hadoopConf, Option<Path> oldSchemaFilePath, Option<Path> newSchemaFilePath) {
        Path path;
        this.newSchemaFilePath = newSchemaFilePath;
        Logging.$init$((Logging)this);
        if (oldSchemaFilePath.isEmpty()) {
            Path storeCpLocation = providerId.storeId().storeCheckpointLocation();
            path = this.schemaFile(storeCpLocation);
        } else {
            path = (Path)oldSchemaFilePath.get();
        }
        this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation = path;
        this.fm = CheckpointFileManager$.MODULE$.create(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation(), hadoopConf);
        this.fm().mkdirs(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation().getParent());
    }
}

