/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class StateStore$
implements Logging {
    public static final StateStore$ MODULE$ = new StateStore$();
    private static final int PARTITION_ID_TO_CHECK_SCHEMA;
    private static final String DEFAULT_COL_FAMILY_NAME;
    @GuardedBy(value="loadedProviders")
    private static final scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> loadedProviders;
    private static final Object maintenanceThreadPoolLock;
    @GuardedBy(value="maintenanceThreadPoolLock")
    private static final HashSet<StateStoreProviderId> maintenancePartitions;
    @GuardedBy(value="loadedProviders")
    private static StateStore.MaintenanceTask maintenanceTask;
    @GuardedBy(value="loadedProviders")
    private static StateStore.MaintenanceThreadPool maintenanceThreadPool;
    @GuardedBy(value="loadedProviders")
    private static StateStoreCoordinatorRef _coordRef;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        PARTITION_ID_TO_CHECK_SCHEMA = 0;
        DEFAULT_COL_FAMILY_NAME = "default";
        loadedProviders = new scala.collection.mutable.HashMap();
        maintenanceThreadPoolLock = new Object();
        maintenancePartitions = new HashSet();
        maintenanceTask = null;
        maintenanceThreadPool = null;
        _coordRef = null;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int PARTITION_ID_TO_CHECK_SCHEMA() {
        return PARTITION_ID_TO_CHECK_SCHEMA;
    }

    public String DEFAULT_COL_FAMILY_NAME() {
        return DEFAULT_COL_FAMILY_NAME;
    }

    private scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> loadedProviders() {
        return loadedProviders;
    }

    private Object maintenanceThreadPoolLock() {
        return maintenanceThreadPoolLock;
    }

    private HashSet<StateStoreProviderId> maintenancePartitions() {
        return maintenancePartitions;
    }

    private StateStore.MaintenanceTask maintenanceTask() {
        return maintenanceTask;
    }

    private void maintenanceTask_$eq(StateStore.MaintenanceTask x$1) {
        maintenanceTask = x$1;
    }

    private StateStore.MaintenanceThreadPool maintenanceThreadPool() {
        return maintenanceThreadPool;
    }

    private void maintenanceThreadPool_$eq(StateStore.MaintenanceThreadPool x$1) {
        maintenanceThreadPool = x$1;
    }

    private StateStoreCoordinatorRef _coordRef() {
        return _coordRef;
    }

    private void _coordRef_$eq(StateStoreCoordinatorRef x$1) {
        _coordRef = x$1;
    }

    public ReadStateStore getReadOnly(StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, long version, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey) {
        if (version < 0L) {
            throw QueryExecutionErrors$.MODULE$.unexpectedStateStoreVersion(version);
        }
        StateStoreProvider storeProvider = this.getStateStoreProvider(storeProviderId, keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey);
        return storeProvider.getReadStore(version);
    }

    public StateStore get(StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, long version, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey) {
        if (version < 0L) {
            throw QueryExecutionErrors$.MODULE$.unexpectedStateStoreVersion(version);
        }
        StateStoreProvider storeProvider = this.getStateStoreProvider(storeProviderId, keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey);
        return storeProvider.getStore(version);
    }

    public boolean getReadOnly$default$9() {
        return false;
    }

    public boolean get$default$9() {
        return false;
    }

    private StateStoreProvider getStateStoreProvider(StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey) {
        StateStoreProvider stateStoreProvider;
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.startMaintenanceIfNeeded(storeConf);
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> (StateStoreProvider)MODULE$.loadedProviders().getOrElseUpdate((Object)storeProviderId, (Function0 & Serializable)() -> StateStoreProvider$.MODULE$.createAndInit(storeProviderId, keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StateStoreProvider provider = (StateStoreProvider)tuple2._1();
            long loadTimeMs = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)provider, (Object)BoxesRunTime.boxToLong((long)loadTimeMs));
            StateStoreProvider provider2 = (StateStoreProvider)tuple22._1();
            long loadTimeMs2 = tuple22._2$mcJ$sp();
            if (loadTimeMs2 > 2000L) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded state store provider in loadTimeMs="}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.LOAD_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)loadTimeMs2))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for storeId=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STORE_ID$.MODULE$, (Object)storeProviderId.storeId().toString())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_RUN_ID$.MODULE$, (Object)storeProviderId.queryRunId())})))));
            }
            Seq otherProviderIds = ((IterableOnceOps)this.loadedProviders().keys().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StateStore$.$anonfun$getStateStoreProvider$4(storeProviderId, x$10)))).toSeq();
            Seq<StateStoreProviderId> providerIdsToUnload = this.reportActiveStoreInstance(storeProviderId, (Seq<StateStoreProviderId>)otherProviderIds);
            providerIdsToUnload.foreach((Function1 & Serializable)x$11 -> {
                StateStore$.MODULE$.unload(x$11);
                return BoxedUnit.UNIT;
            });
            stateStoreProvider = provider2;
        }
        return stateStoreProvider;
    }

    public void unload(StateStoreProviderId storeProviderId) {
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.loadedProviders().remove((Object)storeProviderId).foreach((Function1 & Serializable)x$12 -> {
                x$12.close();
                return BoxedUnit.UNIT;
            });
        }
    }

    public void unloadAll() {
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.loadedProviders().keySet().foreach((Function1 & Serializable)key -> {
                StateStore$.MODULE$.unload(key);
                return BoxedUnit.UNIT;
            });
            this.loadedProviders().clear();
        }
    }

    public boolean isLoaded(StateStoreProviderId storeProviderId) {
        boolean bl;
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            bl = this.loadedProviders().contains((Object)storeProviderId);
        }
        return bl;
    }

    public boolean isMaintenanceRunning() {
        boolean bl;
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            bl = this.maintenanceTask() != null && this.maintenanceTask().isRunning();
        }
        return bl;
    }

    public void stopMaintenanceTask() {
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            if (this.maintenanceThreadPool() != null) {
                Object object = this.maintenanceThreadPoolLock();
                synchronized (object) {
                    this.maintenancePartitions().clear();
                }
                this.maintenanceThreadPool().stop();
                this.maintenanceThreadPool_$eq(null);
            }
            if (this.maintenanceTask() != null) {
                this.maintenanceTask().stop();
                this.maintenanceTask_$eq(null);
            }
        }
    }

    public void stop() {
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.loadedProviders().keySet().foreach((Function1 & Serializable)key -> {
                StateStore$.MODULE$.unload(key);
                return BoxedUnit.UNIT;
            });
            this.loadedProviders().clear();
            this._coordRef_$eq(null);
            this.stopMaintenanceTask();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "StateStore stopped");
        }
    }

    private void startMaintenanceIfNeeded(StateStoreConf storeConf) {
        int numMaintenanceThreads = storeConf.numStateStoreMaintenanceThreads();
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            if (SparkEnv$.MODULE$.get() != null && !this.isMaintenanceRunning()) {
                this.maintenanceTask_$eq(new StateStore.MaintenanceTask(storeConf.maintenanceInterval(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.doMaintenance()));
                this.maintenanceThreadPool_$eq(new StateStore.MaintenanceThreadPool(numMaintenanceThreads));
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "State Store maintenance task started");
            }
        }
    }

    private boolean processThisPartition(StateStoreProviderId id) {
        boolean bl;
        Object object = this.maintenanceThreadPoolLock();
        synchronized (object) {
            boolean bl2;
            if (!this.maintenancePartitions().contains((Object)id)) {
                this.maintenancePartitions().add((Object)id);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private void doMaintenance() {
        Seq seq;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Doing maintenance");
        if (SparkEnv$.MODULE$.get() == null) {
            throw new IllegalStateException("SparkEnv not active, cannot do maintenance on StateStores");
        }
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            seq = this.loadedProviders().toSeq();
        }
        seq.foreach((Function1 & Serializable)x0$1 -> {
            StateStore$.$anonfun$doMaintenance$2(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<StateStoreProviderId> reportActiveStoreInstance(StateStoreProviderId storeProviderId, Seq<StateStoreProviderId> otherProviderIds) {
        if (SparkEnv$.MODULE$.get() != null) {
            String host = SparkEnv$.MODULE$.get().blockManager().blockManagerId().host();
            String executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
            Seq providerIdsToUnload = (Seq)this.coordinatorRef().map((Function1 & Serializable)x$13 -> x$13.reportActiveInstance(storeProviderId, host, executorId, otherProviderIds)).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reported that the loaded instance "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is active"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_PROVIDER$.MODULE$, (Object)storeProviderId)})))));
            this.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The loaded instances are going to unload: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_PROVIDER$.MODULE$, (Object)providerIdsToUnload.mkString(", "))})))));
            return providerIdsToUnload;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private boolean verifyIfStoreInstanceActive(StateStoreProviderId storeProviderId) {
        if (SparkEnv$.MODULE$.get() != null) {
            String executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
            boolean verified = BoxesRunTime.unboxToBoolean((Object)this.coordinatorRef().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.verifyIfInstanceActive(storeProviderId, executorId))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Verified whether the loaded instance " + storeProviderId + " is active: " + verified);
            return verified;
        }
        return false;
    }

    private Option<StateStoreCoordinatorRef> coordinatorRef() {
        None$ none$;
        scala.collection.mutable.HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            None$ none$2;
            SparkEnv env = SparkEnv$.MODULE$.get();
            if (env != null) {
                boolean isDriver;
                String string = env.executorId();
                String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isDriver = false);
                if (isDriver || this._coordRef() == null) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Getting StateStoreCoordinatorRef");
                    this._coordRef_$eq(StateStoreCoordinatorRef$.MODULE$.forExecutor(env));
                }
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieved reference to StateStoreCoordinator: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_PROVIDER$.MODULE$, (Object)MODULE$._coordRef())})))));
                none$2 = new Some((Object)this._coordRef());
            } else {
                this._coordRef_$eq(null);
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$getStateStoreProvider$4(StateStoreProviderId storeProviderId$1, StateStoreProviderId x$10) {
        StateStoreProviderId stateStoreProviderId = x$10;
        StateStoreProviderId stateStoreProviderId2 = storeProviderId$1;
        return stateStoreProviderId == null ? stateStoreProviderId2 != null : !((Object)stateStoreProviderId).equals(stateStoreProviderId2);
    }

    public static final /* synthetic */ void $anonfun$doMaintenance$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StateStoreProviderId id = (StateStoreProviderId)tuple2._1();
            StateStoreProvider provider = (StateStoreProvider)tuple2._2();
            if (MODULE$.processThisPartition(id)) {
                MODULE$.maintenanceThreadPool().execute(() -> {
                    long startTime;
                    block16: {
                        startTime = System.currentTimeMillis();
                        try {
                            try {
                                provider.doMaintenance();
                                if (!MODULE$.verifyIfStoreInstanceActive(id)) {
                                    MODULE$.unload(id);
                                    MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unloaded ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_PROVIDER$.MODULE$, (Object)provider)}))));
                                }
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                if (NonFatal$.MODULE$.apply(throwable2)) {
                                    MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error managing ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_PROVIDER$.MODULE$, (Object)provider)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unloading state store provider"}))).log((Seq)Nil$.MODULE$))), throwable2);
                                    MODULE$.unload(id);
                                    break block16;
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            long duration = System.currentTimeMillis() - startTime;
                            MessageWithContext logMsg = MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished maintenance task for provider=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_PROVIDER$.MODULE$, (Object)id)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" in elapsed_time=", "\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIME_UNITS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)duration))})));
                            if (duration > 5000L) {
                                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                            } else {
                                MODULE$.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                            }
                            Object object = MODULE$.maintenanceThreadPoolLock();
                            synchronized (object) {
                                MODULE$.maintenancePartitions().remove((Object)id);
                            }
                            throw throwable;
                        }
                    }
                    long duration = System.currentTimeMillis() - startTime;
                    MessageWithContext logMsg = MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished maintenance task for provider=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATE_STORE_PROVIDER$.MODULE$, (Object)id)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" in elapsed_time=", "\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIME_UNITS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)duration))})));
                    if (duration > 5000L) {
                        MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                    } else {
                        MODULE$.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                    }
                    Object object = MODULE$.maintenanceThreadPoolLock();
                    synchronized (object) {
                        MODULE$.maintenancePartitions().remove((Object)id);
                    }
                });
                return;
            }
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Not processing partition ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PARTITION_ID$.MODULE$, (Object)id)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for maintenance because it is currently "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"being processed"}))).log((Seq)Nil$.MODULE$))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private StateStore$() {
    }
}

