/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.RecordType$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import scala.Enumeration;
import scala.Tuple3;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I3Aa\u0002\u0005\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"B\u001c\u0001\t\u0003B\u0004\"B \u0001\t\u0003\u0002%aG*uCR,7\u000b^8sK\u000eC\u0017M\\4fY><'+Z1eKJ4\u0016G\u0003\u0002\n\u0015\u0005)1\u000f^1uK*\u00111\u0002D\u0001\ngR\u0014X-Y7j]\u001eT!!\u0004\b\u0002\u0013\u0015DXmY;uS>t'BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\t\u0013\tY\u0002BA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wMU3bI\u0016\u0014\u0018A\u00014n!\tqr$D\u0001\u000b\u0013\t\u0001#BA\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0002\u0015\u0019LG.\u001a+p%\u0016\fG\r\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005\u0011am\u001d\u0006\u0003OI\ta\u0001[1e_>\u0004\u0018BA\u0015%\u0005\u0011\u0001\u0016\r\u001e5\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0011\u0003\tIw.\u0003\u00021[\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$WmY\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM\"TG\u000e\t\u00033\u0001AQ\u0001\b\u0003A\u0002uAQ!\t\u0003A\u0002\tBQA\u000b\u0003A\u0002-\nqA^3sg&|g.F\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0015\u0019\u0006n\u001c:u\u0003\u001d9W\r\u001e(fqR$\u0012!\u0011\t\u0006u\t#E\nT\u0005\u0003\u0007n\u0012a\u0001V;qY\u0016\u001c\u0004CA#I\u001d\tIb)\u0003\u0002H\u0011\u0005Q!+Z2pe\u0012$\u0016\u0010]3\n\u0005%S%!\u0002,bYV,\u0017BA&<\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0011\u0007iju*\u0003\u0002Ow\t)\u0011I\u001d:bsB\u0011!\bU\u0005\u0003#n\u0012AAQ=uK\u0002")
public class StateStoreChangelogReaderV1
extends StateStoreChangelogReader {
    private final Path fileToRead;

    @Override
    public short version() {
        return 1;
    }

    @Override
    public Tuple3<Enumeration.Value, byte[], byte[]> getNext() {
        int keySize = this.input().readInt();
        if (keySize == -1) {
            this.finished_$eq(true);
            return null;
        }
        if (keySize < 0) {
            throw new IOException("Error reading streaming state file " + this.fileToRead + ": key size cannot be " + keySize);
        }
        byte[] keyBuffer = new byte[keySize];
        ByteStreams.readFully((InputStream)this.input(), (byte[])keyBuffer, (int)0, (int)keySize);
        int valueSize = this.input().readInt();
        if (valueSize < 0) {
            return new Tuple3((Object)RecordType$.MODULE$.DELETE_RECORD(), (Object)keyBuffer, null);
        }
        byte[] valueBuffer = new byte[valueSize];
        ByteStreams.readFully((InputStream)this.input(), (byte[])valueBuffer, (int)0, (int)valueSize);
        return new Tuple3((Object)RecordType$.MODULE$.PUT_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
    }

    public StateStoreChangelogReaderV1(CheckpointFileManager fm, Path fileToRead, CompressionCodec compressionCodec) {
        this.fileToRead = fileToRead;
        super(fm, fileToRead, compressionCodec);
    }
}

