/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import com.google.common.io.ByteStreams;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.RecordType$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Tuple3;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%4AAC\u0006\u00015!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011!i\u0003A!A!\u0002\u0013q\u0003\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002\u001e\u0001\t\u0013Y\u0004\"\u0002(\u0001\t\u0003z\u0005bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u00077\u0002\u0001\u000b\u0011B+\t\u000bq\u0003A\u0011I/\u00037M#\u0018\r^3Ti>\u0014Xm\u00115b]\u001e,Gn\\4SK\u0006$WM\u001d,3\u0015\taQ\"A\u0003ti\u0006$XM\u0003\u0002\u000f\u001f\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003!E\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005I\u0019\u0012aA:rY*\u0011A#F\u0001\u0006gB\f'o\u001b\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f\u001e\u001b\u0005Y\u0011B\u0001\u0010\f\u0005e\u0019F/\u0019;f'R|'/Z\"iC:<W\r\\8h%\u0016\fG-\u001a:\u0002\u0005\u0019l\u0007CA\u0011#\u001b\u0005i\u0011BA\u0012\u000e\u0005U\u0019\u0005.Z2la>Lg\u000e\u001e$jY\u0016l\u0015M\\1hKJ\f!BZ5mKR{'+Z1e!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0002gg*\u0011!&F\u0001\u0007Q\u0006$wn\u001c9\n\u00051:#\u0001\u0002)bi\"\f\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u001a\u0012AA5p\u0013\t\u0019\u0004G\u0001\tD_6\u0004(/Z:tS>t7i\u001c3fG\u00061A(\u001b8jiz\"BAN\u001c9sA\u0011A\u0004\u0001\u0005\u0006?\u0011\u0001\r\u0001\t\u0005\u0006I\u0011\u0001\r!\n\u0005\u0006[\u0011\u0001\rAL\u0001\fa\u0006\u00148/\u001a\"vM\u001a,'\u000f\u0006\u0002=\u000bB\u0019Q\b\u0011\"\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012Q!\u0011:sCf\u0004\"!P\"\n\u0005\u0011s$\u0001\u0002\"zi\u0016DQAR\u0003A\u0002\u001d\u000bQ!\u001b8qkR\u0004\"\u0001\u0013'\u000e\u0003%S!!\r&\u000b\u0003-\u000bAA[1wC&\u0011Q*\u0013\u0002\u0010\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\u00069a/\u001a:tS>tW#\u0001)\u0011\u0005u\n\u0016B\u0001*?\u0005\u0015\u0019\u0006n\u001c:u\u0003M\u0019\u0007.\u00198hK2|wMV3sg&|gn\u0015;s+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-K\u0003\u0011a\u0017M\\4\n\u0005i;&AB*ue&tw-\u0001\u000bdQ\u0006tw-\u001a7pOZ+'o]5p]N#(\u000fI\u0001\bO\u0016$h*\u001a=u)\u0005q\u0006#B\u001f`Crb\u0014B\u00011?\u0005\u0019!V\u000f\u001d7fgA\u0011!-\u001a\b\u00039\rL!\u0001Z\u0006\u0002\u0015I+7m\u001c:e)f\u0004X-\u0003\u0002gO\n)a+\u00197vK&\u0011\u0001N\u0010\u0002\f\u000b:,X.\u001a:bi&|g\u000e")
public class StateStoreChangelogReaderV2
extends StateStoreChangelogReader {
    private final String changelogVersionStr = this.input().readUTF();

    private byte[] parseBuffer(DataInputStream input) {
        int blockSize = input.readInt();
        byte[] blockBuffer = new byte[blockSize];
        ByteStreams.readFully((InputStream)input, (byte[])blockBuffer, (int)0, (int)blockSize);
        return blockBuffer;
    }

    @Override
    public short version() {
        return 2;
    }

    public String changelogVersionStr() {
        return this.changelogVersionStr;
    }

    @Override
    public Tuple3<Enumeration.Value, byte[], byte[]> getNext() {
        Enumeration.Value recordType;
        Enumeration.Value value = recordType = RecordType$.MODULE$.getRecordTypeFromByte(this.input().readByte());
        Enumeration.Value value2 = RecordType$.MODULE$.EOF_RECORD();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.finished_$eq(true);
            return null;
        }
        Enumeration.Value value3 = recordType;
        Enumeration.Value value4 = RecordType$.MODULE$.PUT_RECORD();
        Enumeration.Value value5 = value3;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            byte[] valueBuffer = this.parseBuffer(this.input());
            return new Tuple3((Object)RecordType$.MODULE$.PUT_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
        }
        Enumeration.Value value6 = RecordType$.MODULE$.DELETE_RECORD();
        Enumeration.Value value7 = value3;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            int valueSize = this.input().readInt();
            Predef$.MODULE$.assert(valueSize == -1);
            return new Tuple3((Object)RecordType$.MODULE$.DELETE_RECORD(), (Object)keyBuffer, null);
        }
        Enumeration.Value value8 = RecordType$.MODULE$.MERGE_RECORD();
        Enumeration.Value value9 = value3;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            byte[] valueBuffer = this.parseBuffer(this.input());
            return new Tuple3((Object)RecordType$.MODULE$.MERGE_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
        }
        throw new IOException("Failed to process unknown record type");
    }

    public StateStoreChangelogReaderV2(CheckpointFileManager fm, Path fileToRead, CompressionCodec compressionCodec) {
        super(fm, fileToRead, compressionCodec);
        String string = this.changelogVersionStr();
        String string2 = "v2";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Changelog version mismatch: " + this.changelogVersionStr() + " != v2");
    }
}

