/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ClusterBySpec$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.DelegatingCatalogExtension;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002\u0013&\u0005AB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0007\u0011\u0002!\taJ%\t\u000f5\u0003!\u0019!C\u0005\u001d\"1a\u000b\u0001Q\u0001\n=CQa\u0016\u0001\u0005BaCQa\u0016\u0001\u0005B}CQ\u0001\u001c\u0001\u0005B5DQ\u0001\u001d\u0001\u0005BEDQ\u0001\u001d\u0001\u0005BYDQ\u0001\u001d\u0001\u0005BqDa\u0001\u001d\u0001\u0005B\u0005\u0015\u0001bBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003#\u0001A\u0011IA\u0012\u0011\u001d\t)\u0004\u0001C!\u0003oAq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002h\u0001!\t%!\u001b\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBA>\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!a+\u0001\t\u0013\ti\u000bC\u0004\u00022\u0002!\t!a-\t\u000f\u0005E\u0006\u0001\"\u0003\u0002:\"9\u0011\u0011\u0017\u0001\u0005\n\u0005]\u0007bBAs\u0001\u0011%\u0011q\u001d\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqAa\u0004\u0001\t\u0013\u0011)\u0002C\u0004\u0003\u0010\u0001!IAa\n\t\u000f\t-\u0002\u0001\"\u0003\u0003.!9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B\"\u0001\u0011%!Q\t\u0005\b\u0005#\u0002A\u0011\u0002B*\u0011\u001d\u0011)\b\u0001C\u0005\u0005o\u00121\u0003R1uC\u001a\u0013\u0018-\\3Xe&$XM]%na2T!AJ\u0014\u0002\u0011%tG/\u001a:oC2T!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001)\"!\r\u001d\u0014\u0005\u0001\u0011\u0004cA\u001a5m5\tq%\u0003\u00026O\tyA)\u0019;b\rJ\fW.Z,sSR,'\u000f\u0005\u00028q1\u0001A!B\u001d\u0001\u0005\u0004Q$!\u0001+\u0012\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002(pi\"Lgn\u001a\t\u0003y\tK!aQ\u001f\u0003\u0007\u0005s\u00170\u0001\u0002egB\u00191G\u0012\u001c\n\u0005\u001d;#a\u0002#bi\u0006\u001cX\r^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)c\u0005cA&\u0001m5\tQ\u0005C\u0003E\u0005\u0001\u0007Q)\u0001\u0002eMV\tq\n\u0005\u0002Q':\u00111'U\u0005\u0003%\u001e\nq\u0001]1dW\u0006<W-\u0003\u0002U+\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003%\u001e\n1\u0001\u001a4!\u0003\u0011iw\u000eZ3\u0015\u0005eSV\"\u0001\u0001\t\u000bm+\u0001\u0019\u0001/\u0002\u0011M\fg/Z'pI\u0016\u0004\"aM/\n\u0005y;#\u0001C*bm\u0016lu\u000eZ3\u0015\u0005e\u0003\u0007\"B.\u0007\u0001\u0004\t\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002e{5\tQM\u0003\u0002g_\u00051AH]8pizJ!\u0001[\u001f\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003Qv\naAZ8s[\u0006$HCA-o\u0011\u0015yw\u00011\u0001b\u0003\u0019\u0019x.\u001e:dK\u00061q\u000e\u001d;j_:$2!\u0017:u\u0011\u0015\u0019\b\u00021\u0001b\u0003\rYW-\u001f\u0005\u0006k\"\u0001\r!Y\u0001\u0006m\u0006dW/\u001a\u000b\u00043^D\b\"B:\n\u0001\u0004\t\u0007\"B;\n\u0001\u0004I\bC\u0001\u001f{\u0013\tYXHA\u0004C_>dW-\u00198\u0015\u0007ekh\u0010C\u0003t\u0015\u0001\u0007\u0011\rC\u0003v\u0015\u0001\u0007q\u0010E\u0002=\u0003\u0003I1!a\u0001>\u0005\u0011auN\\4\u0015\u000be\u000b9!!\u0003\t\u000bM\\\u0001\u0019A1\t\rU\\\u0001\u0019AA\u0006!\ra\u0014QB\u0005\u0004\u0003\u001fi$A\u0002#pk\ndW-A\u0004paRLwN\\:\u0015\u0007e\u000b)\u0002C\u0004\u0002\u00121\u0001\r!a\u0006\u0011\r\u0005e\u0011qD1b\u001b\t\tYBC\u0002\u0002\u001eu\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t#a\u0007\u0003\u00075\u000b\u0007\u000fF\u0002Z\u0003KAq!!\u0005\u000e\u0001\u0004\t9\u0003\u0005\u0004\u0002*\u0005M\u0012-Y\u0007\u0003\u0003WQA!!\f\u00020\u0005!Q\u000f^5m\u0015\t\t\t$\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003W\t1\u0002]1si&$\u0018n\u001c8CsR\u0019\u0011,!\u000f\t\u000f\u0005mb\u00021\u0001\u0002>\u0005A1m\u001c7OC6,7\u000f\u0005\u0003=\u0003\u007f\t\u0017bAA!{\tQAH]3qK\u0006$X\r\u001a )\u00079\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY%P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u0013\u0012qA^1sCJ<7/\u0001\u0005ck\u000e\\W\r\u001e\"z)\u001dI\u0016QKA0\u0003GBq!a\u0016\u0010\u0001\u0004\tI&\u0001\u0006ok6\u0014UoY6fiN\u00042\u0001PA.\u0013\r\ti&\u0010\u0002\u0004\u0013:$\bBBA1\u001f\u0001\u0007\u0011-A\u0004d_2t\u0015-\\3\t\u000f\u0005mr\u00021\u0001\u0002>!\u001aq\"!\u0012\u0002\rM|'\u000f\u001e\"z)\u0015I\u00161NA7\u0011\u0019\t\t\u0007\u0005a\u0001C\"9\u00111\b\tA\u0002\u0005u\u0002f\u0001\t\u0002F\u0005I1\r\\;ti\u0016\u0014()\u001f\u000b\u00063\u0006U\u0014q\u000f\u0005\u0007\u0003C\n\u0002\u0019A1\t\u000f\u0005m\u0012\u00031\u0001\u0002>!\u001a\u0011#!\u0012\u0002\tM\fg/\u001a\u000b\u0005\u0003\u007f\n)\tE\u0002=\u0003\u0003K1!a!>\u0005\u0011)f.\u001b;\t\r\u0005\u001d%\u00031\u0001b\u0003\u0011\u0001\u0018\r\u001e5\u0015\u0005\u0005}\u0014\u0001D:bm\u0016Le\u000e^3s]\u0006dG\u0003BA@\u0003\u001fCq!a\"\u0015\u0001\u0004\t\t\n\u0005\u0003=\u0003'\u000b\u0017bAAK{\t1q\n\u001d;j_:\f!cZ3u\u001fB$\u0018n\u001c8t/&$\b\u000eU1uQR!\u00111TAU!\u0015\ti*!*b\u001b\t\tyJ\u0003\u0003\u0002.\u0005\u0005&bAARO\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002(\u0006}%AE\"bg\u0016Len]3og&$\u0018N^3NCBDq!a\"\u0016\u0001\u0004\t\t*\u0001\btCZ,Gk\u001c,2'>,(oY3\u0015\t\u0005}\u0014q\u0016\u0005\b\u0003\u000f3\u0002\u0019AAI\u0003)Ign]3si&sGo\u001c\u000b\u0005\u0003\u007f\n)\f\u0003\u0004\u00028^\u0001\r!Y\u0001\ni\u0006\u0014G.\u001a(b[\u0016$b!a \u0002<\u00065\u0007bBA_1\u0001\u0007\u0011qX\u0001\bG\u0006$\u0018\r\\8h!\u0011\t\t-!3\u000e\u0005\u0005\r'\u0002BA_\u0003\u000bT1!a2(\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0002L\u0006\r'!D\"bi\u0006dwn\u001a)mk\u001eLg\u000eC\u0004\u0002Pb\u0001\r!!5\u0002\u000b%$WM\u001c;\u0011\t\u0005\u0005\u00171[\u0005\u0005\u0003+\f\u0019M\u0001\u0006JI\u0016tG/\u001b4jKJ$B!a \u0002Z\"9\u00111\\\rA\u0002\u0005u\u0017A\u0003;bE2,\u0017\nZ3oiB!\u0011q\\Aq\u001b\t\t\t+\u0003\u0003\u0002d\u0006\u0005&a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002%\u001d,Go\u0016:ji\u0016\u0004&/\u001b<jY\u0016<Wm]\u000b\u0003\u0003S\u0004b!a;\u0002t\u0006eh\u0002BAw\u0003ct1\u0001ZAx\u0013\u0005q\u0014B\u0001*>\u0013\u0011\t)0a>\u0003\u0007M+\u0017O\u0003\u0002S{A!\u0011\u0011YA~\u0013\u0011\ti0a1\u0003'Q\u000b'\r\\3Xe&$X\r\u0015:jm&dWmZ3\u0002\u001b\u001d,GOQ;dW\u0016$8\u000b]3d+\t\u0011\u0019\u0001E\u0003=\u0003'\u0013)\u0001\u0005\u0003\u0003\b\t-QB\u0001B\u0005\u0015\u0011\ti,!)\n\t\t5!\u0011\u0002\u0002\u000b\u0005V\u001c7.\u001a;Ta\u0016\u001c\u0017aC:bm\u0016\f5\u000fV1cY\u0016$B!a \u0003\u0014!1\u0011q\u0017\u000fA\u0002\u0005$\u0002\"a \u0003\u0018\t}!\u0011\u0005\u0005\b\u0003{k\u0002\u0019\u0001B\r!\u0011\t\tMa\u0007\n\t\tu\u00111\u0019\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\u0005\b\u0003\u001fl\u0002\u0019AAi\u0011\u001d\u0011\u0019#\ba\u0001\u0005K\t\u0011B\\1nKB\u000b'\u000f^:\u0011\u000b\u0005-\u00181_1\u0015\t\u0005}$\u0011\u0006\u0005\b\u00037t\u0002\u0019AAo\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\t\u0005}$q\u0006\u0005\b\u00037|\u0002\u0019AAo\u0003A\u0001\u0018M\u001d;ji&|g.\u001b8h\u0003N4&'\u0006\u0002\u00036A1\u00111^Az\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0005\u0005{\t)-A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002B!\u0005w\u0011\u0011\u0002\u0016:b]N4wN]7\u0002?\rDWmY6QCJ$\u0018\u000e^5p]&tw-T1uG\",7O\u0016\u001aUC\ndW\r\u0006\u0003\u0002\u0000\t\u001d\u0003b\u0002B%C\u0001\u0007!1J\u0001\u000eKbL7\u000f^5oOR\u000b'\r\\3\u0011\t\u0005\u0005'QJ\u0005\u0005\u0005\u001f\n\u0019MA\u0003UC\ndW-\u0001\u0006sk:\u001cu.\\7b]\u0012$BA!\u0016\u0003lQ!\u0011q\u0010B,\u0011\u001d\u0011IF\ta\u0001\u00057\nqaY8n[\u0006tG\r\u0005\u0003\u0003^\t\u001dTB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\u000f1|w-[2bY*!!QMAQ\u0003\u0015\u0001H.\u00198t\u0013\u0011\u0011IGa\u0018\u0003\u00171{w-[2bYBc\u0017M\u001c\u0005\b\u0005[\u0012\u0003\u0019\u0001B8\u0003\u001d\u0019Xm]:j_:\u00042a\rB9\u0013\r\u0011\u0019h\n\u0002\r'B\f'o[*fgNLwN\\\u0001\u0011Y>|7.\u001e9WeA\u0013xN^5eKJ$\"A!\u001f\u0011\u000bq\n\u0019Ja\u001f\u0011\t\u0005\u0005'QP\u0005\u0005\u0005\u007f\n\u0019MA\u0007UC\ndW\r\u0015:pm&$WM\u001d\u0015\u0004\u0001\t\r\u0005\u0003\u0002BC\u0005\u0013k!Aa\"\u000b\u0007\u0005-\u0013&\u0003\u0003\u0003\f\n\u001d%AB*uC\ndW\r")
public final class DataFrameWriterImpl<T>
extends DataFrameWriter<T> {
    private final Dataset<Row> df;

    public DataFrameWriterImpl<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriterImpl<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriterImpl<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriterImpl<T> clusterBy(String colName, String ... colNames) {
        return this.clusterBy(colName, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriterImpl<T> mode(SaveMode saveMode) {
        return (DataFrameWriterImpl)super.mode(saveMode);
    }

    public DataFrameWriterImpl<T> mode(String saveMode) {
        return (DataFrameWriterImpl)super.mode(saveMode);
    }

    public DataFrameWriterImpl<T> format(String source) {
        return (DataFrameWriterImpl)super.format(source);
    }

    public DataFrameWriterImpl<T> option(String key, String value) {
        return (DataFrameWriterImpl)super.option(key, value);
    }

    public DataFrameWriterImpl<T> option(String key, boolean value) {
        return (DataFrameWriterImpl)super.option(key, value);
    }

    public DataFrameWriterImpl<T> option(String key, long value) {
        return (DataFrameWriterImpl)super.option(key, value);
    }

    public DataFrameWriterImpl<T> option(String key, double value) {
        return (DataFrameWriterImpl)super.option(key, value);
    }

    public DataFrameWriterImpl<T> options(Map<String, String> options) {
        return (DataFrameWriterImpl)super.options(options);
    }

    public DataFrameWriterImpl<T> options(java.util.Map<String, String> options) {
        return (DataFrameWriterImpl)super.options(options);
    }

    public DataFrameWriterImpl<T> partitionBy(Seq<String> colNames) {
        return (DataFrameWriterImpl)super.partitionBy(colNames);
    }

    public DataFrameWriterImpl<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        return (DataFrameWriterImpl)super.bucketBy(numBuckets, colName, colNames);
    }

    public DataFrameWriterImpl<T> sortBy(String colName, Seq<String> colNames) {
        return (DataFrameWriterImpl)super.sortBy(colName, colNames);
    }

    public DataFrameWriterImpl<T> clusterBy(String colName, Seq<String> colNames) {
        return (DataFrameWriterImpl)super.clusterBy(colName, colNames);
    }

    public void save(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenWritingError();
        }
        this.saveInternal((Option<String>)new Some((Object)path));
    }

    public void save() {
        this.saveInternal((Option<String>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveInternal(Option<String> path) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
            scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)((MapOps)sessionOptions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameWriterImpl.$anonfun$saveInternal$1(optionsWithPath, x0$1)))).$plus$plus((IterableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)finalOptions).asJava());
            CatalogManager catalogManager = this.df().sparkSession().sessionState().catalogManager();
            SaveMode saveMode = this.mode();
            if (SaveMode.Append.equals(saveMode) ? true : SaveMode.Overwrite.equals(saveMode)) {
                Tuple3 tuple3;
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
                } else {
                    if (tableProvider == null) throw new MatchError((Object)tableProvider);
                    Table t = this.getTable$1(provider, dsOptions);
                    if (DataSourceV2Implicits$.MODULE$.TableHelper(t).supports(TableCapability.BATCH_WRITE)) {
                        tuple3 = new Tuple3((Object)t, (Object)None$.MODULE$, (Object)None$.MODULE$);
                    } else {
                        this.saveToV1Source(path);
                        return;
                    }
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Table table = (Table)tuple32._1();
                Option catalog = (Option)tuple32._2();
                Option ident = (Option)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
                Table table2 = (Table)tuple33._1();
                Option catalog2 = (Option)tuple33._2();
                Option ident2 = (Option)tuple33._3();
                DataSourceV2Relation relation = DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions);
                this.checkPartitioningMatchesV2Table(table2);
                SaveMode saveMode2 = this.mode();
                SaveMode saveMode3 = SaveMode.Append;
                if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                    this.runCommand(this.df().sparkSession(), (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), finalOptions));
                    return;
                }
                this.runCommand(this.df().sparkSession(), (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), finalOptions));
                return;
            }
            TableProvider tableProvider = provider;
            if (tableProvider instanceof SupportsCatalogOptions) {
                SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
                String string3 = catalog.name();
                SaveMode saveMode4 = saveMode;
                SaveMode saveMode5 = SaveMode.Ignore;
                this.runCommand(this.df().sparkSession(), (LogicalPlan)new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier((Seq)((SeqOps)ArrayImplicits$.MODULE$.SparkArrayOps((Object)ident.namespace()).toImmutableArraySeq().$plus$colon((Object)string3)).$colon$plus((Object)ident.name()), UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, finalOptions, !(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null), CreateTableAsSelect$.MODULE$.apply$default$7()));
                return;
            } else {
                if (tableProvider == null) throw new MatchError((Object)tableProvider);
                if (DataSourceV2Implicits$.MODULE$.TableHelper(this.getTable$1(provider, dsOptions)).supports(TableCapability.BATCH_WRITE)) {
                    throw QueryCompilationErrors$.MODULE$.writeWithSaveModeUnsupportedBySourceError(this.source(), saveMode.name());
                }
                this.saveToV1Source(path);
            }
            return;
        }
        this.saveToV1Source(path);
    }

    private CaseInsensitiveMap<String> getOptionsWithPath(Option<String> path) {
        if (path.isEmpty()) {
            return this.extraOptions();
        }
        return this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
    }

    private void saveToV1Source(Option<String> path) {
        this.partitioningColumns().foreach((Function1 & Serializable)columns -> {
            this.extraOptions_$eq(this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
            return BoxedUnit.UNIT;
        });
        this.clusteringColumns().foreach((Function1 & Serializable)columns -> {
            this.extraOptions_$eq(this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
            return BoxedUnit.UNIT;
        });
        CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = optionsWithPath.originalMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    public void insertInto(String tableName) {
        Option option;
        Option option2;
        Option option3;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.partitionByDoesNotAllowedWhenUsingInsertIntoError();
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        if (seq != null && !(option3 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            this.insertInto(catalog, ident);
            return;
        }
        if (seq != null && !(option2 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                return;
            }
        }
        if (seq != null && !(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.insertInto(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident, CollectionConverters$.MODULE$.SetHasAsJava((Set)this.getWritePrivileges().toSet()).asJava());
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(TableIdentifier$.MODULE$.apply(ident.name(), ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()))));
                        return;
                    }
                    table = DataSourceV2Relation$.MODULE$.create(var7_3, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                    var9_5 = this.mode();
                    if (!(SaveMode.Append.equals(var9_5) != false ? true : (SaveMode.ErrorIfExists.equals(var9_5) != false ? true : SaveMode.Ignore.equals(var9_5) != false))) break block3;
                    v0 /* !! */  = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap());
                    break block4;
                }
                if (!SaveMode.Overwrite.equals(var9_5)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (table.table().partitioning().length <= 0) ** GOTO lbl-1000
                v1 = conf.partitionOverwriteMode();
                var12_7 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v1 != null ? v1.equals(var12_7) == false : var12_7 != null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = dynamicPartitionOverwrite = false;
                }
                v0 /* !! */  = dynamicPartitionOverwrite ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap()) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap());
                break block4;
            }
            throw new MatchError((Object)var9_5);
        }
        command = v0 /* !! */ ;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent).requireWritePrivileges(this.getWritePrivileges()), Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$, this.df().logicalPlan(), !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null), false, InsertIntoStatement$.MODULE$.apply$default$7()));
    }

    private Seq<TableWritePrivilege> getWritePrivileges() {
        SaveMode saveMode = this.mode();
        if (SaveMode.Overwrite.equals(saveMode)) {
            return new .colon.colon((Object)TableWritePrivilege.INSERT, (List)new .colon.colon((Object)TableWritePrivilege.DELETE, (List)Nil$.MODULE$));
        }
        return new .colon.colon((Object)TableWritePrivilege.INSERT, (List)Nil$.MODULE$);
    }

    private Option<BucketSpec> getBucketSpec() {
        this.isBucketed();
        return this.numBuckets().map((Function1 & Serializable)n -> DataFrameWriterImpl.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    public void saveAsTable(String tableName) {
        Option option;
        Option option2;
        Option option3;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined() || this.df().sparkSession().sessionState().conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).isDefined() && !(this.df().sparkSession().sessionState().catalogManager().catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()) instanceof DelegatingCatalogExtension);
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        if (seq != null && !(option3 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
            return;
        }
        if (seq != null && !(option2 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
                return;
            }
        }
        if (seq != null && !(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.saveAsTable(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident, Seq<String> nameParts) {
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident, CollectionConverters$.MODULE$.SetHasAsJava((Set)this.getWritePrivileges().toSet()).asJava()));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var7_5 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var7_5 != null && (var8_6 = (Option)var7_5._2()) instanceof Some && (var9_7 = (Some)var8_6).value() instanceof V1Table) {
            this.saveAsTable(TableIdentifier$.MODULE$.apply(ident.name(), ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()))));
            return;
        }
        if (var7_5 == null) ** GOTO lbl-1000
        var10_8 = (SaveMode)var7_5._1();
        var11_9 = (Option)var7_5._2();
        if (SaveMode.Append.equals(var10_8) && var11_9 instanceof Some) {
            var12_10 = (Some)var11_9;
            table = (Table)var12_10.value();
            this.checkPartitioningMatchesV2Table(table);
            v2Relation = DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
            v2 = AppendData$.MODULE$.byName((NamedRelation)v2Relation, this.df().logicalPlan(), this.extraOptions().toMap());
        } else if (var7_5 != null && SaveMode.Overwrite.equals(var15_13 = (SaveMode)var7_5._1())) {
            tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v2 = new ReplaceTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, this.extraOptions().toMap(), true, ReplaceTableAsSelect$.MODULE$.apply$default$7());
        } else if (var7_5 != null) {
            other = (SaveMode)var7_5._1();
            tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v3 = other;
            var19_17 = SaveMode.Ignore;
            v4 = !(v3 != null ? v3.equals(var19_17) == false : var19_17 != null);
            v2 = new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, this.extraOptions().toMap(), v4, CreateTableAsSelect$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)var7_5);
        }
        command = v2;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void saveAsTable(TableIdentifier tableIdent) {
        TableIdentifier qualifiedIdent;
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(qualifiedIdent = catalog.qualifyIdentifier(tableIdent));
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.Ignore.equals(saveMode)) {
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.ErrorIfExists.equals(saveMode)) {
                throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(qualifiedIdent);
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.Overwrite.equals(saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            return (B1)baseRelation;
                        }
                        if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            return (B1)hiveTableRelation.tableMeta().identifier();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null) {
                            return true;
                        }
                        return logicalPlan2 instanceof HiveTableRelation;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(qualifiedIdent).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(qualifiedIdent);
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(qualifiedIdent);
                }
                catalog.dropTable(qualifiedIdent, true, false);
                this.createTable(qualifiedIdent);
                catalog.refreshTable(qualifiedIdent);
                return;
            }
        }
        this.createTable(qualifiedIdent);
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap());
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        scala.collection.immutable.Map properties = this.clusteringColumns().isEmpty() ? Predef$.MODULE$.Map().empty() : (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ClusterBySpec$.MODULE$.toPropertyWithoutValidation(ClusterBySpec$.MODULE$.fromColumnNames((Seq)this.clusteringColumns().get()))}));
        TableIdentifier x$1 = tableIdent;
        CatalogTableType x$2 = tableType;
        CatalogStorageFormat x$3 = storage;
        StructType x$4 = new StructType();
        Some x$5 = new Some((Object)this.source());
        Seq x$6 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        Option<BucketSpec> x$7 = this.getBucketSpec();
        scala.collection.immutable.Map x$8 = properties;
        String x$9 = CatalogTable$.MODULE$.apply$default$8();
        long x$10 = CatalogTable$.MODULE$.apply$default$9();
        long x$11 = CatalogTable$.MODULE$.apply$default$10();
        String x$12 = CatalogTable$.MODULE$.apply$default$11();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        scala.collection.immutable.Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable tableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$6, x$7, x$9, x$10, x$11, x$12, x$8, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        this.runCommand(this.df().sparkSession(), new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    private Seq<Transform> partitioningAsV2() {
        Seq partitioning2 = (Seq)this.partitioningColumns().map((Function1 & Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Seq bucketing = Option$.MODULE$.option2Iterable(this.getBucketSpec().map((Function1 & Serializable)spec -> CatalogV2Implicits$.MODULE$.BucketSpecHelper(spec).asTransform())).toSeq();
        Option clustering = this.clusteringColumns().map((Function1 & Serializable)colNames -> new ClusterByTransform((Seq)colNames.map((Function1 & Serializable)x$2 -> FieldReference$.MODULE$.apply(x$2))));
        return (Seq)((IterableOps)partitioning2.$plus$plus((IterableOnce)bucketing)).$plus$plus((IterableOnce)clustering);
    }

    private void checkPartitioningMatchesV2Table(Table existingTable) {
        Seq<Transform> v2Partitions = this.partitioningAsV2();
        if (v2Partitions.isEmpty()) {
            return;
        }
        Predef$.MODULE$.require(v2Partitions.sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning())), (Function0 & Serializable)() -> "The provided partitioning or clustering columns do not match the existing table's.\n - provided: " + v2Partitions.mkString(", ") + "\n - table: " + Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning()).mkString(", "));
    }

    private void runCommand(SparkSession session, LogicalPlan command) {
        QueryExecution qe = new QueryExecution(session, command, this.df().queryExecution().tracker(), QueryExecution$.MODULE$.$lessinit$greater$default$4(), QueryExecution$.MODULE$.$lessinit$greater$default$5());
        qe.assertCommandExecuted();
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        Option<TableProvider> option = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        if (option instanceof Some && (some = (Some)option).value() instanceof FileDataSourceV2) {
            return None$.MODULE$;
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$saveInternal$1(CaseInsensitiveMap optionsWithPath$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !optionsWithPath$1.contains(k);
        }
        throw new MatchError((Object)tuple2);
    }

    private final Table getTable$1(TableProvider provider$1, CaseInsensitiveStringMap dsOptions$1) {
        if (provider$1.supportsExternalMetadata()) {
            return provider$1.getTable(this.df().schema().asNullable(), (Transform[])this.partitioningAsV2().toArray(ClassTag$.MODULE$.apply(Transform.class)), dsOptions$1.asCaseSensitiveMap());
        }
        return DataSourceV2Utils$.MODULE$.getTableFromProvider(provider$1, dsOptions$1, (Option<StructType>)None$.MODULE$);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriterImpl $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriterImpl(Dataset<T> ds) {
        this.format(ds.sparkSession().sessionState().conf().defaultDataSourceName());
        this.df = ds.toDF();
    }
}

